/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptFunction;
import org.jmol.script.Token;

class ScriptFlowContext {
    private ScriptCompiler compiler;
    Token token;
    private int pt0;
    ScriptFunction function;
    private ScriptFlowContext parent;
    int lineStart;
    int commandStart;
    int ptLine;
    int ptCommand;
    boolean forceEndIf = true;
    String ident;

    ScriptFlowContext(ScriptCompiler scriptCompiler, Token token, int n, ScriptFlowContext scriptFlowContext) {
        this.compiler = scriptCompiler;
        this.token = token;
        this.ident = (String)token.value;
        this.pt0 = n;
        this.parent = scriptFlowContext;
        short s = this.compiler.lineCurrent;
        this.ptLine = s;
        this.lineStart = s;
        this.commandStart = this.ptCommand = this.compiler.iCommand;
    }

    ScriptFlowContext getBreakableContext(int n) {
        ScriptFlowContext scriptFlowContext;
        for (scriptFlowContext = this; scriptFlowContext != null && (scriptFlowContext.token.tok != 135369224 && scriptFlowContext.token.tok != 102406 || n-- > 0); scriptFlowContext = scriptFlowContext.getParent()) {
        }
        return scriptFlowContext;
    }

    boolean checkForceEndIf(int n) {
        boolean bl;
        boolean bl2 = bl = this.forceEndIf && this.ptCommand < this.compiler.iCommand && this.ptLine == this.compiler.lineCurrent;
        if (bl) {
            this.forceEndIf = false;
        }
        return bl;
    }

    int getPt0() {
        return this.pt0;
    }

    int setPt0(int n) {
        this.pt0 = n;
        this.setLine();
        return n;
    }

    void setLine() {
        this.ptLine = this.compiler.lineCurrent;
        this.ptCommand = this.compiler.iCommand + 1;
    }

    public String toString() {
        return "ident " + this.ident + " line " + this.lineStart + " command " + this.commandStart;
    }

    ScriptFlowContext getParent() {
        return this.parent;
    }

    String path() {
        String string = "";
        ScriptFlowContext scriptFlowContext = this;
        while (scriptFlowContext != null) {
            string = scriptFlowContext.ident + "-" + string;
            scriptFlowContext = scriptFlowContext.parent;
        }
        return "[" + string + "]";
    }

    void setFunction(ScriptFunction scriptFunction) {
        this.function = scriptFunction;
    }
}

