/*
  Copyright (c) 2010-2011 Gordon Gremme <gremme@zbh.uni-hamburg.de>

  Permission to use, copy, modify, and distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

#include "extended/id_to_md5_stream_api.h"
#include "extended/id_to_md5_visitor.h"
#include "extended/visitor_stream_api.h"

GtNodeStream* gt_id_to_md5_stream_new(GtNodeStream *in_stream,
                                      GtRegionMapping *rm,
                                      bool substitute_target_ids)
{
  gt_assert(in_stream && rm);
  return gt_visitor_stream_new(in_stream,
                               gt_id_to_md5_visitor_new(rm,
                                                        substitute_target_ids));
}
