
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQInputDialog.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QInputDialog>
#include <QAction>
#include <QActionEvent>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputContext>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QInputDialog

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QInputDialog::staticMetaObject);
}


// QString QInputDialog::cancelButtonText()


static void _init_f_cancelButtonText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_cancelButtonText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputDialog *)cls)->cancelButtonText ());
}


// QStringList QInputDialog::comboBoxItems()


static void _init_f_comboBoxItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_comboBoxItems_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QInputDialog *)cls)->comboBoxItems ());
}


// void QInputDialog::done(int result)


static void _init_f_done_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_done_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->done (arg1);
}


// int QInputDialog::doubleDecimals()


static void _init_f_doubleDecimals_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_doubleDecimals_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QInputDialog *)cls)->doubleDecimals ());
}


// double QInputDialog::doubleMaximum()


static void _init_f_doubleMaximum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_doubleMaximum_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QInputDialog *)cls)->doubleMaximum ());
}


// double QInputDialog::doubleMinimum()


static void _init_f_doubleMinimum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_doubleMinimum_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QInputDialog *)cls)->doubleMinimum ());
}


// double QInputDialog::doubleValue()


static void _init_f_doubleValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_doubleValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QInputDialog *)cls)->doubleValue ());
}


// QInputDialog::InputMode QInputDialog::inputMode()


static void _init_f_inputMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QInputDialog::InputMode>::target_type > ();
}

static void _call_f_inputMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QInputDialog::InputMode>::target_type > ((qt_gsi::Converter<QInputDialog::InputMode>::target_type)qt_gsi::CppToQtAdaptor<QInputDialog::InputMode>(((QInputDialog *)cls)->inputMode ()));
}


// int QInputDialog::intMaximum()


static void _init_f_intMaximum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_intMaximum_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QInputDialog *)cls)->intMaximum ());
}


// int QInputDialog::intMinimum()


static void _init_f_intMinimum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_intMinimum_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QInputDialog *)cls)->intMinimum ());
}


// int QInputDialog::intStep()


static void _init_f_intStep_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_intStep_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QInputDialog *)cls)->intStep ());
}


// int QInputDialog::intValue()


static void _init_f_intValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_intValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QInputDialog *)cls)->intValue ());
}


// bool QInputDialog::isComboBoxEditable()


static void _init_f_isComboBoxEditable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isComboBoxEditable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QInputDialog *)cls)->isComboBoxEditable ());
}


// QString QInputDialog::labelText()


static void _init_f_labelText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_labelText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputDialog *)cls)->labelText ());
}


// QSize QInputDialog::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QInputDialog *)cls)->minimumSizeHint ());
}


// QString QInputDialog::okButtonText()


static void _init_f_okButtonText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_okButtonText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputDialog *)cls)->okButtonText ());
}


// void QInputDialog::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->open ();
}


// void QInputDialog::open(QObject *receiver, const char *member)


static void _init_f_open_2925 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_open_2925 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->open (arg1, arg2);
}


// QFlags<QInputDialog::InputDialogOption> QInputDialog::options()


static void _init_f_options_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QInputDialog::InputDialogOption> > ();
}

static void _call_f_options_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QInputDialog::InputDialogOption> > ((QFlags<QInputDialog::InputDialogOption>)((QInputDialog *)cls)->options ());
}


// void QInputDialog::setCancelButtonText(const QString &text)


static void _init_f_setCancelButtonText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCancelButtonText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setCancelButtonText (arg1);
}


// void QInputDialog::setComboBoxEditable(bool editable)


static void _init_f_setComboBoxEditable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setComboBoxEditable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setComboBoxEditable (arg1);
}


// void QInputDialog::setComboBoxItems(const QStringList &items)


static void _init_f_setComboBoxItems_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setComboBoxItems_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setComboBoxItems (arg1);
}


// void QInputDialog::setDoubleDecimals(int decimals)


static void _init_f_setDoubleDecimals_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("decimals");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleDecimals_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setDoubleDecimals (arg1);
}


// void QInputDialog::setDoubleMaximum(double max)


static void _init_f_setDoubleMaximum_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("max");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleMaximum_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setDoubleMaximum (arg1);
}


// void QInputDialog::setDoubleMinimum(double min)


static void _init_f_setDoubleMinimum_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleMinimum_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setDoubleMinimum (arg1);
}


// void QInputDialog::setDoubleRange(double min, double max)


static void _init_f_setDoubleRange_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setDoubleRange_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setDoubleRange (arg1, arg2);
}


// void QInputDialog::setDoubleValue(double value)


static void _init_f_setDoubleValue_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleValue_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setDoubleValue (arg1);
}


// void QInputDialog::setInputMode(QInputDialog::InputMode mode)


static void _init_f_setInputMode_2670 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QInputDialog::InputMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputMode_2670 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QInputDialog::InputMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QInputDialog::InputMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setInputMode (qt_gsi::QtToCppAdaptor<QInputDialog::InputMode>(arg1).cref());
}


// void QInputDialog::setIntMaximum(int max)


static void _init_f_setIntMaximum_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("max");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntMaximum_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setIntMaximum (arg1);
}


// void QInputDialog::setIntMinimum(int min)


static void _init_f_setIntMinimum_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntMinimum_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setIntMinimum (arg1);
}


// void QInputDialog::setIntRange(int min, int max)


static void _init_f_setIntRange_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setIntRange_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setIntRange (arg1, arg2);
}


// void QInputDialog::setIntStep(int step)


static void _init_f_setIntStep_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntStep_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setIntStep (arg1);
}


// void QInputDialog::setIntValue(int value)


static void _init_f_setIntValue_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntValue_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setIntValue (arg1);
}


// void QInputDialog::setLabelText(const QString &text)


static void _init_f_setLabelText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLabelText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setLabelText (arg1);
}


// void QInputDialog::setOkButtonText(const QString &text)


static void _init_f_setOkButtonText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOkButtonText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setOkButtonText (arg1);
}


// void QInputDialog::setOption(QInputDialog::InputDialogOption option, bool on)


static void _init_f_setOption_4262 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_4262 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setOption (qt_gsi::QtToCppAdaptor<QInputDialog::InputDialogOption>(arg1).cref(), arg2);
}


// void QInputDialog::setOptions(QFlags<QInputDialog::InputDialogOption> options)


static void _init_f_setOptions_4202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<QFlags<QInputDialog::InputDialogOption> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptions_4202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QInputDialog::InputDialogOption> arg1 = gsi::arg_reader<QFlags<QInputDialog::InputDialogOption> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setOptions (arg1);
}


// void QInputDialog::setTextEchoMode(QLineEdit::EchoMode mode)


static void _init_f_setTextEchoMode_2187 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextEchoMode_2187 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setTextEchoMode (qt_gsi::QtToCppAdaptor<QLineEdit::EchoMode>(arg1).cref());
}


// void QInputDialog::setTextValue(const QString &text)


static void _init_f_setTextValue_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextValue_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setTextValue (arg1);
}


// void QInputDialog::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog *)cls)->setVisible (arg1);
}


// QSize QInputDialog::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QInputDialog *)cls)->sizeHint ());
}


// bool QInputDialog::testOption(QInputDialog::InputDialogOption option)


static void _init_f_testOption_c3506 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c3506 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QInputDialog *)cls)->testOption (qt_gsi::QtToCppAdaptor<QInputDialog::InputDialogOption>(arg1).cref()));
}


// QLineEdit::EchoMode QInputDialog::textEchoMode()


static void _init_f_textEchoMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLineEdit::EchoMode>::target_type > ();
}

static void _call_f_textEchoMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLineEdit::EchoMode>::target_type > ((qt_gsi::Converter<QLineEdit::EchoMode>::target_type)qt_gsi::CppToQtAdaptor<QLineEdit::EchoMode>(((QInputDialog *)cls)->textEchoMode ()));
}


// QString QInputDialog::textValue()


static void _init_f_textValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_textValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputDialog *)cls)->textValue ());
}


// static double QInputDialog::getDouble(QWidget *parent, const QString &title, const QString &label, double value, double minValue, double maxValue, int decimals, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getDouble_12026 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("value", true, "0");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("minValue", true, "-2147483647");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("maxValue", true, "2147483647");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("decimals", true, "1");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_8);
  decl->set_return<double > ();
}

static void _call_f_getDouble_12026 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  double arg4 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (0, heap);
  double arg5 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (-2147483647, heap);
  double arg6 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (2147483647, heap);
  int arg7 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  bool *arg8 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  QFlags<Qt::WindowType> arg9 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<double > ((double)QInputDialog::getDouble (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
}


// static int QInputDialog::getInt(QWidget *parent, const QString &title, const QString &label, int value, int minValue, int maxValue, int step, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getInt_11114 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("value", true, "0");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("minValue", true, "-2147483647");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("maxValue", true, "2147483647");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("step", true, "1");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_8);
  decl->set_return<int > ();
}

static void _call_f_getInt_11114 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-2147483647, heap);
  int arg6 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (2147483647, heap);
  int arg7 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  bool *arg8 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  QFlags<Qt::WindowType> arg9 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<int > ((int)QInputDialog::getInt (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
}


// static int QInputDialog::getInteger(QWidget *parent, const QString &title, const QString &label, int value, int minValue, int maxValue, int step, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getInteger_11114 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("value", true, "0");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("minValue", true, "-2147483647");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("maxValue", true, "2147483647");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("step", true, "1");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_8);
  decl->set_return<int > ();
}

static void _call_f_getInteger_11114 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-2147483647, heap);
  int arg6 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (2147483647, heap);
  int arg7 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  bool *arg8 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  QFlags<Qt::WindowType> arg9 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<int > ((int)QInputDialog::getInteger (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
}


// static QString QInputDialog::getItem(QWidget *parent, const QString &title, const QString &label, const QStringList &items, int current, bool editable, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getItem_12222 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("items");
  decl->add_arg<const QStringList & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("current", true, "0");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("editable", true, "true");
  decl->add_arg<bool > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_7);
  decl->set_return<QString > ();
}

static void _call_f_getItem_12222 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg4 = gsi::arg_reader<const QStringList & >() (args, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  bool arg6 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool *arg7 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  QFlags<Qt::WindowType> arg8 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<QString > ((QString)QInputDialog::getItem (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8));
}


// static QString QInputDialog::getText(QWidget *parent, const QString &title, const QString &label, QLineEdit::EchoMode echo, const QString &text, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getText_12474 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("echo", true, "QLineEdit::Normal");
  decl->add_arg<const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("text", true, "QString()");
  decl->add_arg<const QString & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_6);
  decl->set_return<QString > ();
}

static void _call_f_getText_12474 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLineEdit::EchoMode>(heap, QLineEdit::Normal), heap);
  const QString &arg5 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  bool *arg6 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  QFlags<Qt::WindowType> arg7 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<QString > ((QString)QInputDialog::getText (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QLineEdit::EchoMode>(arg4).cref(), arg5, arg6, arg7));
}


// static QString QInputDialog::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QInputDialog::tr (arg1, arg2));
}


// static QString QInputDialog::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QInputDialog::tr (arg1, arg2, arg3));
}


// static QString QInputDialog::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QInputDialog::trUtf8 (arg1, arg2));
}


// static QString QInputDialog::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QInputDialog::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QInputDialog () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":cancelButtonText", "@brief Method QString QInputDialog::cancelButtonText()\n", true, &_init_f_cancelButtonText_c0, &_call_f_cancelButtonText_c0);
  methods += new qt_gsi::GenericMethod (":comboBoxItems", "@brief Method QStringList QInputDialog::comboBoxItems()\n", true, &_init_f_comboBoxItems_c0, &_call_f_comboBoxItems_c0);
  methods += new qt_gsi::GenericMethod ("done", "@brief Method void QInputDialog::done(int result)\nThis is a reimplementation of QDialog::done", false, &_init_f_done_767, &_call_f_done_767);
  methods += new qt_gsi::GenericMethod (":doubleDecimals", "@brief Method int QInputDialog::doubleDecimals()\n", true, &_init_f_doubleDecimals_c0, &_call_f_doubleDecimals_c0);
  methods += new qt_gsi::GenericMethod (":doubleMaximum", "@brief Method double QInputDialog::doubleMaximum()\n", true, &_init_f_doubleMaximum_c0, &_call_f_doubleMaximum_c0);
  methods += new qt_gsi::GenericMethod (":doubleMinimum", "@brief Method double QInputDialog::doubleMinimum()\n", true, &_init_f_doubleMinimum_c0, &_call_f_doubleMinimum_c0);
  methods += new qt_gsi::GenericMethod (":doubleValue", "@brief Method double QInputDialog::doubleValue()\n", true, &_init_f_doubleValue_c0, &_call_f_doubleValue_c0);
  methods += new qt_gsi::GenericMethod (":inputMode", "@brief Method QInputDialog::InputMode QInputDialog::inputMode()\n", true, &_init_f_inputMode_c0, &_call_f_inputMode_c0);
  methods += new qt_gsi::GenericMethod (":intMaximum", "@brief Method int QInputDialog::intMaximum()\n", true, &_init_f_intMaximum_c0, &_call_f_intMaximum_c0);
  methods += new qt_gsi::GenericMethod (":intMinimum", "@brief Method int QInputDialog::intMinimum()\n", true, &_init_f_intMinimum_c0, &_call_f_intMinimum_c0);
  methods += new qt_gsi::GenericMethod (":intStep", "@brief Method int QInputDialog::intStep()\n", true, &_init_f_intStep_c0, &_call_f_intStep_c0);
  methods += new qt_gsi::GenericMethod (":intValue", "@brief Method int QInputDialog::intValue()\n", true, &_init_f_intValue_c0, &_call_f_intValue_c0);
  methods += new qt_gsi::GenericMethod ("isComboBoxEditable?|:comboBoxEditable", "@brief Method bool QInputDialog::isComboBoxEditable()\n", true, &_init_f_isComboBoxEditable_c0, &_call_f_isComboBoxEditable_c0);
  methods += new qt_gsi::GenericMethod (":labelText", "@brief Method QString QInputDialog::labelText()\n", true, &_init_f_labelText_c0, &_call_f_labelText_c0);
  methods += new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QInputDialog::minimumSizeHint()\nThis is a reimplementation of QDialog::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
  methods += new qt_gsi::GenericMethod (":okButtonText", "@brief Method QString QInputDialog::okButtonText()\n", true, &_init_f_okButtonText_c0, &_call_f_okButtonText_c0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QInputDialog::open()\n", false, &_init_f_open_0, &_call_f_open_0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QInputDialog::open(QObject *receiver, const char *member)\n", false, &_init_f_open_2925, &_call_f_open_2925);
  methods += new qt_gsi::GenericMethod (":options", "@brief Method QFlags<QInputDialog::InputDialogOption> QInputDialog::options()\n", true, &_init_f_options_c0, &_call_f_options_c0);
  methods += new qt_gsi::GenericMethod ("setCancelButtonText|cancelButtonText=", "@brief Method void QInputDialog::setCancelButtonText(const QString &text)\n", false, &_init_f_setCancelButtonText_2025, &_call_f_setCancelButtonText_2025);
  methods += new qt_gsi::GenericMethod ("setComboBoxEditable|comboBoxEditable=", "@brief Method void QInputDialog::setComboBoxEditable(bool editable)\n", false, &_init_f_setComboBoxEditable_864, &_call_f_setComboBoxEditable_864);
  methods += new qt_gsi::GenericMethod ("setComboBoxItems|comboBoxItems=", "@brief Method void QInputDialog::setComboBoxItems(const QStringList &items)\n", false, &_init_f_setComboBoxItems_2437, &_call_f_setComboBoxItems_2437);
  methods += new qt_gsi::GenericMethod ("setDoubleDecimals|doubleDecimals=", "@brief Method void QInputDialog::setDoubleDecimals(int decimals)\n", false, &_init_f_setDoubleDecimals_767, &_call_f_setDoubleDecimals_767);
  methods += new qt_gsi::GenericMethod ("setDoubleMaximum|doubleMaximum=", "@brief Method void QInputDialog::setDoubleMaximum(double max)\n", false, &_init_f_setDoubleMaximum_1071, &_call_f_setDoubleMaximum_1071);
  methods += new qt_gsi::GenericMethod ("setDoubleMinimum|doubleMinimum=", "@brief Method void QInputDialog::setDoubleMinimum(double min)\n", false, &_init_f_setDoubleMinimum_1071, &_call_f_setDoubleMinimum_1071);
  methods += new qt_gsi::GenericMethod ("setDoubleRange", "@brief Method void QInputDialog::setDoubleRange(double min, double max)\n", false, &_init_f_setDoubleRange_2034, &_call_f_setDoubleRange_2034);
  methods += new qt_gsi::GenericMethod ("setDoubleValue|doubleValue=", "@brief Method void QInputDialog::setDoubleValue(double value)\n", false, &_init_f_setDoubleValue_1071, &_call_f_setDoubleValue_1071);
  methods += new qt_gsi::GenericMethod ("setInputMode|inputMode=", "@brief Method void QInputDialog::setInputMode(QInputDialog::InputMode mode)\n", false, &_init_f_setInputMode_2670, &_call_f_setInputMode_2670);
  methods += new qt_gsi::GenericMethod ("setIntMaximum|intMaximum=", "@brief Method void QInputDialog::setIntMaximum(int max)\n", false, &_init_f_setIntMaximum_767, &_call_f_setIntMaximum_767);
  methods += new qt_gsi::GenericMethod ("setIntMinimum|intMinimum=", "@brief Method void QInputDialog::setIntMinimum(int min)\n", false, &_init_f_setIntMinimum_767, &_call_f_setIntMinimum_767);
  methods += new qt_gsi::GenericMethod ("setIntRange", "@brief Method void QInputDialog::setIntRange(int min, int max)\n", false, &_init_f_setIntRange_1426, &_call_f_setIntRange_1426);
  methods += new qt_gsi::GenericMethod ("setIntStep|intStep=", "@brief Method void QInputDialog::setIntStep(int step)\n", false, &_init_f_setIntStep_767, &_call_f_setIntStep_767);
  methods += new qt_gsi::GenericMethod ("setIntValue|intValue=", "@brief Method void QInputDialog::setIntValue(int value)\n", false, &_init_f_setIntValue_767, &_call_f_setIntValue_767);
  methods += new qt_gsi::GenericMethod ("setLabelText|labelText=", "@brief Method void QInputDialog::setLabelText(const QString &text)\n", false, &_init_f_setLabelText_2025, &_call_f_setLabelText_2025);
  methods += new qt_gsi::GenericMethod ("setOkButtonText|okButtonText=", "@brief Method void QInputDialog::setOkButtonText(const QString &text)\n", false, &_init_f_setOkButtonText_2025, &_call_f_setOkButtonText_2025);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Method void QInputDialog::setOption(QInputDialog::InputDialogOption option, bool on)\n", false, &_init_f_setOption_4262, &_call_f_setOption_4262);
  methods += new qt_gsi::GenericMethod ("setOptions|options=", "@brief Method void QInputDialog::setOptions(QFlags<QInputDialog::InputDialogOption> options)\n", false, &_init_f_setOptions_4202, &_call_f_setOptions_4202);
  methods += new qt_gsi::GenericMethod ("setTextEchoMode|textEchoMode=", "@brief Method void QInputDialog::setTextEchoMode(QLineEdit::EchoMode mode)\n", false, &_init_f_setTextEchoMode_2187, &_call_f_setTextEchoMode_2187);
  methods += new qt_gsi::GenericMethod ("setTextValue|textValue=", "@brief Method void QInputDialog::setTextValue(const QString &text)\n", false, &_init_f_setTextValue_2025, &_call_f_setTextValue_2025);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QInputDialog::setVisible(bool visible)\nThis is a reimplementation of QDialog::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QInputDialog::sizeHint()\nThis is a reimplementation of QDialog::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod ("testOption", "@brief Method bool QInputDialog::testOption(QInputDialog::InputDialogOption option)\n", true, &_init_f_testOption_c3506, &_call_f_testOption_c3506);
  methods += new qt_gsi::GenericMethod (":textEchoMode", "@brief Method QLineEdit::EchoMode QInputDialog::textEchoMode()\n", true, &_init_f_textEchoMode_c0, &_call_f_textEchoMode_c0);
  methods += new qt_gsi::GenericMethod (":textValue", "@brief Method QString QInputDialog::textValue()\n", true, &_init_f_textValue_c0, &_call_f_textValue_c0);
  methods += gsi::qt_signal ("accepted()", "accepted", "@brief Signal declaration for QInputDialog::accepted()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QInputDialog::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QInputDialog::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("doubleValueChanged(double)", "doubleValueChanged", gsi::arg("value"), "@brief Signal declaration for QInputDialog::doubleValueChanged(double value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("doubleValueSelected(double)", "doubleValueSelected", gsi::arg("value"), "@brief Signal declaration for QInputDialog::doubleValueSelected(double value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("finished(int)", "finished", gsi::arg("result"), "@brief Signal declaration for QInputDialog::finished(int result)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("intValueChanged(int)", "intValueChanged", gsi::arg("value"), "@brief Signal declaration for QInputDialog::intValueChanged(int value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("intValueSelected(int)", "intValueSelected", gsi::arg("value"), "@brief Signal declaration for QInputDialog::intValueSelected(int value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rejected()", "rejected", "@brief Signal declaration for QInputDialog::rejected()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("textValueChanged(const QString &)", "textValueChanged", gsi::arg("text"), "@brief Signal declaration for QInputDialog::textValueChanged(const QString &text)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("textValueSelected(const QString &)", "textValueSelected", gsi::arg("text"), "@brief Signal declaration for QInputDialog::textValueSelected(const QString &text)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("getDouble", "@brief Static method double QInputDialog::getDouble(QWidget *parent, const QString &title, const QString &label, double value, double minValue, double maxValue, int decimals, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getDouble_12026, &_call_f_getDouble_12026);
  methods += new qt_gsi::GenericStaticMethod ("getInt", "@brief Static method int QInputDialog::getInt(QWidget *parent, const QString &title, const QString &label, int value, int minValue, int maxValue, int step, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getInt_11114, &_call_f_getInt_11114);
  methods += new qt_gsi::GenericStaticMethod ("getInteger", "@brief Static method int QInputDialog::getInteger(QWidget *parent, const QString &title, const QString &label, int value, int minValue, int maxValue, int step, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getInteger_11114, &_call_f_getInteger_11114);
  methods += new qt_gsi::GenericStaticMethod ("getItem", "@brief Static method QString QInputDialog::getItem(QWidget *parent, const QString &title, const QString &label, const QStringList &items, int current, bool editable, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getItem_12222, &_call_f_getItem_12222);
  methods += new qt_gsi::GenericStaticMethod ("getText", "@brief Static method QString QInputDialog::getText(QWidget *parent, const QString &title, const QString &label, QLineEdit::EchoMode echo, const QString &text, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getText_12474, &_call_f_getText_12474);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QInputDialog::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QInputDialog::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QInputDialog::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QInputDialog::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QDialog> &qtdecl_QDialog ();

qt_gsi::QtNativeClass<QInputDialog> decl_QInputDialog (qtdecl_QDialog (), "QtGui", "QInputDialog_Native",
  methods_QInputDialog (),
  "@hide\n@alias QInputDialog");

GSI_QTGUI_PUBLIC gsi::Class<QInputDialog> &qtdecl_QInputDialog () { return decl_QInputDialog; }

}


class QInputDialog_Adaptor : public QInputDialog, public qt_gsi::QtObjectBase
{
public:

  virtual ~QInputDialog_Adaptor();

  //  [adaptor ctor] QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
  QInputDialog_Adaptor() : QInputDialog()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
  QInputDialog_Adaptor(QWidget *parent) : QInputDialog(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
  QInputDialog_Adaptor(QWidget *parent, QFlags<Qt::WindowType> flags) : QInputDialog(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QInputDialog::adjustPosition(QWidget *)
  void fp_QInputDialog_adjustPosition_1315 (QWidget *arg1) {
    QInputDialog::adjustPosition(arg1);
  }

  //  [expose] void QInputDialog::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QInputDialog_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QInputDialog::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QInputDialog::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QInputDialog_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QInputDialog::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QInputDialog::focusNextChild()
  bool fp_QInputDialog_focusNextChild_0 () {
    return QInputDialog::focusNextChild();
  }

  //  [expose] bool QInputDialog::focusPreviousChild()
  bool fp_QInputDialog_focusPreviousChild_0 () {
    return QInputDialog::focusPreviousChild();
  }

  //  [expose] int QInputDialog::receivers(const char *signal)
  int fp_QInputDialog_receivers_c1731 (const char *signal) const {
    return QInputDialog::receivers(signal);
  }

  //  [expose] void QInputDialog::resetInputContext()
  void fp_QInputDialog_resetInputContext_0 () {
    QInputDialog::resetInputContext();
  }

  //  [expose] QObject *QInputDialog::sender()
  QObject * fp_QInputDialog_sender_c0 () const {
    return QInputDialog::sender();
  }

  //  [expose] void QInputDialog::updateMicroFocus()
  void fp_QInputDialog_updateMicroFocus_0 () {
    QInputDialog::updateMicroFocus();
  }

  //  [adaptor impl] void QInputDialog::accept()
  void cbs_accept_0_0()
  {
    QInputDialog::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QInputDialog_Adaptor>(&QInputDialog_Adaptor::cbs_accept_0_0);
    } else {
      QInputDialog::accept();
    }
  }

  //  [adaptor impl] void QInputDialog::done(int result)
  void cbs_done_767_0(int result)
  {
    QInputDialog::done(result);
  }

  virtual void done(int result)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QInputDialog_Adaptor, int>(&QInputDialog_Adaptor::cbs_done_767_0, result);
    } else {
      QInputDialog::done(result);
    }
  }

  //  [adaptor impl] int QInputDialog::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QInputDialog::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QInputDialog_Adaptor, int, int>(&QInputDialog_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QInputDialog::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QInputDialog::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QInputDialog::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QInputDialog_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QInputDialog_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QInputDialog::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QInputDialog::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QInputDialog::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QInputDialog_Adaptor, QSize>(&QInputDialog_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QInputDialog::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QInputDialog::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QInputDialog::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QInputDialog_Adaptor, QPaintEngine *>(&QInputDialog_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QInputDialog::paintEngine();
    }
  }

  //  [adaptor impl] void QInputDialog::reject()
  void cbs_reject_0_0()
  {
    QInputDialog::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QInputDialog_Adaptor>(&QInputDialog_Adaptor::cbs_reject_0_0);
    } else {
      QInputDialog::reject();
    }
  }

  //  [adaptor impl] void QInputDialog::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QInputDialog::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QInputDialog_Adaptor, bool>(&QInputDialog_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QInputDialog::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QInputDialog::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QInputDialog::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QInputDialog_Adaptor, QSize>(&QInputDialog_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QInputDialog::sizeHint();
    }
  }

  //  [emitter impl] void QInputDialog::accepted()
  void emitter_QInputDialog_accepted_0()
  {
    emit QInputDialog::accepted();
  }

  //  [adaptor impl] void QInputDialog::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QInputDialog::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QInputDialog_Adaptor, QActionEvent *>(&QInputDialog_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QInputDialog::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QInputDialog::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QInputDialog_Adaptor, QEvent *>(&QInputDialog_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QInputDialog::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QInputDialog::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QInputDialog_Adaptor, QChildEvent *>(&QInputDialog_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QInputDialog::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QInputDialog::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QInputDialog_Adaptor, QCloseEvent *>(&QInputDialog_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QInputDialog::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QInputDialog::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QInputDialog_Adaptor, QContextMenuEvent *>(&QInputDialog_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QInputDialog::contextMenuEvent(arg1);
    }
  }

  //  [emitter impl] void QInputDialog::customContextMenuRequested(const QPoint &pos)
  void emitter_QInputDialog_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QInputDialog::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QInputDialog::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QInputDialog::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QInputDialog_Adaptor, QEvent *>(&QInputDialog_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QInputDialog::customEvent(arg1);
    }
  }

  //  [emitter impl] void QInputDialog::destroyed(QObject *)
  void emitter_QInputDialog_destroyed_1302(QObject *arg1)
  {
    emit QInputDialog::destroyed(arg1);
  }

  //  [adaptor impl] void QInputDialog::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QInputDialog::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QInputDialog_Adaptor, const char *>(&QInputDialog_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QInputDialog::disconnectNotify(signal);
    }
  }

  //  [emitter impl] void QInputDialog::doubleValueChanged(double value)
  void emitter_QInputDialog_doubleValueChanged_1071(double value)
  {
    emit QInputDialog::doubleValueChanged(value);
  }

  //  [emitter impl] void QInputDialog::doubleValueSelected(double value)
  void emitter_QInputDialog_doubleValueSelected_1071(double value)
  {
    emit QInputDialog::doubleValueSelected(value);
  }

  //  [adaptor impl] void QInputDialog::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QInputDialog::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QInputDialog_Adaptor, QDragEnterEvent *>(&QInputDialog_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QInputDialog::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QInputDialog::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QInputDialog_Adaptor, QDragLeaveEvent *>(&QInputDialog_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QInputDialog::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QInputDialog::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QInputDialog_Adaptor, QDragMoveEvent *>(&QInputDialog_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QInputDialog::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QInputDialog::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QInputDialog_Adaptor, QDropEvent *>(&QInputDialog_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QInputDialog::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QInputDialog::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QInputDialog_Adaptor, bool>(&QInputDialog_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QInputDialog::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QInputDialog::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QInputDialog_Adaptor, QEvent *>(&QInputDialog_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QInputDialog::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QInputDialog::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QInputDialog::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QInputDialog_Adaptor, bool, QEvent *>(&QInputDialog_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QInputDialog::event(arg1);
    }
  }

  //  [adaptor impl] bool QInputDialog::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QInputDialog::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QInputDialog_Adaptor, bool, QObject *, QEvent *>(&QInputDialog_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QInputDialog::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QInputDialog::finished(int result)
  void emitter_QInputDialog_finished_767(int result)
  {
    emit QInputDialog::finished(result);
  }

  //  [adaptor impl] void QInputDialog::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QInputDialog::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QInputDialog_Adaptor, QFocusEvent *>(&QInputDialog_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QInputDialog::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QInputDialog::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QInputDialog::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QInputDialog_Adaptor, bool, bool>(&QInputDialog_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QInputDialog::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QInputDialog::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QInputDialog::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QInputDialog_Adaptor, QFocusEvent *>(&QInputDialog_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QInputDialog::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QInputDialog::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QInputDialog_Adaptor, const QFont &>(&QInputDialog_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QInputDialog::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QInputDialog::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QInputDialog_Adaptor, QHideEvent *>(&QInputDialog_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QInputDialog::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QInputDialog::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QInputDialog_Adaptor, QInputMethodEvent *>(&QInputDialog_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QInputDialog::inputMethodEvent(arg1);
    }
  }

  //  [emitter impl] void QInputDialog::intValueChanged(int value)
  void emitter_QInputDialog_intValueChanged_767(int value)
  {
    emit QInputDialog::intValueChanged(value);
  }

  //  [emitter impl] void QInputDialog::intValueSelected(int value)
  void emitter_QInputDialog_intValueSelected_767(int value)
  {
    emit QInputDialog::intValueSelected(value);
  }

  //  [adaptor impl] void QInputDialog::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QInputDialog::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QInputDialog_Adaptor, QKeyEvent *>(&QInputDialog_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QInputDialog::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QInputDialog::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QInputDialog_Adaptor, QKeyEvent *>(&QInputDialog_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QInputDialog::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::languageChange()
  void cbs_languageChange_0_0()
  {
    QInputDialog::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QInputDialog_Adaptor>(&QInputDialog_Adaptor::cbs_languageChange_0_0);
    } else {
      QInputDialog::languageChange();
    }
  }

  //  [adaptor impl] void QInputDialog::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QInputDialog::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QInputDialog_Adaptor, QEvent *>(&QInputDialog_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QInputDialog::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QInputDialog::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QInputDialog::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QInputDialog_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QInputDialog_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QInputDialog::metric(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QInputDialog::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QInputDialog_Adaptor, QMouseEvent *>(&QInputDialog_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QInputDialog::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QInputDialog::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QInputDialog_Adaptor, QMouseEvent *>(&QInputDialog_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QInputDialog::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QInputDialog::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QInputDialog_Adaptor, QMouseEvent *>(&QInputDialog_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QInputDialog::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QInputDialog::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QInputDialog_Adaptor, QMouseEvent *>(&QInputDialog_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QInputDialog::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QInputDialog::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QInputDialog_Adaptor, QMoveEvent *>(&QInputDialog_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QInputDialog::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QInputDialog::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QInputDialog_Adaptor, QPaintEvent *>(&QInputDialog_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QInputDialog::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QInputDialog::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QInputDialog_Adaptor, const QPalette &>(&QInputDialog_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QInputDialog::paletteChange(arg1);
    }
  }

  //  [emitter impl] void QInputDialog::rejected()
  void emitter_QInputDialog_rejected_0()
  {
    emit QInputDialog::rejected();
  }

  //  [adaptor impl] void QInputDialog::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QInputDialog::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QInputDialog_Adaptor, QResizeEvent *>(&QInputDialog_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QInputDialog::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QInputDialog::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QInputDialog_Adaptor, QShowEvent *>(&QInputDialog_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QInputDialog::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QInputDialog::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QInputDialog_Adaptor, QStyle &>(&QInputDialog_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QInputDialog::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QInputDialog::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QInputDialog_Adaptor, QTabletEvent *>(&QInputDialog_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QInputDialog::tabletEvent(arg1);
    }
  }

  //  [emitter impl] void QInputDialog::textValueChanged(const QString &text)
  void emitter_QInputDialog_textValueChanged_2025(const QString &text)
  {
    emit QInputDialog::textValueChanged(text);
  }

  //  [emitter impl] void QInputDialog::textValueSelected(const QString &text)
  void emitter_QInputDialog_textValueSelected_2025(const QString &text)
  {
    emit QInputDialog::textValueSelected(text);
  }

  //  [adaptor impl] void QInputDialog::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QInputDialog::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QInputDialog_Adaptor, QTimerEvent *>(&QInputDialog_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QInputDialog::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QInputDialog::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QInputDialog_Adaptor, QWheelEvent *>(&QInputDialog_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QInputDialog::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QInputDialog::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QInputDialog_Adaptor, bool>(&QInputDialog_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QInputDialog::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QInputDialog_Adaptor::~QInputDialog_Adaptor() { }

//  Constructor QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QInputDialog_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QInputDialog_Adaptor> ();
}

static void _call_ctor_QInputDialog_Adaptor_3702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<QInputDialog_Adaptor *> (new QInputDialog_Adaptor (arg1, arg2));
}


// void QInputDialog::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_accept_0_0 = cb;
}


// emitter void QInputDialog::accepted()

static void _init_emitter_accepted_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_accepted_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_accepted_0 ();
}


// void QInputDialog::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// exposed void QInputDialog::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_adjustPosition_1315 (arg1);
}


// void QInputDialog::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QInputDialog::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QInputDialog::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QInputDialog::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QInputDialog::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_create_2208 (arg1, arg2, arg3);
}


// emitter void QInputDialog::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_customContextMenuRequested_1916 (arg1);
}


// void QInputDialog::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QInputDialog::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_destroy_1620 (arg1, arg2);
}


// emitter void QInputDialog::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_destroyed_1302 (arg1);
}


// void QInputDialog::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QInputDialog::done(int result)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_done_767_0 = cb;
}


// emitter void QInputDialog::doubleValueChanged(double value)

static void _init_emitter_doubleValueChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_doubleValueChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_doubleValueChanged_1071 (arg1);
}


// emitter void QInputDialog::doubleValueSelected(double value)

static void _init_emitter_doubleValueSelected_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_doubleValueSelected_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_doubleValueSelected_1071 (arg1);
}


// void QInputDialog::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QInputDialog::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QInputDialog::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QInputDialog::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QInputDialog::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}


// void QInputDialog::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QInputDialog::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QInputDialog::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QInputDialog::finished(int result)

static void _init_emitter_finished_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_finished_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_finished_767 (arg1);
}


// void QInputDialog::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QInputDialog::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->fp_QInputDialog_focusNextChild_0 ());
}


// bool QInputDialog::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QInputDialog::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QInputDialog::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->fp_QInputDialog_focusPreviousChild_0 ());
}


// void QInputDialog::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}


// int QInputDialog::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QInputDialog_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QInputDialog::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QInputDialog::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QInputDialog::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QInputDialog_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// emitter void QInputDialog::intValueChanged(int value)

static void _init_emitter_intValueChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_intValueChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_intValueChanged_767 (arg1);
}


// emitter void QInputDialog::intValueSelected(int value)

static void _init_emitter_intValueSelected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_intValueSelected_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_intValueSelected_767 (arg1);
}


// void QInputDialog::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QInputDialog::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QInputDialog::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}


// void QInputDialog::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QInputDialog::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QInputDialog_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QInputDialog::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QInputDialog_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QInputDialog::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QInputDialog::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QInputDialog::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QInputDialog::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QInputDialog::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// QPaintEngine *QInputDialog::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QInputDialog_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QInputDialog::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// void QInputDialog::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = args.read<const QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}


// exposed int QInputDialog::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QInputDialog_Adaptor *)cls)->fp_QInputDialog_receivers_c1731 (arg1));
}


// void QInputDialog::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_reject_0_0 = cb;
}


// emitter void QInputDialog::rejected()

static void _init_emitter_rejected_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rejected_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_rejected_0 ();
}


// exposed void QInputDialog::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_resetInputContext_0 ();
}


// void QInputDialog::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QInputDialog::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QInputDialog_Adaptor *)cls)->fp_QInputDialog_sender_c0 ());
}


// void QInputDialog::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QInputDialog::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QInputDialog::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QInputDialog_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QInputDialog::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle &arg1 = args.read<QStyle & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}


// void QInputDialog::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// emitter void QInputDialog::textValueChanged(const QString &text)

static void _init_emitter_textValueChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_textValueChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_textValueChanged_2025 (arg1);
}


// emitter void QInputDialog::textValueSelected(const QString &text)

static void _init_emitter_textValueSelected_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_textValueSelected_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QInputDialog_Adaptor *)cls)->emitter_QInputDialog_textValueSelected_2025 (arg1);
}


// void QInputDialog::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QInputDialog::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_updateMicroFocus_0 ();
}


// void QInputDialog::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// void QInputDialog::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputDialog_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}


namespace gsi
{

gsi::Class<QInputDialog> &qtdecl_QInputDialog ();

static gsi::Methods methods_QInputDialog_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QInputDialog.", &_init_ctor_QInputDialog_Adaptor_3702, &_call_ctor_QInputDialog_Adaptor_3702);
  methods += new qt_gsi::GenericMethod ("accept", "@brief Virtual method void QInputDialog::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("emit_accepted", "@brief Emitter for signal void QInputDialog::accepted()\nCall this method to emit this signal.", false, &_init_emitter_accepted_0, &_call_emitter_accepted_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QInputDialog::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*adjustPosition", "@brief Method void QInputDialog::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QInputDialog::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QInputDialog::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QInputDialog::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QInputDialog::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QInputDialog::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QInputDialog::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QInputDialog::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QInputDialog::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QInputDialog::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QInputDialog::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("done", "@brief Virtual method void QInputDialog::done(int result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("emit_doubleValueChanged", "@brief Emitter for signal void QInputDialog::doubleValueChanged(double value)\nCall this method to emit this signal.", false, &_init_emitter_doubleValueChanged_1071, &_call_emitter_doubleValueChanged_1071);
  methods += new qt_gsi::GenericMethod ("emit_doubleValueSelected", "@brief Emitter for signal void QInputDialog::doubleValueSelected(double value)\nCall this method to emit this signal.", false, &_init_emitter_doubleValueSelected_1071, &_call_emitter_doubleValueSelected_1071);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QInputDialog::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QInputDialog::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QInputDialog::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QInputDialog::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QInputDialog::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QInputDialog::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QInputDialog::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QInputDialog::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QInputDialog::finished(int result)\nCall this method to emit this signal.", false, &_init_emitter_finished_767, &_call_emitter_finished_767);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QInputDialog::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QInputDialog::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QInputDialog::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QInputDialog::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QInputDialog::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QInputDialog::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QInputDialog::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QInputDialog::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QInputDialog::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QInputDialog::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("emit_intValueChanged", "@brief Emitter for signal void QInputDialog::intValueChanged(int value)\nCall this method to emit this signal.", false, &_init_emitter_intValueChanged_767, &_call_emitter_intValueChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_intValueSelected", "@brief Emitter for signal void QInputDialog::intValueSelected(int value)\nCall this method to emit this signal.", false, &_init_emitter_intValueSelected_767, &_call_emitter_intValueSelected_767);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QInputDialog::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QInputDialog::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QInputDialog::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QInputDialog::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QInputDialog::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QInputDialog::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QInputDialog::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QInputDialog::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QInputDialog::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QInputDialog::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QInputDialog::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QInputDialog::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QInputDialog::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QInputDialog::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QInputDialog::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QInputDialog::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("emit_rejected", "@brief Emitter for signal void QInputDialog::rejected()\nCall this method to emit this signal.", false, &_init_emitter_rejected_0, &_call_emitter_rejected_0);
  methods += new qt_gsi::GenericMethod ("*resetInputContext", "@brief Method void QInputDialog::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QInputDialog::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QInputDialog::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QInputDialog::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QInputDialog::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QInputDialog::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QInputDialog::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QInputDialog::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("emit_textValueChanged", "@brief Emitter for signal void QInputDialog::textValueChanged(const QString &text)\nCall this method to emit this signal.", false, &_init_emitter_textValueChanged_2025, &_call_emitter_textValueChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_textValueSelected", "@brief Emitter for signal void QInputDialog::textValueSelected(const QString &text)\nCall this method to emit this signal.", false, &_init_emitter_textValueSelected_2025, &_call_emitter_textValueSelected_2025);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QInputDialog::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QInputDialog::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QInputDialog::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QInputDialog::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
  return methods;
}

gsi::Class<QInputDialog_Adaptor> decl_QInputDialog_Adaptor (qtdecl_QInputDialog (), "QtGui", "QInputDialog",
  methods_QInputDialog_Adaptor (),
  "@qt\n@brief Binding of QInputDialog");

}


//  Implementation of the enum wrapper class for QInputDialog::InputDialogOption
namespace qt_gsi
{

static gsi::Enum<QInputDialog::InputDialogOption> decl_QInputDialog_InputDialogOption_Enum ("QtGui", "QInputDialog_InputDialogOption",
    gsi::enum_const ("NoButtons", QInputDialog::NoButtons, "@brief Enum constant QInputDialog::NoButtons") +
    gsi::enum_const ("UseListViewForComboBoxItems", QInputDialog::UseListViewForComboBoxItems, "@brief Enum constant QInputDialog::UseListViewForComboBoxItems"),
  "@qt\n@brief This class represents the QInputDialog::InputDialogOption enum");

static gsi::QFlagsClass<QInputDialog::InputDialogOption > decl_QInputDialog_InputDialogOption_Enums ("QtGui", "QInputDialog_QFlags_InputDialogOption",
  "@qt\n@brief This class represents the QFlags<QInputDialog::InputDialogOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QInputDialog> inject_QInputDialog_InputDialogOption_Enum_in_parent (decl_QInputDialog_InputDialogOption_Enum.defs ());
static gsi::ClassExt<QInputDialog> decl_QInputDialog_InputDialogOption_Enum_as_child (decl_QInputDialog_InputDialogOption_Enum, "InputDialogOption");
static gsi::ClassExt<QInputDialog> decl_QInputDialog_InputDialogOption_Enums_as_child (decl_QInputDialog_InputDialogOption_Enums, "QFlags_InputDialogOption");

}


//  Implementation of the enum wrapper class for QInputDialog::InputMode
namespace qt_gsi
{

static gsi::Enum<QInputDialog::InputMode> decl_QInputDialog_InputMode_Enum ("QtGui", "QInputDialog_InputMode",
    gsi::enum_const ("TextInput", QInputDialog::TextInput, "@brief Enum constant QInputDialog::TextInput") +
    gsi::enum_const ("IntInput", QInputDialog::IntInput, "@brief Enum constant QInputDialog::IntInput") +
    gsi::enum_const ("DoubleInput", QInputDialog::DoubleInput, "@brief Enum constant QInputDialog::DoubleInput"),
  "@qt\n@brief This class represents the QInputDialog::InputMode enum");

static gsi::QFlagsClass<QInputDialog::InputMode > decl_QInputDialog_InputMode_Enums ("QtGui", "QInputDialog_QFlags_InputMode",
  "@qt\n@brief This class represents the QFlags<QInputDialog::InputMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QInputDialog> inject_QInputDialog_InputMode_Enum_in_parent (decl_QInputDialog_InputMode_Enum.defs ());
static gsi::ClassExt<QInputDialog> decl_QInputDialog_InputMode_Enum_as_child (decl_QInputDialog_InputMode_Enum, "InputMode");
static gsi::ClassExt<QInputDialog> decl_QInputDialog_InputMode_Enums_as_child (decl_QInputDialog_InputMode_Enums, "QFlags_InputMode");

}

