
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQConcatenateTablesProxyModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QConcatenateTablesProxyModel>
#include <QAbstractItemModel>
#include <QChildEvent>
#include <QDataStream>
#include <QEvent>
#include <QMetaMethod>
#include <QMimeData>
#include <QModelIndex>
#include <QModelRoleDataSpan>
#include <QObject>
#include <QPersistentModelIndex>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QConcatenateTablesProxyModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QConcatenateTablesProxyModel::staticMetaObject);
}


// void QConcatenateTablesProxyModel::addSourceModel(QAbstractItemModel *sourceModel)


static void _init_f_addSourceModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceModel");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addSourceModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel *)cls)->addSourceModel (arg1);
}


// bool QConcatenateTablesProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)


static void _init_f_canDropMimeData_c7425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_canDropMimeData_c7425 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = gsi::arg_reader<const QMimeData * >() (args, heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::DropAction>::target_type & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg5 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel *)cls)->canDropMimeData (arg1, qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg2).cref(), arg3, arg4, arg5));
}


// int QConcatenateTablesProxyModel::columnCount(const QModelIndex &parent)


static void _init_f_columnCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QConcatenateTablesProxyModel *)cls)->columnCount (arg1));
}


// QVariant QConcatenateTablesProxyModel::data(const QModelIndex &index, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QConcatenateTablesProxyModel *)cls)->data (arg1, arg2));
}


// bool QConcatenateTablesProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)


static void _init_f_dropMimeData_7425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_dropMimeData_7425 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = gsi::arg_reader<const QMimeData * >() (args, heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::DropAction>::target_type & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg5 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel *)cls)->dropMimeData (arg1, qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg2).cref(), arg3, arg4, arg5));
}


// QFlags<Qt::ItemFlag> QConcatenateTablesProxyModel::flags(const QModelIndex &index)


static void _init_f_flags_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_f_flags_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QConcatenateTablesProxyModel *)cls)->flags (arg1));
}


// QVariant QConcatenateTablesProxyModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QConcatenateTablesProxyModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}


// QModelIndex QConcatenateTablesProxyModel::index(int row, int column, const QModelIndex &parent)


static void _init_f_index_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel *)cls)->index (arg1, arg2, arg3));
}


// QMap<int, QVariant> QConcatenateTablesProxyModel::itemData(const QModelIndex &proxyIndex)


static void _init_f_itemData_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_f_itemData_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QConcatenateTablesProxyModel *)cls)->itemData (arg1));
}


// QModelIndex QConcatenateTablesProxyModel::mapFromSource(const QModelIndex &sourceIndex)


static void _init_f_mapFromSource_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_mapFromSource_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel *)cls)->mapFromSource (arg1));
}


// QModelIndex QConcatenateTablesProxyModel::mapToSource(const QModelIndex &proxyIndex)


static void _init_f_mapToSource_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_mapToSource_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel *)cls)->mapToSource (arg1));
}


// QMimeData *QConcatenateTablesProxyModel::mimeData(const QList<QModelIndex> &indexes)


static void _init_f_mimeData_c3010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_f_mimeData_c3010 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  ret.write<QMimeData * > ((QMimeData *)((QConcatenateTablesProxyModel *)cls)->mimeData (arg1));
}


// QStringList QConcatenateTablesProxyModel::mimeTypes()


static void _init_f_mimeTypes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_mimeTypes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QConcatenateTablesProxyModel *)cls)->mimeTypes ());
}


// QModelIndex QConcatenateTablesProxyModel::parent(const QModelIndex &index)


static void _init_f_parent_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_parent_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel *)cls)->parent (arg1));
}


// void QConcatenateTablesProxyModel::removeSourceModel(QAbstractItemModel *sourceModel)


static void _init_f_removeSourceModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceModel");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeSourceModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel *)cls)->removeSourceModel (arg1);
}


// int QConcatenateTablesProxyModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QConcatenateTablesProxyModel *)cls)->rowCount (arg1));
}


// bool QConcatenateTablesProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)


static void _init_f_setData_5065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setData_5065 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::EditRole, heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel *)cls)->setData (arg1, arg2, arg3));
}


// bool QConcatenateTablesProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)


static void _init_f_setItemData_5414 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setItemData_5414 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QMap<int, QVariant> &arg2 = gsi::arg_reader<const QMap<int, QVariant> & >() (args, heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel *)cls)->setItemData (arg1, arg2));
}


// QList<QAbstractItemModel *> QConcatenateTablesProxyModel::sourceModels()


static void _init_f_sourceModels_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAbstractItemModel *> > ();
}

static void _call_f_sourceModels_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAbstractItemModel *> > ((QList<QAbstractItemModel *>)((QConcatenateTablesProxyModel *)cls)->sourceModels ());
}


// QSize QConcatenateTablesProxyModel::span(const QModelIndex &index)


static void _init_f_span_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_f_span_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QSize > ((QSize)((QConcatenateTablesProxyModel *)cls)->span (arg1));
}


// static QString QConcatenateTablesProxyModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QConcatenateTablesProxyModel::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QConcatenateTablesProxyModel () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addSourceModel", "@brief Method void QConcatenateTablesProxyModel::addSourceModel(QAbstractItemModel *sourceModel)\n", false, &_init_f_addSourceModel_2419, &_call_f_addSourceModel_2419);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@brief Method bool QConcatenateTablesProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::canDropMimeData", true, &_init_f_canDropMimeData_c7425, &_call_f_canDropMimeData_c7425);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Method int QConcatenateTablesProxyModel::columnCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::columnCount", true, &_init_f_columnCount_c2395, &_call_f_columnCount_c2395);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QVariant QConcatenateTablesProxyModel::data(const QModelIndex &index, int role)\nThis is a reimplementation of QAbstractItemModel::data", true, &_init_f_data_c3054, &_call_f_data_c3054);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Method bool QConcatenateTablesProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::dropMimeData", false, &_init_f_dropMimeData_7425, &_call_f_dropMimeData_7425);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<Qt::ItemFlag> QConcatenateTablesProxyModel::flags(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::flags", true, &_init_f_flags_c2395, &_call_f_flags_c2395);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QConcatenateTablesProxyModel::headerData(int section, Qt::Orientation orientation, int role)\nThis is a reimplementation of QAbstractItemModel::headerData", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QConcatenateTablesProxyModel::index(int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::index", true, &_init_f_index_c3713, &_call_f_index_c3713);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Method QMap<int, QVariant> QConcatenateTablesProxyModel::itemData(const QModelIndex &proxyIndex)\nThis is a reimplementation of QAbstractItemModel::itemData", true, &_init_f_itemData_c2395, &_call_f_itemData_c2395);
  methods += new qt_gsi::GenericMethod ("mapFromSource", "@brief Method QModelIndex QConcatenateTablesProxyModel::mapFromSource(const QModelIndex &sourceIndex)\n", true, &_init_f_mapFromSource_c2395, &_call_f_mapFromSource_c2395);
  methods += new qt_gsi::GenericMethod ("mapToSource", "@brief Method QModelIndex QConcatenateTablesProxyModel::mapToSource(const QModelIndex &proxyIndex)\n", true, &_init_f_mapToSource_c2395, &_call_f_mapToSource_c2395);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Method QMimeData *QConcatenateTablesProxyModel::mimeData(const QList<QModelIndex> &indexes)\nThis is a reimplementation of QAbstractItemModel::mimeData", true, &_init_f_mimeData_c3010, &_call_f_mimeData_c3010);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Method QStringList QConcatenateTablesProxyModel::mimeTypes()\nThis is a reimplementation of QAbstractItemModel::mimeTypes", true, &_init_f_mimeTypes_c0, &_call_f_mimeTypes_c0);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Method QModelIndex QConcatenateTablesProxyModel::parent(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::parent", true, &_init_f_parent_c2395, &_call_f_parent_c2395);
  methods += new qt_gsi::GenericMethod ("removeSourceModel", "@brief Method void QConcatenateTablesProxyModel::removeSourceModel(QAbstractItemModel *sourceModel)\n", false, &_init_f_removeSourceModel_2419, &_call_f_removeSourceModel_2419);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QConcatenateTablesProxyModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Method bool QConcatenateTablesProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis is a reimplementation of QAbstractItemModel::setData", false, &_init_f_setData_5065, &_call_f_setData_5065);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Method bool QConcatenateTablesProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis is a reimplementation of QAbstractItemModel::setItemData", false, &_init_f_setItemData_5414, &_call_f_setItemData_5414);
  methods += new qt_gsi::GenericMethod ("sourceModels", "@brief Method QList<QAbstractItemModel *> QConcatenateTablesProxyModel::sourceModels()\n", true, &_init_f_sourceModels_c0, &_call_f_sourceModels_c0);
  methods += new qt_gsi::GenericMethod ("span", "@brief Method QSize QConcatenateTablesProxyModel::span(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::span", true, &_init_f_span_c2395, &_call_f_span_c2395);
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeInserted(const QModelIndex &, int, int)", "columnsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QConcatenateTablesProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationColumn"), "@brief Signal declaration for QConcatenateTablesProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeRemoved(const QModelIndex &, int, int)", "columnsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QConcatenateTablesProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsInserted(const QModelIndex &, int, int)", "columnsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QConcatenateTablesProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("column"), "@brief Signal declaration for QConcatenateTablesProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsRemoved(const QModelIndex &, int, int)", "columnsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QConcatenateTablesProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex &, const QList<int> & > ("dataChanged(const QModelIndex &, const QModelIndex &, const QList<int> &)", "dataChanged", gsi::arg("topLeft"), gsi::arg("bottomRight"), gsi::arg("roles"), "@brief Signal declaration for QConcatenateTablesProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QConcatenateTablesProxyModel::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int > ("headerDataChanged(Qt::Orientation, int, int)", "headerDataChanged", gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QConcatenateTablesProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutAboutToBeChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutAboutToBeChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QConcatenateTablesProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QConcatenateTablesProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelAboutToBeReset()", "modelAboutToBeReset", "@brief Signal declaration for QConcatenateTablesProxyModel::modelAboutToBeReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelReset()", "modelReset", "@brief Signal declaration for QConcatenateTablesProxyModel::modelReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QConcatenateTablesProxyModel::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeInserted(const QModelIndex &, int, int)", "rowsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QConcatenateTablesProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationRow"), "@brief Signal declaration for QConcatenateTablesProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeRemoved(const QModelIndex &, int, int)", "rowsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QConcatenateTablesProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsInserted(const QModelIndex &, int, int)", "rowsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QConcatenateTablesProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("row"), "@brief Signal declaration for QConcatenateTablesProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsRemoved(const QModelIndex &, int, int)", "rowsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QConcatenateTablesProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QConcatenateTablesProxyModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QAbstractItemModel> &qtdecl_QAbstractItemModel ();

qt_gsi::QtNativeClass<QConcatenateTablesProxyModel> decl_QConcatenateTablesProxyModel (qtdecl_QAbstractItemModel (), "QtCore", "QConcatenateTablesProxyModel_Native",
  methods_QConcatenateTablesProxyModel (),
  "@hide\n@alias QConcatenateTablesProxyModel");

GSI_QTCORE_PUBLIC gsi::Class<QConcatenateTablesProxyModel> &qtdecl_QConcatenateTablesProxyModel () { return decl_QConcatenateTablesProxyModel; }

}


class QConcatenateTablesProxyModel_Adaptor : public QConcatenateTablesProxyModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QConcatenateTablesProxyModel_Adaptor();

  //  [adaptor ctor] QConcatenateTablesProxyModel::QConcatenateTablesProxyModel(QObject *parent)
  QConcatenateTablesProxyModel_Adaptor() : QConcatenateTablesProxyModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QConcatenateTablesProxyModel::QConcatenateTablesProxyModel(QObject *parent)
  QConcatenateTablesProxyModel_Adaptor(QObject *parent) : QConcatenateTablesProxyModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QConcatenateTablesProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QConcatenateTablesProxyModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QConcatenateTablesProxyModel::beginInsertColumns(parent, first, last);
  }

  //  [expose] void QConcatenateTablesProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QConcatenateTablesProxyModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QConcatenateTablesProxyModel::beginInsertRows(parent, first, last);
  }

  //  [expose] bool QConcatenateTablesProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QConcatenateTablesProxyModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QConcatenateTablesProxyModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  [expose] bool QConcatenateTablesProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QConcatenateTablesProxyModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QConcatenateTablesProxyModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  [expose] void QConcatenateTablesProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QConcatenateTablesProxyModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QConcatenateTablesProxyModel::beginRemoveColumns(parent, first, last);
  }

  //  [expose] void QConcatenateTablesProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QConcatenateTablesProxyModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QConcatenateTablesProxyModel::beginRemoveRows(parent, first, last);
  }

  //  [expose] void QConcatenateTablesProxyModel::beginResetModel()
  void fp_QConcatenateTablesProxyModel_beginResetModel_0 () {
    QConcatenateTablesProxyModel::beginResetModel();
  }

  //  [expose] void QConcatenateTablesProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QConcatenateTablesProxyModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QConcatenateTablesProxyModel::changePersistentIndex(from, to);
  }

  //  [expose] void QConcatenateTablesProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QConcatenateTablesProxyModel_changePersistentIndexList_5912 (const QList<QModelIndex> &from, const QList<QModelIndex> &to) {
    QConcatenateTablesProxyModel::changePersistentIndexList(from, to);
  }

  //  [expose] QModelIndex QConcatenateTablesProxyModel::createIndex(int row, int column, const void *data)
  QModelIndex fp_QConcatenateTablesProxyModel_createIndex_c3069 (int row, int column, const void *data) const {
    return QConcatenateTablesProxyModel::createIndex(row, column, data);
  }

  //  [expose] QModelIndex QConcatenateTablesProxyModel::createIndex(int row, int column, quintptr id)
  QModelIndex fp_QConcatenateTablesProxyModel_createIndex_c2657 (int row, int column, quintptr id) const {
    return QConcatenateTablesProxyModel::createIndex(row, column, id);
  }

  //  [expose] bool QConcatenateTablesProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QConcatenateTablesProxyModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QConcatenateTablesProxyModel::decodeData(row, column, parent, stream);
  }

  //  [expose] void QConcatenateTablesProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QConcatenateTablesProxyModel_encodeData_c4599 (const QList<QModelIndex> &indexes, QDataStream &stream) const {
    QConcatenateTablesProxyModel::encodeData(indexes, stream);
  }

  //  [expose] void QConcatenateTablesProxyModel::endInsertColumns()
  void fp_QConcatenateTablesProxyModel_endInsertColumns_0 () {
    QConcatenateTablesProxyModel::endInsertColumns();
  }

  //  [expose] void QConcatenateTablesProxyModel::endInsertRows()
  void fp_QConcatenateTablesProxyModel_endInsertRows_0 () {
    QConcatenateTablesProxyModel::endInsertRows();
  }

  //  [expose] void QConcatenateTablesProxyModel::endMoveColumns()
  void fp_QConcatenateTablesProxyModel_endMoveColumns_0 () {
    QConcatenateTablesProxyModel::endMoveColumns();
  }

  //  [expose] void QConcatenateTablesProxyModel::endMoveRows()
  void fp_QConcatenateTablesProxyModel_endMoveRows_0 () {
    QConcatenateTablesProxyModel::endMoveRows();
  }

  //  [expose] void QConcatenateTablesProxyModel::endRemoveColumns()
  void fp_QConcatenateTablesProxyModel_endRemoveColumns_0 () {
    QConcatenateTablesProxyModel::endRemoveColumns();
  }

  //  [expose] void QConcatenateTablesProxyModel::endRemoveRows()
  void fp_QConcatenateTablesProxyModel_endRemoveRows_0 () {
    QConcatenateTablesProxyModel::endRemoveRows();
  }

  //  [expose] void QConcatenateTablesProxyModel::endResetModel()
  void fp_QConcatenateTablesProxyModel_endResetModel_0 () {
    QConcatenateTablesProxyModel::endResetModel();
  }

  //  [expose] bool QConcatenateTablesProxyModel::isSignalConnected(const QMetaMethod &signal)
  bool fp_QConcatenateTablesProxyModel_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QConcatenateTablesProxyModel::isSignalConnected(signal);
  }

  //  [expose] QList<QModelIndex> QConcatenateTablesProxyModel::persistentIndexList()
  QList<QModelIndex> fp_QConcatenateTablesProxyModel_persistentIndexList_c0 () const {
    return QConcatenateTablesProxyModel::persistentIndexList();
  }

  //  [expose] int QConcatenateTablesProxyModel::receivers(const char *signal)
  int fp_QConcatenateTablesProxyModel_receivers_c1731 (const char *signal) const {
    return QConcatenateTablesProxyModel::receivers(signal);
  }

  //  [expose] QObject *QConcatenateTablesProxyModel::sender()
  QObject * fp_QConcatenateTablesProxyModel_sender_c0 () const {
    return QConcatenateTablesProxyModel::sender();
  }

  //  [expose] int QConcatenateTablesProxyModel::senderSignalIndex()
  int fp_QConcatenateTablesProxyModel_senderSignalIndex_c0 () const {
    return QConcatenateTablesProxyModel::senderSignalIndex();
  }

  //  [adaptor impl] QModelIndex QConcatenateTablesProxyModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QConcatenateTablesProxyModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QConcatenateTablesProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QConcatenateTablesProxyModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_canDropMimeData_c7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent) const
  {
    return QConcatenateTablesProxyModel::canDropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent) const
  {
    if (cb_canDropMimeData_c7425_0.can_issue()) {
      return cb_canDropMimeData_c7425_0.issue<QConcatenateTablesProxyModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_canDropMimeData_c7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QConcatenateTablesProxyModel::canDropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QConcatenateTablesProxyModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QConcatenateTablesProxyModel_Adaptor, bool, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QConcatenateTablesProxyModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::clearItemData(const QModelIndex &index)
  bool cbs_clearItemData_2395_0(const QModelIndex &index)
  {
    return QConcatenateTablesProxyModel::clearItemData(index);
  }

  virtual bool clearItemData(const QModelIndex &index)
  {
    if (cb_clearItemData_2395_0.can_issue()) {
      return cb_clearItemData_2395_0.issue<QConcatenateTablesProxyModel_Adaptor, bool, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_clearItemData_2395_0, index);
    } else {
      return QConcatenateTablesProxyModel::clearItemData(index);
    }
  }

  //  [adaptor impl] int QConcatenateTablesProxyModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    return QConcatenateTablesProxyModel::columnCount(parent);
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QConcatenateTablesProxyModel_Adaptor, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      return QConcatenateTablesProxyModel::columnCount(parent);
    }
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QConcatenateTablesProxyModel_columnsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  void emitter_QConcatenateTablesProxyModel_columnsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationColumn);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QConcatenateTablesProxyModel_columnsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QConcatenateTablesProxyModel_columnsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  void emitter_QConcatenateTablesProxyModel_columnsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (column);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QConcatenateTablesProxyModel_columnsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] QVariant QConcatenateTablesProxyModel::data(const QModelIndex &index, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &index, int role) const
  {
    return QConcatenateTablesProxyModel::data(index, role);
  }

  virtual QVariant data(const QModelIndex &index, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QConcatenateTablesProxyModel_Adaptor, QVariant, const QModelIndex &, int>(&QConcatenateTablesProxyModel_Adaptor::cbs_data_c3054_1, index, role);
    } else {
      return QConcatenateTablesProxyModel::data(index, role);
    }
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  void emitter_QConcatenateTablesProxyModel_dataChanged_6833(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  {
    emit QConcatenateTablesProxyModel::dataChanged(topLeft, bottomRight, roles);
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::destroyed(QObject *)
  void emitter_QConcatenateTablesProxyModel_destroyed_1302(QObject *arg1)
  {
    emit QConcatenateTablesProxyModel::destroyed(arg1);
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QConcatenateTablesProxyModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QConcatenateTablesProxyModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QConcatenateTablesProxyModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QConcatenateTablesProxyModel::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QConcatenateTablesProxyModel_Adaptor, bool, QEvent *>(&QConcatenateTablesProxyModel_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QConcatenateTablesProxyModel::event(_event);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QConcatenateTablesProxyModel::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QConcatenateTablesProxyModel_Adaptor, bool, QObject *, QEvent *>(&QConcatenateTablesProxyModel_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QConcatenateTablesProxyModel::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QConcatenateTablesProxyModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QConcatenateTablesProxyModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QConcatenateTablesProxyModel_Adaptor, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QConcatenateTablesProxyModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QConcatenateTablesProxyModel::flags(const QModelIndex &index)
  QFlags<Qt::ItemFlag> cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return QConcatenateTablesProxyModel::flags(index);
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return cb_flags_c2395_0.issue<QConcatenateTablesProxyModel_Adaptor, QFlags<Qt::ItemFlag>, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_flags_c2395_0, index);
    } else {
      return QConcatenateTablesProxyModel::flags(index);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::hasChildren(const QModelIndex &parent)
  bool cbs_hasChildren_c2395_1(const QModelIndex &parent) const
  {
    return QConcatenateTablesProxyModel::hasChildren(parent);
  }

  virtual bool hasChildren(const QModelIndex &parent) const
  {
    if (cb_hasChildren_c2395_1.can_issue()) {
      return cb_hasChildren_c2395_1.issue<QConcatenateTablesProxyModel_Adaptor, bool, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_hasChildren_c2395_1, parent);
    } else {
      return QConcatenateTablesProxyModel::hasChildren(parent);
    }
  }

  //  [adaptor impl] QVariant QConcatenateTablesProxyModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QConcatenateTablesProxyModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QConcatenateTablesProxyModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QConcatenateTablesProxyModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QConcatenateTablesProxyModel::headerData(section, orientation, role);
    }
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)
  void emitter_QConcatenateTablesProxyModel_headerDataChanged_3231(Qt::Orientation orientation, int first, int last)
  {
    emit QConcatenateTablesProxyModel::headerDataChanged(orientation, first, last);
  }

  //  [adaptor impl] QModelIndex QConcatenateTablesProxyModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QConcatenateTablesProxyModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QConcatenateTablesProxyModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QConcatenateTablesProxyModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QConcatenateTablesProxyModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QConcatenateTablesProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QConcatenateTablesProxyModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QConcatenateTablesProxyModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QConcatenateTablesProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QConcatenateTablesProxyModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QMap<int, QVariant> QConcatenateTablesProxyModel::itemData(const QModelIndex &proxyIndex)
  QMap<int, QVariant> cbs_itemData_c2395_0(const QModelIndex &proxyIndex) const
  {
    return QConcatenateTablesProxyModel::itemData(proxyIndex);
  }

  virtual QMap<int, QVariant> itemData(const QModelIndex &proxyIndex) const
  {
    if (cb_itemData_c2395_0.can_issue()) {
      return cb_itemData_c2395_0.issue<QConcatenateTablesProxyModel_Adaptor, QMap<int, QVariant>, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_itemData_c2395_0, proxyIndex);
    } else {
      return QConcatenateTablesProxyModel::itemData(proxyIndex);
    }
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QConcatenateTablesProxyModel_layoutAboutToBeChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QConcatenateTablesProxyModel::layoutAboutToBeChanged(parents, hint);
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QConcatenateTablesProxyModel_layoutChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QConcatenateTablesProxyModel::layoutChanged(parents, hint);
  }

  //  [adaptor impl] QList<QModelIndex> QConcatenateTablesProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  QList<QModelIndex> cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    return QConcatenateTablesProxyModel::match(start, role, value, hits, flags);
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return cb_match_c7932_2.issue<QConcatenateTablesProxyModel_Adaptor, QList<QModelIndex>, const QModelIndex &, int, const QVariant &, int, QFlags<Qt::MatchFlag> >(&QConcatenateTablesProxyModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, flags);
    } else {
      return QConcatenateTablesProxyModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QConcatenateTablesProxyModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const QList<QModelIndex> &indexes) const
  {
    return QConcatenateTablesProxyModel::mimeData(indexes);
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QConcatenateTablesProxyModel_Adaptor, QMimeData *, const QList<QModelIndex> &>(&QConcatenateTablesProxyModel_Adaptor::cbs_mimeData_c3010_0, indexes);
    } else {
      return QConcatenateTablesProxyModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QConcatenateTablesProxyModel::mimeTypes()
  QStringList cbs_mimeTypes_c0_0() const
  {
    return QConcatenateTablesProxyModel::mimeTypes();
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return cb_mimeTypes_c0_0.issue<QConcatenateTablesProxyModel_Adaptor, QStringList>(&QConcatenateTablesProxyModel_Adaptor::cbs_mimeTypes_c0_0);
    } else {
      return QConcatenateTablesProxyModel::mimeTypes();
    }
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::modelAboutToBeReset()
  void emitter_QConcatenateTablesProxyModel_modelAboutToBeReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::modelAboutToBeReset()'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::modelReset()
  void emitter_QConcatenateTablesProxyModel_modelReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::modelReset()'");
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveColumns_6659_0(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QConcatenateTablesProxyModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
  }

  virtual bool moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveColumns_6659_0.can_issue()) {
      return cb_moveColumns_6659_0.issue<QConcatenateTablesProxyModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QConcatenateTablesProxyModel_Adaptor::cbs_moveColumns_6659_0, sourceParent, sourceColumn, count, destinationParent, destinationChild);
    } else {
      return QConcatenateTablesProxyModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveRows_6659_0(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QConcatenateTablesProxyModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
  }

  virtual bool moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveRows_6659_0.can_issue()) {
      return cb_moveRows_6659_0.issue<QConcatenateTablesProxyModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QConcatenateTablesProxyModel_Adaptor::cbs_moveRows_6659_0, sourceParent, sourceRow, count, destinationParent, destinationChild);
    } else {
      return QConcatenateTablesProxyModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] void QConcatenateTablesProxyModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)
  void cbs_multiData_c4483_0(const QModelIndex &index, QModelRoleDataSpan roleDataSpan) const
  {
    QConcatenateTablesProxyModel::multiData(index, roleDataSpan);
  }

  virtual void multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan) const
  {
    if (cb_multiData_c4483_0.can_issue()) {
      cb_multiData_c4483_0.issue<QConcatenateTablesProxyModel_Adaptor, const QModelIndex &, QModelRoleDataSpan>(&QConcatenateTablesProxyModel_Adaptor::cbs_multiData_c4483_0, index, roleDataSpan);
    } else {
      QConcatenateTablesProxyModel::multiData(index, roleDataSpan);
    }
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::objectNameChanged(const QString &objectName)
  void emitter_QConcatenateTablesProxyModel_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QModelIndex QConcatenateTablesProxyModel::parent(const QModelIndex &index)
  QModelIndex cbs_parent_c2395_0(const QModelIndex &index) const
  {
    return QConcatenateTablesProxyModel::parent(index);
  }

  virtual QModelIndex parent(const QModelIndex &index) const
  {
    if (cb_parent_c2395_0.can_issue()) {
      return cb_parent_c2395_0.issue<QConcatenateTablesProxyModel_Adaptor, QModelIndex, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_parent_c2395_0, index);
    } else {
      return QConcatenateTablesProxyModel::parent(index);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QConcatenateTablesProxyModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QConcatenateTablesProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QConcatenateTablesProxyModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QConcatenateTablesProxyModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QConcatenateTablesProxyModel_Adaptor, bool, int, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QConcatenateTablesProxyModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QConcatenateTablesProxyModel::revert()
  void cbs_revert_0_0()
  {
    QConcatenateTablesProxyModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QConcatenateTablesProxyModel_Adaptor>(&QConcatenateTablesProxyModel_Adaptor::cbs_revert_0_0);
    } else {
      QConcatenateTablesProxyModel::revert();
    }
  }

  //  [adaptor impl] QHash<int, QByteArray> QConcatenateTablesProxyModel::roleNames()
  QHash<int, QByteArray> cbs_roleNames_c0_0() const
  {
    return QConcatenateTablesProxyModel::roleNames();
  }

  virtual QHash<int, QByteArray> roleNames() const
  {
    if (cb_roleNames_c0_0.can_issue()) {
      return cb_roleNames_c0_0.issue<QConcatenateTablesProxyModel_Adaptor, QHash<int, QByteArray> >(&QConcatenateTablesProxyModel_Adaptor::cbs_roleNames_c0_0);
    } else {
      return QConcatenateTablesProxyModel::roleNames();
    }
  }

  //  [adaptor impl] int QConcatenateTablesProxyModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QConcatenateTablesProxyModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QConcatenateTablesProxyModel_Adaptor, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QConcatenateTablesProxyModel::rowCount(parent);
    }
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QConcatenateTablesProxyModel_rowsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  void emitter_QConcatenateTablesProxyModel_rowsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationRow);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QConcatenateTablesProxyModel_rowsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QConcatenateTablesProxyModel_rowsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  void emitter_QConcatenateTablesProxyModel_rowsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (row);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)'");
  }

  //  [emitter impl] void QConcatenateTablesProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QConcatenateTablesProxyModel_rowsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QConcatenateTablesProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QConcatenateTablesProxyModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QConcatenateTablesProxyModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QConcatenateTablesProxyModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QConcatenateTablesProxyModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QConcatenateTablesProxyModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QConcatenateTablesProxyModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QConcatenateTablesProxyModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QConcatenateTablesProxyModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  bool cbs_setItemData_5414_0(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    return QConcatenateTablesProxyModel::setItemData(index, roles);
  }

  virtual bool setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    if (cb_setItemData_5414_0.can_issue()) {
      return cb_setItemData_5414_0.issue<QConcatenateTablesProxyModel_Adaptor, bool, const QModelIndex &, const QMap<int, QVariant> &>(&QConcatenateTablesProxyModel_Adaptor::cbs_setItemData_5414_0, index, roles);
    } else {
      return QConcatenateTablesProxyModel::setItemData(index, roles);
    }
  }

  //  [adaptor impl] QModelIndex QConcatenateTablesProxyModel::sibling(int row, int column, const QModelIndex &idx)
  QModelIndex cbs_sibling_c3713_0(int row, int column, const QModelIndex &idx) const
  {
    return QConcatenateTablesProxyModel::sibling(row, column, idx);
  }

  virtual QModelIndex sibling(int row, int column, const QModelIndex &idx) const
  {
    if (cb_sibling_c3713_0.can_issue()) {
      return cb_sibling_c3713_0.issue<QConcatenateTablesProxyModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_sibling_c3713_0, row, column, idx);
    } else {
      return QConcatenateTablesProxyModel::sibling(row, column, idx);
    }
  }

  //  [adaptor impl] void QConcatenateTablesProxyModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QConcatenateTablesProxyModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QConcatenateTablesProxyModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QConcatenateTablesProxyModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QConcatenateTablesProxyModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QConcatenateTablesProxyModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QConcatenateTablesProxyModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QConcatenateTablesProxyModel_Adaptor, QSize, const QModelIndex &>(&QConcatenateTablesProxyModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QConcatenateTablesProxyModel::span(index);
    }
  }

  //  [adaptor impl] bool QConcatenateTablesProxyModel::submit()
  bool cbs_submit_0_0()
  {
    return QConcatenateTablesProxyModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QConcatenateTablesProxyModel_Adaptor, bool>(&QConcatenateTablesProxyModel_Adaptor::cbs_submit_0_0);
    } else {
      return QConcatenateTablesProxyModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QConcatenateTablesProxyModel::supportedDragActions()
  QFlags<Qt::DropAction> cbs_supportedDragActions_c0_0() const
  {
    return QConcatenateTablesProxyModel::supportedDragActions();
  }

  virtual QFlags<Qt::DropAction> supportedDragActions() const
  {
    if (cb_supportedDragActions_c0_0.can_issue()) {
      return cb_supportedDragActions_c0_0.issue<QConcatenateTablesProxyModel_Adaptor, QFlags<Qt::DropAction> >(&QConcatenateTablesProxyModel_Adaptor::cbs_supportedDragActions_c0_0);
    } else {
      return QConcatenateTablesProxyModel::supportedDragActions();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QConcatenateTablesProxyModel::supportedDropActions()
  QFlags<Qt::DropAction> cbs_supportedDropActions_c0_0() const
  {
    return QConcatenateTablesProxyModel::supportedDropActions();
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return cb_supportedDropActions_c0_0.issue<QConcatenateTablesProxyModel_Adaptor, QFlags<Qt::DropAction> >(&QConcatenateTablesProxyModel_Adaptor::cbs_supportedDropActions_c0_0);
    } else {
      return QConcatenateTablesProxyModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QConcatenateTablesProxyModel::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QConcatenateTablesProxyModel::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QConcatenateTablesProxyModel_Adaptor, QChildEvent *>(&QConcatenateTablesProxyModel_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QConcatenateTablesProxyModel::childEvent(event);
    }
  }

  //  [adaptor impl] void QConcatenateTablesProxyModel::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QConcatenateTablesProxyModel::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QConcatenateTablesProxyModel_Adaptor, QEvent *>(&QConcatenateTablesProxyModel_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QConcatenateTablesProxyModel::customEvent(event);
    }
  }

  //  [adaptor impl] void QConcatenateTablesProxyModel::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QConcatenateTablesProxyModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QConcatenateTablesProxyModel_Adaptor, const QMetaMethod &>(&QConcatenateTablesProxyModel_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QConcatenateTablesProxyModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QConcatenateTablesProxyModel::resetInternalData()
  void cbs_resetInternalData_0_0()
  {
    QConcatenateTablesProxyModel::resetInternalData();
  }

  virtual void resetInternalData()
  {
    if (cb_resetInternalData_0_0.can_issue()) {
      cb_resetInternalData_0_0.issue<QConcatenateTablesProxyModel_Adaptor>(&QConcatenateTablesProxyModel_Adaptor::cbs_resetInternalData_0_0);
    } else {
      QConcatenateTablesProxyModel::resetInternalData();
    }
  }

  //  [adaptor impl] void QConcatenateTablesProxyModel::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QConcatenateTablesProxyModel::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QConcatenateTablesProxyModel_Adaptor, QTimerEvent *>(&QConcatenateTablesProxyModel_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QConcatenateTablesProxyModel::timerEvent(event);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canDropMimeData_c7425_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_clearItemData_2395_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_hasChildren_c2395_1;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_itemData_c2395_0;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_moveColumns_6659_0;
  gsi::Callback cb_moveRows_6659_0;
  gsi::Callback cb_multiData_c4483_0;
  gsi::Callback cb_parent_c2395_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_roleNames_c0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_setItemData_5414_0;
  gsi::Callback cb_sibling_c3713_0;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDragActions_c0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_resetInternalData_0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QConcatenateTablesProxyModel_Adaptor::~QConcatenateTablesProxyModel_Adaptor() { }

//  Constructor QConcatenateTablesProxyModel::QConcatenateTablesProxyModel(QObject *parent) (adaptor class)

static void _init_ctor_QConcatenateTablesProxyModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QConcatenateTablesProxyModel_Adaptor> ();
}

static void _call_ctor_QConcatenateTablesProxyModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QConcatenateTablesProxyModel_Adaptor *> (new QConcatenateTablesProxyModel_Adaptor (arg1));
}


// exposed void QConcatenateTablesProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}


// exposed void QConcatenateTablesProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_beginInsertRows_3713 (arg1, arg2, arg3);
}


// exposed bool QConcatenateTablesProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed bool QConcatenateTablesProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed void QConcatenateTablesProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}


// exposed void QConcatenateTablesProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}


// exposed void QConcatenateTablesProxyModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_beginResetModel_0 ();
}


// QModelIndex QConcatenateTablesProxyModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}


// bool QConcatenateTablesProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_canDropMimeData_c7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_canDropMimeData_c7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_canDropMimeData_c7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_canDropMimeData_c7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_canDropMimeData_c7425_0 = cb;
}


// bool QConcatenateTablesProxyModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}


// exposed void QConcatenateTablesProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_changePersistentIndex_4682 (arg1, arg2);
}


// exposed void QConcatenateTablesProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QList<QModelIndex> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  const QList<QModelIndex> &arg2 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_changePersistentIndexList_5912 (arg1, arg2);
}


// void QConcatenateTablesProxyModel::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// bool QConcatenateTablesProxyModel::clearItemData(const QModelIndex &index)

static void _init_cbs_clearItemData_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_clearItemData_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_clearItemData_2395_0 (arg1));
}

static void _set_callback_cbs_clearItemData_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_clearItemData_2395_0 = cb;
}


// int QConcatenateTablesProxyModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}


// emitter void QConcatenateTablesProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_columnsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QConcatenateTablesProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)

static void _init_emitter_columnsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_columnsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QConcatenateTablesProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_columnsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QConcatenateTablesProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_columnsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QConcatenateTablesProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)

static void _init_emitter_columnsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("column");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_columnsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QConcatenateTablesProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_columnsRemoved_7372 (arg1, arg2, arg3);
}


// exposed QModelIndex QConcatenateTablesProxyModel::createIndex(int row, int column, const void *data)

static void _init_fp_createIndex_c3069 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "nullptr");
  decl->add_arg<const void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c3069 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const void *arg3 = args ? gsi::arg_reader<const void * >() (args, heap) : gsi::arg_maker<const void * >() (nullptr, heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_createIndex_c3069 (arg1, arg2, arg3));
}


// exposed QModelIndex QConcatenateTablesProxyModel::createIndex(int row, int column, quintptr id)

static void _init_fp_createIndex_c2657 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quintptr > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2657 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  quintptr arg3 = gsi::arg_reader<quintptr >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_createIndex_c2657 (arg1, arg2, arg3));
}


// void QConcatenateTablesProxyModel::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QVariant QConcatenateTablesProxyModel::data(const QModelIndex &index, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}


// emitter void QConcatenateTablesProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)

static void _init_emitter_dataChanged_6833 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles", true, "QList<int>()");
  decl->add_arg<const QList<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_dataChanged_6833 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QList<int> &arg3 = args ? gsi::arg_reader<const QList<int> & >() (args, heap) : gsi::arg_maker<const QList<int> & >() (QList<int>(), heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_dataChanged_6833 (arg1, arg2, arg3);
}


// exposed bool QConcatenateTablesProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QDataStream &arg4 = gsi::arg_reader<QDataStream & >() (args, heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}


// emitter void QConcatenateTablesProxyModel::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_destroyed_1302 (arg1);
}


// void QConcatenateTablesProxyModel::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QConcatenateTablesProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}


// exposed void QConcatenateTablesProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  QDataStream &arg2 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_encodeData_c4599 (arg1, arg2);
}


// exposed void QConcatenateTablesProxyModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_endInsertColumns_0 ();
}


// exposed void QConcatenateTablesProxyModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_endInsertRows_0 ();
}


// exposed void QConcatenateTablesProxyModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_endMoveColumns_0 ();
}


// exposed void QConcatenateTablesProxyModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_endMoveRows_0 ();
}


// exposed void QConcatenateTablesProxyModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_endRemoveColumns_0 ();
}


// exposed void QConcatenateTablesProxyModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_endRemoveRows_0 ();
}


// exposed void QConcatenateTablesProxyModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_endResetModel_0 ();
}


// bool QConcatenateTablesProxyModel::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QConcatenateTablesProxyModel::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QConcatenateTablesProxyModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}


// QFlags<Qt::ItemFlag> QConcatenateTablesProxyModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}


// bool QConcatenateTablesProxyModel::hasChildren(const QModelIndex &parent)

static void _init_cbs_hasChildren_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasChildren_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_hasChildren_c2395_1 (arg1));
}

static void _set_callback_cbs_hasChildren_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_hasChildren_c2395_1 = cb;
}


// QVariant QConcatenateTablesProxyModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}


// emitter void QConcatenateTablesProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)

static void _init_emitter_headerDataChanged_3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_headerDataChanged_3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_headerDataChanged_3231 (arg1, arg2, arg3);
}


// QModelIndex QConcatenateTablesProxyModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}


// bool QConcatenateTablesProxyModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}


// bool QConcatenateTablesProxyModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}


// exposed bool QConcatenateTablesProxyModel::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_isSignalConnected_c2394 (arg1));
}


// QMap<int, QVariant> QConcatenateTablesProxyModel::itemData(const QModelIndex &proxyIndex)

static void _init_cbs_itemData_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxyIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_cbs_itemData_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_itemData_c2395_0 (arg1));
}

static void _set_callback_cbs_itemData_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_itemData_c2395_0 = cb;
}


// emitter void QConcatenateTablesProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutAboutToBeChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutAboutToBeChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_layoutAboutToBeChanged_7947 (arg1, arg2);
}


// emitter void QConcatenateTablesProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_layoutChanged_7947 (arg1, arg2);
}


// QList<QModelIndex> QConcatenateTablesProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  QFlags<Qt::MatchFlag> arg5 = args.read<QFlags<Qt::MatchFlag> > (heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}


// QMimeData *QConcatenateTablesProxyModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = args.read<const QList<QModelIndex> & > (heap);
  ret.write<QMimeData * > ((QMimeData *)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}


// QStringList QConcatenateTablesProxyModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}


// emitter void QConcatenateTablesProxyModel::modelAboutToBeReset()

static void _init_emitter_modelAboutToBeReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelAboutToBeReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_modelAboutToBeReset_3767 ();
}


// emitter void QConcatenateTablesProxyModel::modelReset()

static void _init_emitter_modelReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_modelReset_3767 ();
}


// bool QConcatenateTablesProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveColumns_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceColumn");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveColumns_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_moveColumns_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveColumns_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_moveColumns_6659_0 = cb;
}


// bool QConcatenateTablesProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveRows_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceRow");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveRows_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_moveRows_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveRows_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_moveRows_6659_0 = cb;
}


// void QConcatenateTablesProxyModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)

static void _init_cbs_multiData_c4483_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roleDataSpan");
  decl->add_arg<QModelRoleDataSpan > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_multiData_c4483_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  QModelRoleDataSpan arg2 = args.read<QModelRoleDataSpan > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_multiData_c4483_0 (arg1, arg2);
}

static void _set_callback_cbs_multiData_c4483_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_multiData_c4483_0 = cb;
}


// emitter void QConcatenateTablesProxyModel::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_objectNameChanged_4567 (arg1);
}


// QModelIndex QConcatenateTablesProxyModel::parent(const QModelIndex &index)

static void _init_cbs_parent_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_parent_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_parent_c2395_0 (arg1));
}

static void _set_callback_cbs_parent_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_parent_c2395_0 = cb;
}


// exposed QList<QModelIndex> QConcatenateTablesProxyModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_persistentIndexList_c0 ());
}


// exposed int QConcatenateTablesProxyModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_receivers_c1731 (arg1));
}


// bool QConcatenateTablesProxyModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}


// bool QConcatenateTablesProxyModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}


// void QConcatenateTablesProxyModel::resetInternalData()

static void _init_cbs_resetInternalData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_resetInternalData_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_resetInternalData_0_0 ();
}

static void _set_callback_cbs_resetInternalData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_resetInternalData_0_0 = cb;
}


// void QConcatenateTablesProxyModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}


// QHash<int, QByteArray> QConcatenateTablesProxyModel::roleNames()

static void _init_cbs_roleNames_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHash<int, QByteArray> > ();
}

static void _call_cbs_roleNames_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHash<int, QByteArray> > ((QHash<int, QByteArray>)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_roleNames_c0_0 ());
}

static void _set_callback_cbs_roleNames_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_roleNames_c0_0 = cb;
}


// int QConcatenateTablesProxyModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}


// emitter void QConcatenateTablesProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_rowsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QConcatenateTablesProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)

static void _init_emitter_rowsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_rowsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QConcatenateTablesProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_rowsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QConcatenateTablesProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_rowsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QConcatenateTablesProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)

static void _init_emitter_rowsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("row");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_rowsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QConcatenateTablesProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->emitter_QConcatenateTablesProxyModel_rowsRemoved_7372 (arg1, arg2, arg3);
}


// exposed QObject *QConcatenateTablesProxyModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_sender_c0 ());
}


// exposed int QConcatenateTablesProxyModel::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QConcatenateTablesProxyModel_Adaptor *)cls)->fp_QConcatenateTablesProxyModel_senderSignalIndex_c0 ());
}


// bool QConcatenateTablesProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}


// bool QConcatenateTablesProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}


// bool QConcatenateTablesProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)

static void _init_cbs_setItemData_5414_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setItemData_5414_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QMap<int, QVariant> &arg2 = args.read<const QMap<int, QVariant> & > (heap);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_setItemData_5414_0 (arg1, arg2));
}

static void _set_callback_cbs_setItemData_5414_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_setItemData_5414_0 = cb;
}


// QModelIndex QConcatenateTablesProxyModel::sibling(int row, int column, const QModelIndex &idx)

static void _init_cbs_sibling_c3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_sibling_c3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_sibling_c3713_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_sibling_c3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_sibling_c3713_0 = cb;
}


// void QConcatenateTablesProxyModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}


// QSize QConcatenateTablesProxyModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}


// bool QConcatenateTablesProxyModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}


// QFlags<Qt::DropAction> QConcatenateTablesProxyModel::supportedDragActions()

static void _init_cbs_supportedDragActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDragActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_supportedDragActions_c0_0 ());
}

static void _set_callback_cbs_supportedDragActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_supportedDragActions_c0_0 = cb;
}


// QFlags<Qt::DropAction> QConcatenateTablesProxyModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}


// void QConcatenateTablesProxyModel::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QConcatenateTablesProxyModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QConcatenateTablesProxyModel> &qtdecl_QConcatenateTablesProxyModel ();

static gsi::Methods methods_QConcatenateTablesProxyModel_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QConcatenateTablesProxyModel::QConcatenateTablesProxyModel(QObject *parent)\nThis method creates an object of class QConcatenateTablesProxyModel.", &_init_ctor_QConcatenateTablesProxyModel_Adaptor_1302, &_call_ctor_QConcatenateTablesProxyModel_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*beginInsertColumns", "@brief Method void QConcatenateTablesProxyModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginInsertRows", "@brief Method void QConcatenateTablesProxyModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginMoveColumns", "@brief Method bool QConcatenateTablesProxyModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
  methods += new qt_gsi::GenericMethod ("*beginMoveRows", "@brief Method bool QConcatenateTablesProxyModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
  methods += new qt_gsi::GenericMethod ("*beginRemoveColumns", "@brief Method void QConcatenateTablesProxyModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginRemoveRows", "@brief Method void QConcatenateTablesProxyModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginResetModel", "@brief Method void QConcatenateTablesProxyModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QConcatenateTablesProxyModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@brief Virtual method bool QConcatenateTablesProxyModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@hide", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0, &_set_callback_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QConcatenateTablesProxyModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndex", "@brief Method void QConcatenateTablesProxyModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndexList", "@brief Method void QConcatenateTablesProxyModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QConcatenateTablesProxyModel::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clearItemData", "@brief Virtual method bool QConcatenateTablesProxyModel::clearItemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clearItemData_2395_0, &_call_cbs_clearItemData_2395_0);
  methods += new qt_gsi::GenericMethod ("clearItemData", "@hide", false, &_init_cbs_clearItemData_2395_0, &_call_cbs_clearItemData_2395_0, &_set_callback_cbs_clearItemData_2395_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QConcatenateTablesProxyModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeInserted", "@brief Emitter for signal void QConcatenateTablesProxyModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeInserted_7372, &_call_emitter_columnsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeMoved", "@brief Emitter for signal void QConcatenateTablesProxyModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeMoved_10318, &_call_emitter_columnsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeRemoved", "@brief Emitter for signal void QConcatenateTablesProxyModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeRemoved_7372, &_call_emitter_columnsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsInserted", "@brief Emitter for signal void QConcatenateTablesProxyModel::columnsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsInserted_7372, &_call_emitter_columnsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsMoved", "@brief Emitter for signal void QConcatenateTablesProxyModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nCall this method to emit this signal.", false, &_init_emitter_columnsMoved_10318, &_call_emitter_columnsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsRemoved", "@brief Emitter for signal void QConcatenateTablesProxyModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsRemoved_7372, &_call_emitter_columnsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QConcatenateTablesProxyModel::createIndex(int row, int column, const void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c3069, &_call_fp_createIndex_c3069);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QConcatenateTablesProxyModel::createIndex(int row, int column, quintptr id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2657, &_call_fp_createIndex_c2657);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QConcatenateTablesProxyModel::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QConcatenateTablesProxyModel::data(const QModelIndex &index, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("emit_dataChanged", "@brief Emitter for signal void QConcatenateTablesProxyModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nCall this method to emit this signal.", false, &_init_emitter_dataChanged_6833, &_call_emitter_dataChanged_6833);
  methods += new qt_gsi::GenericMethod ("*decodeData", "@brief Method bool QConcatenateTablesProxyModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QConcatenateTablesProxyModel::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QConcatenateTablesProxyModel::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QConcatenateTablesProxyModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("*encodeData", "@brief Method void QConcatenateTablesProxyModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
  methods += new qt_gsi::GenericMethod ("*endInsertColumns", "@brief Method void QConcatenateTablesProxyModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
  methods += new qt_gsi::GenericMethod ("*endInsertRows", "@brief Method void QConcatenateTablesProxyModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
  methods += new qt_gsi::GenericMethod ("*endMoveColumns", "@brief Method void QConcatenateTablesProxyModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endMoveRows", "@brief Method void QConcatenateTablesProxyModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveColumns", "@brief Method void QConcatenateTablesProxyModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveRows", "@brief Method void QConcatenateTablesProxyModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endResetModel", "@brief Method void QConcatenateTablesProxyModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QConcatenateTablesProxyModel::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QConcatenateTablesProxyModel::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QConcatenateTablesProxyModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QConcatenateTablesProxyModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@brief Virtual method bool QConcatenateTablesProxyModel::hasChildren(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1);
  methods += new qt_gsi::GenericMethod ("hasChildren", "@hide", true, &_init_cbs_hasChildren_c2395_1, &_call_cbs_hasChildren_c2395_1, &_set_callback_cbs_hasChildren_c2395_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QConcatenateTablesProxyModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("emit_headerDataChanged", "@brief Emitter for signal void QConcatenateTablesProxyModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_headerDataChanged_3231, &_call_emitter_headerDataChanged_3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QConcatenateTablesProxyModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QConcatenateTablesProxyModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QConcatenateTablesProxyModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QConcatenateTablesProxyModel::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Virtual method QMap<int, QVariant> QConcatenateTablesProxyModel::itemData(const QModelIndex &proxyIndex)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("itemData", "@hide", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0, &_set_callback_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutAboutToBeChanged", "@brief Emitter for signal void QConcatenateTablesProxyModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutAboutToBeChanged_7947, &_call_emitter_layoutAboutToBeChanged_7947);
  methods += new qt_gsi::GenericMethod ("emit_layoutChanged", "@brief Emitter for signal void QConcatenateTablesProxyModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutChanged_7947, &_call_emitter_layoutChanged_7947);
  methods += new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QConcatenateTablesProxyModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QConcatenateTablesProxyModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QConcatenateTablesProxyModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_modelAboutToBeReset", "@brief Emitter for signal void QConcatenateTablesProxyModel::modelAboutToBeReset()\nCall this method to emit this signal.", false, &_init_emitter_modelAboutToBeReset_3767, &_call_emitter_modelAboutToBeReset_3767);
  methods += new qt_gsi::GenericMethod ("emit_modelReset", "@brief Emitter for signal void QConcatenateTablesProxyModel::modelReset()\nCall this method to emit this signal.", false, &_init_emitter_modelReset_3767, &_call_emitter_modelReset_3767);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@brief Virtual method bool QConcatenateTablesProxyModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@hide", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0, &_set_callback_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@brief Virtual method bool QConcatenateTablesProxyModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@hide", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0, &_set_callback_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("multiData", "@brief Virtual method void QConcatenateTablesProxyModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_multiData_c4483_0, &_call_cbs_multiData_c4483_0);
  methods += new qt_gsi::GenericMethod ("multiData", "@hide", true, &_init_cbs_multiData_c4483_0, &_call_cbs_multiData_c4483_0, &_set_callback_cbs_multiData_c4483_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QConcatenateTablesProxyModel::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Virtual method QModelIndex QConcatenateTablesProxyModel::parent(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0);
  methods += new qt_gsi::GenericMethod ("parent", "@hide", true, &_init_cbs_parent_c2395_0, &_call_cbs_parent_c2395_0, &_set_callback_cbs_parent_c2395_0);
  methods += new qt_gsi::GenericMethod ("*persistentIndexList", "@brief Method QList<QModelIndex> QConcatenateTablesProxyModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QConcatenateTablesProxyModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QConcatenateTablesProxyModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QConcatenateTablesProxyModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@brief Virtual method void QConcatenateTablesProxyModel::resetInternalData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resetInternalData_0_0, &_call_cbs_resetInternalData_0_0);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@hide", false, &_init_cbs_resetInternalData_0_0, &_call_cbs_resetInternalData_0_0, &_set_callback_cbs_resetInternalData_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QConcatenateTablesProxyModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@brief Virtual method QHash<int, QByteArray> QConcatenateTablesProxyModel::roleNames()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@hide", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0, &_set_callback_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QConcatenateTablesProxyModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeInserted", "@brief Emitter for signal void QConcatenateTablesProxyModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeInserted_7372, &_call_emitter_rowsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeMoved", "@brief Emitter for signal void QConcatenateTablesProxyModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeMoved_10318, &_call_emitter_rowsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeRemoved", "@brief Emitter for signal void QConcatenateTablesProxyModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeRemoved_7372, &_call_emitter_rowsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsInserted", "@brief Emitter for signal void QConcatenateTablesProxyModel::rowsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsInserted_7372, &_call_emitter_rowsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsMoved", "@brief Emitter for signal void QConcatenateTablesProxyModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nCall this method to emit this signal.", false, &_init_emitter_rowsMoved_10318, &_call_emitter_rowsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsRemoved", "@brief Emitter for signal void QConcatenateTablesProxyModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsRemoved_7372, &_call_emitter_rowsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QConcatenateTablesProxyModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QConcatenateTablesProxyModel::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QConcatenateTablesProxyModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QConcatenateTablesProxyModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Virtual method bool QConcatenateTablesProxyModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setItemData", "@hide", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0, &_set_callback_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Virtual method QModelIndex QConcatenateTablesProxyModel::sibling(int row, int column, const QModelIndex &idx)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@hide", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0, &_set_callback_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QConcatenateTablesProxyModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
  methods += new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QConcatenateTablesProxyModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QConcatenateTablesProxyModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@brief Virtual method QFlags<Qt::DropAction> QConcatenateTablesProxyModel::supportedDragActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@hide", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0, &_set_callback_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QConcatenateTablesProxyModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QConcatenateTablesProxyModel::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QConcatenateTablesProxyModel_Adaptor> decl_QConcatenateTablesProxyModel_Adaptor (qtdecl_QConcatenateTablesProxyModel (), "QtCore", "QConcatenateTablesProxyModel",
  methods_QConcatenateTablesProxyModel_Adaptor (),
  "@qt\n@brief Binding of QConcatenateTablesProxyModel");

}

