/*

Copyright (C) 2020 Pantxo Diribarne

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see
<https://www.gnu.org/licenses/>.

Author: Pantxo Diribarne <pantxo@dibona>
Created: 2020-12-04

*/

#include <octave/oct.h>
#include <octave/text-renderer.h>

DEFUN_DLD(__text_to_pixels__, args, nargout,
          "-*- texinfo -*-\n\
@deftypefn {} {@var{ALPHA} =} __text_to_pixels__ (@var{text}, @var{fontname}, @var{fontsize})\n\
Render @var{text} to pixels and return a 4-by-M-by-N uint8 array.\n\
@seealso{}\n\
@end deftypefn")
{
  int nargin = args.length ();

  if (nargin != 3)
    print_usage ();

  std::string txt
    = args(0).string_value ("__text_to_pixels__:TEXT must be a string.");

  std::string fontname
    = args(1).string_value ("__text_to_pixels__:FONTNAME must be a string.");

  double fontsize
    = args(2).double_value ("__text_to_pixels__:FONTSIZE must be numeric a scalar.");

  octave::text_renderer txt_renderer;
  txt_renderer.set_font (fontname, "normal", "normal", fontsize);

  uint8NDArray pixels;
  Matrix bbox;
  txt_renderer.text_to_pixels (txt, pixels, bbox,
                               /*halign*/ 0, /*valign*/ 0, /*rotation*/ 0.0,
                               /*interpreter*/ "none");

  return ovl (pixels, bbox);
}
