%feature("docstring") OT::PiecewiseLinearEvaluation
"Piecewise linear interpolation evaluation.

Parameters
----------
locations : sequence of float
    Locations
values : 1-d or 2-d sequence of float
    Values at each location

See also
--------
PiecewiseHermiteEvaluation

Notes
-----
The evaluation returns constant values for data outside the bounds of the design of experiments.
Thus, the approximation should not be used outside the range of the design of experiments.
The possibility of extrapolation can be changed using :meth:`setEnableExtrapolation` (default value is *True*, see :class:`~openturns.ResourceMap`). 
If this parameter is set to *False*, an error message is retrieved for evaluations outside the design of experiments.

Examples
--------
>>> import openturns as ot
>>> locations = [1.0, 2.0, 3.0, 4.0, 5.0]
>>> values = [-2.0, 2.0, 1.0, 3.0, 5.0]
>>> evaluation = ot.PiecewiseLinearEvaluation(locations, values)
>>> f = ot.Function(evaluation)
>>> print(f([2.5]))
[1.5]"

// ---------------------------------------------------------------------

%feature("docstring") OT::PiecewiseLinearEvaluation::getLocations
"Accessor to the locations.

Returns
-------
locations : :class:`~openturns.Point`
    Locations."

// ---------------------------------------------------------------------

%feature("docstring") OT::PiecewiseLinearEvaluation::getValues
"Accessor to the values.

Returns
-------
values : :class:`~openturns.Sample`
    Values of the function at the locations."

// ---------------------------------------------------------------------

%feature("docstring") OT::PiecewiseLinearEvaluation::setLocations
"Accessor to the locations.

Parameters
----------
locations : :class:`~openturns.Point`
    Locations."

// ---------------------------------------------------------------------

%feature("docstring") OT::PiecewiseLinearEvaluation::setValues
"Accessor to the values.

Parameters
----------
values : :class:`~openturns.Sample`
    Values of the function at the locations."

// ---------------------------------------------------------------------

%feature("docstring") OT::PiecewiseLinearEvaluation::setLocationsAndValues
"Accessor to the locations and values.

Parameters
----------
locations : :class:`~openturns.Point`
    Locations.
values : :class:`~openturns.Sample`
    Values of the function at the locations."

// ---------------------------------------------------------------------

%feature("docstring") OT::PiecewiseLinearEvaluation::setEnableExtrapolation
"Accessor to the parameters allowing extrapolation outside the design of experiments.

Parameters
----------
enableExtrapolation : bool
    Parameter for extrapolation."
    
// ---------------------------------------------------------------------

%feature("docstring") OT::PiecewiseLinearEvaluation::getEnableExtrapolation
"Accessor to the parameters allowing extrapolation outside the design of experiments.

Returns
-------
enableExtrapolation : bool
    Parameter for extrapolation."
