// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SSUBL2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SSUBL2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_ssubl2_8H[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd9, 0xffde, 0xffd4, 0xfffb, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffb7, 0xffb2, 0xffcf, 0xfffa, 0xfffe, 0xfffe, 0xfffe, 0xfffe,
  0xff8b, 0xffad, 0xffce, 0xfff9, 0xfffd, 0xfffd, 0xfffd, 0xfff8,
  0xff86, 0xffac, 0xffcd, 0xfff8, 0xfffc, 0xfffc, 0xfff7, 0xffcd,
  0xff85, 0xffab, 0xffcc, 0xfff7, 0xfffb, 0xfff6, 0xffcc, 0xffab,
  0xff84, 0xffaa, 0xffcb, 0xfff6, 0xfff5, 0xffcb, 0xffaa, 0xff83,
  0xff83, 0xffa9, 0xffca, 0xfff0, 0xffca, 0xffa9, 0xff82, 0xff82,
  0xff82, 0xffa8, 0xffc4, 0xffc5, 0xffa8, 0xff81, 0xff81, 0xff81,
  0xff81, 0xffa2, 0xff99, 0xffa3, 0xff80, 0xff80, 0xff80, 0x0080,
  0xff7b, 0xff77, 0xff77, 0xff7b, 0xff7f, 0xff7f, 0x007f, 0x007f,
  0xff50, 0xff55, 0xff4f, 0xff7a, 0xff7e, 0x007e, 0x007e, 0x007e,
  0xff2e, 0xff2d, 0xff4e, 0xff79, 0x007d, 0x007d, 0x007d, 0x007d,
  0xff06, 0xff2c, 0xff4d, 0x0078, 0x007c, 0x007c, 0x007c, 0x0056,
  0xff05, 0xff2b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x0034,
  0xff04, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x0008,
  0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x0003,
  0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x0002,
  0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x0001,
  0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffde, 0xffd4, 0xfffb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffb2, 0xffcf, 0xfffa, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfff9,
  0xffad, 0xffce, 0xfff9, 0xfffd, 0xfffd, 0xfffd, 0xfff8, 0xffce,
  0xffac, 0xffcd, 0xfff8, 0xfffc, 0xfffc, 0xfff7, 0xffcd, 0xffac,
  0xffab, 0xffcc, 0xfff7, 0xfffb, 0xfff6, 0xffcc, 0xffab, 0xff84,
  0xffaa, 0xffcb, 0xfff6, 0xfff5, 0xffcb, 0xffaa, 0xff83, 0xff83,
  0xffa9, 0xffca, 0xfff0, 0xffca, 0xffa9, 0xff82, 0xff82, 0xff82,
  0xffa8, 0xffc4, 0xffc5, 0xffa8, 0xff81, 0xff81, 0xff81, 0x0081,
  0xffa2, 0xff99, 0xffa3, 0xff80, 0xff80, 0xff80, 0x0080, 0x0080,
  0xff77, 0xff77, 0xff7b, 0xff7f, 0xff7f, 0x007f, 0x007f, 0x007f,
  0xff55, 0xff4f, 0xff7a, 0xff7e, 0x007e, 0x007e, 0x007e, 0x007e,
  0xff2d, 0xff4e, 0xff79, 0x007d, 0x007d, 0x007d, 0x007d, 0x0057,
  0xff2c, 0xff4d, 0x0078, 0x007c, 0x007c, 0x007c, 0x0056, 0x0035,
  0xff2b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x0034, 0x0009,
  0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x0008, 0x0004,
  0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x0003, 0x0003,
  0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x0002, 0x0002,
  0x0049, 0x004e, 0x0031, 0x0006, 0x0002, 0x0002, 0x0002, 0x0002,
  0x0022, 0x002c, 0x0005, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd4, 0xfffb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffa,
  0xffcf, 0xfffa, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfff9, 0xffcf,
  0xffce, 0xfff9, 0xfffd, 0xfffd, 0xfffd, 0xfff8, 0xffce, 0xffad,
  0xffcd, 0xfff8, 0xfffc, 0xfffc, 0xfff7, 0xffcd, 0xffac, 0xff85,
  0xffcc, 0xfff7, 0xfffb, 0xfff6, 0xffcc, 0xffab, 0xff84, 0xff84,
  0xffcb, 0xfff6, 0xfff5, 0xffcb, 0xffaa, 0xff83, 0xff83, 0xff83,
  0xffca, 0xfff0, 0xffca, 0xffa9, 0xff82, 0xff82, 0xff82, 0x0082,
  0xffc4, 0xffc5, 0xffa8, 0xff81, 0xff81, 0xff81, 0x0081, 0x0081,
  0xff99, 0xffa3, 0xff80, 0xff80, 0xff80, 0x0080, 0x0080, 0x0080,
  0xff77, 0xff7b, 0xff7f, 0xff7f, 0x007f, 0x007f, 0x007f, 0x007f,
  0xff4f, 0xff7a, 0xff7e, 0x007e, 0x007e, 0x007e, 0x007e, 0x0058,
  0xff4e, 0xff79, 0x007d, 0x007d, 0x007d, 0x007d, 0x0057, 0x0036,
  0xff4d, 0x0078, 0x007c, 0x007c, 0x007c, 0x0056, 0x0035, 0x000a,
  0x004c, 0x0077, 0x007b, 0x007b, 0x0055, 0x0034, 0x0009, 0x0005,
  0x004b, 0x0076, 0x007a, 0x0054, 0x0033, 0x0008, 0x0004, 0x0004,
  0x004a, 0x0075, 0x0053, 0x0032, 0x0007, 0x0003, 0x0003, 0x0003,
  0x0075, 0x0053, 0x0032, 0x0007, 0x0003, 0x0003, 0x0003, 0x0008,
  0x004e, 0x0031, 0x0006, 0x0002, 0x0002, 0x0002, 0x0002, 0x0007,
  0x002c, 0x0005, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0006,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffa, 0xffd5,
  0xfffa, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfff9, 0xffcf, 0xffb3,
  0xfff9, 0xfffd, 0xfffd, 0xfffd, 0xfff8, 0xffce, 0xffad, 0xff8b,
  0xfff8, 0xfffc, 0xfffc, 0xfff7, 0xffcd, 0xffac, 0xff85, 0xff8a,
  0xfff7, 0xfffb, 0xfff6, 0xffcc, 0xffab, 0xff84, 0xff84, 0xff89,
  0xfff6, 0xfff5, 0xffcb, 0xffaa, 0xff83, 0xff83, 0xff83, 0x0088,
  0xfff0, 0xffca, 0xffa9, 0xff82, 0xff82, 0xff82, 0x0082, 0x0087,
  0xffc5, 0xffa8, 0xff81, 0xff81, 0xff81, 0x0081, 0x0081, 0x0086,
  0xffa3, 0xff80, 0xff80, 0xff80, 0x0080, 0x0080, 0x0080, 0x0085,
  0xff7b, 0xff7f, 0xff7f, 0x007f, 0x007f, 0x007f, 0x007f, 0x005e,
  0xff7a, 0xff7e, 0x007e, 0x007e, 0x007e, 0x007e, 0x0058, 0x003c,
  0xff79, 0x007d, 0x007d, 0x007d, 0x007d, 0x0057, 0x0036, 0x0010,
  0x0078, 0x007c, 0x007c, 0x007c, 0x0056, 0x0035, 0x000a, 0x000b,
  0x0077, 0x007b, 0x007b, 0x0055, 0x0034, 0x0009, 0x0005, 0x000a,
  0x0076, 0x007a, 0x0054, 0x0033, 0x0008, 0x0004, 0x0004, 0x0009,
  0x007a, 0x0054, 0x0033, 0x0008, 0x0004, 0x0004, 0x0009, 0x0033,
  0x0053, 0x0032, 0x0007, 0x0003, 0x0003, 0x0003, 0x0008, 0x0032,
  0x0031, 0x0006, 0x0002, 0x0002, 0x0002, 0x0002, 0x0007, 0x0031,
  0x0005, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0006, 0x002b,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffa, 0xffd5, 0xffde,
  0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfff9, 0xffcf, 0xffb3, 0xffb6,
  0xfffd, 0xfffd, 0xfffd, 0xfff8, 0xffce, 0xffad, 0xff8b, 0xffb5,
  0xfffc, 0xfffc, 0xfff7, 0xffcd, 0xffac, 0xff85, 0xff8a, 0xffb4,
  0xfffb, 0xfff6, 0xffcc, 0xffab, 0xff84, 0xff84, 0xff89, 0x00b3,
  0xfff5, 0xffcb, 0xffaa, 0xff83, 0xff83, 0xff83, 0x0088, 0x00b2,
  0xffca, 0xffa9, 0xff82, 0xff82, 0xff82, 0x0082, 0x0087, 0x00b1,
  0xffa8, 0xff81, 0xff81, 0xff81, 0x0081, 0x0081, 0x0086, 0x00b0,
  0xff80, 0xff80, 0xff80, 0x0080, 0x0080, 0x0080, 0x0085, 0x0089,
  0xff7f, 0xff7f, 0x007f, 0x007f, 0x007f, 0x007f, 0x005e, 0x0067,
  0xff7e, 0x007e, 0x007e, 0x007e, 0x007e, 0x0058, 0x003c, 0x003b,
  0x007d, 0x007d, 0x007d, 0x007d, 0x0057, 0x0036, 0x0010, 0x0036,
  0x007c, 0x007c, 0x007c, 0x0056, 0x0035, 0x000a, 0x000b, 0x0035,
  0x007b, 0x007b, 0x0055, 0x0034, 0x0009, 0x0005, 0x000a, 0x0034,
  0x007b, 0x0055, 0x0034, 0x0009, 0x0005, 0x000a, 0x0034, 0x0055,
  0x0054, 0x0033, 0x0008, 0x0004, 0x0004, 0x0009, 0x0033, 0x0054,
  0x0032, 0x0007, 0x0003, 0x0003, 0x0003, 0x0008, 0x0032, 0x0053,
  0x0006, 0x0002, 0x0002, 0x0002, 0x0002, 0x0007, 0x0031, 0x004d,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0xfffa, 0xffd5, 0xffde, 0xffd8,
  0xfffe, 0xfffe, 0xfffe, 0xfff9, 0xffcf, 0xffb3, 0xffb6, 0xffd7,
  0xfffd, 0xfffd, 0xfff8, 0xffce, 0xffad, 0xff8b, 0xffb5, 0xffd6,
  0xfffc, 0xfff7, 0xffcd, 0xffac, 0xff85, 0xff8a, 0xffb4, 0x00d5,
  0xfff6, 0xffcc, 0xffab, 0xff84, 0xff84, 0xff89, 0x00b3, 0x00d4,
  0xffcb, 0xffaa, 0xff83, 0xff83, 0xff83, 0x0088, 0x00b2, 0x00d3,
  0xffa9, 0xff82, 0xff82, 0xff82, 0x0082, 0x0087, 0x00b1, 0x00d2,
  0xff81, 0xff81, 0xff81, 0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab,
  0xff80, 0xff80, 0x0080, 0x0080, 0x0080, 0x0085, 0x0089, 0x0089,
  0xff7f, 0x007f, 0x007f, 0x007f, 0x007f, 0x005e, 0x0067, 0x005d,
  0x007e, 0x007e, 0x007e, 0x007e, 0x0058, 0x003c, 0x003b, 0x0058,
  0x007d, 0x007d, 0x007d, 0x0057, 0x0036, 0x0010, 0x0036, 0x0057,
  0x007c, 0x007c, 0x0056, 0x0035, 0x000a, 0x000b, 0x0035, 0x0056,
  0x007c, 0x0056, 0x0035, 0x000a, 0x000b, 0x0035, 0x0056, 0x007d,
  0x0055, 0x0034, 0x0009, 0x0005, 0x000a, 0x0034, 0x0055, 0x007c,
  0x0033, 0x0008, 0x0004, 0x0004, 0x0009, 0x0033, 0x0054, 0x007b,
  0x0007, 0x0003, 0x0003, 0x0003, 0x0008, 0x0032, 0x0053, 0x0075,
  0x0002, 0x0002, 0x0002, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a,
  0x0001, 0x0001, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xfffa, 0xffd5, 0xffde, 0xffd8, 0xffff,
  0xfffe, 0xfffe, 0xfff9, 0xffcf, 0xffb3, 0xffb6, 0xffd7, 0xfffe,
  0xfffd, 0xfff8, 0xffce, 0xffad, 0xff8b, 0xffb5, 0xffd6, 0x00fd,
  0xfff7, 0xffcd, 0xffac, 0xff85, 0xff8a, 0xffb4, 0x00d5, 0x00fc,
  0xffcc, 0xffab, 0xff84, 0xff84, 0xff89, 0x00b3, 0x00d4, 0x00fb,
  0xffaa, 0xff83, 0xff83, 0xff83, 0x0088, 0x00b2, 0x00d3, 0x00fa,
  0xff82, 0xff82, 0xff82, 0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3,
  0xff81, 0xff81, 0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1,
  0xff80, 0x0080, 0x0080, 0x0080, 0x0085, 0x0089, 0x0089, 0x0085,
  0x007f, 0x007f, 0x007f, 0x007f, 0x005e, 0x0067, 0x005d, 0x0080,
  0x007e, 0x007e, 0x007e, 0x0058, 0x003c, 0x003b, 0x0058, 0x007f,
  0x007d, 0x007d, 0x0057, 0x0036, 0x0010, 0x0036, 0x0057, 0x007e,
  0x007d, 0x0057, 0x0036, 0x0010, 0x0036, 0x0057, 0x007e, 0x007e,
  0x0056, 0x0035, 0x000a, 0x000b, 0x0035, 0x0056, 0x007d, 0x007d,
  0x0034, 0x0009, 0x0005, 0x000a, 0x0034, 0x0055, 0x007c, 0x007c,
  0x0008, 0x0004, 0x0004, 0x0009, 0x0033, 0x0054, 0x007b, 0x0076,
  0x0003, 0x0003, 0x0003, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b,
  0x0002, 0x0002, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029,
  0x0001, 0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfffa, 0xffd5, 0xffde, 0xffd8, 0xffff, 0xffff,
  0xfffe, 0xfff9, 0xffcf, 0xffb3, 0xffb6, 0xffd7, 0xfffe, 0x00fe,
  0xfff8, 0xffce, 0xffad, 0xff8b, 0xffb5, 0xffd6, 0x00fd, 0x00fd,
  0xffcd, 0xffac, 0xff85, 0xff8a, 0xffb4, 0x00d5, 0x00fc, 0x00fc,
  0xffab, 0xff84, 0xff84, 0xff89, 0x00b3, 0x00d4, 0x00fb, 0x00fb,
  0xff83, 0xff83, 0xff83, 0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4,
  0xff82, 0xff82, 0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2,
  0xff81, 0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086,
  0x0080, 0x0080, 0x0080, 0x0085, 0x0089, 0x0089, 0x0085, 0x0081,
  0x007f, 0x007f, 0x007f, 0x005e, 0x0067, 0x005d, 0x0080, 0x0080,
  0x007e, 0x007e, 0x0058, 0x003c, 0x003b, 0x0058, 0x007f, 0x007f,
  0x007e, 0x0058, 0x003c, 0x003b, 0x0058, 0x007f, 0x007f, 0x007f,
  0x0057, 0x0036, 0x0010, 0x0036, 0x0057, 0x007e, 0x007e, 0x007e,
  0x0035, 0x000a, 0x000b, 0x0035, 0x0056, 0x007d, 0x007d, 0x007d,
  0x0009, 0x0005, 0x000a, 0x0034, 0x0055, 0x007c, 0x007c, 0x0077,
  0x0004, 0x0004, 0x0009, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c,
  0x0003, 0x0003, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a,
  0x0002, 0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002,
  0x0001, 0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfffa, 0xffd5, 0xffde, 0xffd8, 0xffff, 0xffff, 0x00ff,
  0xfff9, 0xffcf, 0xffb3, 0xffb6, 0xffd7, 0xfffe, 0x00fe, 0x00fe,
  0xffce, 0xffad, 0xff8b, 0xffb5, 0xffd6, 0x00fd, 0x00fd, 0x00fd,
  0xffac, 0xff85, 0xff8a, 0xffb4, 0x00d5, 0x00fc, 0x00fc, 0x00fc,
  0xff84, 0xff84, 0xff89, 0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5,
  0xff83, 0xff83, 0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3,
  0xff82, 0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087,
  0x0081, 0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082,
  0x0080, 0x0080, 0x0085, 0x0089, 0x0089, 0x0085, 0x0081, 0x0081,
  0x007f, 0x007f, 0x005e, 0x0067, 0x005d, 0x0080, 0x0080, 0x0080,
  0x007f, 0x005e, 0x0067, 0x005d, 0x0080, 0x0080, 0x0080, 0xff80,
  0x0058, 0x003c, 0x003b, 0x0058, 0x007f, 0x007f, 0x007f, 0xff7f,
  0x0036, 0x0010, 0x0036, 0x0057, 0x007e, 0x007e, 0x007e, 0xff7e,
  0x000a, 0x000b, 0x0035, 0x0056, 0x007d, 0x007d, 0x007d, 0xff78,
  0x0005, 0x000a, 0x0034, 0x0055, 0x007c, 0x007c, 0x0077, 0xff4d,
  0x0004, 0x0009, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0xff2b,
  0x0003, 0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0xff03,
  0x0002, 0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0xff02,
  0x0001, 0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0xff01,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xffd5, 0xffde, 0xffd8, 0xffff, 0xffff, 0x00ff, 0xffff,
  0xffcf, 0xffb3, 0xffb6, 0xffd7, 0xfffe, 0x00fe, 0x00fe, 0xfffe,
  0xffad, 0xff8b, 0xffb5, 0xffd6, 0x00fd, 0x00fd, 0x00fd, 0xfffd,
  0xff85, 0xff8a, 0xffb4, 0x00d5, 0x00fc, 0x00fc, 0x00fc, 0xffd6,
  0xff84, 0xff89, 0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5, 0xffb4,
  0xff83, 0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3, 0xff88,
  0x0082, 0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087, 0xff83,
  0x0081, 0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082, 0xff82,
  0x0080, 0x0085, 0x0089, 0x0089, 0x0085, 0x0081, 0x0081, 0xff81,
  0x0085, 0x0089, 0x0089, 0x0085, 0x0081, 0x0081, 0xff81, 0xff81,
  0x005e, 0x0067, 0x005d, 0x0080, 0x0080, 0x0080, 0xff80, 0xff80,
  0x003c, 0x003b, 0x0058, 0x007f, 0x007f, 0x007f, 0xff7f, 0xff7f,
  0x0010, 0x0036, 0x0057, 0x007e, 0x007e, 0x007e, 0xff7e, 0xff79,
  0x000b, 0x0035, 0x0056, 0x007d, 0x007d, 0x007d, 0xff78, 0xff4e,
  0x000a, 0x0034, 0x0055, 0x007c, 0x007c, 0x0077, 0xff4d, 0xff2c,
  0x0009, 0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0xff2b, 0xff04,
  0x0008, 0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0xff03, 0xff03,
  0x0007, 0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0xff02, 0xff02,
  0x0006, 0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0xff01, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd5, 0xffde, 0xffd8, 0xffff, 0xffff, 0x00ff, 0xffff, 0xffff,
  0xffb3, 0xffb6, 0xffd7, 0xfffe, 0x00fe, 0x00fe, 0xfffe, 0xfffe,
  0xff8b, 0xffb5, 0xffd6, 0x00fd, 0x00fd, 0x00fd, 0xfffd, 0xffd7,
  0xff8a, 0xffb4, 0x00d5, 0x00fc, 0x00fc, 0x00fc, 0xffd6, 0xffb5,
  0xff89, 0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5, 0xffb4, 0xff89,
  0x0088, 0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3, 0xff88, 0xff84,
  0x0087, 0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087, 0xff83, 0xff83,
  0x0086, 0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082, 0xff82, 0xff82,
  0x00b0, 0x00ab, 0x00b1, 0x0086, 0x0082, 0xff82, 0xff82, 0xff82,
  0x0089, 0x0089, 0x0085, 0x0081, 0x0081, 0xff81, 0xff81, 0xff81,
  0x0067, 0x005d, 0x0080, 0x0080, 0x0080, 0xff80, 0xff80, 0xff80,
  0x003b, 0x0058, 0x007f, 0x007f, 0x007f, 0xff7f, 0xff7f, 0xff7a,
  0x0036, 0x0057, 0x007e, 0x007e, 0x007e, 0xff7e, 0xff79, 0xff4f,
  0x0035, 0x0056, 0x007d, 0x007d, 0x007d, 0xff78, 0xff4e, 0xff2d,
  0x0034, 0x0055, 0x007c, 0x007c, 0x0077, 0xff4d, 0xff2c, 0xff05,
  0x0033, 0x0054, 0x007b, 0x0076, 0x004c, 0xff2b, 0xff04, 0xff04,
  0x0032, 0x0053, 0x0075, 0x004b, 0x002a, 0xff03, 0xff03, 0xff03,
  0x0031, 0x004d, 0x004a, 0x0029, 0x0002, 0xff02, 0xff02, 0x0002,
  0x002b, 0x0022, 0x0028, 0x0001, 0x0001, 0xff01, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffde, 0xffd8, 0xffff, 0xffff, 0x00ff, 0xffff, 0xffff, 0xffff,
  0xffb6, 0xffd7, 0xfffe, 0x00fe, 0x00fe, 0xfffe, 0xfffe, 0xffd8,
  0xffb5, 0xffd6, 0x00fd, 0x00fd, 0x00fd, 0xfffd, 0xffd7, 0xffb6,
  0xffb4, 0x00d5, 0x00fc, 0x00fc, 0x00fc, 0xffd6, 0xffb5, 0xff8a,
  0x00b3, 0x00d4, 0x00fb, 0x00fb, 0x00d5, 0xffb4, 0xff89, 0xff85,
  0x00b2, 0x00d3, 0x00fa, 0x00d4, 0x00b3, 0xff88, 0xff84, 0xff84,
  0x00b1, 0x00d2, 0x00d3, 0x00b2, 0x0087, 0xff83, 0xff83, 0xff83,
  0x00d2, 0x00d3, 0x00b2, 0x0087, 0xff83, 0xff83, 0xff83, 0xff83,
  0x00ab, 0x00b1, 0x0086, 0x0082, 0xff82, 0xff82, 0xff82, 0xff82,
  0x0089, 0x0085, 0x0081, 0x0081, 0xff81, 0xff81, 0xff81, 0xff81,
  0x005d, 0x0080, 0x0080, 0x0080, 0xff80, 0xff80, 0xff80, 0xff7b,
  0x0058, 0x007f, 0x007f, 0x007f, 0xff7f, 0xff7f, 0xff7a, 0xff50,
  0x0057, 0x007e, 0x007e, 0x007e, 0xff7e, 0xff79, 0xff4f, 0xff2e,
  0x0056, 0x007d, 0x007d, 0x007d, 0xff78, 0xff4e, 0xff2d, 0xff06,
  0x0055, 0x007c, 0x007c, 0x0077, 0xff4d, 0xff2c, 0xff05, 0xff05,
  0x0054, 0x007b, 0x0076, 0x004c, 0xff2b, 0xff04, 0xff04, 0xff04,
  0x0053, 0x0075, 0x004b, 0x002a, 0xff03, 0xff03, 0xff03, 0x0003,
  0x004d, 0x004a, 0x0029, 0x0002, 0xff02, 0xff02, 0x0002, 0x0002,
  0x0022, 0x0028, 0x0001, 0x0001, 0xff01, 0x0001, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffd8, 0xffff, 0xffff, 0x00ff, 0xffff, 0xffff, 0xffff, 0xffd9,
  0xffd7, 0xfffe, 0x00fe, 0x00fe, 0xfffe, 0xfffe, 0xffd8, 0xffb7,
  0xffd6, 0x00fd, 0x00fd, 0x00fd, 0xfffd, 0xffd7, 0xffb6, 0xff8b,
  0x00d5, 0x00fc, 0x00fc, 0x00fc, 0xffd6, 0xffb5, 0xff8a, 0xff86,
  0x00d4, 0x00fb, 0x00fb, 0x00d5, 0xffb4, 0xff89, 0xff85, 0xff85,
  0x00d3, 0x00fa, 0x00d4, 0x00b3, 0xff88, 0xff84, 0xff84, 0xff84,
  0x00fa, 0x00d4, 0x00b3, 0xff88, 0xff84, 0xff84, 0xff84, 0xffaa,
  0x00d3, 0x00b2, 0x0087, 0xff83, 0xff83, 0xff83, 0xff83, 0xffa9,
  0x00b1, 0x0086, 0x0082, 0xff82, 0xff82, 0xff82, 0xff82, 0xffa8,
  0x0085, 0x0081, 0x0081, 0xff81, 0xff81, 0xff81, 0xff81, 0xffa2,
  0x0080, 0x0080, 0x0080, 0xff80, 0xff80, 0xff80, 0xff7b, 0xff77,
  0x007f, 0x007f, 0x007f, 0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff55,
  0x007e, 0x007e, 0x007e, 0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff2d,
  0x007d, 0x007d, 0x007d, 0xff78, 0xff4e, 0xff2d, 0xff06, 0xff2c,
  0x007c, 0x007c, 0x0077, 0xff4d, 0xff2c, 0xff05, 0xff05, 0xff2b,
  0x007b, 0x0076, 0x004c, 0xff2b, 0xff04, 0xff04, 0xff04, 0x002a,
  0x0075, 0x004b, 0x002a, 0xff03, 0xff03, 0xff03, 0x0003, 0x0029,
  0x004a, 0x0029, 0x0002, 0xff02, 0xff02, 0x0002, 0x0002, 0x0028,
  0x0028, 0x0001, 0x0001, 0xff01, 0x0001, 0x0001, 0x0001, 0x0027,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x00ff, 0xffff, 0xffff, 0xffff, 0xffd9, 0xffde,
  0xfffe, 0x00fe, 0x00fe, 0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xffb2,
  0x00fd, 0x00fd, 0x00fd, 0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xffad,
  0x00fc, 0x00fc, 0x00fc, 0xffd6, 0xffb5, 0xff8a, 0xff86, 0xffac,
  0x00fb, 0x00fb, 0x00d5, 0xffb4, 0xff89, 0xff85, 0xff85, 0xffab,
  0x00fb, 0x00d5, 0xffb4, 0xff89, 0xff85, 0xff85, 0xffab, 0xffcc,
  0x00d4, 0x00b3, 0xff88, 0xff84, 0xff84, 0xff84, 0xffaa, 0xffcb,
  0x00b2, 0x0087, 0xff83, 0xff83, 0xff83, 0xff83, 0xffa9, 0xffca,
  0x0086, 0x0082, 0xff82, 0xff82, 0xff82, 0xff82, 0xffa8, 0xffc4,
  0x0081, 0x0081, 0xff81, 0xff81, 0xff81, 0xff81, 0xffa2, 0xff99,
  0x0080, 0x0080, 0xff80, 0xff80, 0xff80, 0xff7b, 0xff77, 0xff77,
  0x007f, 0x007f, 0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff55, 0xff4f,
  0x007e, 0x007e, 0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff2d, 0xff4e,
  0x007d, 0x007d, 0xff78, 0xff4e, 0xff2d, 0xff06, 0xff2c, 0xff4d,
  0x007c, 0x0077, 0xff4d, 0xff2c, 0xff05, 0xff05, 0xff2b, 0x004c,
  0x0076, 0x004c, 0xff2b, 0xff04, 0xff04, 0xff04, 0x002a, 0x004b,
  0x004b, 0x002a, 0xff03, 0xff03, 0xff03, 0x0003, 0x0029, 0x004a,
  0x0029, 0x0002, 0xff02, 0xff02, 0x0002, 0x0002, 0x0028, 0x0049,
  0x0001, 0x0001, 0xff01, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x00ff, 0xffff, 0xffff, 0xffff, 0xffd9, 0xffde, 0xffd4,
  0x00fe, 0x00fe, 0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xffb2, 0xffcf,
  0x00fd, 0x00fd, 0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xffad, 0xffce,
  0x00fc, 0x00fc, 0xffd6, 0xffb5, 0xff8a, 0xff86, 0xffac, 0xffcd,
  0x00fc, 0xffd6, 0xffb5, 0xff8a, 0xff86, 0xffac, 0xffcd, 0xfff8,
  0x00d5, 0xffb4, 0xff89, 0xff85, 0xff85, 0xffab, 0xffcc, 0xfff7,
  0x00b3, 0xff88, 0xff84, 0xff84, 0xff84, 0xffaa, 0xffcb, 0xfff6,
  0x0087, 0xff83, 0xff83, 0xff83, 0xff83, 0xffa9, 0xffca, 0xfff0,
  0x0082, 0xff82, 0xff82, 0xff82, 0xff82, 0xffa8, 0xffc4, 0xffc5,
  0x0081, 0xff81, 0xff81, 0xff81, 0xff81, 0xffa2, 0xff99, 0xffa3,
  0x0080, 0xff80, 0xff80, 0xff80, 0xff7b, 0xff77, 0xff77, 0xff7b,
  0x007f, 0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff55, 0xff4f, 0xff7a,
  0x007e, 0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff2d, 0xff4e, 0xff79,
  0x007d, 0xff78, 0xff4e, 0xff2d, 0xff06, 0xff2c, 0xff4d, 0x0078,
  0x0077, 0xff4d, 0xff2c, 0xff05, 0xff05, 0xff2b, 0x004c, 0x0077,
  0x004c, 0xff2b, 0xff04, 0xff04, 0xff04, 0x002a, 0x004b, 0x0076,
  0x002a, 0xff03, 0xff03, 0xff03, 0x0003, 0x0029, 0x004a, 0x0075,
  0x0002, 0xff02, 0xff02, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e,
  0x0001, 0xff01, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00ff, 0xffff, 0xffff, 0xffff, 0xffd9, 0xffde, 0xffd4, 0xfffb,
  0x00fe, 0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xffb2, 0xffcf, 0xfffa,
  0x00fd, 0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xffad, 0xffce, 0xfff9,
  0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xffad, 0xffce, 0xfff9, 0xfffd,
  0xffd6, 0xffb5, 0xff8a, 0xff86, 0xffac, 0xffcd, 0xfff8, 0xfffc,
  0xffb4, 0xff89, 0xff85, 0xff85, 0xffab, 0xffcc, 0xfff7, 0xfffb,
  0xff88, 0xff84, 0xff84, 0xff84, 0xffaa, 0xffcb, 0xfff6, 0xfff5,
  0xff83, 0xff83, 0xff83, 0xff83, 0xffa9, 0xffca, 0xfff0, 0xffca,
  0xff82, 0xff82, 0xff82, 0xff82, 0xffa8, 0xffc4, 0xffc5, 0xffa8,
  0xff81, 0xff81, 0xff81, 0xff81, 0xffa2, 0xff99, 0xffa3, 0xff80,
  0xff80, 0xff80, 0xff80, 0xff7b, 0xff77, 0xff77, 0xff7b, 0xff7f,
  0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff55, 0xff4f, 0xff7a, 0xff7e,
  0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff2d, 0xff4e, 0xff79, 0x007d,
  0xff78, 0xff4e, 0xff2d, 0xff06, 0xff2c, 0xff4d, 0x0078, 0x007c,
  0xff4d, 0xff2c, 0xff05, 0xff05, 0xff2b, 0x004c, 0x0077, 0x007b,
  0xff2b, 0xff04, 0xff04, 0xff04, 0x002a, 0x004b, 0x0076, 0x007a,
  0xff03, 0xff03, 0xff03, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053,
  0xff02, 0xff02, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031,
  0xff01, 0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffd9, 0xffde, 0xffd4, 0xfffb, 0xffff,
  0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xffb2, 0xffcf, 0xfffa, 0xfffe,
  0xfffe, 0xffd8, 0xffb7, 0xffb2, 0xffcf, 0xfffa, 0xfffe, 0xfffe,
  0xffd7, 0xffb6, 0xff8b, 0xffad, 0xffce, 0xfff9, 0xfffd, 0xfffd,
  0xffb5, 0xff8a, 0xff86, 0xffac, 0xffcd, 0xfff8, 0xfffc, 0xfffc,
  0xff89, 0xff85, 0xff85, 0xffab, 0xffcc, 0xfff7, 0xfffb, 0xfff6,
  0xff84, 0xff84, 0xff84, 0xffaa, 0xffcb, 0xfff6, 0xfff5, 0xffcb,
  0xff83, 0xff83, 0xff83, 0xffa9, 0xffca, 0xfff0, 0xffca, 0xffa9,
  0xff82, 0xff82, 0xff82, 0xffa8, 0xffc4, 0xffc5, 0xffa8, 0xff81,
  0xff81, 0xff81, 0xff81, 0xffa2, 0xff99, 0xffa3, 0xff80, 0xff80,
  0xff80, 0xff80, 0xff7b, 0xff77, 0xff77, 0xff7b, 0xff7f, 0xff7f,
  0xff7f, 0xff7a, 0xff50, 0xff55, 0xff4f, 0xff7a, 0xff7e, 0x007e,
  0xff79, 0xff4f, 0xff2e, 0xff2d, 0xff4e, 0xff79, 0x007d, 0x007d,
  0xff4e, 0xff2d, 0xff06, 0xff2c, 0xff4d, 0x0078, 0x007c, 0x007c,
  0xff2c, 0xff05, 0xff05, 0xff2b, 0x004c, 0x0077, 0x007b, 0x007b,
  0xff04, 0xff04, 0xff04, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054,
  0xff03, 0xff03, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032,
  0xff02, 0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006,
  0x0001, 0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffd9, 0xffde, 0xffd4, 0xfffb, 0xffff, 0xffff,
  0xffff, 0xffd9, 0xffde, 0xffd4, 0xfffb, 0xffff, 0xffff, 0xffff,
  0xffd8, 0xffb7, 0xffb2, 0xffcf, 0xfffa, 0xfffe, 0xfffe, 0xfffe,
  0xffb6, 0xff8b, 0xffad, 0xffce, 0xfff9, 0xfffd, 0xfffd, 0xfffd,
  0xff8a, 0xff86, 0xffac, 0xffcd, 0xfff8, 0xfffc, 0xfffc, 0xfff7,
  0xff85, 0xff85, 0xffab, 0xffcc, 0xfff7, 0xfffb, 0xfff6, 0xffcc,
  0xff84, 0xff84, 0xffaa, 0xffcb, 0xfff6, 0xfff5, 0xffcb, 0xffaa,
  0xff83, 0xff83, 0xffa9, 0xffca, 0xfff0, 0xffca, 0xffa9, 0xff82,
  0xff82, 0xff82, 0xffa8, 0xffc4, 0xffc5, 0xffa8, 0xff81, 0xff81,
  0xff81, 0xff81, 0xffa2, 0xff99, 0xffa3, 0xff80, 0xff80, 0xff80,
  0xff80, 0xff7b, 0xff77, 0xff77, 0xff7b, 0xff7f, 0xff7f, 0x007f,
  0xff7a, 0xff50, 0xff55, 0xff4f, 0xff7a, 0xff7e, 0x007e, 0x007e,
  0xff4f, 0xff2e, 0xff2d, 0xff4e, 0xff79, 0x007d, 0x007d, 0x007d,
  0xff2d, 0xff06, 0xff2c, 0xff4d, 0x0078, 0x007c, 0x007c, 0x007c,
  0xff05, 0xff05, 0xff2b, 0x004c, 0x0077, 0x007b, 0x007b, 0x0055,
  0xff04, 0xff04, 0x002a, 0x004b, 0x0076, 0x007a, 0x0054, 0x0033,
  0xff03, 0x0003, 0x0029, 0x004a, 0x0075, 0x0053, 0x0032, 0x0007,
  0x0002, 0x0002, 0x0028, 0x0049, 0x004e, 0x0031, 0x0006, 0x0002,
  0x0001, 0x0001, 0x0027, 0x0022, 0x002c, 0x0005, 0x0001, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_ssubl2_8H = 361;

#endif  // VIXL_SIM_SSUBL2_8H_TRACE_AARCH64_H_
