.\" Automatically generated by Pandoc 3.1.3
.\"
.\" Define V font for inline verbatim, using C font in formats
.\" that render this, and otherwise B font.
.ie "\f[CB]x\f[]"x" \{\
. ftr V B
. ftr VI BI
. ftr VB B
. ftr VBI BI
.\}
.el \{\
. ftr V CR
. ftr VI CI
. ftr VB CB
. ftr VBI CBI
.\}
.TH "VORONOTA" "1" "January, 2021" "" ""
.hy
.SH NAME
.PP
Voronota - software for Voronoi tessellation-based analysis of macromolecular structures
.SH SYNOPSIS
.PP
voronota \f[I]command\f[R] [\f[I]options\f[R]]\&...
.PP
voronota-voromqa [\f[I]options\f[R]]\&...
.PP
voronota-cadscore [\f[I]options\f[R]]\&...
.PP
voronota-contacts [\f[I]options\f[R]]\&...
.PP
voronota-volumes [\f[I]options\f[R]]\&...
.PP
voronota-pocket [\f[I]options\f[R]]\&...
.PP
voronota-membrane [\f[I]options\f[R]]\&...
.SH DESCRIPTION
.PP
The analysis of macromolecular structures often requires a comprehensive definition of atomic neighborhoods.
Such a definition can be based on the Voronoi diagram of balls, where each ball represents an atom of some van der Waals radius.
Voronota is a software tool for finding all the vertices of the Voronoi diagram of balls.
Such vertices correspond to the centers of the empty tangent spheres defined by quadruples of balls.
Voronota is especially suitable for processing three-dimensional structures of biological macromolecules such as proteins and RNA.
.PP
Since version 1.2 Voronota also uses the Voronoi vertices to construct inter-atom contact surfaces and solvent accessible surfaces.
Voronota provides tools to query contacts, generate contacts graphics, compare contacts and evaluate quality of protein structural models using contacts.
.PP
The list of all available Voronota commands is displayed when executing Voronota without any parameters.
.PP
Command help is shown when \f[V]--help\f[R] command line option is present, for example:
.IP
.nf
\f[C]
voronota calculate-vertices --help
\f[R]
.fi
.PP
Using \f[V]--help\f[R] option without specific command results in printing help for all commands:
.IP
.nf
\f[C]
voronota --help
\f[R]
.fi
.PP
There are several Voronota wrapper scripts, their interfaces can displayed similarly:
.IP
.nf
\f[C]
voronota-voromqa --help
voronota-cadscore --help
voronota-contacts --help
voronota-volumes --help
voronota-pocket --help
voronota-membrane --help
\f[R]
.fi
.SH SEE ALSO
.PP
The \f[I]README\f[R] file distributed with Voronota contains more detailed documentation.
.PP
The Voronota source code and all the supporting files may be downloaded from <https://github.com/kliment-olechnovic/voronota/releases>.
.SH AUTHORS
Kliment Olechnovic.
