/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.objects.PointObject;

public class MidpointObject
extends PointObject {
    PointObject P1;
    PointObject P2;
    static Count N = new Count();

    public MidpointObject(Construction construction, PointObject pointObject, PointObject pointObject2) {
        super(construction, 0.0, 0.0);
        this.P1 = pointObject;
        this.P2 = pointObject2;
        this.Moveable = false;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Midpoint";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        try {
            this.setText(MidpointObject.text2(Zirkel.name("text.midpoint"), this.P1.getName(), this.P2.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validate() {
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
        } else {
            this.Valid = true;
            this.X = (this.P1.getX() + this.P2.getX()) / 2.0;
            this.Y = (this.P1.getY() + this.P2.getY()) / 2.0;
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("first", this.P1.getName());
        xmlWriter.printArg("second", this.P2.getName());
        this.printType(xmlWriter);
    }

    public Enumeration depending() {
        super.depending();
        DL.add(this.P1);
        DL.add(this.P2);
        return DL.elements();
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
    }
}

