/*
 * Copyright (C) 2000-2025 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */

#ifndef HAVE_XITK_LABELBUTTON_H
#define HAVE_XITK_LABELBUTTON_H

#define CLICK_BUTTON 1
#define RADIO_BUTTON 2
#define TAB_BUTTON   3

typedef struct {
  xitk_new_widget_t   nw;
  int                 button_type;
  int                 align;
  uint32_t            style; /** << XITK_DRAW_{R|G|B}, XITK_DRAW_SAT (), or just 0. */
  const char         *label;
  xitk_int_callback_t callback;
} xitk_labelbutton_widget_t;

/** Create a labeled button. */
xitk_widget_t *xitk_labelbutton_create (const xitk_labelbutton_widget_t *b, xitk_skin_config_t *skonfig);
xitk_widget_t *xitk_info_labelbutton_create (const xitk_labelbutton_widget_t *b, const xitk_skin_element_info_t *info);
xitk_widget_t *xitk_noskin_labelbutton_create (const xitk_labelbutton_widget_t *b,
  int x, int y, int width, int height,
  uint32_t ncolor, uint32_t fcolor, uint32_t ccolor,
  const char *fname);

/** Label text. */
int xitk_labelbutton_change_label (xitk_widget_t *w, const char *new_label);
int xitk_labelbutton_change_shortcut_label (xitk_widget_t *w, const char *string, int x_pos, const char *);
const char *xitk_labelbutton_get_label (xitk_widget_t *w);
/** Label position. */
void xitk_labelbutton_set_alignment (xitk_widget_t *w, int align);
void xitk_labelbutton_set_label_offset (xitk_widget_t *w, int dx);
int xitk_labelbutton_get_alignment (xitk_widget_t *w);

/** State. RADIO_BUTTON and TAB_BUTTON can be "on". */
#define xitk_labelbutton_get_state(w) (!!(xitk_widgets_state (&(w), 1, 0, 0) & XITK_WIDGET_STATE_ON))
#define xitk_labelbutton_set_state(w,on) xitk_widgets_state (&(w), 1, XITK_WIDGET_STATE_ON, (on) ? ~0u : 0)

/* Unused. */
#if 0
const char *xitk_labelbutton_get_fontname (xitk_widget_t *w);
int xitk_labelbutton_get_label_offset (xitk_widget_t *w);
const char *xitk_labelbutton_get_shortcut_label (xitk_widget_t *w);
#endif

#endif
