#############################################################################
##
#W  monoid.gd                   GAP library                     Thomas Breuer
##
##
#Y  Copyright (C)  1997,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
##  This file contains the declaration of operations for monoids.
##


#############################################################################
##
#P  IsMonoid( <D> )
##
##  <#GAPDoc Label="IsMonoid">
##  <ManSection>
##  <Prop Name="IsMonoid" Arg='D'/>
##
##  <Description>
##  A <E>monoid</E> is a magma-with-one (see&nbsp;<Ref Chap="Magmas"/>)
##  with associative multiplication.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareSynonymAttr( "IsMonoid", IsMagmaWithOne and IsAssociative );


#############################################################################
##
#F  Monoid( <gen1>, <gen2> ... )
#F  Monoid( <gens> )
#F  Monoid( <gens>, <id> )
##
##  <#GAPDoc Label="Monoid">
##  <ManSection>
##  <Heading>Monoid</Heading>
##  <Func Name="Monoid" Arg='gen1, gen2 ...'
##   Label="for various generators"/>
##  <Func Name="Monoid" Arg='gens[, id]' Label="for a list"/>
##
##  <Description>
##  In the first form, <Ref Func="Monoid" Label="for various generators"/>
##  returns the monoid generated by the arguments <A>gen1</A>, <A>gen2</A>,
##  <M>\ldots</M>,
##  that is, the closure of these elements under multiplication and taking
##  the 0-th power.
##  In the second form, <Ref Func="Monoid" Label="for a list"/> returns
##  the monoid generated by the elements in the homogeneous list <A>gens</A>;
##  a square matrix as only argument is treated as one generator,
##  not as a list of generators.
##  In the second form, the identity element <A>id</A> may be given as the
##  second argument.
##  <P/>
##  It is <E>not</E> checked whether the underlying multiplication is
##  associative, use <Ref Func="MagmaWithOne"/> and
##  <Ref Func="IsAssociative"/>
##  if you want to check whether a magma-with-one is in fact a monoid.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareGlobalFunction( "Monoid" );


#############################################################################
##
#F  Submonoid( <M>, <gens> ) . . . . . . submonoid of <M> generated by <gens>
#F  SubmonoidNC( <M>, <gens> )
##
##  <#GAPDoc Label="Submonoid">
##  <ManSection>
##  <Func Name="Submonoid" Arg='M, gens'/>
##  <Func Name="SubmonoidNC" Arg='M, gens'/>
##
##  <Description>
##  are just synonyms of <Ref Func="SubmagmaWithOne"/>
##  and <Ref Func="SubmagmaWithOneNC"/>, respectively.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareSynonym( "Submonoid", SubmagmaWithOne );

DeclareSynonym( "SubmonoidNC", SubmagmaWithOneNC );


#############################################################################
##
#O  MonoidByGenerators( <gens>[, <one>] )  . . . . monoid generated by <gens>
##
##  <#GAPDoc Label="MonoidByGenerators">
##  <ManSection>
##  <Oper Name="MonoidByGenerators" Arg='gens[, one]'/>
##
##  <Description>
##  is the underlying operation of <Ref Func="Monoid" Label="for a list"/>.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareOperation( "MonoidByGenerators", [ IsCollection ] );


#############################################################################
##
#A  AsMonoid( <C> ) . . . . . . . . . . . . collection <C> regarded as monoid
##
##  <#GAPDoc Label="AsMonoid">
##  <ManSection>
##  <Attr Name="AsMonoid" Arg='C'/>
##
##  <Description>
##  If <A>C</A> is a collection whose elements form a monoid
##  (see&nbsp;<Ref Func="IsMonoid"/>)
##  then <Ref Func="AsMonoid"/> returns this monoid.
##  Otherwise <K>fail</K> is returned.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareAttribute( "AsMonoid", IsCollection );


#############################################################################
##
#O  AsSubmonoid( <D>, <C> )
##
##  <#GAPDoc Label="AsSubmonoid">
##  <ManSection>
##  <Oper Name="AsSubmonoid" Arg='D, C'/>
##
##  <Description>
##  Let <A>D</A> be a domain and <A>C</A> a collection.
##  If <A>C</A> is a subset of <A>D</A> that forms a monoid then
##  <Ref Func="AsSubmonoid"/>
##  returns this monoid, with parent <A>D</A>.
##  Otherwise <K>fail</K> is returned.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareOperation( "AsSubmonoid", [ IsDomain, IsCollection ] );


#############################################################################
##
#A  GeneratorsOfMonoid( <M> )  . . . . . . .  monoid generators of monoid <M>
##
##  <#GAPDoc Label="GeneratorsOfMonoid">
##  <ManSection>
##  <Attr Name="GeneratorsOfMonoid" Arg='M'/>
##
##  <Description>
##  Monoid generators of a monoid <A>M</A> are the same as
##  magma-with-one generators
##  (see&nbsp;<Ref Func="GeneratorsOfMagmaWithOne"/>).
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareSynonymAttr( "GeneratorsOfMonoid", GeneratorsOfMagmaWithOne );


#############################################################################
##
#A  TrivialSubmonoid( <M> ) . . . . . . . . . trivial submonoid of monoid <M>
##
##  <#GAPDoc Label="TrivialSubmonoid">
##  <ManSection>
##  <Attr Name="TrivialSubmonoid" Arg='M'/>
##
##  <Description>
##  is just a synonym for <Ref Func="TrivialSubmagmaWithOne"/>.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareSynonymAttr( "TrivialSubmonoid", TrivialSubmagmaWithOne );


#############################################################################
##
#F  FreeMonoid( [<wfilt>,]<rank> )
#F  FreeMonoid( [<wfilt>,]<rank>, <name> )
#F  FreeMonoid( [<wfilt>,]<name1>, <name2>, ... )
#F  FreeMonoid( [<wfilt>,]<names> )
#F  FreeMonoid( [<wfilt>,]infinity, <name>, <init> )
##
##  <#GAPDoc Label="FreeMonoid">
##  <ManSection>
##  <Heading>FreeMonoid</Heading>
##  <Func Name="FreeMonoid" Arg='[wfilt, ]rank[, name]'
##   Label="for given rank"/>
##  <Func Name="FreeMonoid" Arg='[wfilt, ]name1, name2, ...'
##   Label="for various names"/>
##  <Func Name="FreeMonoid" Arg='[wfilt, ]names'
##   Label="for a list of names"/>
##  <Func Name="FreeMonoid" Arg='[wfilt, ]infinity, name, init'
##   Label="for infinitely many generators"/>
##
##  <Description>
##  Called with a positive integer <A>rank</A>,
##  <Ref Func="FreeMonoid" Label="for given rank"/> returns
##  a free monoid on <A>rank</A> generators.
##  If the optional argument <A>name</A> is given then the generators are
##  printed as <A>name</A><C>1</C>, <A>name</A><C>2</C> etc.,
##  that is, each name is the concatenation of the string <A>name</A> and an
##  integer from <C>1</C> to <A>range</A>.
##  The default for <A>name</A> is the string <C>"m"</C>.
##  <P/>
##  Called in the second form,
##  <Ref Func="FreeMonoid" Label="for various names"/> returns
##  a free monoid on as many generators as arguments, printed as
##  <A>name1</A>, <A>name2</A> etc.
##  <P/>
##  Called in the third form,
##  <Ref Func="FreeMonoid" Label="for a list of names"/> returns
##  a free monoid on as many generators as the length of the list
##  <A>names</A>, the <M>i</M>-th generator being printed as
##  <A>names</A><C>[</C><M>i</M><C>]</C>.
##  <P/>
##  Called in the fourth form,
##  <Ref Func="FreeMonoid" Label="for infinitely many generators"/>
##  returns a free monoid on infinitely many generators, where the first
##  generators are printed by the names in the list <A>init</A>,
##  and the other generators by <A>name</A> and an appended number.
##  <P/>
##  If the extra argument <A>wfilt</A> is given, it must be either
##  <Ref Func="IsSyllableWordsFamily"/> or <Ref Func="IsLetterWordsFamily"/>
##  or <Ref Func="IsWLetterWordsFamily"/> or
##  <Ref Func="IsBLetterWordsFamily"/>.
##  This filter then specifies the representation used for the elements of
##  the free monoid
##  (see&nbsp;<Ref Sect="Representations for Associative Words"/>).
##  If no such filter is given, a letter representation is used.
##  <P/>
##  Also see Chapter&nbsp;<Ref Chap="Monoids"/>.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareGlobalFunction( "FreeMonoid" );


#############################################################################
##
#E

