.\" @(#)$RCSfile: gfal_readdir.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/11/19 12:56:29 $ CERN Jean-Philippe Baud
.\" Copyright (C) 2003 by CERN
.\" All rights reserved
.\"
.TH GFAL_READDIR 3 "$Date: 2003/11/19 12:56:29 $" GFAL "Library Functions"
.SH NAME
gfal_readdir \- read a directory
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "struct dirent *gfal_readdir (DIR *" dirp ");"
.sp
Under Linux, for large files:
.br
.B #define _LARGEFILE64_SOURCE
.br
\fB#include "gfal_api.h"\fR
.sp
.BI "struct dirent64 *gfal_readdir64 (DIR *" dirp ");"
.sp
Under Solaris, for large files:
.br
\fB#include "gfal_api.h"\fR
.sp
.BI "struct dirent64 *gfal_readdir64 (DIR *" dirp ");"
.SH DESCRIPTION
.B gfal_readdir
reads a directory opened by
.B gfal_opendir
and associated with the
.B DIR
structure pointed by
.IR dirp .
.LP
The 64 bits function must be used for large files. It has the same syntax as
the normal readdir function except that it uses a
.B dirent64
structure.
.SH RETURN VALUE
These routines return a pointer to a structure containing the current directory
entry if the operation was successful or NULL if the end of the directory was
reached or if the operation failed. In the latter case,
.B errno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EBADF
File descriptor in DIR structure is invalid.
.TP
.B EFAULT
.I dirp
is a NULL pointer.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.
.SH SEE ALSO
.B gfal(3)
