/*
 * Copyright (C) 2024 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2024 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins
 * Created on: 14 июл. 2024 г.
 *
 * lsp-plugins is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef GENERATED_ISO226_ISO226_2023_H_
#define GENERATED_ISO226_ISO226_2023_H_

#include <generated/iso226/defs.h>

namespace lsp
{
    static const float iso226_2023_curve_0_phons[985] =
    {
        -42.88, -43.00,
        -42.75, -42.85, -43.10, -43.07, -43.29, -43.39, -43.58, -43.78, -43.75, -44.29,
        -44.26, -44.33, -44.74, -44.87, -44.81, -45.22, -45.22, -45.48, -45.48, -45.58,
        -45.71, -45.97, -46.06, -46.06, -46.06, -46.35, -46.48, -46.35, -46.79, -46.89,
        -47.12, -47.06, -47.38, -47.60, -47.82, -47.92, -48.18, -48.30, -48.40, -48.57,
        -48.69, -48.86, -48.95, -49.08, -49.14, -49.34, -49.43, -49.66, -49.60, -49.85,
        -50.04, -50.04, -50.27, -50.43, -50.43, -50.33, -50.84, -50.82, -50.91, -51.11,
        -51.33, -51.39, -51.49, -51.71, -52.00, -51.97, -51.97, -52.32, -52.42, -52.46,
        -52.70, -52.71, -52.71, -52.99, -52.90, -53.00, -53.10, -53.29, -53.51, -53.51,
        -53.80, -53.77, -53.99, -54.09, -54.16, -54.38, -54.45, -54.54, -54.67, -54.61,
        -54.74, -54.93, -55.05, -55.00, -55.22, -55.34, -55.41, -55.54, -55.73, -55.83,
        -56.02, -56.21, -56.44, -56.41, -56.63, -56.63, -56.75, -56.85, -56.82, -57.07,
        -57.14, -57.14, -57.14, -57.36, -57.46, -57.46, -57.68, -57.72, -57.82, -57.94,
        -58.10, -58.20, -58.17, -58.40, -58.64, -58.74, -58.84, -58.84, -59.06, -59.23,
        -59.35, -59.35, -59.57, -59.64, -59.64, -59.64, -59.84, -59.93, -59.93, -60.15,
        -60.12, -60.44, -60.32, -60.51, -60.64, -60.67, -60.73, -60.86, -60.98, -61.05,
        -61.02, -61.12, -61.25, -61.19, -61.28, -61.53, -61.51, -61.82, -61.80, -61.92,
        -62.11, -62.21, -62.21, -62.31, -62.31, -62.40, -62.28, -62.53, -62.60, -62.72,
        -62.94, -62.92, -63.17, -63.01, -63.23, -63.23, -63.30, -63.37, -63.62, -63.47,
        -63.69, -63.66, -63.88, -63.95, -64.01, -64.17, -64.05, -64.26, -64.24, -64.46,
        -64.46, -64.61, -64.68, -64.78, -64.88, -65.00, -65.19, -65.32, -65.42, -65.61,
        -65.51, -65.61, -65.71, -65.74, -65.83, -65.83, -65.83, -65.80, -65.80, -65.93,
        -66.00, -65.97, -66.19, -66.16, -66.38, -66.48, -66.73, -66.58, -66.83, -67.05,
        -66.83, -67.08, -67.15, -67.15, -67.02, -67.24, -67.36, -67.31, -67.53, -67.50,
        -67.60, -67.70, -67.70, -67.82, -67.79, -68.01, -68.07, -68.04, -68.24, -68.25,
        -68.24, -68.46, -68.24, -68.43, -68.56, -68.62, -68.78, -68.72, -68.85, -69.07,
        -69.04, -69.16, -69.29, -69.29, -69.29, -69.26, -69.36, -69.33, -69.45, -69.45,
        -69.52, -69.65, -69.74, -69.74, -69.97, -69.97, -70.09, -70.22, -70.19, -70.34,
        -70.28, -70.48, -70.41, -70.48, -70.58, -70.57, -70.57, -70.45, -70.67, -70.76,
        -70.67, -70.86, -70.83, -70.86, -71.06, -71.28, -71.18, -71.28, -71.40, -71.25,
        -71.44, -71.60, -71.44, -71.60, -71.57, -71.69, -71.72, -71.79, -71.92, -72.01,
        -71.89, -72.08, -71.98, -72.08, -72.30, -72.18, -72.27, -72.52, -72.50, -72.43,
        -72.62, -72.56, -72.52, -72.75, -72.87, -72.84, -72.97, -73.07, -73.04, -73.13,
        -73.26, -73.23, -73.23, -73.36, -73.33, -73.33, -73.45, -73.55, -73.39, -73.55,
        -73.64, -73.49, -73.64, -73.84, -73.71, -73.84, -73.84, -73.95, -73.84, -73.93,
        -74.03, -73.93, -74.03, -74.13, -74.27, -74.13, -74.25, -74.38, -74.22, -74.35,
        -74.48, -74.60, -74.57, -74.63, -74.80, -74.79, -74.79, -74.89, -74.92, -74.88,
        -74.89, -74.89, -75.01, -74.99, -75.08, -75.08, -75.18, -75.15, -75.25, -75.34,
        -75.47, -75.37, -75.47, -75.50, -75.69, -75.74, -75.60, -75.69, -75.57, -75.91,
        -75.69, -75.89, -75.89, -76.13, -76.13, -75.89, -76.14, -76.14, -76.13, -76.26,
        -76.23, -76.23, -76.42, -76.55, -76.43, -76.52, -76.72, -76.77, -76.65, -76.87,
        -76.90, -76.90, -77.02, -77.00, -77.00, -77.00, -77.02, -77.12, -77.09, -77.22,
        -77.19, -77.31, -77.41, -77.31, -77.38, -77.41, -77.51, -77.51, -77.51, -77.60,
        -77.60, -77.76, -77.85, -77.70, -77.70, -77.80, -77.83, -78.02, -78.04, -78.14,
        -78.02, -78.02, -78.12, -78.24, -78.23, -78.12, -78.34, -78.34, -78.34, -78.31,
        -78.43, -78.43, -78.43, -78.53, -78.43, -78.53, -78.53, -78.41, -78.60, -78.47,
        -78.47, -78.82, -78.70, -78.72, -78.95, -78.95, -78.95, -79.03, -79.05, -79.05,
        -79.17, -79.27, -79.02, -79.02, -79.14, -79.14, -79.24, -79.14, -79.01, -79.21,
        -79.24, -79.14, -79.24, -79.33, -79.36, -79.39, -79.58, -79.46, -79.52, -79.71,
        -79.70, -79.59, -79.71, -79.83, -79.83, -79.83, -79.96, -79.93, -79.90, -80.00,
        -80.12, -79.90, -79.90, -80.00, -80.00, -80.00, -80.12, -80.00, -80.12, -80.10,
        -80.10, -80.10, -80.10, -80.25, -80.34, -80.34, -80.32, -80.43, -80.32, -80.32,
        -80.42, -80.32, -80.32, -80.44, -80.54, -80.53, -80.51, -80.54, -80.64, -80.64,
        -80.51, -80.51, -80.61, -80.51, -80.64, -80.64, -80.65, -80.57, -80.57, -80.60,
        -80.67, -80.67, -80.76, -80.67, -80.67, -80.67, -80.66, -80.54, -80.54, -80.64,
        -80.64, -80.73, -80.76, -80.76, -80.64, -80.73, -80.73, -80.68, -80.70, -80.83,
        -80.83, -80.98, -80.98, -80.86, -80.96, -80.98, -80.98, -80.98, -80.98, -80.98,
        -81.01, -80.98, -80.89, -80.89, -80.89, -80.79, -80.89, -80.89, -80.89, -81.11,
        -81.11, -81.11, -81.11, -81.14, -81.14, -81.14, -81.16, -81.17, -81.07, -81.07,
        -81.07, -81.07, -81.04, -81.05, -81.05, -81.14, -81.26, -81.26, -81.26, -81.17,
        -81.29, -81.29, -81.29, -81.26, -81.20, -81.29, -81.29, -81.14, -81.17, -81.29,
        -81.29, -81.39, -81.29, -81.29, -81.49, -81.39, -81.26, -81.49, -81.36, -81.33,
        -81.58, -81.52, -81.65, -81.68, -81.62, -81.55, -81.68, -81.62, -81.65, -81.62,
        -81.75, -81.97, -81.81, -82.04, -82.13, -82.23, -82.36, -82.42, -82.55, -82.55,
        -82.80, -82.77, -82.74, -82.87, -83.03, -83.03, -83.03, -83.32, -83.32, -83.29,
        -83.51, -83.51, -83.58, -83.81, -84.00, -84.12, -84.25, -84.29, -84.29, -84.51,
        -84.58, -84.58, -84.67, -84.87, -84.99, -84.99, -85.18, -85.31, -85.31, -85.41,
        -85.50, -85.50, -85.47, -85.57, -85.57, -85.54, -85.64, -85.51, -85.64, -85.74,
        -85.76, -85.86, -85.86, -85.99, -85.99, -85.93, -85.96, -85.83, -85.93, -85.80,
        -85.96, -85.83, -85.96, -85.83, -85.99, -85.86, -85.99, -85.83, -85.99, -86.08,
        -85.99, -85.99, -86.11, -86.08, -85.99, -86.08, -85.89, -85.83, -85.86, -85.76,
        -85.74, -85.76, -85.74, -85.76, -85.76, -85.89, -85.76, -85.89, -85.79, -85.89,
        -85.79, -85.76, -85.79, -85.79, -85.79, -85.99, -85.89, -85.79, -85.99, -85.76,
        -85.89, -85.86, -85.89, -85.86, -85.76, -85.79, -85.74, -85.74, -85.64, -85.76,
        -85.76, -85.76, -85.79, -85.79, -85.86, -85.86, -85.86, -85.96, -85.99, -86.05,
        -86.05, -86.18, -86.15, -86.28, -86.25, -86.22, -86.34, -86.37, -86.44, -86.31,
        -86.44, -86.57, -86.44, -86.54, -86.66, -86.66, -86.66, -86.76, -86.86, -86.86,
        -86.73, -86.73, -86.60, -86.63, -86.73, -86.73, -86.76, -86.76, -86.76, -86.86,
        -86.86, -87.08, -87.08, -87.08, -87.08, -87.08, -87.08, -87.05, -87.05, -87.05,
        -87.05, -87.17, -87.27, -87.24, -87.24, -87.37, -87.49, -87.37, -87.24, -87.24,
        -87.21, -87.34, -87.34, -87.31, -87.50, -87.53, -87.53, -87.63, -87.66, -87.63,
        -87.63, -87.66, -87.75, -87.75, -87.53, -87.66, -87.78, -87.63, -87.53, -87.74,
        -87.53, -87.53, -87.72, -87.53, -87.72, -87.63, -87.50, -87.63, -87.53, -87.50,
        -87.53, -87.38, -87.53, -87.44, -87.44, -87.56, -87.46, -87.59, -87.59, -87.37,
        -87.46, -87.49, -87.27, -87.27, -87.15, -87.15, -87.02, -87.15, -87.15, -87.17,
        -86.95, -87.05, -87.08, -86.98, -86.98, -86.91, -86.79, -86.66, -86.76, -86.76,
        -86.57, -86.47, -86.47, -86.31, -86.22, -86.18, -86.08, -85.83, -85.86, -85.89,
        -85.76, -85.64, -85.67, -85.70, -85.60, -85.70, -85.50, -85.25, -85.28, -85.31,
        -85.31, -85.21, -84.87, -84.77, -84.70, -84.80, -84.59, -84.48, -84.48, -84.23,
        -84.26, -84.19, -84.19, -84.06, -83.84, -83.87, -83.84, -83.78, -83.65, -83.68,
        -83.71, -83.64, -83.61, -83.51, -83.54, -83.38, -83.35, -83.22, -83.25, -83.13,
        -83.03, -83.00, -82.88, -82.75, -82.78, -82.68, -82.65, -82.46, -82.49, -82.24,
        -82.39, -82.24, -82.37, -82.27, -82.27, -82.14, -82.14, -82.14, -82.11, -82.02,
        -82.14, -81.92, -81.89, -82.05, -81.95, -81.82, -81.95, -81.95, -81.86, -81.81,
        -81.92, -81.92, -81.89, -81.80, -81.77, -81.77, -81.67, -81.64, -81.64, -81.67,
        -81.67, -81.54, -81.57, -81.57, -81.32, -81.45, -81.45, -81.32, -81.42, -81.45,
        -81.45, -81.29, -81.32, -81.07, -81.10, -80.97, -80.75, -80.78, -80.66, -80.46,
        -80.49, -80.37, -80.40, -80.05, -80.17, -80.17, -79.83, -79.83, -79.60, -79.60,
        -79.41, -79.09, -79.09, -78.93, -78.71, -78.54, -78.32, -78.13, -77.90, -77.49,
        -77.20, -77.01, -76.72
    };

    static const float iso226_2023_curve_10_phons[985] =
    {
        -36.79, -36.92,
        -36.76, -36.86, -37.11, -37.08, -37.40, -37.40, -37.50, -37.69, -37.66, -38.01,
        -37.98, -37.95, -38.08, -38.30, -38.24, -38.37, -38.37, -38.53, -38.63, -38.53,
        -38.75, -38.82, -39.01, -39.01, -38.92, -39.11, -39.24, -39.21, -39.45, -39.46,
        -39.58, -39.62, -39.75, -39.87, -40.00, -40.00, -40.07, -40.29, -40.39, -40.36,
        -40.48, -40.55, -40.65, -40.87, -40.74, -40.84, -40.94, -41.06, -41.10, -41.16,
        -41.35, -41.35, -41.57, -41.54, -41.54, -41.64, -41.77, -41.74, -41.83, -42.03,
        -42.06, -42.22, -42.22, -42.35, -42.54, -42.51, -42.51, -42.76, -42.76, -42.61,
        -42.95, -42.95, -42.95, -43.14, -43.24, -43.34, -43.44, -43.63, -43.76, -43.76,
        -43.85, -43.92, -44.05, -44.14, -44.02, -44.24, -44.31, -44.31, -44.43, -44.37,
        -44.50, -44.60, -44.72, -44.66, -44.79, -44.92, -44.89, -45.11, -45.20, -45.30,
        -45.20, -45.49, -45.62, -45.59, -45.81, -45.81, -45.94, -46.04, -46.01, -46.16,
        -46.13, -46.32, -46.32, -46.45, -46.55, -46.55, -46.67, -46.62, -46.61, -46.64,
        -46.71, -46.81, -46.78, -47.00, -47.24, -47.25, -47.45, -47.35, -47.47, -47.54,
        -47.76, -47.76, -47.89, -47.96, -47.96, -48.15, -48.05, -48.25, -48.25, -48.47,
        -48.34, -48.66, -48.54, -48.73, -48.76, -48.88, -48.95, -49.08, -49.11, -49.17,
        -49.14, -49.24, -49.37, -49.31, -49.31, -49.56, -49.63, -49.75, -49.63, -49.85,
        -49.95, -49.95, -50.14, -50.24, -50.24, -50.33, -50.21, -50.46, -50.53, -50.65,
        -50.58, -50.75, -50.90, -50.85, -51.07, -51.07, -51.04, -51.01, -51.26, -51.20,
        -51.42, -51.39, -51.52, -51.49, -51.65, -51.71, -51.68, -51.80, -51.88, -51.90,
        -52.00, -52.25, -52.13, -52.32, -52.32, -52.54, -52.74, -52.77, -52.86, -53.06,
        -53.06, -53.15, -53.25, -53.28, -53.37, -53.47, -53.47, -53.54, -53.54, -53.57,
        -53.64, -53.61, -53.73, -53.61, -53.83, -54.02, -54.17, -54.21, -54.37, -54.59,
        -54.47, -54.72, -54.69, -54.69, -54.66, -54.88, -54.91, -54.85, -55.07, -54.95,
        -55.05, -55.14, -55.24, -55.36, -55.33, -55.46, -55.70, -55.68, -55.88, -55.89,
        -55.88, -56.10, -56.07, -56.07, -56.19, -56.26, -56.51, -56.36, -56.48, -56.71,
        -56.68, -56.90, -57.02, -57.02, -57.12, -57.19, -57.09, -57.16, -57.29, -57.29,
        -57.35, -57.48, -57.67, -57.58, -57.80, -57.80, -57.92, -58.05, -58.02, -58.17,
        -58.12, -58.31, -58.34, -58.31, -58.50, -58.50, -58.60, -58.47, -58.60, -58.79,
        -58.70, -58.89, -58.86, -58.89, -59.08, -59.21, -59.21, -59.30, -59.43, -59.37,
        -59.47, -59.62, -59.47, -59.72, -59.79, -59.91, -60.04, -60.01, -60.23, -60.23,
        -60.11, -60.30, -60.30, -60.40, -60.62, -60.50, -60.59, -60.74, -60.81, -60.84,
        -60.94, -61.07, -61.13, -61.16, -61.38, -61.45, -61.48, -61.57, -61.64, -61.54,
        -61.67, -61.74, -61.74, -61.86, -61.83, -61.93, -61.96, -62.15, -62.00, -62.25,
        -62.25, -62.19, -62.25, -62.44, -62.41, -62.44, -62.54, -62.75, -62.54, -62.73,
        -62.82, -62.73, -62.93, -63.12, -63.26, -63.12, -63.34, -63.47, -63.31, -63.44,
        -63.56, -63.69, -63.56, -63.72, -63.79, -63.78, -63.78, -63.98, -64.01, -64.07,
        -64.07, -64.07, -64.20, -64.17, -64.37, -64.36, -64.46, -64.43, -64.53, -64.63,
        -64.75, -64.75, -64.85, -64.88, -65.07, -65.11, -64.97, -65.17, -65.04, -65.29,
        -65.26, -65.26, -65.36, -65.61, -65.61, -65.55, -65.71, -65.71, -65.90, -65.83,
        -65.90, -66.00, -66.00, -66.12, -66.09, -66.09, -66.29, -66.44, -66.32, -66.54,
        -66.66, -66.76, -66.79, -66.86, -66.86, -66.86, -66.98, -66.98, -67.05, -67.08,
        -67.15, -67.17, -67.27, -67.37, -67.34, -67.46, -67.56, -67.46, -67.56, -67.56,
        -67.66, -67.81, -67.90, -67.85, -67.95, -67.95, -68.07, -68.17, -68.19, -68.20,
        -68.17, -68.17, -68.27, -68.39, -68.38, -68.36, -68.49, -68.58, -68.68, -68.65,
        -68.78, -68.78, -68.87, -68.97, -68.97, -68.97, -69.07, -68.94, -68.94, -69.01,
        -69.01, -69.16, -69.23, -69.26, -69.39, -69.48, -69.48, -69.56, -69.59, -69.68,
        -69.80, -69.80, -69.65, -69.75, -69.87, -69.97, -69.97, -69.97, -69.94, -69.94,
        -70.06, -70.06, -70.06, -70.26, -70.28, -70.41, -70.51, -70.38, -70.54, -70.63,
        -70.62, -70.51, -70.63, -70.76, -70.76, -70.85, -70.98, -70.85, -71.02, -71.02,
        -71.04, -71.02, -71.02, -71.02, -71.21, -71.21, -71.33, -71.21, -71.34, -71.21,
        -71.21, -71.41, -71.31, -71.46, -71.65, -71.65, -71.53, -71.64, -71.53, -71.63,
        -71.63, -71.63, -71.63, -71.66, -71.85, -71.84, -71.72, -71.95, -71.95, -71.95,
        -71.92, -71.92, -72.01, -71.92, -72.04, -72.14, -72.25, -72.17, -72.17, -72.29,
        -72.26, -72.26, -72.36, -72.26, -72.26, -72.36, -72.45, -72.33, -72.33, -72.43,
        -72.52, -72.52, -72.56, -72.65, -72.52, -72.52, -72.52, -72.47, -72.50, -72.62,
        -72.71, -72.87, -72.86, -72.75, -72.85, -72.87, -72.87, -72.87, -72.87, -72.97,
        -73.00, -72.97, -72.97, -72.97, -72.97, -72.87, -72.87, -72.97, -72.97, -73.19,
        -73.19, -73.19, -73.19, -73.22, -73.22, -73.22, -73.24, -73.25, -73.34, -73.34,
        -73.34, -73.35, -73.32, -73.42, -73.42, -73.41, -73.54, -73.54, -73.44, -73.45,
        -73.57, -73.47, -73.47, -73.44, -73.37, -73.47, -73.47, -73.41, -73.44, -73.57,
        -73.47, -73.66, -73.57, -73.57, -73.76, -73.66, -73.54, -73.76, -73.73, -73.61,
        -73.86, -73.80, -73.93, -73.95, -73.90, -73.92, -74.05, -73.90, -74.02, -74.09,
        -74.12, -74.34, -74.19, -74.41, -74.50, -74.50, -74.63, -74.60, -74.73, -74.73,
        -74.88, -74.76, -74.73, -74.85, -74.82, -74.82, -74.82, -75.01, -75.02, -74.99,
        -75.21, -75.21, -75.18, -75.40, -75.40, -75.62, -75.75, -75.69, -75.79, -75.91,
        -76.08, -76.08, -76.17, -76.27, -76.40, -76.40, -76.49, -76.62, -76.62, -76.72,
        -76.72, -76.72, -76.69, -76.69, -76.69, -76.66, -76.75, -76.63, -76.66, -76.85,
        -76.78, -76.88, -76.88, -76.91, -76.91, -76.85, -76.98, -76.85, -76.95, -76.82,
        -76.98, -76.95, -77.07, -76.85, -77.10, -76.88, -77.01, -76.95, -77.01, -77.10,
        -77.10, -77.01, -77.23, -77.01, -77.01, -77.10, -76.91, -76.75, -76.98, -76.88,
        -76.75, -76.88, -76.85, -76.88, -76.88, -77.10, -76.88, -77.10, -76.91, -77.10,
        -76.91, -76.88, -76.91, -76.81, -76.91, -76.91, -76.91, -76.91, -76.91, -76.88,
        -76.91, -76.98, -76.91, -76.78, -76.88, -76.91, -76.75, -76.85, -76.66, -76.88,
        -76.88, -76.69, -76.91, -76.91, -76.78, -76.98, -76.88, -76.98, -77.10, -76.98,
        -77.17, -77.20, -77.07, -77.30, -77.17, -77.04, -77.27, -77.30, -77.17, -77.24,
        -77.27, -77.30, -77.36, -77.36, -77.49, -77.58, -77.58, -77.58, -77.68, -77.68,
        -77.56, -77.56, -77.53, -77.56, -77.56, -77.65, -77.68, -77.68, -77.68, -77.68,
        -77.68, -77.81, -77.81, -77.81, -77.81, -77.81, -77.81, -77.78, -77.78, -77.78,
        -77.78, -77.90, -78.00, -77.97, -77.97, -78.10, -78.22, -78.10, -78.07, -77.97,
        -77.94, -78.07, -77.97, -77.94, -78.04, -78.16, -78.07, -78.16, -78.10, -78.07,
        -78.07, -78.00, -78.10, -78.10, -77.97, -78.00, -78.13, -77.97, -77.87, -78.09,
        -78.07, -77.97, -78.07, -78.07, -78.16, -78.07, -78.04, -78.16, -78.16, -78.04,
        -78.07, -77.82, -78.07, -77.97, -77.88, -77.90, -78.00, -78.03, -78.03, -77.90,
        -78.00, -78.03, -77.90, -78.00, -77.87, -77.87, -77.75, -77.78, -77.78, -77.90,
        -77.68, -77.68, -77.71, -77.61, -77.61, -77.64, -77.61, -77.49, -77.49, -77.39,
        -77.39, -77.49, -77.49, -77.24, -77.24, -77.30, -77.30, -77.14, -77.17, -77.20,
        -77.07, -76.95, -77.07, -77.10, -77.01, -76.81, -76.81, -76.56, -76.69, -76.72,
        -76.72, -76.62, -76.37, -76.37, -76.20, -76.30, -76.09, -76.08, -76.08, -75.63,
        -75.76, -75.79, -75.60, -75.47, -75.34, -75.28, -75.25, -75.28, -75.15, -75.28,
        -75.31, -75.33, -75.11, -75.11, -75.05, -75.17, -75.05, -74.92, -74.95, -74.82,
        -74.82, -74.70, -74.57, -74.45, -74.48, -74.38, -74.25, -74.16, -74.19, -73.93,
        -74.09, -73.84, -73.87, -73.77, -73.67, -73.64, -73.64, -73.64, -73.42, -73.52,
        -73.55, -73.33, -73.20, -73.36, -73.16, -73.13, -73.16, -73.07, -72.98, -72.82,
        -72.84, -72.75, -72.72, -72.52, -72.50, -72.40, -72.30, -72.27, -72.27, -72.11,
        -72.11, -71.79, -71.82, -71.82, -71.47, -71.50, -71.40, -71.28, -71.18, -71.21,
        -71.21, -70.96, -70.89, -70.64, -70.67, -70.45, -70.23, -70.35, -70.13, -69.94,
        -70.06, -69.84, -69.77, -69.52, -69.65, -69.55, -69.20, -69.11, -68.98, -68.79,
        -68.59, -68.37, -68.28, -68.11, -67.89, -67.82, -67.60, -67.50, -67.38, -67.25,
        -66.96, -66.96, -66.87
    };

    static const float iso226_2023_curve_20_phons[985] =
    {
        -31.00, -31.12,
        -30.97, -30.97, -31.22, -31.39, -31.41, -31.42, -31.61, -31.51, -31.39, -31.73,
        -31.61, -31.58, -31.70, -31.83, -31.77, -31.90, -31.90, -32.06, -31.96, -32.06,
        -32.09, -32.16, -32.25, -32.25, -32.25, -32.35, -32.57, -32.45, -32.78, -32.80,
        -32.92, -32.86, -32.80, -33.02, -33.14, -33.14, -33.21, -33.34, -33.34, -33.50,
        -33.53, -33.60, -33.69, -33.82, -33.79, -33.89, -33.79, -33.92, -33.86, -34.11,
        -34.01, -34.11, -34.33, -34.30, -34.30, -34.30, -34.52, -34.50, -34.59, -34.69,
        -34.91, -34.78, -34.88, -34.91, -35.01, -34.98, -34.88, -35.04, -35.13, -35.07,
        -35.22, -35.23, -35.23, -35.41, -35.33, -35.33, -35.42, -35.52, -35.74, -35.84,
        -35.93, -35.90, -36.03, -36.13, -36.00, -36.22, -36.19, -36.39, -36.42, -36.36,
        -36.48, -36.58, -36.71, -36.55, -36.58, -36.80, -36.87, -36.90, -37.09, -37.09,
        -37.09, -37.29, -37.41, -37.38, -37.70, -37.60, -37.73, -37.83, -37.80, -37.96,
        -37.83, -37.92, -37.92, -38.05, -38.05, -38.05, -38.17, -38.12, -38.21, -38.24,
        -38.40, -38.50, -38.47, -38.50, -38.74, -38.75, -38.95, -38.85, -38.98, -38.95,
        -39.07, -39.17, -39.20, -39.17, -39.17, -39.27, -39.36, -39.36, -39.46, -39.68,
        -39.65, -39.78, -39.85, -39.94, -39.97, -40.10, -40.16, -40.19, -40.22, -40.29,
        -40.16, -40.17, -40.29, -40.23, -40.23, -40.48, -40.45, -40.68, -40.55, -40.77,
        -40.87, -40.87, -40.97, -40.97, -41.06, -41.16, -40.94, -41.28, -41.35, -41.38,
        -41.50, -41.57, -41.73, -41.57, -41.80, -41.80, -41.77, -41.83, -42.09, -41.93,
        -42.15, -42.03, -42.15, -42.12, -42.38, -42.25, -42.22, -42.43, -42.22, -42.53,
        -42.54, -42.79, -42.76, -42.66, -42.86, -42.98, -43.08, -43.21, -43.21, -43.40,
        -43.40, -43.50, -43.50, -43.62, -43.72, -43.72, -43.81, -43.69, -43.79, -43.91,
        -43.88, -43.76, -43.98, -43.85, -43.98, -44.17, -44.32, -44.17, -44.42, -44.64,
        -44.62, -44.77, -44.74, -44.84, -44.81, -45.03, -45.06, -45.00, -45.13, -45.10,
        -45.20, -45.29, -45.39, -45.51, -45.39, -45.61, -45.85, -45.74, -45.83, -45.95,
        -45.93, -46.05, -46.03, -46.22, -46.25, -46.22, -46.47, -46.41, -46.54, -46.66,
        -46.54, -46.76, -46.89, -46.98, -46.89, -46.95, -47.05, -47.12, -47.15, -47.24,
        -47.31, -47.24, -47.44, -47.44, -47.56, -47.66, -47.78, -47.91, -47.88, -48.13,
        -48.07, -48.08, -48.20, -48.17, -48.27, -48.17, -48.27, -48.14, -48.27, -48.36,
        -48.36, -48.46, -48.43, -48.56, -48.65, -48.87, -48.78, -48.87, -49.10, -48.94,
        -49.14, -49.29, -49.23, -49.39, -49.45, -49.58, -49.80, -49.68, -49.90, -49.90,
        -49.87, -49.97, -49.87, -49.97, -50.19, -50.07, -50.26, -50.51, -50.38, -50.51,
        -50.70, -50.64, -50.70, -50.83, -50.95, -50.92, -50.95, -51.05, -51.02, -51.11,
        -51.24, -51.21, -51.31, -51.43, -51.31, -51.40, -51.43, -51.63, -51.38, -51.63,
        -51.72, -51.57, -51.72, -51.92, -51.98, -51.92, -52.11, -52.23, -52.11, -52.21,
        -52.30, -52.21, -52.30, -52.50, -52.64, -52.50, -52.72, -52.75, -52.59, -52.82,
        -52.84, -52.97, -52.94, -53.09, -53.16, -53.16, -53.26, -53.36, -53.58, -53.44,
        -53.55, -53.55, -53.67, -53.64, -53.74, -53.74, -53.84, -53.81, -53.91, -54.00,
        -54.03, -54.13, -54.13, -54.25, -54.45, -54.49, -54.35, -54.45, -54.32, -54.67,
        -54.45, -54.64, -54.74, -54.79, -54.99, -54.93, -55.08, -55.08, -55.27, -55.21,
        -55.18, -55.28, -55.37, -55.40, -55.37, -55.47, -55.57, -55.82, -55.79, -55.92,
        -56.04, -56.14, -56.17, -56.14, -56.14, -56.14, -56.26, -56.36, -56.33, -56.46,
        -56.52, -56.55, -56.65, -56.65, -56.72, -56.74, -56.74, -56.84, -56.84, -56.94,
        -57.04, -57.19, -57.28, -57.23, -57.13, -57.23, -57.26, -57.35, -57.57, -57.48,
        -57.55, -57.55, -57.74, -57.77, -57.76, -57.84, -57.87, -57.87, -58.06, -57.93,
        -58.15, -58.15, -58.06, -58.25, -58.15, -58.25, -58.25, -58.13, -58.32, -58.19,
        -58.29, -58.63, -58.61, -58.64, -58.86, -58.86, -59.05, -58.94, -58.96, -59.06,
        -59.18, -59.18, -59.13, -59.12, -59.15, -59.34, -59.34, -59.25, -59.31, -59.31,
        -59.44, -59.44, -59.44, -59.63, -59.76, -59.88, -59.88, -59.95, -60.01, -60.01,
        -60.10, -60.08, -60.11, -60.23, -60.33, -60.33, -60.55, -60.42, -60.40, -60.50,
        -60.61, -60.40, -60.50, -60.59, -60.59, -60.59, -60.81, -60.69, -60.71, -60.78,
        -60.78, -60.78, -60.78, -61.03, -61.03, -61.03, -61.10, -61.21, -61.10, -61.10,
        -61.20, -61.10, -61.20, -61.23, -61.23, -61.41, -61.29, -61.32, -61.52, -61.52,
        -61.39, -61.49, -61.58, -61.49, -61.81, -61.80, -61.82, -61.74, -61.93, -61.96,
        -61.93, -62.03, -62.13, -62.03, -62.03, -62.12, -62.11, -62.00, -62.09, -62.09,
        -62.09, -62.09, -62.31, -62.32, -62.19, -62.38, -62.38, -62.23, -62.26, -62.58,
        -62.57, -62.63, -62.63, -62.61, -62.61, -62.73, -62.73, -62.73, -62.73, -62.74,
        -62.95, -62.93, -62.83, -62.83, -62.83, -62.83, -62.83, -62.93, -62.93, -63.05,
        -63.05, -63.14, -63.14, -63.27, -63.27, -63.27, -63.30, -63.30, -63.30, -63.30,
        -63.30, -63.30, -63.27, -63.28, -63.28, -63.37, -63.59, -63.59, -63.59, -63.60,
        -63.72, -63.62, -63.62, -63.59, -63.52, -63.62, -63.52, -63.47, -63.59, -63.72,
        -63.72, -63.91, -63.91, -63.72, -63.91, -63.91, -63.78, -63.91, -63.88, -63.76,
        -63.91, -63.85, -63.98, -64.01, -63.85, -63.98, -64.01, -63.85, -63.98, -64.05,
        -64.07, -64.20, -64.14, -64.36, -64.36, -64.36, -64.49, -64.56, -64.59, -64.49,
        -64.74, -64.71, -64.59, -64.62, -64.68, -64.68, -64.59, -64.77, -64.68, -64.65,
        -64.78, -64.78, -64.75, -64.97, -64.97, -65.10, -65.13, -65.07, -65.07, -65.10,
        -65.17, -65.17, -65.17, -65.26, -65.39, -65.39, -65.39, -65.51, -65.51, -65.61,
        -65.61, -65.61, -65.48, -65.48, -65.68, -65.55, -65.65, -65.62, -65.65, -65.75,
        -65.68, -65.68, -65.68, -65.71, -65.80, -65.65, -65.68, -65.65, -65.65, -65.62,
        -65.77, -65.84, -65.77, -65.75, -66.00, -65.77, -65.90, -65.84, -65.90, -66.09,
        -65.90, -65.90, -66.12, -65.90, -66.00, -66.00, -65.90, -65.75, -65.87, -65.77,
        -65.75, -65.87, -65.75, -65.87, -65.97, -66.00, -65.97, -66.09, -66.00, -66.09,
        -66.00, -65.97, -65.90, -66.00, -65.90, -66.09, -66.00, -66.09, -66.09, -65.87,
        -66.09, -65.97, -66.00, -65.97, -65.97, -66.00, -65.84, -65.94, -65.84, -65.87,
        -65.87, -65.87, -65.90, -65.90, -65.97, -65.97, -65.97, -66.06, -66.09, -66.06,
        -66.16, -66.19, -66.26, -66.29, -66.16, -66.13, -66.26, -66.29, -66.16, -66.23,
        -66.26, -66.29, -66.26, -66.35, -66.38, -66.48, -66.48, -66.48, -66.48, -66.48,
        -66.35, -66.35, -66.23, -66.26, -66.26, -66.26, -66.38, -66.38, -66.38, -66.48,
        -66.48, -66.60, -66.60, -66.60, -66.60, -66.60, -66.60, -66.57, -66.58, -66.48,
        -66.48, -66.60, -66.60, -66.58, -66.58, -66.70, -66.83, -66.70, -66.67, -66.67,
        -66.64, -66.68, -66.67, -66.64, -66.74, -66.67, -66.67, -66.77, -66.70, -66.67,
        -66.67, -66.70, -66.70, -66.70, -66.67, -66.60, -66.73, -66.67, -66.48, -66.69,
        -66.48, -66.38, -66.48, -66.48, -66.48, -66.48, -66.35, -66.48, -66.48, -66.45,
        -66.48, -66.42, -66.67, -66.48, -66.58, -66.70, -66.70, -66.73, -66.73, -66.60,
        -66.51, -66.63, -66.60, -66.60, -66.38, -66.48, -66.35, -66.38, -66.38, -66.51,
        -66.29, -66.38, -66.51, -66.41, -66.41, -66.44, -66.41, -66.29, -66.29, -66.19,
        -66.19, -66.19, -66.29, -66.04, -66.04, -66.09, -66.09, -66.04, -66.06, -66.09,
        -65.97, -65.75, -65.97, -66.00, -65.80, -65.80, -65.90, -65.65, -65.68, -65.71,
        -65.80, -65.80, -65.46, -65.55, -65.68, -65.68, -65.47, -65.36, -65.36, -65.01,
        -65.04, -64.97, -64.97, -64.85, -64.72, -64.75, -64.82, -64.75, -64.63, -64.75,
        -64.78, -64.81, -64.68, -64.59, -64.71, -64.74, -64.62, -64.49, -64.52, -64.39,
        -64.30, -64.17, -64.05, -64.02, -64.05, -64.05, -63.82, -63.63, -63.66, -63.41,
        -63.56, -63.31, -63.34, -63.24, -63.34, -63.12, -63.02, -63.02, -62.80, -62.80,
        -62.83, -62.70, -62.48, -62.64, -62.54, -62.32, -62.44, -62.35, -62.26, -62.01,
        -62.12, -61.93, -61.81, -61.71, -61.58, -61.49, -61.39, -61.26, -61.26, -61.10,
        -61.10, -60.97, -60.81, -60.81, -60.56, -60.58, -60.49, -60.27, -60.17, -60.20,
        -60.11, -59.85, -59.79, -59.63, -59.66, -59.44, -59.31, -59.34, -59.12, -58.93,
        -59.05, -58.83, -58.76, -58.61, -58.64, -58.54, -58.20, -58.19, -57.97, -57.78,
        -57.68, -57.36, -57.17, -57.10, -56.78, -56.62, -56.49, -56.40, -56.08, -55.95,
        -55.86, -55.66, -55.57
    };

    static const float iso226_2023_curve_30_phons[985] =
    {
        -25.69, -25.81,
        -25.76, -25.66, -25.91, -25.98, -26.10, -25.91, -26.01, -26.01, -25.98, -26.13,
        -26.10, -26.07, -26.20, -26.33, -26.27, -26.39, -26.39, -26.36, -26.36, -26.36,
        -26.49, -26.56, -26.56, -26.65, -26.65, -26.75, -26.97, -26.85, -27.09, -27.10,
        -27.22, -26.97, -27.19, -27.32, -27.35, -27.25, -27.32, -27.54, -27.54, -27.61,
        -27.64, -27.61, -27.71, -27.83, -27.71, -27.80, -27.80, -27.93, -27.87, -27.93,
        -28.02, -28.02, -28.15, -28.12, -28.02, -28.02, -28.34, -28.31, -28.22, -28.41,
        -28.54, -28.51, -28.51, -28.63, -28.73, -28.70, -28.70, -28.95, -28.86, -28.80,
        -29.04, -28.95, -28.95, -29.14, -29.15, -29.24, -29.34, -29.34, -29.46, -29.46,
        -29.56, -29.53, -29.75, -29.85, -29.63, -29.85, -29.82, -29.92, -30.04, -29.89,
        -29.92, -30.01, -30.14, -29.89, -30.01, -30.14, -30.21, -30.14, -30.24, -30.33,
        -30.33, -30.53, -30.55, -30.53, -30.75, -30.65, -30.78, -30.87, -30.75, -30.90,
        -30.87, -30.97, -30.97, -31.00, -31.10, -31.10, -31.32, -31.26, -31.26, -31.39,
        -31.45, -31.45, -31.33, -31.55, -31.69, -31.61, -31.80, -31.80, -31.83, -31.90,
        -31.93, -32.02, -32.15, -32.22, -32.02, -32.12, -32.22, -32.41, -32.41, -32.53,
        -32.60, -32.73, -32.60, -32.70, -32.82, -32.95, -33.02, -32.95, -33.08, -33.14,
        -33.11, -33.02, -33.14, -33.09, -32.99, -33.24, -33.21, -33.34, -33.21, -33.43,
        -33.34, -33.43, -33.53, -33.63, -33.63, -33.63, -33.60, -33.85, -33.92, -34.04,
        -33.97, -34.04, -34.29, -34.14, -34.26, -34.17, -34.23, -34.21, -34.46, -34.21,
        -34.43, -34.40, -34.62, -34.50, -34.65, -34.72, -34.69, -34.90, -34.69, -34.90,
        -35.01, -35.06, -35.13, -35.13, -35.23, -35.35, -35.35, -35.48, -35.67, -35.77,
        -35.67, -35.77, -35.77, -35.90, -35.80, -35.90, -35.90, -35.96, -35.87, -35.99,
        -36.06, -36.03, -36.16, -36.03, -36.16, -36.35, -36.50, -36.45, -36.70, -36.73,
        -36.60, -36.95, -36.82, -36.92, -36.89, -37.02, -37.14, -36.99, -37.11, -37.08,
        -37.08, -37.08, -37.08, -37.31, -37.28, -37.31, -37.55, -37.53, -37.72, -37.74,
        -37.72, -37.94, -37.91, -37.91, -38.04, -38.01, -38.16, -38.11, -38.14, -38.36,
        -38.23, -38.36, -38.58, -38.68, -38.58, -38.65, -38.65, -38.62, -38.74, -38.84,
        -38.81, -38.94, -39.03, -39.03, -39.26, -39.26, -39.38, -39.41, -39.38, -39.63,
        -39.48, -39.57, -39.60, -39.57, -39.77, -39.67, -39.77, -39.74, -39.86, -39.95,
        -39.96, -40.06, -40.03, -40.15, -40.25, -40.38, -40.38, -40.38, -40.50, -40.35,
        -40.54, -40.60, -40.54, -40.69, -40.76, -40.79, -41.01, -40.98, -41.11, -41.11,
        -41.08, -41.27, -41.08, -41.27, -41.40, -41.28, -41.37, -41.53, -41.50, -41.53,
        -41.62, -41.76, -41.72, -41.84, -41.97, -42.04, -42.07, -42.16, -42.13, -42.13,
        -42.26, -42.23, -42.23, -42.36, -42.33, -42.33, -42.55, -42.55, -42.39, -42.65,
        -42.74, -42.59, -42.74, -42.94, -42.81, -42.94, -42.94, -43.05, -42.94, -43.03,
        -43.12, -43.03, -43.13, -43.32, -43.46, -43.32, -43.54, -43.57, -43.52, -43.64,
        -43.86, -43.99, -43.86, -44.02, -44.09, -44.08, -44.08, -44.18, -44.31, -44.27,
        -44.28, -44.37, -44.40, -44.37, -44.57, -44.57, -44.57, -44.54, -44.54, -44.73,
        -44.85, -44.86, -44.86, -44.98, -45.08, -45.22, -45.08, -45.18, -45.15, -45.40,
        -45.27, -45.37, -45.37, -45.62, -45.62, -45.47, -45.62, -45.62, -45.81, -45.84,
        -45.81, -45.91, -46.01, -46.04, -46.01, -46.10, -46.20, -46.36, -46.32, -46.35,
        -46.58, -46.58, -46.60, -46.67, -46.67, -46.67, -46.70, -46.89, -46.77, -46.99,
        -46.87, -47.09, -47.09, -47.09, -47.06, -47.09, -47.28, -47.18, -47.18, -47.28,
        -47.28, -47.53, -47.52, -47.47, -47.47, -47.57, -47.60, -47.70, -47.91, -47.82,
        -47.89, -47.89, -47.99, -48.11, -48.10, -48.18, -48.21, -48.30, -48.40, -48.28,
        -48.40, -48.50, -48.40, -48.59, -48.50, -48.50, -48.50, -48.47, -48.47, -48.34,
        -48.54, -48.69, -48.57, -48.79, -48.91, -48.91, -49.11, -49.09, -49.11, -49.30,
        -49.33, -49.33, -49.28, -49.27, -49.30, -49.40, -49.49, -49.40, -49.27, -49.46,
        -49.49, -49.59, -49.59, -49.59, -49.81, -49.84, -49.84, -49.81, -49.97, -49.97,
        -50.15, -50.03, -50.16, -50.28, -50.28, -50.38, -50.51, -50.38, -50.35, -50.45,
        -50.47, -50.35, -50.35, -50.45, -50.55, -50.55, -50.57, -50.64, -50.67, -50.55,
        -50.74, -50.74, -50.83, -50.99, -51.08, -51.18, -51.06, -51.36, -51.25, -51.25,
        -51.35, -51.25, -51.25, -51.28, -51.28, -51.27, -51.25, -51.28, -51.28, -51.47,
        -51.35, -51.35, -51.54, -51.44, -51.57, -51.76, -51.78, -51.69, -51.79, -51.92,
        -51.89, -51.98, -52.08, -51.98, -52.08, -52.18, -52.17, -52.05, -52.05, -52.15,
        -52.06, -52.24, -52.27, -52.27, -52.24, -52.34, -52.34, -52.19, -52.31, -52.44,
        -52.53, -52.59, -52.58, -52.47, -52.47, -52.50, -52.59, -52.59, -52.69, -52.69,
        -52.72, -52.79, -52.69, -52.69, -52.79, -52.69, -52.69, -52.79, -52.79, -53.00,
        -53.00, -53.00, -53.01, -53.04, -53.13, -53.13, -53.16, -53.16, -53.16, -53.16,
        -53.16, -53.16, -53.13, -53.14, -53.14, -53.23, -53.36, -53.36, -53.36, -53.36,
        -53.48, -53.48, -53.48, -53.45, -53.48, -53.48, -53.48, -53.42, -53.45, -53.58,
        -53.48, -53.67, -53.67, -53.58, -53.77, -53.77, -53.64, -53.87, -53.84, -53.62,
        -53.87, -53.81, -53.84, -53.87, -53.81, -53.74, -53.87, -53.71, -53.74, -53.81,
        -53.84, -53.96, -53.91, -53.93, -54.03, -54.13, -54.06, -54.13, -54.25, -54.16,
        -54.31, -54.28, -54.25, -54.19, -54.25, -54.25, -54.06, -54.25, -54.25, -54.13,
        -54.35, -54.25, -54.22, -54.45, -54.35, -54.48, -54.50, -54.45, -54.45, -54.57,
        -54.64, -54.64, -54.63, -54.64, -54.77, -54.77, -54.77, -54.89, -54.89, -54.89,
        -54.98, -54.99, -54.86, -54.86, -54.96, -54.93, -54.93, -54.80, -55.03, -55.03,
        -54.96, -55.05, -55.05, -55.08, -55.08, -55.03, -55.05, -54.93, -55.03, -54.90,
        -55.15, -55.12, -55.15, -55.03, -55.28, -55.05, -55.18, -55.03, -55.18, -55.28,
        -55.28, -55.28, -55.40, -55.28, -55.28, -55.37, -55.18, -55.03, -55.25, -55.05,
        -55.03, -55.15, -55.12, -55.15, -55.15, -55.37, -55.25, -55.37, -55.28, -55.28,
        -55.28, -55.15, -55.28, -55.18, -55.18, -55.28, -55.18, -55.28, -55.28, -55.15,
        -55.28, -55.15, -55.08, -55.15, -55.15, -55.28, -55.12, -55.22, -55.03, -55.25,
        -55.25, -55.05, -55.18, -55.28, -55.15, -55.25, -55.25, -55.25, -55.47, -55.34,
        -55.44, -55.57, -55.44, -55.57, -55.54, -55.41, -55.63, -55.66, -55.63, -55.61,
        -55.63, -55.66, -55.54, -55.64, -55.76, -55.76, -55.76, -55.76, -55.76, -55.76,
        -55.63, -55.63, -55.51, -55.63, -55.63, -55.63, -55.66, -55.66, -55.66, -55.66,
        -55.66, -55.79, -55.79, -55.79, -55.79, -55.79, -55.79, -55.76, -55.76, -55.66,
        -55.66, -55.79, -55.79, -55.76, -55.76, -55.79, -55.91, -55.79, -55.66, -55.66,
        -55.54, -55.66, -55.57, -55.54, -55.63, -55.66, -55.66, -55.76, -55.69, -55.66,
        -55.66, -55.69, -55.79, -55.69, -55.66, -55.79, -55.72, -55.66, -55.66, -55.68,
        -55.66, -55.66, -55.76, -55.66, -55.76, -55.76, -55.54, -55.66, -55.66, -55.54,
        -55.66, -55.51, -55.66, -55.57, -55.57, -55.69, -55.60, -55.62, -55.82, -55.60,
        -55.69, -55.82, -55.69, -55.79, -55.57, -55.57, -55.54, -55.57, -55.57, -55.69,
        -55.47, -55.57, -55.69, -55.60, -55.69, -55.72, -55.60, -55.57, -55.47, -55.37,
        -55.37, -55.47, -55.47, -55.22, -55.22, -55.47, -55.47, -55.22, -55.25, -55.28,
        -55.15, -55.12, -55.15, -55.28, -55.28, -55.28, -55.28, -54.93, -54.96, -55.08,
        -54.99, -55.08, -54.74, -54.74, -54.77, -54.86, -54.75, -54.64, -54.64, -54.39,
        -54.51, -54.45, -54.45, -54.32, -54.29, -54.42, -54.39, -54.32, -54.29, -54.22,
        -54.35, -54.38, -54.25, -54.16, -54.19, -54.21, -54.09, -53.96, -54.09, -53.96,
        -53.87, -53.74, -53.71, -53.68, -53.71, -53.71, -53.59, -53.39, -53.42, -53.17,
        -53.33, -53.08, -53.10, -52.91, -53.10, -52.88, -52.79, -52.79, -52.66, -52.66,
        -52.69, -52.47, -52.24, -52.30, -52.30, -52.08, -52.21, -52.11, -51.92, -51.68,
        -51.69, -51.69, -51.47, -51.47, -51.25, -51.25, -51.25, -51.03, -51.03, -51.06,
        -50.96, -50.74, -50.77, -50.67, -50.42, -50.35, -50.35, -50.23, -50.03, -50.06,
        -50.06, -49.81, -49.74, -49.49, -49.52, -49.30, -49.08, -49.20, -48.98, -48.79,
        -49.01, -48.79, -48.72, -48.47, -48.50, -48.50, -48.15, -48.15, -47.93, -47.73,
        -47.73, -47.51, -47.32, -47.35, -47.13, -47.06, -46.84, -46.74, -46.61, -46.39,
        -46.20, -46.20, -46.10
    };

    static const float iso226_2023_curve_40_phons[985] =
    {
        -20.67, -20.79,
        -20.64, -20.64, -20.89, -20.76, -20.89, -20.89, -20.89, -20.89, -20.86, -21.01,
        -20.98, -20.96, -20.98, -21.11, -20.96, -21.18, -21.18, -21.25, -21.15, -21.15,
        -21.37, -21.34, -21.34, -21.34, -21.34, -21.44, -21.56, -21.44, -21.58, -21.79,
        -21.82, -21.66, -21.98, -22.01, -22.04, -22.04, -22.11, -22.23, -22.23, -22.30,
        -22.42, -22.20, -22.30, -22.42, -22.30, -22.30, -22.30, -22.42, -22.37, -22.52,
        -22.42, -22.42, -22.65, -22.62, -22.62, -22.42, -22.65, -22.62, -22.71, -22.71,
        -22.84, -22.91, -22.91, -23.03, -23.03, -23.00, -23.00, -23.25, -23.06, -23.00,
        -23.25, -23.16, -23.16, -23.34, -23.35, -23.45, -23.45, -23.54, -23.67, -23.77,
        -23.67, -23.64, -23.77, -23.86, -23.83, -23.86, -23.83, -23.93, -23.96, -23.80,
        -23.93, -23.93, -23.96, -23.90, -24.03, -24.15, -24.22, -24.25, -24.35, -24.35,
        -24.34, -24.54, -24.66, -24.44, -24.66, -24.66, -24.69, -24.69, -24.66, -24.72,
        -24.79, -24.79, -24.79, -24.92, -24.82, -24.92, -25.04, -24.98, -24.89, -25.01,
        -25.08, -25.18, -25.15, -25.37, -25.51, -25.43, -25.62, -25.62, -25.75, -25.81,
        -25.75, -25.84, -25.87, -25.84, -25.84, -25.75, -25.84, -26.04, -26.04, -26.16,
        -26.04, -26.26, -26.13, -26.13, -26.26, -26.38, -26.26, -26.38, -26.51, -26.38,
        -26.35, -26.45, -26.48, -26.33, -26.42, -26.67, -26.55, -26.67, -26.64, -26.87,
        -26.87, -26.87, -26.96, -26.96, -26.96, -27.06, -26.84, -27.09, -27.16, -27.18,
        -27.21, -27.28, -27.44, -27.28, -27.50, -27.41, -27.38, -27.45, -27.60, -27.45,
        -27.67, -27.64, -27.67, -27.64, -27.79, -27.86, -27.74, -27.95, -27.74, -27.95,
        -28.05, -28.30, -28.18, -28.18, -28.28, -28.40, -28.40, -28.43, -28.43, -28.62,
        -28.53, -28.53, -28.62, -28.75, -28.75, -28.75, -28.75, -28.62, -28.72, -28.85,
        -28.72, -28.69, -28.91, -28.88, -28.91, -29.11, -29.35, -29.20, -29.36, -29.58,
        -29.55, -29.61, -29.68, -29.68, -29.45, -29.68, -29.80, -29.55, -29.77, -29.74,
        -29.84, -29.84, -29.84, -29.97, -29.84, -29.97, -30.21, -30.09, -30.19, -30.21,
        -30.19, -30.41, -30.28, -30.48, -30.51, -30.48, -30.73, -30.57, -30.70, -30.83,
        -30.70, -30.83, -30.95, -30.95, -31.05, -31.02, -31.02, -31.09, -31.02, -31.21,
        -31.18, -31.21, -31.31, -31.40, -31.53, -31.53, -31.66, -31.78, -31.66, -31.81,
        -31.75, -31.75, -31.88, -31.75, -31.85, -31.85, -31.85, -31.82, -31.95, -32.04,
        -32.04, -32.04, -32.01, -32.14, -32.14, -32.26, -32.26, -32.36, -32.49, -32.33,
        -32.43, -32.68, -32.52, -32.68, -32.65, -32.87, -33.00, -32.97, -33.19, -33.19,
        -33.16, -33.26, -33.16, -33.16, -33.29, -33.17, -33.16, -33.41, -33.38, -33.41,
        -33.51, -33.55, -33.51, -33.64, -33.76, -33.73, -33.76, -33.86, -33.93, -33.93,
        -34.05, -34.02, -34.02, -34.05, -34.12, -34.12, -34.24, -34.34, -34.28, -34.34,
        -34.44, -34.19, -34.44, -34.44, -34.50, -34.44, -34.63, -34.75, -34.53, -34.73,
        -34.91, -34.82, -34.82, -34.82, -35.06, -34.82, -34.95, -35.07, -35.02, -35.05,
        -35.17, -35.29, -35.07, -35.33, -35.30, -35.39, -35.30, -35.49, -35.61, -35.58,
        -35.49, -35.59, -35.61, -35.59, -35.68, -35.78, -35.78, -35.65, -35.85, -35.85,
        -36.07, -35.97, -35.97, -36.10, -36.19, -36.34, -36.19, -36.29, -36.26, -36.51,
        -36.29, -36.48, -36.48, -36.64, -36.73, -36.58, -36.74, -36.74, -36.92, -36.86,
        -36.83, -36.93, -37.02, -37.05, -36.93, -37.12, -37.12, -37.18, -37.25, -37.28,
        -37.40, -37.50, -37.43, -37.60, -37.50, -37.50, -37.62, -37.62, -37.69, -37.72,
        -37.79, -37.82, -38.01, -37.91, -37.79, -38.01, -38.01, -38.11, -38.01, -38.01,
        -38.11, -38.26, -38.25, -38.30, -38.20, -38.20, -38.23, -38.43, -38.54, -38.55,
        -38.43, -38.52, -38.62, -38.65, -38.83, -38.72, -38.84, -38.94, -38.94, -39.00,
        -39.03, -39.13, -39.13, -39.13, -39.23, -39.23, -39.13, -39.10, -39.20, -39.07,
        -39.27, -39.41, -39.29, -39.52, -39.55, -39.55, -39.74, -39.62, -39.65, -39.84,
        -39.86, -39.96, -39.81, -39.81, -39.84, -40.03, -40.03, -39.93, -40.00, -40.00,
        -40.03, -40.03, -40.13, -40.13, -40.15, -40.38, -40.38, -40.25, -40.41, -40.50,
        -40.49, -40.38, -40.50, -40.63, -40.63, -40.72, -40.85, -40.72, -40.70, -40.89,
        -40.91, -40.69, -40.80, -40.89, -40.89, -40.89, -41.11, -40.98, -41.02, -40.98,
        -40.98, -41.08, -40.98, -41.14, -41.33, -41.33, -41.21, -41.42, -41.40, -41.40,
        -41.40, -41.40, -41.50, -41.53, -41.62, -41.71, -41.59, -41.62, -41.62, -41.82,
        -41.69, -41.69, -41.69, -41.60, -41.82, -41.81, -41.83, -41.84, -41.84, -41.87,
        -41.94, -42.04, -42.04, -42.04, -42.04, -42.04, -42.12, -42.01, -42.01, -42.10,
        -42.20, -42.20, -42.23, -42.33, -42.20, -42.20, -42.20, -42.05, -42.08, -42.29,
        -42.29, -42.35, -42.35, -42.33, -42.33, -42.36, -42.45, -42.45, -42.55, -42.55,
        -42.58, -42.65, -42.55, -42.65, -42.65, -42.65, -42.65, -42.65, -42.74, -42.86,
        -42.86, -42.86, -42.86, -42.89, -42.89, -42.99, -43.02, -43.02, -43.12, -43.12,
        -43.12, -43.12, -43.09, -43.10, -43.10, -43.19, -43.31, -43.31, -43.31, -43.32,
        -43.44, -43.44, -43.44, -43.41, -43.34, -43.44, -43.44, -43.28, -43.31, -43.44,
        -43.44, -43.53, -43.53, -43.44, -43.63, -43.63, -43.41, -43.63, -43.60, -43.38,
        -43.63, -43.48, -43.51, -43.63, -43.57, -43.51, -43.63, -43.57, -43.51, -43.57,
        -43.60, -43.73, -43.67, -43.89, -43.89, -43.89, -44.02, -43.89, -44.02, -44.02,
        -44.07, -44.05, -44.02, -43.95, -44.02, -44.01, -43.82, -44.01, -43.92, -43.79,
        -44.02, -44.02, -43.89, -44.02, -44.02, -44.14, -44.17, -44.11, -44.11, -44.24,
        -44.21, -44.21, -44.21, -44.21, -44.34, -44.34, -44.34, -44.46, -44.46, -44.46,
        -44.46, -44.56, -44.43, -44.43, -44.43, -44.31, -44.31, -44.28, -44.40, -44.40,
        -44.43, -44.53, -44.43, -44.56, -44.65, -44.41, -44.53, -44.40, -44.50, -44.47,
        -44.63, -44.60, -44.72, -44.50, -44.65, -44.63, -44.65, -44.60, -44.65, -44.75,
        -44.75, -44.65, -44.88, -44.75, -44.75, -44.75, -44.65, -44.60, -44.72, -44.63,
        -44.69, -44.63, -44.69, -44.72, -44.72, -44.85, -44.72, -44.85, -44.65, -44.85,
        -44.65, -44.63, -44.65, -44.65, -44.65, -44.75, -44.75, -44.75, -44.85, -44.72,
        -44.85, -44.72, -44.75, -44.72, -44.63, -44.85, -44.60, -44.69, -44.60, -44.63,
        -44.72, -44.63, -44.65, -44.75, -44.72, -44.72, -44.63, -44.72, -44.85, -44.72,
        -44.72, -44.94, -44.82, -44.85, -44.82, -44.79, -44.82, -44.94, -44.92, -44.79,
        -44.92, -45.04, -44.92, -44.92, -45.14, -45.14, -45.14, -45.14, -45.14, -45.23,
        -45.01, -45.01, -44.89, -44.92, -45.01, -45.01, -45.04, -45.04, -45.04, -45.04,
        -45.04, -45.17, -45.17, -45.17, -45.17, -45.17, -45.17, -45.04, -45.04, -44.94,
        -44.94, -45.07, -45.17, -45.14, -45.14, -45.26, -45.29, -45.17, -45.14, -45.14,
        -45.11, -45.23, -45.04, -45.01, -45.11, -45.23, -45.04, -45.14, -45.26, -45.14,
        -45.04, -45.17, -45.26, -45.07, -45.04, -45.17, -45.20, -45.04, -45.04, -45.15,
        -45.04, -44.94, -45.04, -45.04, -45.04, -45.04, -44.82, -45.04, -45.04, -44.92,
        -45.04, -44.89, -44.94, -44.94, -44.85, -44.97, -44.97, -45.00, -45.10, -44.97,
        -44.97, -45.00, -44.88, -44.97, -44.85, -44.85, -44.82, -44.94, -44.94, -45.07,
        -44.85, -45.04, -45.07, -44.97, -44.97, -45.10, -44.98, -44.94, -45.04, -44.94,
        -44.85, -44.85, -44.94, -44.69, -44.69, -44.75, -44.85, -44.60, -44.63, -44.75,
        -44.72, -44.60, -44.82, -44.85, -44.75, -44.75, -44.85, -44.60, -44.63, -44.75,
        -44.75, -44.75, -44.40, -44.41, -44.43, -44.43, -44.42, -44.31, -44.31, -44.15,
        -44.18, -44.21, -44.21, -44.08, -44.06, -44.18, -44.06, -44.08, -43.96, -43.99,
        -44.02, -44.05, -43.92, -43.82, -44.05, -43.98, -43.85, -43.73, -43.85, -43.73,
        -43.63, -43.51, -43.48, -43.35, -43.48, -43.38, -43.25, -43.16, -43.28, -43.03,
        -43.09, -42.94, -42.96, -42.87, -42.96, -42.74, -42.74, -42.65, -42.42, -42.42,
        -42.45, -42.33, -42.10, -42.26, -42.26, -42.04, -42.16, -42.07, -41.98, -41.82,
        -41.84, -41.75, -41.62, -41.62, -41.50, -41.40, -41.40, -41.37, -41.18, -41.21,
        -41.21, -40.98, -41.01, -40.92, -40.67, -40.69, -40.69, -40.47, -40.38, -40.41,
        -40.50, -40.25, -40.18, -40.03, -40.06, -39.84, -39.71, -39.74, -39.52, -39.42,
        -39.55, -39.32, -39.26, -39.10, -39.13, -39.03, -38.88, -38.69, -38.56, -38.46,
        -38.37, -38.15, -38.05, -38.08, -37.76, -37.79, -37.66, -37.47, -37.34, -37.22,
        -37.12, -37.03, -36.93
    };

    static const float iso226_2023_curve_50_phons[985] =
    {
        -15.74, -15.87,
        -15.71, -15.62, -15.87, -15.74, -15.87, -15.87, -15.97, -15.77, -15.74, -15.99,
        -15.96, -15.93, -16.06, -16.28, -16.13, -16.25, -16.25, -16.22, -16.32, -16.13,
        -16.25, -16.22, -16.22, -16.13, -16.13, -16.22, -16.35, -16.42, -16.56, -16.57,
        -16.70, -16.64, -16.57, -16.70, -16.82, -16.82, -16.79, -16.92, -16.82, -16.89,
        -17.02, -16.79, -16.89, -17.02, -16.99, -16.99, -16.99, -17.02, -16.96, -17.11,
        -17.21, -17.21, -17.24, -17.21, -17.21, -17.11, -17.24, -17.21, -17.21, -17.21,
        -17.33, -17.40, -17.40, -17.53, -17.53, -17.40, -17.40, -17.65, -17.56, -17.40,
        -17.65, -17.65, -17.56, -17.74, -17.75, -17.94, -17.95, -17.94, -18.07, -18.16,
        -18.07, -18.14, -18.16, -18.26, -18.23, -18.26, -18.23, -18.33, -18.36, -18.20,
        -18.33, -18.33, -18.45, -18.20, -18.33, -18.36, -18.33, -18.36, -18.45, -18.45,
        -18.36, -18.55, -18.68, -18.65, -18.77, -18.68, -18.80, -18.90, -18.68, -18.93,
        -18.90, -19.00, -18.90, -18.93, -19.02, -19.12, -19.25, -19.00, -19.09, -19.22,
        -19.09, -19.19, -19.06, -19.19, -19.43, -19.34, -19.44, -19.44, -19.47, -19.54,
        -19.57, -19.57, -19.59, -19.66, -19.57, -19.66, -19.66, -19.85, -19.76, -19.98,
        -19.85, -19.98, -19.95, -19.95, -20.08, -20.01, -20.08, -20.20, -20.23, -20.20,
        -20.17, -20.18, -20.20, -20.14, -20.05, -20.30, -20.27, -20.30, -20.27, -20.40,
        -20.40, -20.40, -20.40, -20.49, -20.49, -20.59, -20.46, -20.62, -20.59, -20.71,
        -20.74, -20.71, -20.97, -20.81, -20.94, -20.84, -20.91, -20.88, -21.03, -20.88,
        -21.10, -21.07, -21.10, -21.07, -21.23, -21.20, -21.17, -21.28, -21.17, -21.29,
        -21.29, -21.45, -21.32, -21.42, -21.42, -21.54, -21.64, -21.67, -21.77, -21.86,
        -21.77, -21.86, -21.86, -21.99, -21.99, -22.09, -21.89, -21.96, -21.86, -21.99,
        -21.86, -21.74, -21.96, -21.93, -21.96, -22.15, -22.30, -22.15, -22.31, -22.43,
        -22.31, -22.56, -22.43, -22.53, -22.40, -22.53, -22.65, -22.50, -22.63, -22.50,
        -22.60, -22.69, -22.60, -22.82, -22.69, -22.82, -23.06, -22.95, -23.04, -23.16,
        -23.14, -23.17, -23.14, -23.14, -23.26, -23.23, -23.39, -23.23, -23.36, -23.58,
        -23.46, -23.49, -23.71, -23.71, -23.71, -23.68, -23.68, -23.65, -23.58, -23.78,
        -23.65, -23.78, -23.78, -23.78, -23.90, -23.90, -24.03, -24.15, -24.03, -24.28,
        -24.12, -24.22, -24.25, -24.22, -24.32, -24.32, -24.41, -24.29, -24.41, -24.50,
        -24.41, -24.51, -24.48, -24.51, -24.61, -24.73, -24.73, -24.83, -24.86, -24.61,
        -24.80, -24.86, -24.70, -24.86, -24.73, -24.95, -25.08, -25.05, -25.08, -25.18,
        -25.15, -25.34, -25.15, -25.24, -25.47, -25.25, -25.34, -25.49, -25.37, -25.49,
        -25.49, -25.53, -25.49, -25.62, -25.75, -25.72, -25.75, -25.84, -25.91, -25.91,
        -25.94, -26.01, -25.91, -26.04, -26.01, -25.91, -26.13, -26.13, -26.07, -26.13,
        -26.33, -26.07, -26.23, -26.33, -26.20, -26.33, -26.33, -26.54, -26.33, -26.52,
        -26.51, -26.52, -26.52, -26.61, -26.76, -26.52, -26.74, -26.77, -26.71, -26.74,
        -26.77, -26.99, -26.77, -26.92, -26.99, -27.08, -26.99, -26.99, -27.21, -27.08,
        -27.18, -27.09, -27.11, -27.18, -27.19, -27.09, -27.28, -27.16, -27.35, -27.35,
        -27.47, -27.47, -27.47, -27.60, -27.70, -27.94, -27.70, -27.79, -27.77, -28.01,
        -27.79, -27.89, -27.99, -28.14, -28.05, -27.99, -28.04, -28.04, -28.23, -28.17,
        -28.04, -28.24, -28.24, -28.27, -28.24, -28.24, -28.34, -28.49, -28.36, -28.49,
        -28.61, -28.61, -28.74, -28.71, -28.71, -28.71, -28.74, -28.74, -28.81, -28.84,
        -28.71, -28.93, -28.93, -28.93, -28.90, -28.93, -29.03, -29.03, -29.03, -29.13,
        -29.13, -29.18, -29.37, -29.22, -29.22, -29.32, -29.25, -29.45, -29.56, -29.47,
        -29.35, -29.54, -29.54, -29.57, -29.75, -29.64, -29.67, -29.86, -29.86, -29.93,
        -29.96, -29.96, -29.96, -30.05, -29.96, -29.96, -30.05, -29.93, -29.93, -29.90,
        -29.99, -30.14, -30.03, -30.15, -30.18, -30.27, -30.27, -30.16, -30.38, -30.37,
        -30.40, -30.59, -30.35, -30.44, -30.56, -30.56, -30.66, -30.66, -30.54, -30.54,
        -30.76, -30.66, -30.66, -30.66, -30.88, -30.91, -30.91, -30.98, -31.04, -31.04,
        -31.03, -31.11, -31.13, -31.16, -31.17, -31.36, -31.39, -31.26, -31.23, -31.24,
        -31.45, -31.23, -31.23, -31.23, -31.42, -31.42, -31.55, -31.33, -31.45, -31.42,
        -31.42, -31.43, -31.42, -31.58, -31.67, -31.67, -31.55, -31.86, -31.74, -31.74,
        -31.84, -31.74, -31.84, -31.87, -31.87, -31.95, -31.84, -31.87, -31.87, -31.87,
        -31.84, -31.84, -31.84, -31.84, -31.96, -31.96, -31.98, -31.90, -31.99, -32.02,
        -31.99, -32.19, -32.19, -32.09, -32.19, -32.19, -32.27, -32.16, -32.16, -32.25,
        -32.25, -32.25, -32.38, -32.38, -32.25, -32.35, -32.35, -32.29, -32.32, -32.54,
        -32.54, -32.60, -32.59, -32.48, -32.58, -32.60, -32.60, -32.70, -32.80, -32.80,
        -32.82, -32.80, -32.80, -32.80, -32.80, -32.80, -32.80, -32.80, -32.80, -33.01,
        -33.01, -33.01, -33.01, -33.04, -33.04, -33.04, -33.07, -33.07, -33.07, -33.07,
        -33.07, -33.08, -33.05, -33.15, -33.15, -33.24, -33.37, -33.37, -33.27, -33.27,
        -33.39, -33.39, -33.30, -33.27, -33.30, -33.30, -33.30, -33.24, -33.37, -33.40,
        -33.39, -33.59, -33.59, -33.59, -33.59, -33.59, -33.46, -33.49, -33.37, -33.34,
        -33.49, -33.34, -33.46, -33.59, -33.43, -33.46, -33.59, -33.53, -33.56, -33.53,
        -33.65, -33.78, -33.63, -33.75, -33.75, -33.85, -33.78, -33.85, -33.97, -33.88,
        -34.03, -34.00, -33.78, -33.91, -33.88, -33.78, -33.68, -33.77, -33.78, -33.65,
        -33.78, -33.78, -33.75, -33.78, -33.78, -33.91, -33.84, -33.78, -33.78, -33.81,
        -33.88, -33.88, -33.88, -33.88, -34.00, -34.00, -34.00, -34.13, -34.13, -34.13,
        -34.22, -34.22, -34.10, -34.10, -34.20, -34.07, -34.07, -34.04, -34.07, -34.17,
        -34.10, -34.10, -34.20, -34.22, -34.22, -34.17, -34.20, -34.07, -34.17, -34.04,
        -34.20, -34.17, -34.20, -34.07, -34.22, -34.10, -34.22, -34.17, -34.32, -34.42,
        -34.32, -34.32, -34.45, -34.32, -34.32, -34.32, -34.22, -34.17, -34.29, -34.29,
        -34.26, -34.29, -34.26, -34.29, -34.20, -34.42, -34.29, -34.42, -34.32, -34.42,
        -34.22, -34.29, -34.22, -34.22, -34.22, -34.32, -34.32, -34.42, -34.42, -34.20,
        -34.42, -34.39, -34.42, -34.29, -34.29, -34.42, -34.17, -34.17, -34.07, -34.20,
        -34.20, -34.20, -34.22, -34.32, -34.29, -34.29, -34.39, -34.39, -34.42, -34.30,
        -34.49, -34.51, -34.39, -34.51, -34.49, -34.36, -34.39, -34.61, -34.49, -34.36,
        -34.49, -34.51, -34.39, -34.49, -34.51, -34.51, -34.52, -34.61, -34.61, -34.61,
        -34.58, -34.58, -34.46, -34.58, -34.58, -34.58, -34.52, -34.51, -34.51, -34.51,
        -34.42, -34.54, -34.54, -34.54, -34.54, -34.54, -34.54, -34.51, -34.52, -34.51,
        -34.51, -34.64, -34.64, -34.61, -34.61, -34.64, -34.76, -34.54, -34.51, -34.51,
        -34.39, -34.51, -34.51, -34.39, -34.49, -34.61, -34.51, -34.61, -34.74, -34.61,
        -34.61, -34.74, -34.64, -34.64, -34.61, -34.54, -34.67, -34.61, -34.42, -34.63,
        -34.51, -34.42, -34.61, -34.42, -34.51, -34.42, -34.39, -34.42, -34.42, -34.49,
        -34.42, -34.36, -34.42, -34.42, -34.42, -34.54, -34.54, -34.57, -34.67, -34.54,
        -34.54, -34.67, -34.54, -34.54, -34.42, -34.51, -34.39, -34.51, -34.42, -34.64,
        -34.42, -34.42, -34.45, -34.35, -34.45, -34.48, -34.35, -34.32, -34.42, -34.32,
        -34.22, -34.32, -34.42, -34.17, -34.17, -34.42, -34.42, -34.17, -34.20, -34.22,
        -34.29, -34.17, -34.29, -34.42, -34.42, -34.42, -34.42, -34.17, -34.29, -34.32,
        -34.42, -34.42, -34.17, -34.07, -34.20, -34.20, -34.09, -34.07, -34.07, -33.92,
        -33.94, -33.97, -33.98, -33.95, -33.82, -33.85, -33.82, -33.75, -33.63, -33.75,
        -33.78, -33.81, -33.78, -33.78, -33.71, -33.74, -33.71, -33.59, -33.62, -33.49,
        -33.49, -33.37, -33.24, -33.21, -33.24, -33.14, -33.02, -33.02, -33.05, -32.80,
        -33.05, -32.80, -32.92, -32.82, -32.92, -32.80, -32.80, -32.80, -32.57, -32.57,
        -32.60, -32.38, -32.35, -32.41, -32.31, -32.28, -32.41, -32.31, -32.32, -32.17,
        -32.19, -32.09, -31.87, -31.87, -31.74, -31.55, -31.55, -31.52, -31.52, -31.45,
        -31.45, -31.33, -31.36, -31.36, -31.11, -31.13, -31.13, -31.01, -30.91, -30.94,
        -30.94, -30.69, -30.72, -30.47, -30.50, -30.46, -30.25, -30.27, -30.05, -30.05,
        -30.08, -30.05, -29.99, -29.83, -29.86, -29.86, -29.71, -29.51, -29.48, -29.39,
        -29.39, -29.16, -29.16, -29.10, -28.87, -28.90, -28.78, -28.68, -28.56, -28.43,
        -28.33, -28.33, -28.24
    };

    static const float iso226_2023_curve_60_phons[985] =
    {
        -11.11, -11.23,
        -11.08, -10.98, -11.23, -11.11, -11.23, -11.23, -11.14, -11.14, -11.11, -11.26,
        -11.13, -11.11, -11.23, -11.26, -11.11, -11.33, -11.33, -11.30, -11.30, -11.30,
        -11.42, -11.30, -11.30, -11.30, -11.30, -11.30, -11.33, -11.30, -11.54, -11.45,
        -11.48, -11.42, -11.55, -11.58, -11.61, -11.61, -11.68, -11.61, -11.61, -11.68,
        -11.80, -11.77, -11.77, -11.80, -11.77, -11.87, -11.87, -11.90, -11.84, -11.90,
        -11.90, -11.80, -12.02, -11.90, -11.90, -11.80, -12.02, -11.99, -12.09, -12.09,
        -12.22, -12.19, -12.19, -12.31, -12.22, -12.19, -12.19, -12.34, -12.25, -12.19,
        -12.34, -12.25, -12.25, -12.33, -12.34, -12.34, -12.44, -12.44, -12.47, -12.56,
        -12.56, -12.53, -12.56, -12.56, -12.63, -12.66, -12.63, -12.63, -12.66, -12.51,
        -12.53, -12.63, -12.76, -12.60, -12.73, -12.76, -12.73, -12.85, -12.85, -12.95,
        -12.95, -12.95, -13.08, -12.95, -13.17, -12.98, -13.01, -13.10, -12.98, -13.13,
        -13.10, -13.10, -13.01, -13.13, -13.13, -13.33, -13.26, -13.20, -13.20, -13.33,
        -13.29, -13.30, -13.17, -13.30, -13.44, -13.45, -13.55, -13.45, -13.58, -13.55,
        -13.67, -13.67, -13.70, -13.67, -13.58, -13.58, -13.67, -13.77, -13.67, -13.90,
        -13.67, -13.90, -13.87, -13.87, -13.99, -13.93, -13.90, -13.93, -13.86, -13.93,
        -13.80, -13.90, -13.83, -13.77, -13.87, -14.02, -13.90, -14.12, -13.99, -14.12,
        -14.22, -14.22, -14.22, -14.31, -14.31, -14.31, -14.19, -14.44, -14.41, -14.44,
        -14.36, -14.44, -14.59, -14.53, -14.66, -14.56, -14.53, -14.50, -14.66, -14.60,
        -14.73, -14.60, -14.82, -14.60, -14.66, -14.73, -14.50, -14.71, -14.60, -14.72,
        -14.73, -14.98, -14.85, -14.85, -14.85, -14.88, -14.98, -15.01, -15.10, -15.20,
        -15.20, -15.30, -15.20, -15.33, -15.23, -15.23, -15.13, -15.20, -15.20, -15.23,
        -15.20, -15.08, -15.20, -15.07, -15.20, -15.30, -15.45, -15.30, -15.45, -15.67,
        -15.45, -15.70, -15.67, -15.58, -15.55, -15.67, -15.70, -15.64, -15.87, -15.64,
        -15.84, -15.84, -15.84, -15.96, -15.84, -15.96, -16.01, -15.99, -15.99, -15.91,
        -15.99, -16.12, -15.99, -16.09, -16.12, -16.09, -16.34, -16.09, -16.21, -16.44,
        -16.21, -16.44, -16.47, -16.47, -16.47, -16.34, -16.44, -16.31, -16.34, -16.44,
        -16.31, -16.44, -16.53, -16.53, -16.66, -16.66, -16.78, -16.81, -16.69, -16.94,
        -16.69, -16.78, -16.81, -16.78, -16.98, -16.78, -16.98, -16.85, -16.98, -17.07,
        -16.98, -17.07, -16.95, -17.07, -17.07, -17.10, -17.20, -17.10, -17.13, -17.07,
        -17.07, -17.13, -17.07, -17.13, -17.10, -17.23, -17.45, -17.32, -17.55, -17.45,
        -17.42, -17.52, -17.52, -17.52, -17.74, -17.52, -17.61, -17.77, -17.74, -17.77,
        -17.77, -17.81, -17.77, -17.80, -18.02, -17.89, -17.92, -18.02, -17.89, -17.99,
        -18.02, -17.89, -17.99, -18.02, -18.09, -17.99, -18.12, -18.21, -18.16, -18.21,
        -18.22, -18.16, -18.21, -18.31, -18.28, -18.21, -18.31, -18.43, -18.21, -18.41,
        -18.40, -18.31, -18.41, -18.60, -18.65, -18.41, -18.63, -18.66, -18.50, -18.63,
        -18.75, -18.88, -18.66, -18.72, -18.88, -18.78, -18.78, -18.88, -18.91, -18.97,
        -18.88, -18.78, -19.00, -18.88, -18.88, -18.88, -18.98, -18.85, -18.95, -19.04,
        -19.07, -19.07, -19.07, -19.10, -19.20, -19.24, -19.10, -19.10, -19.07, -19.32,
        -19.10, -19.10, -19.29, -19.35, -19.45, -19.29, -19.45, -19.55, -19.54, -19.57,
        -19.55, -19.55, -19.54, -19.67, -19.55, -19.55, -19.64, -19.80, -19.67, -19.89,
        -19.92, -19.92, -20.05, -20.02, -19.93, -20.02, -20.05, -20.05, -20.12, -20.14,
        -20.02, -20.24, -20.24, -20.14, -20.12, -20.24, -20.24, -20.15, -20.05, -20.24,
        -20.24, -20.30, -20.48, -20.34, -20.24, -20.34, -20.37, -20.46, -20.49, -20.49,
        -20.46, -20.46, -20.46, -20.68, -20.67, -20.56, -20.69, -20.78, -20.78, -20.66,
        -20.78, -20.88, -20.78, -20.78, -20.88, -20.88, -20.88, -20.75, -20.85, -20.72,
        -20.72, -21.07, -20.95, -20.98, -21.00, -21.01, -21.10, -21.08, -21.11, -21.10,
        -21.32, -21.32, -21.08, -21.27, -21.29, -21.29, -21.39, -21.39, -21.26, -21.26,
        -21.39, -21.39, -21.39, -21.49, -21.52, -21.54, -21.64, -21.52, -21.57, -21.67,
        -21.66, -21.55, -21.67, -21.70, -21.70, -21.89, -21.92, -21.80, -21.86, -21.77,
        -21.79, -21.67, -21.67, -21.67, -21.77, -21.77, -21.79, -21.86, -21.89, -21.77,
        -21.86, -21.86, -21.77, -22.02, -22.01, -22.01, -21.99, -22.10, -21.99, -21.99,
        -22.09, -21.99, -21.99, -22.11, -22.21, -22.20, -22.09, -22.12, -22.21, -22.21,
        -22.18, -22.18, -22.18, -22.18, -22.40, -22.40, -22.42, -22.43, -22.34, -22.37,
        -22.43, -22.53, -22.53, -22.43, -22.44, -22.53, -22.52, -22.40, -22.40, -22.50,
        -22.50, -22.50, -22.62, -22.72, -22.60, -22.60, -22.60, -22.44, -22.47, -22.60,
        -22.69, -22.75, -22.84, -22.72, -22.73, -22.85, -22.85, -22.85, -22.76, -22.85,
        -22.88, -22.85, -22.75, -22.75, -22.75, -22.66, -22.66, -22.66, -22.75, -22.87,
        -22.87, -22.97, -22.97, -23.00, -23.00, -23.00, -23.03, -23.03, -23.03, -23.03,
        -23.03, -23.03, -23.00, -23.01, -23.01, -23.10, -23.23, -23.23, -23.23, -23.23,
        -23.35, -23.25, -23.25, -23.23, -23.16, -23.25, -23.25, -23.20, -23.23, -23.35,
        -23.35, -23.35, -23.35, -23.35, -23.35, -23.35, -23.23, -23.35, -23.32, -23.20,
        -23.35, -23.20, -23.23, -23.35, -23.20, -23.32, -23.35, -23.20, -23.32, -23.29,
        -23.32, -23.45, -23.39, -23.51, -23.51, -23.61, -23.54, -23.61, -23.74, -23.54,
        -23.79, -23.77, -23.54, -23.67, -23.54, -23.54, -23.35, -23.54, -23.54, -23.32,
        -23.54, -23.54, -23.32, -23.55, -23.54, -23.48, -23.60, -23.54, -23.54, -23.57,
        -23.64, -23.64, -23.64, -23.64, -23.77, -23.67, -23.67, -23.80, -23.80, -23.80,
        -23.80, -23.80, -23.67, -23.77, -23.77, -23.64, -23.74, -23.61, -23.64, -23.74,
        -23.67, -23.77, -23.77, -23.89, -23.99, -23.74, -23.77, -23.74, -23.74, -23.61,
        -23.77, -23.64, -23.77, -23.64, -23.89, -23.67, -23.89, -23.74, -23.89, -23.99,
        -23.89, -23.89, -24.02, -23.89, -23.80, -23.89, -23.80, -23.54, -23.77, -23.67,
        -23.64, -23.67, -23.74, -23.67, -23.67, -23.89, -23.77, -23.89, -23.80, -23.99,
        -23.89, -23.86, -23.89, -23.89, -23.79, -23.99, -23.89, -23.89, -23.99, -23.77,
        -23.89, -23.86, -23.89, -23.86, -23.86, -23.99, -23.74, -23.93, -23.74, -23.77,
        -23.96, -23.77, -23.89, -23.99, -23.86, -23.87, -23.86, -23.96, -23.99, -23.87,
        -23.96, -24.08, -23.96, -24.08, -24.06, -23.93, -23.96, -24.08, -23.96, -23.83,
        -23.96, -23.99, -23.86, -23.96, -23.99, -23.99, -23.99, -23.99, -24.08, -24.08,
        -23.96, -24.06, -23.93, -23.96, -23.96, -23.96, -23.99, -23.99, -23.99, -23.99,
        -23.99, -24.11, -24.11, -24.11, -24.11, -24.11, -24.11, -23.99, -23.99, -23.99,
        -23.89, -24.02, -24.11, -23.99, -23.99, -24.11, -24.14, -24.02, -23.99, -23.89,
        -23.86, -23.99, -23.89, -23.86, -23.96, -23.99, -23.99, -24.08, -24.11, -23.99,
        -23.99, -24.11, -24.11, -24.02, -23.99, -24.11, -24.14, -23.99, -23.99, -24.20,
        -23.99, -23.99, -23.99, -23.89, -23.99, -23.99, -23.86, -23.99, -23.99, -24.06,
        -23.99, -23.93, -24.08, -23.89, -23.89, -24.02, -24.02, -24.05, -24.14, -24.02,
        -24.02, -24.05, -24.02, -24.11, -23.99, -23.89, -23.86, -23.99, -23.89, -24.02,
        -23.89, -23.99, -24.02, -24.02, -24.02, -24.05, -24.11, -23.99, -24.08, -23.99,
        -23.99, -23.99, -23.99, -23.93, -23.93, -23.99, -23.99, -23.83, -23.96, -23.99,
        -23.86, -23.83, -23.96, -23.99, -23.89, -23.89, -23.89, -23.74, -23.77, -23.80,
        -23.80, -23.80, -23.64, -23.74, -23.77, -23.77, -23.75, -23.74, -23.74, -23.49,
        -23.61, -23.64, -23.64, -23.51, -23.39, -23.42, -23.39, -23.42, -23.29, -23.32,
        -23.45, -23.48, -23.45, -23.45, -23.57, -23.60, -23.57, -23.45, -23.57, -23.45,
        -23.35, -23.23, -23.20, -23.17, -23.20, -23.20, -23.17, -23.07, -23.10, -22.95,
        -23.00, -22.95, -22.97, -22.88, -22.97, -22.85, -22.85, -22.85, -22.63, -22.72,
        -22.85, -22.63, -22.60, -22.75, -22.66, -22.53, -22.66, -22.56, -22.47, -22.41,
        -22.34, -22.34, -22.31, -22.11, -22.09, -22.09, -21.99, -21.86, -21.86, -21.89,
        -21.80, -21.67, -21.70, -21.70, -21.54, -21.48, -21.57, -21.45, -21.45, -21.48,
        -21.48, -21.32, -21.26, -21.10, -21.23, -21.10, -20.98, -21.10, -20.98, -20.78,
        -20.91, -20.78, -20.71, -20.56, -20.69, -20.78, -20.53, -20.43, -20.40, -20.41,
        -20.31, -20.18, -20.09, -20.12, -19.99, -19.92, -19.80, -19.80, -19.67, -19.64,
        -19.55, -19.55, -19.55
    };

    static const float iso226_2023_curve_70_phons[985] =
    {
        -6.28, -6.40,
        -6.15, -6.15, -6.40, -6.28, -6.40, -6.40, -6.41, -6.40, -6.28, -6.53,
        -6.40, -6.28, -6.40, -6.53, -6.28, -6.40, -6.40, -6.28, -6.28, -6.28,
        -6.40, -6.28, -6.28, -6.28, -6.28, -6.28, -6.40, -6.28, -6.52, -6.53,
        -6.65, -6.40, -6.53, -6.65, -6.78, -6.78, -6.65, -6.78, -6.78, -6.65,
        -6.78, -6.65, -6.65, -6.78, -6.65, -6.65, -6.65, -6.78, -6.53, -6.78,
        -6.78, -6.78, -6.90, -6.78, -6.78, -6.78, -6.90, -6.78, -6.78, -6.78,
        -6.90, -6.78, -6.78, -6.90, -6.90, -6.78, -6.78, -7.03, -7.03, -6.78,
        -7.02, -7.03, -7.03, -7.02, -7.03, -7.03, -7.04, -7.03, -7.16, -7.16,
        -7.16, -7.03, -7.16, -7.16, -7.03, -7.16, -7.03, -7.03, -7.16, -6.90,
        -7.03, -7.03, -7.16, -6.90, -7.03, -7.16, -7.03, -7.16, -7.16, -7.16,
        -7.15, -7.16, -7.28, -7.16, -7.28, -7.28, -7.41, -7.41, -7.28, -7.53,
        -7.41, -7.41, -7.41, -7.53, -7.53, -7.53, -7.66, -7.41, -7.41, -7.53,
        -7.40, -7.41, -7.28, -7.41, -7.65, -7.66, -7.66, -7.66, -7.78, -7.66,
        -7.78, -7.78, -7.91, -7.78, -7.78, -7.78, -7.78, -7.78, -7.78, -7.91,
        -7.78, -7.91, -7.78, -7.78, -7.91, -8.03, -7.91, -8.03, -8.16, -8.04,
        -7.91, -7.92, -8.03, -7.78, -7.78, -8.03, -7.91, -8.03, -7.91, -8.03,
        -8.03, -8.03, -8.03, -8.03, -8.03, -8.03, -7.91, -8.16, -8.03, -8.16,
        -8.28, -8.16, -8.41, -8.16, -8.29, -8.29, -8.16, -8.03, -8.29, -8.03,
        -8.16, -8.03, -8.16, -8.03, -8.29, -8.16, -8.03, -8.15, -8.03, -8.15,
        -8.16, -8.41, -8.29, -8.29, -8.29, -8.41, -8.41, -8.54, -8.54, -8.54,
        -8.54, -8.54, -8.54, -8.66, -8.66, -8.66, -8.66, -8.54, -8.54, -8.66,
        -8.54, -8.42, -8.54, -8.41, -8.54, -8.54, -8.78, -8.54, -8.79, -8.91,
        -8.79, -9.04, -8.91, -8.91, -8.79, -8.92, -9.03, -8.79, -8.91, -8.79,
        -8.79, -8.79, -8.79, -8.91, -8.79, -8.91, -9.16, -9.04, -9.04, -9.15,
        -9.04, -9.16, -9.04, -9.04, -9.16, -9.04, -9.29, -9.04, -9.16, -9.29,
        -9.16, -9.29, -9.42, -9.42, -9.42, -9.30, -9.29, -9.16, -9.29, -9.29,
        -9.16, -9.29, -9.29, -9.29, -9.42, -9.42, -9.54, -9.67, -9.54, -9.79,
        -9.54, -9.54, -9.67, -9.54, -9.55, -9.54, -9.54, -9.42, -9.54, -9.53,
        -9.54, -9.54, -9.42, -9.54, -9.54, -9.67, -9.67, -9.67, -9.79, -9.54,
        -9.54, -9.79, -9.54, -9.79, -9.67, -9.79, -9.92, -9.79, -9.92, -9.92,
        -9.79, -9.79, -9.79, -9.79, -9.92, -9.80, -9.79, -10.04, -9.92, -10.04,
        -10.04, -10.18, -10.04, -10.17, -10.29, -10.17, -10.29, -10.29, -10.17, -10.17,
        -10.29, -10.17, -10.17, -10.29, -10.17, -10.17, -10.29, -10.29, -10.04, -10.29,
        -10.29, -10.04, -10.29, -10.29, -10.17, -10.29, -10.29, -10.41, -10.29, -10.29,
        -10.29, -10.29, -10.29, -10.29, -10.53, -10.29, -10.42, -10.55, -10.30, -10.43,
        -10.55, -10.67, -10.55, -10.80, -10.68, -10.66, -10.67, -10.67, -10.80, -10.66,
        -10.67, -10.67, -10.79, -10.67, -10.68, -10.67, -10.67, -10.55, -10.55, -10.55,
        -10.67, -10.67, -10.67, -10.80, -10.80, -11.04, -10.80, -10.80, -10.68, -10.92,
        -10.80, -10.80, -10.80, -11.05, -11.05, -10.80, -11.05, -11.05, -11.04, -11.17,
        -11.05, -11.05, -11.05, -11.17, -11.05, -11.05, -11.05, -11.30, -11.17, -11.30,
        -11.42, -11.42, -11.55, -11.43, -11.42, -11.42, -11.55, -11.55, -11.42, -11.55,
        -11.43, -11.55, -11.55, -11.55, -11.43, -11.55, -11.55, -11.55, -11.55, -11.55,
        -11.55, -11.80, -11.79, -11.55, -11.55, -11.55, -11.68, -11.68, -11.79, -11.80,
        -11.68, -11.68, -11.68, -11.80, -11.79, -11.68, -11.80, -11.80, -11.80, -11.68,
        -11.80, -11.80, -11.80, -11.80, -11.80, -11.80, -11.80, -11.68, -11.68, -11.55,
        -11.55, -11.80, -11.68, -11.80, -11.93, -11.93, -11.93, -11.82, -11.93, -11.93,
        -12.05, -12.05, -11.81, -11.80, -11.93, -11.93, -11.93, -11.93, -11.80, -11.80,
        -11.93, -11.93, -11.93, -11.93, -12.05, -12.18, -12.18, -12.05, -12.30, -12.30,
        -12.29, -12.18, -12.30, -12.43, -12.43, -12.43, -12.55, -12.43, -12.30, -12.31,
        -12.43, -12.30, -12.30, -12.30, -12.30, -12.31, -12.43, -12.30, -12.43, -12.30,
        -12.30, -12.31, -12.30, -12.55, -12.55, -12.55, -12.43, -12.54, -12.43, -12.43,
        -12.44, -12.43, -12.43, -12.55, -12.55, -12.54, -12.43, -12.55, -12.55, -12.55,
        -12.43, -12.43, -12.43, -12.43, -12.55, -12.55, -12.67, -12.68, -12.68, -12.81,
        -12.68, -12.68, -12.69, -12.68, -12.68, -12.68, -12.67, -12.55, -12.55, -12.55,
        -12.55, -12.55, -12.67, -12.67, -12.55, -12.55, -12.55, -12.30, -12.43, -12.55,
        -12.55, -12.80, -12.80, -12.68, -12.69, -12.81, -12.81, -12.81, -12.81, -12.81,
        -12.92, -12.81, -12.81, -12.81, -12.81, -12.81, -12.81, -12.81, -12.81, -12.93,
        -12.93, -12.93, -12.93, -13.05, -13.05, -13.05, -13.18, -13.18, -13.18, -13.18,
        -13.18, -13.18, -13.06, -13.07, -13.07, -13.06, -13.18, -13.18, -13.18, -13.19,
        -13.31, -13.31, -13.31, -13.18, -13.31, -13.31, -13.31, -13.06, -13.18, -13.31,
        -13.31, -13.31, -13.31, -13.31, -13.31, -13.31, -13.18, -13.31, -13.18, -13.06,
        -13.31, -13.06, -13.18, -13.31, -13.06, -13.18, -13.31, -13.06, -13.18, -13.06,
        -13.18, -13.31, -13.06, -13.18, -13.18, -13.18, -13.31, -13.18, -13.31, -13.31,
        -13.55, -13.43, -13.31, -13.43, -13.31, -13.31, -13.31, -13.30, -13.31, -13.18,
        -13.31, -13.31, -13.18, -13.32, -13.31, -13.43, -13.56, -13.31, -13.31, -13.43,
        -13.31, -13.31, -13.31, -13.31, -13.43, -13.43, -13.43, -13.56, -13.56, -13.56,
        -13.56, -13.56, -13.43, -13.43, -13.43, -13.31, -13.31, -13.18, -13.31, -13.31,
        -13.43, -13.43, -13.43, -13.56, -13.56, -13.32, -13.43, -13.31, -13.31, -13.18,
        -13.43, -13.31, -13.43, -13.31, -13.56, -13.43, -13.56, -13.31, -13.56, -13.56,
        -13.56, -13.56, -13.68, -13.56, -13.56, -13.56, -13.56, -13.31, -13.43, -13.43,
        -13.31, -13.43, -13.31, -13.43, -13.43, -13.56, -13.43, -13.56, -13.56, -13.56,
        -13.56, -13.43, -13.56, -13.56, -13.56, -13.56, -13.56, -13.56, -13.56, -13.43,
        -13.56, -13.43, -13.56, -13.43, -13.43, -13.56, -13.31, -13.31, -13.31, -13.43,
        -13.43, -13.43, -13.56, -13.56, -13.43, -13.44, -13.43, -13.43, -13.56, -13.43,
        -13.43, -13.56, -13.43, -13.56, -13.43, -13.31, -13.43, -13.56, -13.43, -13.31,
        -13.43, -13.56, -13.43, -13.43, -13.56, -13.56, -13.56, -13.56, -13.56, -13.56,
        -13.43, -13.43, -13.31, -13.43, -13.43, -13.43, -13.56, -13.56, -13.56, -13.56,
        -13.56, -13.68, -13.68, -13.68, -13.68, -13.68, -13.68, -13.56, -13.56, -13.56,
        -13.56, -13.68, -13.68, -13.57, -13.56, -13.68, -13.81, -13.68, -13.56, -13.56,
        -13.43, -13.56, -13.56, -13.43, -13.43, -13.56, -13.56, -13.56, -13.68, -13.56,
        -13.56, -13.68, -13.68, -13.68, -13.56, -13.68, -13.81, -13.56, -13.56, -13.67,
        -13.56, -13.56, -13.56, -13.56, -13.56, -13.56, -13.43, -13.56, -13.56, -13.43,
        -13.56, -13.31, -13.56, -13.56, -13.56, -13.68, -13.69, -13.81, -13.81, -13.68,
        -13.68, -13.81, -13.68, -13.68, -13.56, -13.56, -13.43, -13.56, -13.56, -13.68,
        -13.56, -13.56, -13.68, -13.68, -13.68, -13.81, -13.68, -13.56, -13.56, -13.56,
        -13.56, -13.56, -13.56, -13.31, -13.31, -13.56, -13.56, -13.31, -13.43, -13.56,
        -13.43, -13.31, -13.43, -13.56, -13.56, -13.56, -13.56, -13.31, -13.43, -13.56,
        -13.56, -13.56, -13.31, -13.32, -13.43, -13.43, -13.42, -13.31, -13.31, -13.06,
        -13.18, -13.31, -13.31, -13.18, -13.06, -13.18, -13.06, -13.18, -13.06, -13.18,
        -13.31, -13.43, -13.31, -13.31, -13.43, -13.56, -13.43, -13.31, -13.43, -13.31,
        -13.31, -13.18, -13.06, -12.93, -13.06, -13.06, -12.93, -12.93, -13.06, -12.81,
        -13.06, -12.81, -12.93, -12.93, -12.93, -12.81, -12.81, -12.81, -12.68, -12.68,
        -12.81, -12.68, -12.55, -12.81, -12.81, -12.68, -12.81, -12.81, -12.81, -12.56,
        -12.68, -12.68, -12.55, -12.55, -12.43, -12.43, -12.43, -12.30, -12.30, -12.43,
        -12.43, -12.30, -12.43, -12.43, -12.18, -12.30, -12.30, -12.18, -12.18, -12.30,
        -12.30, -12.05, -12.18, -11.93, -12.05, -11.93, -11.80, -11.93, -11.80, -11.80,
        -11.93, -11.80, -11.93, -11.68, -11.80, -11.80, -11.55, -11.55, -11.42, -11.42,
        -11.42, -11.30, -11.30, -11.42, -11.30, -11.42, -11.30, -11.30, -11.17, -11.05,
        -11.05, -11.05, -11.05
    };

    static const float iso226_2023_curve_80_phons[985] =
    {
        -1.45, -1.48,
        -1.42, -1.42, -1.48, -1.45, -1.48, -1.48, -1.48, -1.48, -1.45, -1.51,
        -1.48, -1.45, -1.48, -1.51, -1.45, -1.48, -1.48, -1.45, -1.45, -1.45,
        -1.48, -1.45, -1.45, -1.45, -1.45, -1.45, -1.48, -1.45, -1.50, -1.51,
        -1.54, -1.48, -1.51, -1.54, -1.56, -1.56, -1.54, -1.56, -1.56, -1.54,
        -1.56, -1.54, -1.54, -1.56, -1.54, -1.54, -1.54, -1.56, -1.51, -1.56,
        -1.56, -1.56, -1.59, -1.56, -1.56, -1.56, -1.59, -1.56, -1.56, -1.56,
        -1.59, -1.56, -1.56, -1.59, -1.59, -1.56, -1.56, -1.62, -1.62, -1.56,
        -1.62, -1.62, -1.62, -1.62, -1.62, -1.62, -1.63, -1.62, -1.65, -1.65,
        -1.65, -1.62, -1.65, -1.65, -1.62, -1.65, -1.62, -1.62, -1.65, -1.59,
        -1.62, -1.62, -1.65, -1.59, -1.62, -1.65, -1.62, -1.65, -1.65, -1.65,
        -1.65, -1.65, -1.68, -1.65, -1.68, -1.68, -1.71, -1.71, -1.68, -1.74,
        -1.71, -1.71, -1.71, -1.74, -1.74, -1.74, -1.77, -1.71, -1.71, -1.74,
        -1.71, -1.71, -1.68, -1.71, -1.76, -1.77, -1.77, -1.77, -1.80, -1.77,
        -1.80, -1.80, -1.83, -1.80, -1.80, -1.80, -1.80, -1.80, -1.80, -1.83,
        -1.80, -1.83, -1.80, -1.80, -1.83, -1.85, -1.83, -1.85, -1.88, -1.85,
        -1.83, -1.83, -1.85, -1.80, -1.80, -1.85, -1.83, -1.85, -1.83, -1.85,
        -1.85, -1.85, -1.85, -1.85, -1.85, -1.85, -1.83, -1.88, -1.85, -1.88,
        -1.91, -1.88, -1.94, -1.88, -1.91, -1.91, -1.88, -1.85, -1.91, -1.85,
        -1.88, -1.85, -1.88, -1.85, -1.91, -1.88, -1.85, -1.88, -1.85, -1.88,
        -1.88, -1.94, -1.91, -1.91, -1.91, -1.94, -1.94, -1.97, -1.97, -1.97,
        -1.97, -1.97, -1.97, -2.00, -2.00, -2.00, -2.00, -1.97, -1.97, -2.00,
        -1.97, -1.94, -1.97, -1.94, -1.97, -1.97, -2.03, -1.97, -2.03, -2.06,
        -2.03, -2.09, -2.06, -2.06, -2.03, -2.06, -2.08, -2.03, -2.06, -2.03,
        -2.03, -2.03, -2.03, -2.06, -2.03, -2.06, -2.11, -2.09, -2.09, -2.11,
        -2.09, -2.11, -2.09, -2.09, -2.11, -2.09, -2.14, -2.09, -2.11, -2.14,
        -2.11, -2.14, -2.17, -2.17, -2.17, -2.15, -2.14, -2.11, -2.14, -2.14,
        -2.11, -2.14, -2.14, -2.14, -2.17, -2.17, -2.20, -2.23, -2.20, -2.26,
        -2.20, -2.20, -2.23, -2.20, -2.20, -2.20, -2.20, -2.17, -2.20, -2.20,
        -2.20, -2.20, -2.17, -2.20, -2.20, -2.23, -2.23, -2.23, -2.26, -2.20,
        -2.20, -2.26, -2.20, -2.26, -2.23, -2.26, -2.29, -2.26, -2.29, -2.29,
        -2.26, -2.26, -2.26, -2.26, -2.29, -2.26, -2.26, -2.32, -2.29, -2.32,
        -2.32, -2.35, -2.32, -2.35, -2.38, -2.35, -2.38, -2.38, -2.35, -2.35,
        -2.38, -2.35, -2.35, -2.38, -2.35, -2.35, -2.38, -2.38, -2.32, -2.38,
        -2.38, -2.32, -2.38, -2.38, -2.35, -2.38, -2.38, -2.40, -2.38, -2.38,
        -2.37, -2.38, -2.38, -2.38, -2.43, -2.38, -2.40, -2.43, -2.38, -2.41,
        -2.43, -2.46, -2.43, -2.49, -2.46, -2.46, -2.46, -2.46, -2.49, -2.46,
        -2.46, -2.46, -2.49, -2.46, -2.46, -2.46, -2.46, -2.43, -2.43, -2.43,
        -2.46, -2.46, -2.46, -2.49, -2.49, -2.55, -2.49, -2.49, -2.46, -2.52,
        -2.49, -2.49, -2.49, -2.55, -2.55, -2.49, -2.55, -2.55, -2.55, -2.58,
        -2.55, -2.55, -2.55, -2.58, -2.55, -2.55, -2.55, -2.61, -2.58, -2.61,
        -2.64, -2.64, -2.67, -2.64, -2.64, -2.64, -2.67, -2.67, -2.64, -2.67,
        -2.64, -2.67, -2.67, -2.67, -2.64, -2.67, -2.67, -2.67, -2.67, -2.67,
        -2.67, -2.72, -2.72, -2.67, -2.67, -2.67, -2.69, -2.70, -2.72, -2.72,
        -2.69, -2.69, -2.69, -2.72, -2.72, -2.69, -2.72, -2.72, -2.72, -2.69,
        -2.72, -2.72, -2.72, -2.72, -2.72, -2.72, -2.72, -2.69, -2.69, -2.67,
        -2.67, -2.72, -2.69, -2.72, -2.75, -2.75, -2.75, -2.73, -2.75, -2.75,
        -2.78, -2.78, -2.72, -2.72, -2.75, -2.75, -2.75, -2.75, -2.72, -2.72,
        -2.75, -2.75, -2.75, -2.75, -2.78, -2.81, -2.81, -2.78, -2.84, -2.84,
        -2.84, -2.81, -2.84, -2.87, -2.87, -2.87, -2.90, -2.87, -2.84, -2.84,
        -2.87, -2.84, -2.84, -2.84, -2.84, -2.84, -2.87, -2.84, -2.87, -2.84,
        -2.84, -2.84, -2.84, -2.90, -2.90, -2.90, -2.87, -2.89, -2.87, -2.87,
        -2.87, -2.87, -2.87, -2.90, -2.90, -2.89, -2.87, -2.90, -2.90, -2.90,
        -2.87, -2.87, -2.87, -2.87, -2.90, -2.90, -2.92, -2.93, -2.93, -2.96,
        -2.93, -2.93, -2.93, -2.93, -2.93, -2.93, -2.92, -2.90, -2.90, -2.90,
        -2.90, -2.90, -2.92, -2.92, -2.90, -2.90, -2.90, -2.84, -2.87, -2.90,
        -2.90, -2.95, -2.95, -2.93, -2.93, -2.96, -2.96, -2.96, -2.96, -2.96,
        -2.98, -2.96, -2.96, -2.96, -2.96, -2.96, -2.96, -2.96, -2.96, -2.98,
        -2.98, -2.98, -2.98, -3.01, -3.01, -3.01, -3.04, -3.04, -3.04, -3.04,
        -3.04, -3.04, -3.01, -3.02, -3.02, -3.01, -3.04, -3.04, -3.04, -3.04,
        -3.07, -3.07, -3.07, -3.04, -3.07, -3.07, -3.07, -3.01, -3.04, -3.07,
        -3.07, -3.07, -3.07, -3.07, -3.07, -3.07, -3.04, -3.07, -3.04, -3.01,
        -3.07, -3.01, -3.04, -3.07, -3.01, -3.04, -3.07, -3.01, -3.04, -3.01,
        -3.04, -3.07, -3.01, -3.04, -3.04, -3.04, -3.07, -3.04, -3.07, -3.07,
        -3.13, -3.10, -3.07, -3.10, -3.07, -3.07, -3.07, -3.07, -3.07, -3.04,
        -3.07, -3.07, -3.04, -3.07, -3.07, -3.10, -3.13, -3.07, -3.07, -3.10,
        -3.07, -3.07, -3.07, -3.07, -3.10, -3.10, -3.10, -3.13, -3.13, -3.13,
        -3.13, -3.13, -3.10, -3.10, -3.10, -3.07, -3.07, -3.04, -3.07, -3.07,
        -3.10, -3.10, -3.10, -3.13, -3.13, -3.07, -3.10, -3.07, -3.07, -3.04,
        -3.10, -3.07, -3.10, -3.07, -3.13, -3.10, -3.13, -3.07, -3.13, -3.13,
        -3.13, -3.13, -3.16, -3.13, -3.13, -3.13, -3.13, -3.07, -3.10, -3.10,
        -3.07, -3.10, -3.07, -3.10, -3.10, -3.13, -3.10, -3.13, -3.13, -3.13,
        -3.13, -3.10, -3.13, -3.13, -3.13, -3.13, -3.13, -3.13, -3.13, -3.10,
        -3.13, -3.10, -3.13, -3.10, -3.10, -3.13, -3.07, -3.07, -3.07, -3.10,
        -3.10, -3.10, -3.13, -3.13, -3.10, -3.10, -3.10, -3.10, -3.13, -3.10,
        -3.10, -3.13, -3.10, -3.13, -3.10, -3.07, -3.10, -3.13, -3.10, -3.07,
        -3.10, -3.13, -3.10, -3.10, -3.13, -3.13, -3.13, -3.13, -3.13, -3.13,
        -3.10, -3.10, -3.07, -3.10, -3.10, -3.10, -3.13, -3.13, -3.13, -3.13,
        -3.13, -3.16, -3.16, -3.16, -3.16, -3.16, -3.16, -3.13, -3.13, -3.13,
        -3.13, -3.16, -3.16, -3.13, -3.13, -3.16, -3.19, -3.16, -3.13, -3.13,
        -3.10, -3.13, -3.13, -3.10, -3.10, -3.13, -3.13, -3.13, -3.16, -3.13,
        -3.13, -3.16, -3.16, -3.16, -3.13, -3.16, -3.19, -3.13, -3.13, -3.16,
        -3.13, -3.13, -3.13, -3.13, -3.13, -3.13, -3.10, -3.13, -3.13, -3.10,
        -3.13, -3.07, -3.13, -3.13, -3.13, -3.16, -3.16, -3.19, -3.19, -3.16,
        -3.16, -3.19, -3.16, -3.16, -3.13, -3.13, -3.10, -3.13, -3.13, -3.16,
        -3.13, -3.13, -3.16, -3.16, -3.16, -3.19, -3.16, -3.13, -3.13, -3.13,
        -3.13, -3.13, -3.13, -3.07, -3.07, -3.13, -3.13, -3.07, -3.10, -3.13,
        -3.10, -3.07, -3.10, -3.13, -3.13, -3.13, -3.13, -3.07, -3.10, -3.13,
        -3.13, -3.13, -3.07, -3.07, -3.10, -3.10, -3.10, -3.07, -3.07, -3.01,
        -3.04, -3.07, -3.07, -3.04, -3.01, -3.04, -3.01, -3.04, -3.01, -3.04,
        -3.07, -3.10, -3.07, -3.07, -3.10, -3.13, -3.10, -3.07, -3.10, -3.07,
        -3.07, -3.04, -3.01, -2.98, -3.01, -3.01, -2.98, -2.98, -3.01, -2.96,
        -3.01, -2.96, -2.98, -2.98, -2.98, -2.96, -2.96, -2.96, -2.93, -2.93,
        -2.96, -2.93, -2.90, -2.96, -2.96, -2.93, -2.96, -2.96, -2.96, -2.90,
        -2.93, -2.93, -2.90, -2.90, -2.87, -2.87, -2.87, -2.84, -2.84, -2.87,
        -2.87, -2.84, -2.87, -2.87, -2.81, -2.84, -2.84, -2.81, -2.81, -2.84,
        -2.84, -2.78, -2.81, -2.75, -2.78, -2.75, -2.72, -2.75, -2.72, -2.72,
        -2.75, -2.72, -2.75, -2.69, -2.72, -2.72, -2.67, -2.67, -2.64, -2.64,
        -2.64, -2.61, -2.61, -2.64, -2.61, -2.64, -2.61, -2.61, -2.58, -2.55,
        -2.55, -2.55, -2.55
    };

    static const float iso226_2023_curve_90_phons[985] =
    {
        3.38, 3.45,
        3.31, 3.31, 3.45, 3.38, 3.45, 3.45, 3.45, 3.45, 3.38, 3.52,
        3.45, 3.38, 3.45, 3.52, 3.38, 3.45, 3.45, 3.38, 3.38, 3.38,
        3.45, 3.38, 3.38, 3.38, 3.38, 3.38, 3.45, 3.38, 3.51, 3.52,
        3.58, 3.45, 3.52, 3.58, 3.65, 3.65, 3.58, 3.65, 3.65, 3.58,
        3.65, 3.58, 3.58, 3.65, 3.58, 3.58, 3.58, 3.65, 3.52, 3.65,
        3.65, 3.65, 3.72, 3.65, 3.65, 3.65, 3.72, 3.65, 3.65, 3.65,
        3.72, 3.65, 3.65, 3.72, 3.72, 3.65, 3.65, 3.79, 3.79, 3.65,
        3.78, 3.79, 3.79, 3.78, 3.79, 3.79, 3.79, 3.79, 3.85, 3.85,
        3.85, 3.79, 3.85, 3.85, 3.79, 3.85, 3.79, 3.79, 3.85, 3.72,
        3.79, 3.79, 3.85, 3.72, 3.79, 3.85, 3.79, 3.85, 3.85, 3.85,
        3.85, 3.85, 3.92, 3.85, 3.92, 3.92, 3.99, 3.99, 3.92, 4.06,
        3.99, 3.99, 3.99, 4.06, 4.06, 4.06, 4.12, 3.99, 3.99, 4.06,
        3.99, 3.99, 3.92, 3.99, 4.12, 4.12, 4.12, 4.12, 4.19, 4.12,
        4.19, 4.19, 4.26, 4.19, 4.19, 4.19, 4.19, 4.19, 4.19, 4.26,
        4.19, 4.26, 4.19, 4.19, 4.26, 4.33, 4.26, 4.33, 4.39, 4.33,
        4.26, 4.26, 4.33, 4.19, 4.19, 4.33, 4.26, 4.33, 4.26, 4.33,
        4.33, 4.33, 4.33, 4.33, 4.33, 4.33, 4.26, 4.39, 4.33, 4.39,
        4.46, 4.39, 4.53, 4.40, 4.46, 4.46, 4.39, 4.33, 4.46, 4.33,
        4.39, 4.33, 4.39, 4.33, 4.46, 4.39, 4.33, 4.39, 4.33, 4.39,
        4.39, 4.53, 4.46, 4.46, 4.46, 4.53, 4.53, 4.60, 4.60, 4.60,
        4.60, 4.60, 4.60, 4.66, 4.66, 4.66, 4.66, 4.60, 4.60, 4.66,
        4.60, 4.53, 4.60, 4.53, 4.60, 4.60, 4.73, 4.60, 4.73, 4.80,
        4.73, 4.87, 4.80, 4.80, 4.73, 4.80, 4.86, 4.73, 4.80, 4.73,
        4.73, 4.73, 4.73, 4.80, 4.73, 4.80, 4.93, 4.87, 4.87, 4.93,
        4.87, 4.93, 4.87, 4.87, 4.93, 4.87, 5.00, 4.87, 4.93, 5.00,
        4.93, 5.00, 5.07, 5.07, 5.07, 5.01, 5.00, 4.93, 5.00, 5.00,
        4.93, 5.00, 5.00, 5.00, 5.07, 5.07, 5.14, 5.21, 5.14, 5.27,
        5.14, 5.14, 5.21, 5.14, 5.14, 5.14, 5.14, 5.07, 5.14, 5.13,
        5.14, 5.14, 5.07, 5.14, 5.14, 5.21, 5.21, 5.21, 5.27, 5.14,
        5.14, 5.27, 5.14, 5.27, 5.21, 5.27, 5.34, 5.27, 5.34, 5.34,
        5.27, 5.27, 5.27, 5.27, 5.34, 5.28, 5.27, 5.41, 5.34, 5.41,
        5.41, 5.48, 5.41, 5.48, 5.54, 5.48, 5.54, 5.54, 5.48, 5.48,
        5.54, 5.48, 5.48, 5.54, 5.48, 5.48, 5.54, 5.54, 5.41, 5.54,
        5.54, 5.41, 5.54, 5.54, 5.48, 5.54, 5.54, 5.61, 5.54, 5.54,
        5.54, 5.54, 5.54, 5.54, 5.67, 5.54, 5.61, 5.68, 5.54, 5.61,
        5.68, 5.75, 5.68, 5.81, 5.75, 5.74, 5.75, 5.75, 5.81, 5.74,
        5.75, 5.75, 5.81, 5.75, 5.75, 5.75, 5.75, 5.68, 5.68, 5.68,
        5.74, 5.75, 5.75, 5.81, 5.81, 5.94, 5.81, 5.81, 5.75, 5.88,
        5.81, 5.81, 5.81, 5.95, 5.95, 5.81, 5.95, 5.95, 5.95, 6.02,
        5.95, 5.95, 5.95, 6.02, 5.95, 5.95, 5.95, 6.08, 6.02, 6.09,
        6.15, 6.15, 6.22, 6.15, 6.15, 6.15, 6.22, 6.22, 6.15, 6.22,
        6.15, 6.22, 6.22, 6.22, 6.15, 6.22, 6.22, 6.22, 6.22, 6.22,
        6.22, 6.35, 6.35, 6.22, 6.22, 6.22, 6.29, 6.29, 6.35, 6.35,
        6.29, 6.29, 6.29, 6.35, 6.35, 6.29, 6.35, 6.35, 6.35, 6.29,
        6.35, 6.35, 6.35, 6.35, 6.35, 6.35, 6.35, 6.29, 6.29, 6.22,
        6.22, 6.35, 6.29, 6.35, 6.42, 6.42, 6.42, 6.36, 6.43, 6.42,
        6.49, 6.49, 6.36, 6.36, 6.42, 6.42, 6.42, 6.42, 6.35, 6.35,
        6.42, 6.42, 6.42, 6.42, 6.49, 6.56, 6.56, 6.49, 6.62, 6.62,
        6.62, 6.56, 6.62, 6.69, 6.69, 6.69, 6.76, 6.69, 6.62, 6.63,
        6.69, 6.62, 6.62, 6.62, 6.62, 6.63, 6.69, 6.62, 6.69, 6.62,
        6.62, 6.63, 6.62, 6.76, 6.76, 6.76, 6.69, 6.75, 6.69, 6.70,
        6.70, 6.69, 6.69, 6.76, 6.76, 6.75, 6.70, 6.76, 6.76, 6.76,
        6.69, 6.69, 6.69, 6.69, 6.76, 6.76, 6.82, 6.83, 6.83, 6.90,
        6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.82, 6.76, 6.76, 6.76,
        6.76, 6.76, 6.82, 6.82, 6.76, 6.76, 6.76, 6.62, 6.69, 6.76,
        6.76, 6.89, 6.89, 6.83, 6.83, 6.90, 6.90, 6.90, 6.90, 6.90,
        6.96, 6.90, 6.90, 6.90, 6.90, 6.90, 6.90, 6.90, 6.90, 6.96,
        6.96, 6.96, 6.96, 7.03, 7.03, 7.03, 7.10, 7.10, 7.10, 7.10,
        7.10, 7.10, 7.03, 7.04, 7.04, 7.03, 7.10, 7.10, 7.10, 7.10,
        7.17, 7.17, 7.17, 7.10, 7.17, 7.17, 7.17, 7.03, 7.10, 7.17,
        7.17, 7.17, 7.17, 7.17, 7.17, 7.17, 7.10, 7.17, 7.10, 7.03,
        7.17, 7.03, 7.10, 7.17, 7.03, 7.10, 7.17, 7.03, 7.10, 7.03,
        7.10, 7.17, 7.03, 7.10, 7.10, 7.10, 7.17, 7.10, 7.17, 7.17,
        7.30, 7.23, 7.17, 7.23, 7.17, 7.17, 7.17, 7.16, 7.17, 7.10,
        7.17, 7.17, 7.10, 7.17, 7.17, 7.23, 7.30, 7.17, 7.17, 7.23,
        7.17, 7.17, 7.17, 7.17, 7.23, 7.23, 7.23, 7.30, 7.30, 7.30,
        7.30, 7.30, 7.23, 7.23, 7.23, 7.17, 7.17, 7.10, 7.17, 7.17,
        7.23, 7.23, 7.23, 7.30, 7.30, 7.17, 7.23, 7.17, 7.17, 7.10,
        7.23, 7.17, 7.23, 7.17, 7.30, 7.23, 7.30, 7.17, 7.30, 7.30,
        7.30, 7.30, 7.37, 7.30, 7.30, 7.30, 7.30, 7.17, 7.23, 7.23,
        7.17, 7.23, 7.17, 7.23, 7.23, 7.30, 7.23, 7.30, 7.30, 7.30,
        7.30, 7.23, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.23,
        7.30, 7.23, 7.30, 7.23, 7.23, 7.30, 7.17, 7.17, 7.17, 7.23,
        7.23, 7.23, 7.30, 7.30, 7.23, 7.24, 7.23, 7.23, 7.30, 7.23,
        7.23, 7.30, 7.23, 7.30, 7.23, 7.17, 7.23, 7.30, 7.23, 7.17,
        7.23, 7.30, 7.23, 7.23, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30,
        7.23, 7.23, 7.17, 7.23, 7.23, 7.23, 7.30, 7.30, 7.30, 7.30,
        7.30, 7.37, 7.37, 7.37, 7.37, 7.37, 7.37, 7.30, 7.30, 7.30,
        7.30, 7.37, 7.37, 7.30, 7.30, 7.37, 7.44, 7.37, 7.30, 7.30,
        7.23, 7.30, 7.30, 7.23, 7.23, 7.30, 7.30, 7.30, 7.37, 7.30,
        7.30, 7.37, 7.37, 7.37, 7.30, 7.37, 7.44, 7.30, 7.30, 7.36,
        7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.23, 7.30, 7.30, 7.23,
        7.30, 7.17, 7.30, 7.30, 7.30, 7.37, 7.37, 7.44, 7.44, 7.37,
        7.37, 7.44, 7.37, 7.37, 7.30, 7.30, 7.23, 7.30, 7.30, 7.37,
        7.30, 7.30, 7.37, 7.37, 7.37, 7.44, 7.37, 7.30, 7.30, 7.30,
        7.30, 7.30, 7.30, 7.17, 7.17, 7.30, 7.30, 7.17, 7.23, 7.30,
        7.23, 7.17, 7.23, 7.30, 7.30, 7.30, 7.30, 7.17, 7.23, 7.30,
        7.30, 7.30, 7.17, 7.17, 7.23, 7.23, 7.23, 7.17, 7.17, 7.03,
        7.10, 7.17, 7.17, 7.10, 7.03, 7.10, 7.03, 7.10, 7.03, 7.10,
        7.17, 7.23, 7.17, 7.17, 7.23, 7.30, 7.23, 7.17, 7.23, 7.17,
        7.17, 7.10, 7.03, 6.96, 7.03, 7.03, 6.96, 6.96, 7.03, 6.90,
        7.03, 6.90, 6.96, 6.96, 6.96, 6.90, 6.90, 6.90, 6.83, 6.83,
        6.90, 6.83, 6.76, 6.90, 6.90, 6.83, 6.90, 6.90, 6.90, 6.77,
        6.83, 6.83, 6.76, 6.76, 6.69, 6.69, 6.69, 6.62, 6.62, 6.69,
        6.69, 6.62, 6.69, 6.69, 6.56, 6.62, 6.62, 6.56, 6.56, 6.62,
        6.62, 6.49, 6.56, 6.42, 6.49, 6.42, 6.35, 6.42, 6.35, 6.35,
        6.42, 6.35, 6.42, 6.29, 6.35, 6.35, 6.22, 6.22, 6.15, 6.15,
        6.15, 6.08, 6.08, 6.15, 6.08, 6.15, 6.08, 6.08, 6.02, 5.95,
        5.95, 5.95, 5.95
    };

    static const float * const iso226_2023_curves[] =
    {
        iso226_2023_curve_0_phons,
        iso226_2023_curve_10_phons,
        iso226_2023_curve_20_phons,
        iso226_2023_curve_30_phons,
        iso226_2023_curve_40_phons,
        iso226_2023_curve_50_phons,
        iso226_2023_curve_60_phons,
        iso226_2023_curve_70_phons,
        iso226_2023_curve_80_phons,
        iso226_2023_curve_90_phons
    };

    static const freq_curve_t iso226_2023_curve =
    {
        22.33, // fmin
        12989.79, // fmax
        0.00, // amin
        90.00, // amax
        985, // hdots
        10, // curves
        iso226_2023_curves // curve data
    };

} /* namespace lsp */

#endif /* GENERATED_ISO226_ISO226_2023_H_ */

