/*******************************************************************************
* Copyright 2023-2024 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include <cstdint>
#include <vector>

namespace dnnl {
namespace impl {
namespace gpu {
namespace intel {
namespace jit {

// clang-format off
static const uint64_t _data[] = {
        0x000000133e4ccccd, 0x0000000100000000, 0x3f80000000000000, 0x0000000000000044, 0x3d2000003ce00000, 0x3d6000003d400000, 0x3d8c00003d7c0000, 0x3da800003da00000,
        0x3dd200003dc00000, 0x3df000003de00000, 0x3e0000003dfc0000, 0x3e1000003e0c0000, 0x3e2000003e1c0000, 0x3e3400003e280000, 0x3e4800003e400000, 0x3e6000003e520000,
        0x3e7c00003e700000, 0x3e8700003e800000, 0x3e9000003e8c0000, 0x3ea000003e960000, 0x3eb000003ea80000, 0x3ec000003eb40000, 0x3ed000003ec60000, 0x3ed800003ed20000,
        0x3ee400003ee00000, 0x3efc00003ef00000, 0x3f0400003f000000, 0x3f0c00003f070000, 0x3f1300003f100000, 0x3f2000003f180000, 0x3f2800003f264000, 0x3f3400003f2e0000,
        0x3f4000003f3b8000, 0x3f5000003f480000, 0x3f5800003f52f000, 0x3f6000003f5ec000, 0x3f7000003f640000, 0x3f8000003f7c0000, 0x0000000000000002, 0x3f80000000000000,
        0x000000000000000e, 0x3ea000003e600000, 0x3ee000003ec00000, 0x3f0f00003f000000, 0x3f2800003f1c0000, 0x3f5200003f400000, 0x3f7000003f600000, 0x3f8000003f7c0000,
        0x00000000000000bf, 0x49870000497c0000, 0x49900000498dc000, 0x49a20000499c0000, 0x49ac440049a56000, 0x49bd000049b40000, 0x49ceb80049c4e000, 0x49dc800049dac000,
        0x49f3000049e5b000, 0x4a03400049fc0000, 0x4a0dc0004a070000, 0x4a1900004a100000, 0x4a2200004a1d8000, 0x4a2b80004a256000, 0x4a3400004a2f0000, 0x4a44e0004a3d0000,
        0x4a5ac0004a520000, 0x4a65b0004a5c8000, 0x4a7810004a700000, 0x4a82b6004a7c0000, 0x4a89d0004a856b00, 0x4a9000004a8dc000, 0x4a9920004a930000, 0x4a9e34004a9c0000,
        0x4aa560004aa20000, 0x4aab48004aa8c000, 0x4ab220004aaf0000, 0x4abd00004ab64000, 0x4ac8d0004ac06000, 0x4ad200004aca8000, 0x4ad800004ad4a000, 0x4ae118004adc8000,
        0x4aed4e004ae86000, 0x4af810004af30000, 0x4b0040004afc0000, 0x4b0700004b03a000, 0x4b0dc0004b09d000, 0x4b12f4004b100000, 0x4b15a0004b13a800, 0x4b18ee004b16c000,
        0x4b1e34004b1c4000, 0x4b2560004b220000, 0x4b2f80004b29ec00, 0x4b3d00004b37c000, 0x4b4864004b400000, 0x4b52f0004b4daa00, 0x4b6100004b580000, 0x4b73a2004b6c4000,
        0x4b7c00004b7a0000, 0x4b83a0004b804000, 0x4b8dc0004b870000, 0x4b9480004b900000, 0x4b9e34004b992000, 0x4ba54b004ba20000, 0x4bac44004ba71000, 0x4bb9ab404bb40000,
        0x4bc8fa004bbe2000, 0x4bd800004bd2f000, 0x4be5b0004bdc8000, 0x4bf810004bf4e600, 0x4c00e8004bfd2000, 0x4c0dc0004c091c00, 0x4c1480004c100000, 0x4c2800004c220000,
        0x4c3304004c2f0000, 0x4c3dd8004c391900, 0x4c4e40004c4766e0, 0x4c5c80004c580000, 0x4c76cc004c65b000, 0x4c8f70004c83a000, 0x4c97e0004c900000, 0x4caf80004ca56000,
        0x4cc0be804cb94d80, 0x4ce07d804cd80000, 0x4cf40b004ce5b000, 0x4d02a0a04d006010, 0x4d0ca0004d0721c0, 0x4d1600004d100000, 0x4d28c0004d241000, 0x4d2ea8004d2cc200,
        0x4d4210004d340000, 0x4d52f0004d48fa00, 0x4d6658004d5f2000, 0x4d7f00004d730000, 0x4d8f8e004d891c00, 0x4daed0804da20000, 0x4dbe50004db64000, 0x4ddf20004dcb4a80,
        0x4e0196004df30000, 0x4e1924004e0c0000, 0x4e2e06004e28c000, 0x4e48fa004e2f0000, 0x4e7300004e5c8000, 0x4eb5e0004e900000, 0x4ef300004ed5c000, 0x4f4000004f192400,
        0x000000a04f859800, 0x4210000000000000, 0x4290000042600000, 0x42e0000042a80000, 0x430f000043000000, 0x4320000043100000, 0x4340000043280000, 0x43580000434f0000,
        0x4370000043600000, 0x43800000437c0000, 0x43900000438c0000, 0x43a00000439c0000, 0x43b4000043a80000, 0x43cc000043c00000, 0x43d2000043cf0000, 0x43e0000043d80000,
        0x43f0000043ee0000, 0x4400000043fc0000, 0x440a000044050000, 0x44100000440c0000, 0x4420000044160000, 0x442f000044280000, 0x443d000044340000, 0x4446000044400000,
        0x44520000444cc000, 0x4460000044580000, 0x4470000044640000, 0x44800000447c0000, 0x4487600044840000, 0x44900000448c0000, 0x4498000044930000, 0x44a5a00044a00000,
        0x44ac800044a80000, 0x44bb800044b40000, 0x44c6000044c00000, 0x44d2000044cf0000, 0x44e0000044d80000, 0x44f0000044e40000, 0x44fc000044fbc000, 0x4504000045000000,
        0x450c000045076000, 0x4513000045100000, 0x45200000451a0000, 0x4528000045250000, 0x45340000452d4000, 0x454000004539a000, 0x455000004546c000, 0x455b60004555c000,
        0x456a000045600000, 0x457c000045730000, 0x4584000045800000, 0x458ca0004587f000, 0x4593000045900000, 0x45a00000459c0000, 0x45b2200045a80000, 0x45bb800045b58000,
        0x45ca800045c00000, 0x45dc800045d2f000, 0x45f0000045e00000, 0x4600000045fc0000, 0x460ca00046070000, 0x4616000046100000, 0x4629000046200000, 0x463d000046340000,
        0x4652000046400000, 0x4671e00046600000, 0x46804000467d8000, 0x46900000468c0000, 0x46a80000469c3000, 0x46c0000046b58000, 0x46e0000046d5c000, 0x4707000046fc0000,
        0x4720000047100000, 0x4744000047358000, 0x47750000475c8000, 0x4793000047870000, 0x47c78c0047b40000, 0x4800a00047e10000, 0x483d000048151480, 0x488e800048600000,
        0x490ca00048c00000, 0x0000000d49900000, 0x3f80000000000000, 0x41c0000041400000, 0x4290000042400000, 0x4310000042c00000, 0x43a0000043400000, 0x4440000043d80000,
        0x4690000044d80000, 0x0000000000000004, 0x400000003f800000, 0x4100000040800000, 0x0000000000000001, 0x000000013f800000, 0x3f80000000000000, 0x0000000000000004,
        0x4180000041000000, 0x4280000042000000, 0x000000000000000c, 0x40c000003f800000, 0x4100000040e00000, 0x4120000041100000, 0x4140000041300000, 0x4160000041500000,
        0x4180000041700000, 0x0000000000000001, 0x000000083f800000, 0x3f80000000000000, 0x40a0000040400000, 0x4100000040c00000, 0x4140000041100000, 0x0000001d41800000,
        0x3f80000000000000, 0x4080000040400000, 0x40e0000040a00000, 0x4110000041000000, 0x4150000041300000, 0x4188000041800000, 0x41c0000041b80000, 0x41f8000041c80000,
        0x421c000042040000, 0x4240000042240000, 0x42800000424c0000, 0x4296000042860000, 0x42e6000042c00000, 0x4340000042f60000, 0x4540000043d80000, 0x0000000000000001,
        0x0000000100000000, 0x0000000000000000, 0x0000000000000003, 0x400000003f800000, 0x0000000340400000, 0x3f80000000000000, 0x4040000040000000, 0x000000323c4ddeae,
        0x0000001300000000, 0x000003e800000005, 0x0000023c00000001, 0x0120011100000000, 0x0050260400945804, 0x00220e010030000d, 0x470773ff001d0501, 0x0011bc40e63fffbc,
        0xffbc3e5571ff002b, 0x00421a04bc31e99c, 0x3ad17aff003d0a04, 0x0011bc322605ffbc, 0xffbc2e1950ff004b, 0x00740011bc221c60, 0x006115010066000d, 0x37c0ffbc40543eff,
        0xbcff006f0007bc32, 0xbc20501dffbc2d4c, 0x008112010086000d, 0xe816ffbc38668eff, 0xe2ff008f3a04bc1d, 0xbc022fa7ffbc1513, 0x00bc000700dc0011, 0x00a9010a00ae010d,
        0xc4bfffbc312ab5ff, 0x5bff00b77704bc2a, 0xbc1b0d01ffbc2320, 0x00c9000a00ce010d, 0xc313ffbc2560b0ff, 0xe8ff00d77304bc16, 0xbbf0d4ccffbc0a01, 0x00f2010d01000007,
        0x16185bff00ed060e, 0x9505bc00027dffbc, 0xffbbe3dc3fff00fb, 0x0112010dbc0c53c7, 0xfc9fd7ff010d060e, 0x030ebb90f136ffbb, 0xffbb83fdf4ff011b, 0x01b0000b38003c37,
        0x014c020e016c000a, 0x01390806013e0906, 0x9966ffbb79129cff, 0xe4ff0147000ebbc9, 0xbc04af86ffbc2fb7, 0x01590a06015e1205, 0x3951ffbbc41d16ff, 0x21ff0167a604bb42,
        0xb9379bd5ffbb3861, 0x0182000e0190010e, 0x1f6244ff017d010a, 0x050dbc0543a9ffbc, 0xffbbbe3ad0ff018b, 0x01a2a404bb1791a6, 0x3f1230ff019d1905, 0x120ebab8afb3ff3a,
        0xff3bd588d8ff01ab, 0x01f8010d3936abd8, 0x01ca000d01d83204, 0xd98114ff01c51701, 0x19043c1fa8b5ffb9, 0xff3c55292cff01d3, 0x01ea000d3cf1292e, 0x5a387cff01e5000a,
        0x75053cd95e96ff3c, 0xff3d518016ff01f3, 0x021c32043c90029d, 0x02091201020e1e04, 0x2ba3ff3c2f2ed3ff, 0xeaff0217010e3ccd, 0x3ce5f900ff3d278b, 0x02295c04022e8205,
        0xc69fff3d671790ff, 0x27ff023794053db9, 0x3cdc8281ff3d43d6, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094620401200112, 0x0030000d00502204,
        0x001d040100221201, 0x87bcffbc1fae6bff, 0x37ff002b0011bc1a, 0xbc0e6701ffbc1883, 0x003d070100420e01, 0x36bdffbc197b47ff, 0xa2ff004b0011bc12, 0xbc058adeffbc104e,
        0x006600110074000d, 0x1abcacff00611501, 0x1c01bc0e15cdffbc, 0xffbc0e8bbeff006f, 0x00860011bbf632d2, 0x068eadff0081020d, 0x4804bbf7f1e4ffbc, 0xffbbe92a8dff008f,
        0x00dc0011bbbef042, 0x00ae000700bc010d, 0x0f954eff00a9000a, 0x000abc096759ffbc, 0xffbc04237bff00b7, 0x00ce0007bbef2e62, 0x00b8a4ff00c97a04, 0x9405bbf7a154ffbc,
        0xffbbc41ae1ff00d7, 0x01008305bc007336, 0x00ed000d00f27f04, 0x9547ffbbd81bf9ff, 0xe2ff00fb000dbb9c, 0xbb0c51ceffbb95c4, 0x010d000a0112010d, 0x36a7ffbc02a2c1ff,
        0xbfff011b8f05bbd1, 0xbbcff278ffbb89f3, 0x016c380501b00007, 0x013e0205014c1905, 0x596720ff01390a06, 0x000a3ba7ebd8ff3a, 0xffbb8b39c8ff0147, 0x015e000bba0d454d,
        0x2240beff0159a604, 0x000d3b3a87ebffbb, 0xff3b9d6d10ff0167, 0x0190010d3c89be7b, 0x017d000d0182000a, 0x055dff3b3587fbff, 0x05ff018b000d3c41, 0x3ce9e3eaff3c7d8e,
        0x019d030e01a20006, 0xca9eff3d0e5107ff, 0x82ff01ab07063d8a, 0xbba4b527ff3a47b7, 0x01d8270401f8010d, 0x01c50a0101ca000d, 0xb9ceffbb4524daff, 0x1aff01d310043b61,
        0x3ca3ce71ff3bfa0c, 0x01e5000a01ea000d, 0xa4deff3c5778faff, 0x4fff01f378053cbc, 0x3c36746dff3d3145, 0x020e1901021c4a04, 0x7bd40aff02090c01, 0x37043c90ed01ff3b,
        0xff3d06c5f9ff0217, 0x022e97043d3dd85d, 0x988b04ff0229030e, 0x010e3dff94c0ff3d, 0xff3ca9d6cfff0237, 0x000000133d5ef037, 0x000003e800000005, 0x0000023c00000001,
        0x0120011200000000, 0x0050330400946304, 0x0022000d00301604, 0xff1ecbff001d0701, 0x0801bbf4bedcffbb, 0xffbbf5452cff002b, 0x0042030ebbe8357c, 0xdfc22bff003d0011,
        0x0011bbc9cb25ffbb, 0xffbbf16c0aff004b, 0x0074000dbbe27f98, 0x0061000700660011, 0x2141ffbbee8efbff, 0x80ff006f0007bbdc, 0xbbbfc3b9ffbbdacc, 0x0081510400864b05,
        0x3b26ffbbb0d1e7ff, 0x5aff008f0012bb8a, 0xbbbcb797ffbbd428, 0x00bc000700dc0011, 0x00a9000e00ae010d, 0xfb58ffbc04de97ff, 0x95ff00b79d05bbde, 0xbbe5976effbbc7e7,
        0x00c9000e00ce010d, 0xd851ffbc0bd3cfff, 0x41ff00d7ba04bbc5, 0xbbda4109ffbb9bd3, 0x00f2890401007905, 0xa56a34ff00ed000d, 0x000dbb5a0f7dffbb, 0xffbb413e09ff00fb,
        0x0112020dba4a18c7, 0xbf049fff010d060e, 0x8f05bb8e2f0affbb, 0xffbb450c6aff011b, 0x01b00007bba11f8b, 0x014c1905016c3805, 0x0139140e013e0005, 0x5b07ff3bfc2792ff,
        0xd4ff0147000a3ad7, 0xb8f1c4feffbb5ec2, 0x01591b05015e000b, 0x488cff3bb9582bff, 0xb4ff0167030ebaa7, 0x3b797401ff3c5bd7, 0x0182000a0190010d, 0x11398bff017d000d,
        0x000d3c1a6aaeff3b, 0xff3c4ad801ff018b, 0x01a2a8043cbb1cc7, 0xe1b335ff019d7d04, 0x45053d2a6570ff3c, 0xffb9e09dc1ff01ab, 0x01f8020d3c7525e7, 0x01ca030e01d82001,
        0x03edf9ff01c52104, 0x16013cc6abd8ff3c, 0xffba725f2bff01d3, 0x01ea000a3bd47ec5, 0x882202ff01e58105, 0x000d39a2748cff3c, 0xff3cacab9eff01f3, 0x021c030e3d24bc6a,
        0x02096104020e9804, 0x5c9eff3d08472cff, 0x44ff0217010e3d8d, 0x3d522479ff3c828a, 0x02298f04022e9604, 0xd685ff3dd22d9eff, 0x0bff0237010b3e04, 0x3da07f76ff3cae7a,
        0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x00945e0401200112, 0x0030120100501901, 0x001d09040022010e, 0xab9dffbbc2fb34ff, 0xadff002b0801bbb5,
        0xbbc325d4ffbbcbfe, 0x003d00110042020d, 0x01e3ffbbc2e450ff, 0xa5ff004b0011bbb3, 0xbb9e063dffbbb55d, 0x0066010d00740011, 0xbdde34ff0061000a, 0x0007bbb157f4ffbb,
        0xffbbb2e525ff006f, 0x0086010dbba0d67a, 0xa82690ff0081000a, 0x0007bb919e94ffbb, 0xffbb8bacbcff008f, 0x00dc010dbb51e067, 0x00ae7c0500bc0011, 0xa4cc79ff00a99204,
        0x010abb851ca5ffbb, 0xffbbb6d20cff00b7, 0x00ce060ebb8f545a, 0x6ad86aff00c96505, 0x7c04bb99fb94ffbb, 0xffbba52f86ff00d7, 0x01000007bb0d19e7, 0x00ed001100f29704,
        0x59dbffbba14c04ff, 0x7bff00fb9505bb8d, 0xbb972554ffbb574b, 0x010d780401120011, 0x3f95ffbb8e9316ff, 0x52ff011b8605bb70, 0xbb6070d7ffba5e87, 0x016c470401b09704,
        0x013e000d014c1c04, 0x8f56a9ff01390c04, 0x0a04b8d5ce33ffbb, 0xff3aba0781ff0147, 0x015e030e3c1463c0, 0xa08e59ff01594b05, 0x060e3c27fa99ff3c, 0xff3c02db27ff0167,
        0x0190000dbb0af12b, 0x017d220101825705, 0x624aff3c2ebb06ff, 0x09ff018b7b053c9f, 0x3b25b031ff3c2441, 0x019d020d01a2030e, 0x8c60ff3cdfdbcfff, 0xe8ff01ab00073d36,
        0x3d985767ff3d2200, 0x01d8000a01f8000b, 0x01c5050d01ca020e, 0xdc84ffbbcafd80ff, 0xfcff01d39f04bb83, 0xbb1870ceff39babc, 0x01e5090601ea020e, 0xe880ffb9cc7d27ff,
        0x15ff01f30c0ebb8d, 0x3969f27bff3b526e, 0x020e010d021c060e, 0xd72f09ff0209010a, 0x010e3c239ed0ffb9, 0xff3c41e381ff0217, 0x022e000a3d160d35, 0x5cdedaff02290107,
        0xac043ca6a847ff3c, 0xff3cec477dff0237, 0x000000133d441432, 0x000003e800000005, 0x0000023c00000001, 0x0120011200000000, 0x00502b0400946704, 0x0022001200301104,
        0xa384baff001d020d, 0x010ebb95a344ffbb, 0xffbb9421fdff002b, 0x0042010ebb9dda02, 0x900edfff003d0011, 0x0f01bb822536ffbb, 0xffbb9e70cbff004b, 0x00740011bb922f6a,
        0x0061010d00660007, 0x5775ffbb998ffdff, 0x74ff006f000dbb8c, 0xbb7d2e0dffbb8d6a, 0x008100070086010e, 0xe568ffbb783b92ff, 0xfdff008f1d01bb34, 0xbb721d6cffbb9219,
        0x00bc060e00dc010d, 0x00a98d0400ae000a, 0x5ab9ffbb81ff8dff, 0xf0ff00b70011bb9c, 0xbb432830ffbb7ffc, 0x00c9a20400ce0007, 0x9a74ffbb8aeb3dff, 0x43ff00d79904bb50,
        0xba446d4affbb378d, 0x00f2980401000007, 0x6e9556ff00ed000a, 0x030ebb512452ffbb, 0xffbb5b2f93ff00fb, 0x0112030ebb0d691b, 0x08bd51ff010d000a, 0x9704b9ef5a9affbb,
        0xffbb11b594ff011b, 0x01b000073acc8a60, 0x014c2d05016c3805, 0x0139000d013e0b03, 0x487cffbbac4233ff, 0x09ff01470c0e3b0c, 0xba3835beff3ac244, 0x01592f05015e000b,
        0x56c1ff3b69f2c9ff, 0xa2ff01671404bb56, 0x3c4212e1ff3aa64a, 0x0182000a0190010d, 0x73c733ff017d8b05, 0x000dbb4aaa3fff3b, 0xff3bfd4a95ff018b, 0x01a2a8043c6d1f02,
        0x8dcbb8ff019d030e, 0x000a3d1b961dff3c, 0xff3b36c4d9ff01ab, 0x01f8010d3d39cf61, 0x01ca030e01d83e04, 0x745a35ff01c51304, 0x16043c3aa60eff3b, 0xffbaf4793cff01d3,
        0x01ea68053b62774f, 0x695a05ff01e5000d, 0x80043ce97bc2ff3c, 0xff3c984408ff01f3, 0x021c3f043b26551c, 0x02091404020e1d01, 0xe8b0ffbb4f5d5eff, 0x61ff02172f043bee,
        0x3cb9a05bff3c8456, 0x02296e04022e9704, 0xf221ff3d08512dff, 0x1eff0237010e3d51, 0x3cf80e4dff3c2db4, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c,
        0x0094810401200112, 0x00301a0400504004, 0x001d00120022000d, 0xe2bbffbb82b6afff, 0x08ff002b0c04bb79, 0xbb68e289ffbb7913, 0x003d4b050042060e, 0x922affbb548fcbff,
        0xe4ff004b010abb76, 0xbb88b336ffbb7f59, 0x0066000d00740011, 0x5ee448ff00616205, 0x0007bb7ebda3ffbb, 0xffbb5de330ff006f, 0x00860007bb3d8dab, 0x5fdeadff0081020d,
        0x2501bb30f838ffbb, 0xffbb5c146fff008f, 0x00dc6805bb0112be, 0x00ae000d00bc9904, 0x04cbf5ff00a9130e, 0x0011bb5ceefeffbb, 0xffbb067499ff00b7, 0x00ce000db9f6af94,
        0x2bbe78ff00c94805, 0xa504bab0caa7ff3a, 0xff3a120386ff00d7, 0x0100010d3b13cb97, 0x00ed8d0500f2000a, 0xff14ffbb522e70ff, 0x0eff00fb060ebb7e, 0xbadd4038ffbb3a86,
        0x010d000701128705, 0x3121ffbb17cf9aff, 0xd1ff011b0002b9f3, 0xbb098b9fffbb3f55, 0x016c380501b00007, 0x013e000a014c2d05, 0xa770c7ff01391401, 0x2405bae48ef7ff3a,
        0xff39a7d2a2ff0147, 0x015e00063bccaf17, 0x85087dff01591404, 0x000a3c1b4251ff3a, 0xffbb2b789aff0167, 0x0190010d3b3b28a1, 0x017d8c050182000a, 0x0a2dff3b41f7cfff,
        0x0dff018b000dbb2a, 0x3c3db25eff3bcaa2, 0x019d000a01a20006, 0x8d2bff3c4aff09ff, 0x79ff01ab08063cf0, 0xbb962f4bff39fc9f, 0x01d8210101f8020d, 0x01c5060e01ca0f01,
        0x2046ff390441fdff, 0x9aff01d3000dbbc4, 0x3c0bcb94ff3b1834, 0x01e5060e01ea000a, 0x2036ff3b6b7af3ff, 0xc4ff01f381043c72, 0x3c16b2c8ff3caa5b, 0x020e9404021c030e,
        0x931f00ff02096604, 0x010e3d256c55ff3c, 0xff3bfa0454ff0217, 0x022e96043ce2989b, 0x6973bbff02299004, 0x36053da28090ff3d, 0xff3d81fd2bff0237, 0x000000133c6cbf9b,
        0x000003e800000005, 0x0000023c00000001, 0x0120011100000000, 0x0050130100944804, 0x00220a0100300012, 0x5ec04fff001d0201, 0x0e04bb582338ffbb, 0xffbb562bdcff002b,
        0x0042060ebb4cc97c, 0x45d9a6ff003d020d, 0x0801bb3b7bd9ffbb, 0xffbb5b7fbeff004b, 0x00740011bb4e44dc, 0x00614b050066010d, 0xe365ffbb4002b0ff, 0x8cff006f0007bb50,
        0xbb277e0dffbb3aea, 0x0081030e00862001, 0x425cffbb22c023ff, 0x6aff008f4b05bb3d, 0xbb3f6cb3ffbb0ea1, 0x00bc8b0500dc0011, 0x00a9000d00ae0007, 0x9f53ffbb451217ff,
        0x0cff00b7000dbb2c, 0xbb0dab1dffbb2a3f, 0x00c9000e00ce010a, 0xfa51ffbb805fc3ff, 0x37ff00d7b804bb46, 0xbab1e7c5ffbb2a2c, 0x00f2020d01000007, 0x40787dff00ed000a,
        0x040ebb206497ffbb, 0xffbb08b9a6ff00fb, 0x0112060dbaa4e58f, 0xf63120ff010d000a, 0x040bba86191cffba, 0xff3b014fa3ff011b, 0x01b09704bb109e09, 0x014c5404016c020d,
        0x0139060e013e000d, 0x0af9ff3af3c5eeff, 0x58ff0147000abb71, 0x3c221295ff3b42c8, 0x01594b05015e000d, 0x8018ff3c424e5dff, 0x7fff0167000a3b85, 0x3ce4ab38ff3c1ba9,
        0x0182240101906d04, 0x425e3fff017d2405, 0x00073c31791fff3b, 0xff3c17f308ff018b, 0x01a2050b3ca6fcc4, 0x90f31bff019d0007, 0x7d043d03dc94ff3c, 0xff3cedcf8fff01ab,
        0x01f8000a3d75a113, 0x01ca060e01d8010d, 0x37f0e7ff01c5b704, 0xae04bc366c89ffbb, 0xff3c1b3201ff01d3, 0x01ea000b3c69ebd4, 0x9b4442ff01e5010e, 0xbb04ba98f77bffbb,
        0xff3c24dd4dff01f3, 0x021c010bbb4320c8, 0x0209020e020e020a, 0xae47ffbb0f2b81ff, 0x40ff0217b5043a82, 0x3c8d160dff3bd904, 0x0229010d022e060e, 0xda85ff3b024345ff,
        0x8aff0237ac043d26, 0x3d11d81fff3ca23b, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094210101200111, 0x00301f040050010e, 0x001d001200220704,
        0xed8cffbb2a1df1ff, 0x73ff002b000ebb1f, 0xbb15052bffbae9f7, 0x003d14010042010a, 0xa4bbffbb0fe4baff, 0x9aff004b030bbae2, 0xbb4527b0ffbb03bb, 0x00662b040074060e,
        0x2995eaff00610b04, 0x0e01bb1d7db4ffbb, 0xffbb3e8811ff006f, 0x00864704bb0cde3e, 0x32094fff00810301, 0x2705bb28f023ffbb, 0xffbb513231ff008f, 0x00dc010dbb17fee9,
        0x00ae000700bc000a, 0x2c556aff00a9000d, 0xb504bb10ef30ffbb, 0xffbb0dc865ff00b7, 0x00ce060ebb39b706, 0x275a92ff00c9000e, 0x0007bae6398dffbb, 0xffbafcd8b1ff00d7,
        0x01000011b937ef28, 0x00edab0400f2ae04, 0xb449ffbafa1b0dff, 0x91ff00fb010ebb3f, 0xbaaebd0cffbb42bc, 0x010d040e01120007, 0xb0d2ffbad869d8ff, 0x5fff011b030eba83,
        0x3a8f79ecffba1e13, 0x016c590401b09904, 0x013e1304014c010e, 0x1ea4c7ff01390504, 0x000a3b127cf7ffbb, 0xff3bbf3efeff0147, 0x015e1a043c2e78a6, 0x6c62a8ff01590b04,
        0x060eba8b48cbffbb, 0xff3b8836a1ff0167, 0x01906305bb0c4109, 0x017d070b0182000d, 0x0d14ff3c26c223ff, 0xc9ff018b71043b9f, 0x3d042c22ff3c9721, 0x019d020d01a20002,
        0x4db2ff3bdc143eff, 0x6aff01ab010b3ca4, 0xbb94669cff3c9cc3, 0x01d8010e01f8000b, 0x01c5050d01ca000e, 0x80a3ffbbd4b879ff, 0xffff01d3050dbbab, 0xbad478efffbb8368,
        0x01e5170e01ea010a, 0xa1dfff39075df7ff, 0x6fff01f30a06baea, 0x3b980ed7ff3a5179, 0x020e010d021c060e, 0xead7a8ff0209010a, 0x010e3ba09039ffba, 0xff3b8e34acff0217,
        0x022e010a3c9127f9, 0x76f382ff02297a05, 0xac043c21bb43ff3c, 0xff3cbef96cff0237, 0x000000133d1c032d, 0x000003e800000005, 0x0000023c00000001, 0x0120011100000000,
        0x0050220100942a01, 0x00220c0100305b04, 0x049e9bff001d2704, 0x020dbb14a80effbb, 0xffbaf60da0ff002b, 0x00421901bacf5ec5, 0x59a494ff003d2305, 0x0007bb107648ffbb,
        0xffbacbf99eff004b, 0x0074010dbb15ee5c, 0x0061010a00660011, 0x7c38ffbaf76e69ff, 0x25ff006f010ebada, 0xbad61262ffbaaa79, 0x00810e0400864204, 0x60cbffbaea34dfff,
        0x30ff008f6304baad, 0xbb32e8eaffba281c, 0x00bc000700dc000d, 0x00a9040b00aea204, 0xa08fffbb0d4369ff, 0x5fff00b79805bb01, 0xbb0bd648ffba9f99, 0x00c9740500ce000a,
        0xb6f0ffbaec758dff, 0x36ff00d7060ebb07, 0xb9e3b6e3ffbabc89, 0x00f2050d0100010e, 0xcfd7a2ff00ed000a, 0x7b04ba6a0165ffba, 0xffba943bf9ff00fb, 0x011200073a76d14f,
        0xe16719ff010d7905, 0x0002ba6bc330ffba, 0xffb999e6ecff011b, 0x01b001073a8b6f9f, 0x014c0c03016c2d05, 0x0139000d013e0605, 0xeea7ffbb8307b4ff, 0x94ff0147060ebbe8,
        0xbb5b30c6ffba8688, 0x01590706015e0c0e, 0x07f0ff3ae2bf74ff, 0xbaff01670205b98f, 0xba85b52cff3a3541, 0x0182000a01900007, 0xc2f143ff017d000d, 0x2c013b347e53ffba,
        0xff3bddcb91ff018b, 0x01a2000d3b3f6f37, 0xaacbc4ff019d000a, 0x82053bcad580ffb9, 0xff3c6c4fc4ff01ab, 0x01f8010d3b21b18e, 0x01ca0d0e01d8000a, 0x0d15e4ff01c58004,
        0x9404bba234dcff3b, 0xff3c8a9d7dff01d3, 0x01ea0e0e3b44b756, 0x099635ff01e58104, 0x000d3a11eb6dff3c, 0xff3c09ef88ff01f3, 0x021c060e3d348ec7, 0x02093d04020e9004,
        0x4495ff3bae7c5cff, 0x8bff021796043ca3, 0x3c016c1cffbcbd72, 0x0229000a022e4201, 0x3e05ff3d887b25ff, 0xb3ff023796043dc0, 0x3c80f407ff3d385f, 0x0000000500000013,
        0x00000001000003e8, 0x000000000000023c, 0x0094020d01200111, 0x0030a30400508905, 0x001d740400228604, 0x4c59ffbabe7158ff, 0x54ff002b4405ba89, 0xba95da2dffb96bdd,
        0x003d00020042090e, 0x7008ffbaad99d3ff, 0xfcff004b000db985, 0x3afe3327ff390eb7, 0x0066ba040074010a, 0xe40e5fff00610002, 0x060eba9de770ffba, 0xffbb0c5a11ff006f,
        0x0086be04bb5b7c58, 0x98a094ff00810002, 0x060eba255349ffba, 0xff393e00b7ff008f, 0x00dc040ebad38b2b, 0x00ae9e0500bc0007, 0xc4e5caff00a90011, 0x020bba92dad6ffba,
        0xffba14a1e4ff00b7, 0x00ce4904baf75c1e, 0xb1d4b9ff00c92f04, 0x000aba6c6120ffba, 0xffba0df5d4ff00d7, 0x01009e0439ce348b, 0x00ed2e0100f20007, 0x11c9ffbb8cb9d4ff,
        0x6dff00fb0002ba93, 0x3a66baceffb9cbc5, 0x010da70401120007, 0xc3baffba422e69ff, 0x8dff011b050b3850, 0x3b2d7f44ff3ac6d6, 0x016c310501b00107, 0x013e000d014c0804,
        0x9c40ebff0139000a, 0x0007bb33bbe0ffbb, 0xff3a74da45ff0147, 0x015e010ebb75cd0a, 0x37c73eff0159010b, 0x0c0e3b75d03effbb, 0xff3a7c92acff0167, 0x0190030eba24ea91,
        0x017d5e0401820002, 0x0f0eff3b89c733ff, 0x9dff018b6f043c32, 0xba5ed287ff3c65a6, 0x019d010a01a2060e, 0x1d51ffb96dae8bff, 0xd0ff01ab00073baa, 0x3c2569b7ff3b14b1,
        0x01d8270101f8010d, 0x01c5060e01ca1501, 0xceedffbaa339faff, 0xa0ff01d3040bbb9c, 0xba7e260aff3b4544, 0x01e5710401ea5205, 0x5e60ff3badca70ff, 0x3fff01f37d043c6a,
        0xba621501ff3befac, 0x020e9104021c060e, 0x17c61cff02097404, 0x96043cb94fecff3c, 0xffbcc32035ff0217, 0x022e42013bcf1357, 0x5a5ea2ff0229000a, 0x96043d99cb38ff3d,
        0xff3d137fc3ff0237, 0x000000133c4e533e, 0x000003e800000005, 0x0000023c00000001, 0x0120011100000000, 0x0050190100942a01, 0x0022001100305504, 0xb39439ff001d010a,
        0x1101babd9a5bffba, 0xffbaa9ead3ff002b, 0x00420007ba8f677c, 0xbf1752ff003d8104, 0x8104bb09db06ffba, 0xffbb139bd4ff004b, 0x00740011bb54c6de, 0x006128010066060e,
        0x71b1ffba9fe58bff, 0xbaff006f3d05ba72, 0xba898c88ffbac435, 0x0081030e00862301, 0x8465ffba69150aff, 0x48ff008f030eba9b, 0xba81b8ceffba200b, 0x00bc000700dc000d,
        0x00a9020b00aea304, 0x051effbaccaaaaff, 0x3eff00b7010abab1, 0xba2f274effbaa9de, 0x00c9010a00ce0011, 0x3b4dffbab048dfff, 0x2aff00d7000aba45, 0xb9e74d4cffba94f3,
        0x00f29c040100010e, 0x9106a9ff00ed0007, 0x7f05ba1d2b08ffba, 0xffbaddf674ff00fb, 0x01129005ba9e3b49, 0x06a74eff010d9804, 0xbc043a1f48ffffba, 0xffba8bd729ff011b,
        0x01b00107bb33447b, 0x014c1c05016c3205, 0x0139020d013e0703, 0x0fe2ffbb29c9f6ff, 0x54ff0147000abc1f, 0x39805c53ffbada34, 0x0159000d015e010a, 0xb7c0ffbb18ae1eff,
        0x7bff0167030b3ab9, 0x380eeae7ff3bbef8, 0x01828f040190030e, 0x73cdf7ff017d6a04, 0x020e3c56096dff3b, 0xffbad51eabff018b, 0x01a2000a3bef620a, 0x9906aaff019d5805,
        0x000d3a4c6664ffba, 0xff3b48a1eaff01ab, 0x01f8010d3cb4d892, 0x01ca0d0e01d8000a, 0x281c10ff01c58204, 0x9404bb76422eff3a, 0xff3c36fe24ff01d3, 0x01ea000db9a8afa7,
        0xf9f0c5ff01e52701, 0x56053b9806f6ffb9, 0xff3c3d91b7ff01f3, 0x021c030e3a5dc6d6, 0x02091d01020e000a, 0x6f40ffbb50bc37ff, 0x92ff02172e043c08, 0x3cac8f21ff3a7004,
        0x02298e04022e3e01, 0x9818ff3d4234dfff, 0xf3ff023796043d80, 0x3c250f62ff3ce225, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094070d01200111,
        0x0030020d00509604, 0x001d000e00220011, 0x97baffbaaace98ff, 0x81ff002b9004ba83, 0xbaaba66affba4c5e, 0x003d420400428104, 0x1f2cffba597b26ff, 0x2bff004b7305b9eb,
        0xba078502ff3a0e1c, 0x0066a50400746d05, 0x88e7caff0061000d, 0x58053a10dba9ffb9, 0xff3af2acf2ff006f, 0x008600023a4fd6fd, 0x875e48ff0081040d, 0x00113adcdcf9ffba,
        0xffba8cf571ff008f, 0x00dc0002b9909ca0, 0x00ae000700bca204, 0x07f652ff00a9030b, 0x9204badc4424ff3a, 0xff3aab7bafff00b7, 0x00ce8d053b3b1422, 0xba8b92ff00c9a704,
        0x8f053b9bcbaaff3b, 0xff3b0be07eff00d7, 0x010065053b3d2830, 0x00ed920400f29404, 0x7f6aff3ab365f6ff, 0x82ff00fb9f04bb45, 0xb8c10fe0ff3b629b, 0x010d91040112a204,
        0xe81dff3a5242f9ff, 0x51ff011ba304ba9f, 0x3ab2a190ffbb93bd, 0x016c320501b00107, 0x013e050b014c1905, 0x6c396bff01390205, 0x2f04ba01cecaff3a, 0xffbaf92745ff0147,
        0x015e0f04bbc141b8, 0x01f0eaff0159020d, 0x030e3b8bc7ddffbb, 0xff3b4a0bf0ff0167, 0x019000073a2de74b, 0x017d010d01822601, 0xdd3cff3ad68806ff, 0x5fff018b2c013c05,
        0x39401c4fff3ba464, 0x019d4d0401a28405, 0x4f64ff3a8d81b3ff, 0x2aff01ab010d3c0f, 0x3bd57ce6ffbadbbb, 0x01d8200401f8070b, 0x01c5020d01ca0c04, 0x6733ffbb427cf2ff,
        0x2cff01d30a01bc17, 0x397f764dffbb0d47, 0x01e5350501ea7204, 0x5376ff3bb8b9c5ff, 0x91ff01f360053a42, 0x3b00fdfcff3c4d15, 0x020e7204021c7e04, 0xb28e65ff02096804,
        0x000dbbbd074bff3a, 0xff3beefe95ff0217, 0x022e060e3cca6a4f, 0x5e2e8bff02299a04, 0xa304bb1b54d8ffbc, 0xff3baf5f74ff0237, 0x000000133c8df3c5, 0x000003e800000005,
        0x0000023c00000001, 0x0120011100000000, 0x0050190100942a01, 0x0022060e00305704, 0x600111ff001d1501, 0x000dba3baee7ffba, 0xffba7ebd1aff002b, 0x00421d05baefadf6,
        0x8f9b58ff003d0012, 0x2605bb02d467ffba, 0xffbab44f9aff004b, 0x00742401ba81e511, 0x0061030e00669304, 0x3621ffba26d127ff, 0x9eff006f000dba57, 0xbb98cb30ffbab062,
        0x0081000e00861d04, 0x81e6ffba398ad8ff, 0x51ff008f060eba5b, 0xba62e1c5ffb9dc39, 0x00bc740500dc000d, 0x00a94b0500aea204, 0x1a07ffb9f35449ff, 0x3fff00b7130eba55,
        0x3a5ce79effb9a0fe, 0x00c9050b00ce010a, 0x0d35ffba903822ff, 0x64ff00d7a604ba59, 0xb9a034cbffba631f, 0x00f2060e0100040d, 0x3f0a60ff00ed000a, 0x0007b91bd975ffba,
        0xffba2e28d3ff00fb, 0x01127b043a2e0042, 0x28ddfdff010d0002, 0x00073afa07ecffba, 0xffb974e7c0ff011b, 0x01b001073aa9c6f0, 0x014c010a016c3805, 0x0139000a013e000d,
        0x562affbb693069ff, 0xdaff0147000aba81, 0x3a4f4af6ffb9d913, 0x01590301015e1d05, 0xe27dffbb17103fff, 0x99ff0167030b3a0f, 0x398a8917ff3bb225, 0x0182020d0190000a,
        0xa5760cff017d060e, 0x96043b0de449ffba, 0xff3be74990ff018b, 0x01a2010d3a3d0bf8, 0xa74722ff019d7f04, 0x4b0538f0eec2ff3b, 0xff3ce24b95ff01ab, 0x01f8070b3c5056c9,
        0x01ca0a0101d85404, 0x01e886ff01c5000d, 0x4201bbaa703affbb, 0xff3b04f0c0ff01d3, 0x01ea3405ba639a81, 0xb613bfff01e5000d, 0x00023c9d2be8ff3b, 0xff3bbea6ceff01f3,
        0x021c4f05b97765cd, 0x02091301020e2501, 0x601bffbb9a5d5bff, 0xfaff0217000dba9b, 0x3c05d1b4ff3a95bb, 0x0229a504022e060e, 0x58c7ffbbd8b0a5ff, 0x27ff02375405ba31,
        0x3c454f08ffbc100f, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094020d01200111, 0x0030730400508705, 0x001d000200224905, 0xbd9bffba21c467ff,
        0x1cff002b020bb867, 0xba305ef9ffba5f82, 0x003dad0400420007, 0x2f00ffba23e0d3ff, 0x12ff004b000ab860, 0x38afd42dffba3775, 0x0066000e0074ba04, 0x673ef2ff00616504,
        0xb004bad2f899ffba, 0xffb9f75a98ff006f, 0x00860011ba3e7506, 0x1ac592ff0081010a, 0x010a399bf6b2ffba, 0xffbac481b7ff008f, 0x00dc0002ba318e6c, 0x00ae7e0400bcb804,
        0x25f893ff00a90011, 0x030bb9927352ffba, 0xff39e92745ff00b7, 0x00ce0007b9f8fcff, 0x9876c6ff00c9bd04, 0x010bba20748fffba, 0xff3a8e201cff00d7, 0x01007205bacf8dbe,
        0x00ed610500f20011, 0x7550ffb9b488a3ff, 0x83ff00fb0007ba89, 0x3a88db2dffbaa57e, 0x010dac040112ba04, 0x19eaffb9bdfb1aff, 0xafff011b000a3a5c, 0xb8899bb3ffbab2c5,
        0x016c2d0501b00107, 0x013e0304014c1104, 0x3c47dfff0139000a, 0x000dbad1ba51ffbb, 0xffbab2013eff0147, 0x015e030e396cedc8, 0x63329fff01592301, 0x0b06bb18e7faff3b,
        0xffb8960077ff0167, 0x019000073b66ab94, 0x017d8b050182000a, 0x798cffb5aaeaeeff, 0x76ff018b2c01bad2, 0x39746396ff3b41be, 0x019d000a01a2010d, 0x405dffbab5ee24ff,
        0xecff01ab000a3ba4, 0x3ca63056ff3bf5c7, 0x01d8000a01f8010d, 0x01c5790401ca010e, 0x7a62ffb937c201ff, 0x50ff01d30e0ebba7, 0x3b89338bffb98571, 0x01e5290101ea000d,
        0x3c84ffba9a1ed2ff, 0x7bff01f3010e3b25, 0x3cccbdd8ff3b974c, 0x020e030e021cbc04, 0x139a8aff02092804, 0x40013bc9e3bcffbb, 0xff3d244a65ff0217, 0x022e98053c666bd9,
        0xa85c45ff02290002, 0x0002bc79aeb2ff3c, 0xffbbb2b340ff0237, 0x00000013bc410815, 0x000003e800000005, 0x0000023c00000001, 0x0120011100000000, 0x005096040094070d,
        0x0022000a0030020d, 0x466f66ff001d020b, 0x6a04ba0ac770ffba, 0xffb9f75fdfff002b, 0x00427204b962215a, 0x0191e3ff003d2001, 0x0011b96f8ef2ffba, 0xffba2e72caff004b,
        0x007458053990baa9, 0x006100020066a404, 0x6ca7ff392fddf2ff, 0x8eff006fa5043a87, 0x3aafc43aff38a486, 0x0081000a0086040d, 0x6952ffba265539ff, 0xf4ff008f030bb96b,
        0xb9578153ff3aa4b5, 0x00bca20400dc0002, 0x00a9030b00ae8005, 0xa414ff3abb0470ff, 0xffff00b79e04ba9d, 0xba563256ff3a37e9, 0x00c98f0500ce0007, 0x8edeff3ada44a0ff,
        0xe1ff00d7a8043b14, 0x3b4dc484ff3b87e1, 0x00f2000701009104, 0xf6efb4ff00ed7405, 0x860439be4e40ffba, 0xff3a88ba33ff00fb, 0x011292043ae564a9, 0x8c330aff010d8205,
        0x6105bb265afbffbb, 0xff3aa5881aff011b, 0x01b00002b8265b94, 0x014c020d016c3a04, 0x01394b05013e000a, 0xb016ffbab4f2e9ff, 0x8aff0147010dbb2e, 0x3b6c5332ffb8e782,
        0x01591601015e1a05, 0x6e7effbb82bb71ff, 0x75ff01674b053b1c, 0xbbccda03ff3b7f3b, 0x0182720401909904, 0x73a02fff017d4201, 0x000dba150a08ff3b, 0xff3b1289d1ff018b,
        0x01a29a043c42d0fa, 0x3d50a6ff019d000a, 0xa604bcb4f7cbffbc, 0xffba3cafcaff01ab, 0x01f868043aa57abc, 0x01ca010d01d8000a, 0x1d81efff01c56204, 0x00073c0038f7ff3b,
        0xffbb5bbcfdff01d3, 0x01ea00073cc8ee9a, 0xffe0fdff01e5010e, 0x010a3aee4d22ff3b, 0xff3c9aa286ff01f3, 0x021c98043cfb8aa6, 0x0209030b020e6f04, 0x4e96ff3ae6f129ff,
        0x99ff0217010b3d03, 0xbc010144ff3c9a5b, 0x02299d05022e010a, 0x17f0ffb9e99d53ff, 0x93ff02370b0ebbba, 0x3c60a3a7ff3b12b8, 0x0000000500000013, 0x00000001000003e8,
        0x000000000000023c, 0x0094070d01200111, 0x0030020d00509604, 0x001d710400220f0e, 0xb803ffb9d7188fff, 0x94ff002b110eb93c, 0xba4383ebff38c0c4, 0x003d680400428104,
        0x0941ffb987d11eff, 0x0fff004b0011b93a, 0x39b9a648ffba1472, 0x0066970400745805, 0x9746c9ff0061010a, 0x0002baaef5b9ffb9, 0xff39cda589ff006f, 0x0086090b3a82f688,
        0xce2f07ff00818d05, 0x0002ba1dae99ff38, 0xffba130068ff008f, 0x00dc0002b897363e, 0x00ae760500bca204, 0x618cfaff00a99204, 0x92043b21102bff3a, 0xffba2b1e4dff00b7,
        0x00ce87053a516465, 0x596966ff00c9a804, 0x8d053b08fbc8ff3b, 0xff3b403ea8ff00d7, 0x0100a7043ace2758, 0x00ed940400f26505, 0x722eff381b7970ff, 0xa7ff00fba2043a9b,
        0xbb2cf487ffba19b8, 0x010d020b0112ad04, 0x1990ff3b020e19ff, 0xaaff011b020b3b89, 0x3b3fb648ffbaccf3, 0x016c6b0501b07005, 0x013e050b014c3005, 0x1a47b2ff01390107,
        0x30013adeb104ff39, 0xffba9fee03ff0147, 0x015e000d3b8891aa, 0xfdeea5ff01597204, 0x80043b0bc942ffb9, 0xff3b66bfa7ff0167, 0x0190a5043a305c3e, 0x017d8a0401820207,
        0x5451ff3928c48fff, 0x20ff018b010e3beb, 0xbb3cc41dffbc8351, 0x019da80401a2020a, 0x8034ff3c40cccbff, 0xe3ff01ab010b3c0b, 0x3ca0bb62ff3cc716, 0x01d8740401f88204,
        0x01c55c0401ca7305, 0x35d1ffb69e52abff, 0x95ff01d3010ebbb0, 0xbabb7cedff3b2369, 0x01e5000a01ea010e, 0xc80fff3bd9e34eff, 0x3bff01f371053cbe, 0x3b63f8c3ffbc95a0,
        0x020e9704021ca404, 0xed9bcdff0209020d, 0x060e3bff5ba7ffbb, 0xffbb194056ff0217, 0x022e92053bae36c2, 0x7379e5ff0229060e, 0xb7043c6762ebff3b, 0xff3ac50de4ff0237,
        0x00000013bb44e514, 0x000003e800000005, 0x0000023c00000001, 0x0120011100000000, 0x00508e0400942a01, 0x00221e0400306504, 0x020ebbff001d0704, 0x2401b9c2a47bffba,
        0xffb9a54384ff002b, 0x00423205b89f7c10, 0x1cb11aff003d1001, 0x0d0eba483e24ffbb, 0xffb99eff11ff004b, 0x0074000d39933a68, 0x0061001200662601, 0xcdd5ffb9f11905ff,
        0x30ff006f020abaed, 0x3a8109a1ffba160b, 0x0081960400863105, 0x415fffbb681ad6ff, 0x3cff008f2301bba4, 0xbb10e6eeffbb202b, 0x00bc740500dc000d, 0x00a91c0500aea204,
        0xe693ff3940f7a2ff, 0x0aff00b7130eb995, 0x3a089aafffb96840, 0x00c9060b00ce010a, 0xe92affba1be14aff, 0x57ff00d7a804b9c4, 0xb81f06f6ffb9f864, 0x00f2050b01000011,
        0xdbd578ff00ed9804, 0x5504ba6f5303ffb9, 0xffb9f38fdaff00fb, 0x0112000ab9312607, 0x9231c6ff010d040d, 0x780539bdfd93ffb9, 0xff39c4ca49ff011b, 0x01b06505b7b6a2a0,
        0x014c4b05016c4d04, 0x0139060e013e0f05, 0x511fffba30d09cff, 0x54ff01474804bb35, 0xbb1fbc47ff3a420e, 0x0159000e015e5305, 0x2c3bff3aa24a14ff, 0x1aff01674201bbac,
        0x36889ef5ffbb2d9c, 0x0182020e01900007, 0xf7b1e5ff017d3f01, 0x140ebb14966eff3a, 0xff39eec18cff018b, 0x01a2000dba75262f, 0x3668bfff019d4201, 0x4001b9626796ff3b,
        0xff3c8aefafff01ab, 0x01f8010d3ba056c8, 0x01ca800401d8060e, 0xee3a29ff01c57404, 0xa3043c24cba0ffb9, 0xffbbb09210ff01d3, 0x01eaac043a0a8300, 0x108339ff01e57e04,
        0x010a3b8e7c9affbb, 0xff3be246ecff01f3, 0x021c6e053cb3389e, 0x02096a04020e6d04, 0x774fffba0c48d9ff, 0x87ff02179304bcc7, 0x3a87ebd7ff3c735c, 0x02298404022e8604,
        0x5577ffbadeb4faff, 0x6fff02379104bd0b, 0x3a3779b6ff3c6199, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094330501201c04, 0x0030020100500111,
        0x001d00010022000d, 0x0d4fffba04008fff, 0xc2ff002b0805b9c9, 0xba117a2affba31eb, 0x003d080400420012, 0xd0afffb9deb596ff, 0x25ff004b0504b9b0, 0xb984dbb0ffb9bc5e,
        0x0066000700741404, 0x55968eff0061010d, 0x010d3b395ebdffba, 0xffba87ea4fff006f, 0x0086060ebb92ba3a, 0x33f14bff00810007, 0x170139da25dbff3b, 0xffbb098dc2ff008f,
        0x00dc0112bbcedde9, 0x00ae001200bc0107, 0xd6eb2dff00a9010a, 0x4b05b976cf18ffb9, 0xffb9733ff4ff00b7, 0x00ce000ab9e89f43, 0x35a17cff00c94905, 0x0002ba0da582ffba,
        0xffba048d2bff00d7, 0x0100030bb8f3d046, 0x00ed000a00f21604, 0x24e6ffbae292a3ff, 0xc4ff00fb010e3a9d, 0xbad3471affbb6ba6, 0x010d1c0101121e01, 0x6306ffba85c65fff,
        0x33ff011b010ebba9, 0xb8da6c0bff3b6bb7, 0x016c001101b00111, 0x013e0207014c010a, 0x9e9280ff0139110e, 0x2005ba1344e9ffb9, 0xffb985d22bff0147, 0x015e2001ba10dcd5,
        0xc43f19ff0159090b, 0x6304ba1654cdffb9, 0xff38b27ffbff0167, 0x01900002b96039af, 0x017d9f040182b704, 0x8673ffb8c8dcf3ff, 0x58ff018b010ab95c, 0xb95e46c9ffba663d,
        0x019d990401a25805, 0xcf4fff39d75830ff, 0x9bff01ab98043a7b, 0x3984e6a8ffba1977, 0x01d8070b01f8010a, 0x01c5010b01ca020b, 0x7293ffb9b89692ff, 0x08ff01d3010dba87,
        0x3b884915ffb991bd, 0x01e5710401ea7d04, 0x8547ff39211002ff, 0xc2ff01f3060e3bd4, 0x3b3a71baffbb8f13, 0x020e040b021c3005, 0x34c38aff0209020b, 0x0d0e3b2e9bf4ff3a,
        0xffbaeae9d5ff0217, 0x022e010ebbd80359, 0x3e2373ff02290007, 0x060e3c557f92ff3b, 0xff3a8d0d4cff0237, 0x000000133bd9fe40, 0x000003e800000005, 0x0000023c00000001,
        0x0120000200000000, 0x00506e0500948d05, 0x0022690400306e04, 0x1abc5bff001d4a05, 0x0111ba1b8396ffb8, 0xffb9930f26ff002b, 0x00420112bba05991, 0x9e9306ff003d0011,
        0x9504393a07c2ffb9, 0xff3bc2ffc2ff004b, 0x0074010d37221877, 0x006101120066030b, 0xa3b0ffb960234aff, 0xc6ff006f00073adc, 0xba4b2e84ffb8c0db, 0x0081011100868604,
        0x512fffb9eddfccff, 0xb0ff008f0111bb81, 0x3c13d953ff352cc8, 0x00bc011200dca404, 0x00a9000a00aea204, 0x51bcffb9527476ff, 0x42ff00b70012ba25, 0xba9060c1ff3a22e3,
        0x00c9970400ce010e, 0xa130ffbc5f1e7cff, 0x5aff00d7a104bb51, 0xbbbd6713ffba0b2a, 0x00f2b00401000112, 0xd473c0ff00ed030b, 0xb304b7023ae9ffb9, 0xffba9268b4ff00fb,
        0x0112b504b9ef027a, 0x434bb3ff010db304, 0x9b05bb4218c2ff3b, 0xff3c1b4e4fff011b, 0x01b06404b87aa92f, 0x014c0007016c0111, 0x01395f04013e6105, 0xef8fffb9cdc52bff,
        0x88ff01474204ba1d, 0xb955fd7effb9d9ab, 0x0159010d015e000a, 0x47a0ffb887c94eff, 0xdfff016748043a31, 0x3a335f7affb8f84f, 0x018200070190000a, 0x7f3b50ff017d7405,
        0x010d3b614943ffbb, 0xff3b870a4cff018b, 0x01a248043c8d2405, 0x82d656ff019d3405, 0x0007b9e1d453ff3b, 0xff3b9d99eeff01ab, 0x01f8020e3ca97984, 0x01ca4b0501d80111,
        0x0de2e5ff01c57a04, 0x01073a6fe39eff39, 0xffb8f31959ff01d3, 0x01ea9604b9ab3a58, 0x27687fff01e58404, 0xbb04bc6b428fffbb, 0xffba4a5dceff01f3, 0x021c030ebc1b0b8f,
        0x02094b05020e6f04, 0x4e10ff3d082cacff, 0x5fff02179404bbc3, 0x3af528c6ffbb89bd, 0x02290111022ea404, 0xeee0ffb9915e52ff, 0x5bff0237060ebaff, 0x3a9ed183ffb8f681,
        0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x009461050120010e, 0x0030011100505c05, 0x001d8f0400229004, 0x3d48ffb8b713b5ff, 0x24ff002b010d3a76,
        0xba08f280ffbb62b1, 0x003d030d0042000a, 0x92f3ffbaf6bd7aff, 0x76ff004b81043a54, 0xbb932785ff3b522b, 0x0066011100740207, 0xf584a7ff00616f04, 0x72043a5ae762ffb8,
        0xff389e0a37ff006f, 0x008601123ca73a3f, 0x12d92cff0081090b, 0x0002bad73508ffb9, 0xff3bdecff3ff008f, 0x00dc010dbcbc1c4a, 0x00ae670400bc8204, 0x8ffb74ff00a96504,
        0x0111bb5d342affb9, 0xff3702dfa2ff00b7, 0x00ce01113c0fa2ca, 0xa05e48ff00c98d04, 0x9704b9d89b76ff38, 0xffbc1fccc6ff00d7, 0x01008904391aef84, 0x00ed830400f20002,
        0xf07effba1a47e9ff, 0x48ff00fb01123a0f, 0x3c7ee75dff38cf87, 0x010d01110112020b, 0x3bd2ff3993ad55ff, 0x02ff011b00023b8c, 0xbacb94b3ff3a3a97, 0x016c830401b00112,
        0x013e000d014c070e, 0x5e33c9ff01393504, 0x8004b88eacdcffb9, 0xffb984aa01ff0147, 0x015e000d39e8bb56, 0xac1ab9ff01595704, 0x4b05ba05013effb9, 0xff3aac60ebff0167,
        0x01907705b9a83d14, 0x017d030e0182a704, 0x6500ff3a30c91aff, 0xeaff018b020ab868, 0xb9b32695ff3a5954, 0x019d050b01a2ba04, 0xeaf4ffb944b0ecff, 0x9aff01ab000236b7,
        0xbaaaae08ffb99e3a, 0x01d8020701f88705, 0x01c5450401ca7805, 0xaaa3ffb9f1888aff, 0xf8ff01d3a60439d6, 0x3bdeaabcffbad2af, 0x01e5690401ea020e, 0xbf67ff3c621a40ff,
        0x28ff01f3000d3ceb, 0x3b8a006fff38902a, 0x020e000a021c030e, 0x1a8291ff0209020d, 0x9c043c517dc1ff3a, 0xff3cf1f25dff0217, 0x022e00073c7ae386, 0x006faeff0229a304,
        0xb7043b63eab3ffb9, 0xffb9a253a8ff0237, 0x00000013bb8dd52a, 0x000003e800000005, 0x0000023c00000001, 0x0120010e00000000, 0x00505c0500946105, 0x0022040b0030000a,
        0x89df44ff001d4c05, 0x050bba3c610fffb9, 0xff3a88cab7ff002b, 0x00425f04b98b9fca, 0x8f08b0ff003d0a0b, 0x01113a23dbbbff37, 0xff3997ce20ff004b, 0x007402073bc38ce5,
        0x0061700400660111, 0x36bcffb8cba8adff, 0x5fff006f6b043a35, 0x3c62cdc4ffb9b13c, 0x0081001200860111, 0x3294ff3967f794ff, 0x12ff008f010dba84, 0x3c3112f6ffbc86a4,
        0x00bc810400dc010d, 0x00a96d0400ae7204, 0xdfdcffb9a63ce6ff, 0x92ff00b7011139cf, 0x3c38b74fff3916fd, 0x00c9011100ce9704, 0x05f9ffb901fb95ff, 0x79ff00d77f05bbff,
        0x381d3286ffbb050f, 0x00f2000201008804, 0x13083bff00ed0111, 0x0112bac03708ffb9, 0xff38a605caff00fb, 0x011291043c4bec4f, 0xf557c6ff010d0111, 0x01113c33683eff38,
        0xffb90e0637ff011b, 0x01b00111baf5608f, 0x014c020a016c010d, 0x01397c04013ebc04, 0x68d6ffb9302c87ff, 0x65ff0147060eb615, 0xbaab1215ff373f43, 0x0159af04015e090b,
        0x9c7cffb8d792d6ff, 0xb1ff01678a0539a8, 0xb8dcab02ffbac2bb, 0x018200020190ba04, 0x0cca5dff017da204, 0x000ab9e3fb7affb9, 0xff3937def7ff018b, 0x01a200023aab68da,
        0x517f09ff019d010a, 0xbc043a97149effba, 0xffb9d69a9dff01ab, 0x01f8070bbb1b82db, 0x01ca030b01d8020a, 0x10f7a6ff01c56405, 0x000d3a51be9eff39, 0xffba24e77bff01d3,
        0x01ea1b013c4261a2, 0x805325ff01e5060e, 0x7404bb4c0e83ff39, 0xff3baa00c4ff01f3, 0x021c000d3a5b2630, 0x02099b04020ea204, 0x1d9dffbaad3344ff, 0xd1ff0217060e3a01,
        0x3bb7273effbad0db, 0x02296204022e4101, 0x9199ff3a37a307ff, 0xb1ff023786053c6c, 0x3ba01622ffbbb037, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c,
        0x00948d0501200002, 0x0030070500506e05, 0x001d011200220906, 0x34fcffb97df869ff, 0xffff002ba404ba93, 0x3b1f3833ffb9f7a0, 0x003d6e040042000d, 0x5bd5ffb94d9779ff,
        0xdbff004b0207390c, 0x391ffdf3ff39a6b6, 0x006601110074020d, 0xdb7edeff0061b604, 0x790438c7c65bffb8, 0xff3abd63e8ff006f, 0x00868604bb0d7b38, 0x94a6f5ff00818204,
        0x0111bb899646ff38, 0xff38d482faff008f, 0x00dca4043c16778d, 0x00ae000700bc0112, 0xba7282ff00a9000a, 0x000ab9d845eeffb8, 0xffb9ec762dff00b7, 0x00cea104baca4f7c,
        0xa5e24aff00c99a04, 0x91053986a47cffbb, 0xffbb672b9dff00d7, 0x01000111bc4bf18c, 0x00ed940500f20007, 0x374bff3973e6eaff, 0x26ff00fbac04b94a, 0xb9fd05faff390714,
        0x010db3040112b504, 0x3d2dff3b14745fff, 0xe3ff011b9b05bb21, 0x3815585dff3bf9f3, 0x016c011101b06404, 0x013e010e014c5504, 0x39012bff01395204, 0x090bba8c5edcffb9,
        0xffb7bac40bff0147, 0x015e340539ee0ddf, 0x61df42ff01592005, 0x00073a032195ff3a, 0xffb90f25a3ff0167, 0x01905e04395f16a3, 0x017d010d01824b05, 0x1fd0ff3b2583f5ff,
        0x22ff018b030b3c51, 0xbbb6b62fffba1b3c, 0x019d000a01a23405, 0x5c74ff3c37fee2ff, 0xb8ff01ab000a3c8e, 0x3c29a2c9ff3b96a0, 0x01d8011101f8020e, 0x01c5a10401ca010d,
        0xab36ffb9d69efaff, 0xc7ff01d3000a38aa, 0x3a9c1ee8ff37486c, 0x01e5010b01ea9604, 0x65e7ff3c38358aff, 0x7eff01f3b704bbd6, 0xbb824210ffb965a2, 0x020e6f04021c030e,
        0xecae00ff02090007, 0x94043cc3b1a0ffbb, 0xffbb65fce4ff0217, 0x022ea5043aa75d1a, 0x764ccbff02290111, 0xa804bad001b0ffb9, 0xff3b23afd7ff0237, 0x0000001338e17366,
        0x000003e800000005, 0x0000023c00000001, 0x0120080600000000, 0x0050000200948404, 0x0022820400300111, 0x02e082ff001d6704, 0x6405b8b1265fffb9, 0xffba6fd67fff002b,
        0x00428104b8be1218, 0x004fbbff003d8004, 0x83043b5677fdff3a, 0xffbc20b4c1ff004b, 0x0074020a3b2ba0f5, 0x0061010a0066010d, 0xfb0cffb9870e01ff, 0x1eff006f01113aa1,
        0x3c2a3f16ff39fbf5, 0x0081020700860112, 0x3380ffba0a72daff, 0xacff008f000739b6, 0xbcfc4d87ffbc53d7, 0x00bc011100dc8504, 0x00a9001100ae0012, 0xa20affb9b9fdcfff,
        0xd1ff00b741013a99, 0xba43d0e1ff3a1104, 0x00c95d0500ce010d, 0xc523ffbca035ceff, 0x04ff00d7020bbb69, 0xbc95d417ffbd69cb, 0x00f2490501000111, 0x0cca56ff00ed170e,
        0x4a05ba00766eff3a, 0xff3aa6c2a5ff00fb, 0x01128c04b8c46dd9, 0x816322ff010d0002, 0x060ebbdf11c4ff3b, 0xffba1d74e5ff011b, 0x01b00b053a405aaa, 0x014c040e016c170e,
        0x01390705013e050d, 0x2034ffbb3c4b47ff, 0x0aff0147010e3988, 0x3b10ec13ffb98752, 0x01590f0e015e0005, 0x36bdff3bcb3c39ff, 0x28ff01670f0e3b11, 0xb9cc79f6ff3adbd8,
        0x018202050190030d, 0x6f8fcbff017d1a0e, 0x0a06baa271abff3a, 0xffbb39fe35ff018b, 0x01a2010abaa5f7b4, 0x637206ff019d000a, 0x0002bba26845ffbb, 0xffbb08900dff01ab,
        0x01f8040ebbbde03c, 0x01ca030d01d81b05, 0x7ad1f7ff01c59d04, 0x000ebb269592ffbb, 0xffbb5e2670ff01d3, 0x01ea000aba3a4250, 0x1da027ff01e50a06, 0x2405bb713aabffbb,
        0xffbb7b9d8fff01f3, 0x021c000abbc2c72b, 0x02090c0e020e1205, 0x7871ffba9240e7ff, 0xd1ff02170a06bb22, 0xbb7a57c5ff3a0a46, 0x02290906022e0a06, 0xaf2eff3b814364ff,
        0xffff0237030d3b01, 0xba6171b0ffbb66c0, 0x0000000500000013, 0x00000001000003e8, 0x0000000000000233, 0x009400020120020a, 0x003094040050010d, 0x001d4f0500225e05,
        0x2f7affb8b42ee6ff, 0xbdff002b0111b93e, 0x3a5db177ffb882d3, 0x003d950400422205, 0xb389ff3c0b36ddff, 0xe9ff004b970439e5, 0x386bb08cffba6d37, 0x0066040b00740111,
        0x03a404ff0061000a, 0x000a3938e6b7ffb9, 0xffb8d18a0eff006f, 0x00868105ba6b1994, 0xab020fff0081020b, 0xb9043b30eac6ffb9, 0xffba22da93ff008f, 0x00dc77053c2ca1f2,
        0x00ae011100bc6f04, 0x85ffacff00a90007, 0x6204393d552dffb9, 0xff3abf2035ff00b7, 0x00ce01123c00ebc0, 0x1b3e5fff00c94b05, 0x9404b8f6d4cdff3a, 0xffbbc8cf9bff00d7,
        0x01008b05ba6bcca3, 0x00ed050b00f2a504, 0xfdacffb9ef1ce3ff, 0x4cff00fb01113829, 0x3b911c41ff3941b2, 0x010da80401128c05, 0x69dcff392acbe3ff, 0x8eff011b9505bb31,
        0xba0cf656ff3a2568, 0x016c011201b07405, 0x013e070b014c000d, 0x01a89aff01395405, 0x1201ba007f11ffb5, 0xffb96884eeff0147, 0x015e9404bad92f06, 0xb860adff01590207,
        0x9804bba92514ffbb, 0xffb8829655ff0167, 0x0190a404bb4be9eb, 0x017d280101824201, 0xcd69ffb824a515ff, 0x5aff018b060e3c05, 0x3bc2d938ffbba6e5, 0x019d5f0501a2060e,
        0x85e3ff3c8c86d2ff, 0x5cff01ab01073b74, 0x3ca0a831ff3c2b78, 0x01d8be0401f80111, 0x01c5001201ca040b, 0x815fffbab6eaf0ff, 0xfdff01d37a05b785, 0xb9f7d5d0ffbaf266,
        0x01e59c0501ea060e, 0xef90ff3b19cf24ff, 0x80ff01f30007394c, 0xbaa0b52dffb938c9, 0x020e000202139004, 0x533036ff02097805, 0x70ff3d0f00ddff3c, 0x070225a1043bc241,
        0xbaa06761ff022000, 0x2eb804bc523cd2ff, 0xedff3b21eb16ff02, 0x05000000133c2677, 0x01000003e8000000, 0x0000000233000000, 0x040120020a000000, 0x040050000a0094b7,
        0x1100220111003059, 0xb9190473ff001d00, 0x2b060eb82b88b2ff, 0x6cffba19aee3ff00, 0x0700428c04bb28f4, 0xb8bb416bff003d02, 0x4b0207b9e29974ff, 0x13ff37802c80ff00,
        0x040074020bb9ec6b, 0xff0061690400666a, 0xcf1e1bffb92ba34d, 0x13e6ff006f7904bb, 0x01388fcee1ff3b3d, 0xff00818e04008635, 0x9b7e33ffb899230b, 0xbffeff008f0111b9,
        0x0a3afc3b1fff38dc, 0x0e00bc011100dc01, 0xff00a9000200ae06, 0x245964ffb9d0ee4e, 0xbaa4ff00b7bc0438, 0x04bab5cde5ffba30, 0xff00c9010d00ceb8, 0xfa95baffbbebb2c8,
        0xd9ebff00d7bc043b, 0x04bbbe8033ffb9d0, 0x1100f2060e0100b8, 0x392869f5ff00ed01, 0xfb0112bc26b081ff, 0xceff39d22115ff00, 0x0e011200023c8101, 0x39fd7c5dff010d0f,
        0x1b0111ba1e056aff, 0xd8ffb910938dff01, 0x0501b0ab043bcfd5, 0x01014c3301016c74, 0xff01394105013e25, 0x65e547ffb8b9fb58, 0x2cd9ff014701113a, 0x013bf3da80ff399e,
        0xff01590112015e3e, 0xd85be4ff3a49dbc7, 0xa632ff016776043b, 0x07ba3560b7ffbbb5, 0x0501820112019000, 0x39c42d7cff017d7f, 0x8b9004b9a36f03ff, 0xe2ff3c6ac12bff01,
        0x1201a2a1043b338d, 0xb9232e30ff019d00, 0xab0002bc1338b7ff, 0x17ffbae40c88ff01, 0x0501ef01113b172f, 0x0501ca000201cf4e, 0x3a7e09b0ff01c546, 0x38f0ff3b04f4d9ff,
        0x000d01e1050bba97, 0xff393e320bff01dc, 0x01ea5c05b9f3aead, 0x56f5ffbb973186ff, 0xb7040213060eba0a, 0x3aff0200b5040205, 0x3c18a13fff3ac81f, 0x46661fff020eb804,
        0x01073c13b2b8ffbc, 0x28ff0220ac040225, 0x3bcb879eff3b3372, 0x705656ff022e0207, 0x00133c8964baff3c, 0x03e8000000050000, 0x023c000000010000, 0x020a000000000000,
        0x4d050094b7040120, 0x3601003042010050, 0x7fff001d25050022, 0x38c5df15ffb92247, 0x039668ff002b0111, 0x70043b96955bff3a, 0xa5ff003d00020042, 0x3a9bb8c0ffba6a41,
        0x28f5f1ff004b4805, 0xa9043b04efefffb9, 0x000a006602070074, 0xffb8d02eccff0061, 0x006f0111385e7903, 0x5277ffb9f0819eff, 0xb5040086020bbb54, 0xff39b275e7ff0081,
        0x008f01113b3c8f7d, 0x48d0ff3906677aff, 0x0b0600dc010a3a86, 0x010b00ae030600bc, 0xff3992353eff00a9, 0x00b70a06ba03b896, 0x9083ffbb5f2de4ff, 0x040d00ce050eba85,
        0xffbb2b3ba2ff00c9, 0x00d702053a26a463, 0x3c47ff3ba80cb2ff, 0x060e0100b8043ac1, 0x2cff00ed011100f2, 0xbc055a00ff3906bb, 0xa81a75ff00fb0111, 0x00023c4e694bff39,
        0x1fff010d0b060112, 0x3b4e7c17ff3899a8, 0xe75294ff011b0111, 0x70053ba644aeffb8, 0x2101016c2c0101b0, 0x0d0e013e2205014c, 0xffb8c558c2ff0139, 0x0147030ebad7d4b5,
        0x3037ffbb1abe56ff, 0x9104015e01123a15, 0xff398170f4ff0159, 0x01672801ba34c7dd, 0x28bcff3b046a64ff, 0x011101903e013c4c, 0x3fff017d70040182, 0x3a621ce0ffb98825,
        0x6a3c48ff018b8704, 0x060e3d8c40bdff3b, 0xc8ff019d3f0101a2, 0xba8b4e28ffbc0f38, 0x857372ff01ab0111, 0x01123bf71bb6ffb9, 0x7b0501d8001201f8, 0xf8ff01c58a0401ca,
        0x38eeeb55ffb8ffc4, 0x88fcc9ff01d30107, 0xbe04baf42162ffba, 0x2aff01e5000201ea, 0x39afd6c7ffb93c10, 0xd1ef95ff01f3060e, 0x0007ba41026eff3a, 0x0002020e9004021c,
        0xff3c852a37ff0209, 0x02179f043c35e8c3, 0xc1caffba6768ebff, 0x7705022ea4043b96, 0xff3b1e4f36ff0229, 0x02378005bbfe02ab, 0x8d1eff3ba7896bff, 0x000500000013ba5f,
        0x0001000003e80000, 0x00000000023c0000, 0x8e05012000020000, 0x420100504b050094, 0x4f0400222f010030, 0xffb88988c4ff001d, 0x002b0111b83f7b5e, 0x39a3ff39965a03ff,
        0xb404004245053b3a, 0xffb98ff53aff003d, 0x004b4705bb021bfb, 0xd159ffba815f86ff, 0x0207007401123b33, 0xebff0061010a0066, 0xb931abf5ff371e0a, 0xfc047aff006f4f05,
        0x6e04b9fc5e4cff39, 0x3bff00814f050086, 0xbabcbc38ffbb9c47, 0x9192a0ff008f020e, 0xa404383a5759ff3b, 0xa20400bc011100dc, 0x96ff00a98f0500ae, 0xb8647e4dffb9c927,
        0x80984dff00b7040b, 0x000db9860a88ffba, 0x45ff00c9000a00ce, 0xbb4298bcff3a8eef, 0x014bdbff00d79704, 0x010dbb23cc18ffbc, 0x030b00f201110100, 0xffb9f1871dff00ed,
        0x00fba904b7861d2c, 0xbc5cffbb1b7f7eff, 0x01120112a8043b3f, 0xffb9bc90efff010d, 0x011ba9043cb759e2, 0xf0dbffbc254537ff, 0x011101b06404b955, 0x0011014c4204016c,
        0x45ff01392904013e, 0xba2ef51dffb997a4, 0x26328fff01472005, 0x030bb91bce0bff39, 0x89ff01595504015e, 0xb74a9827ffb970a7, 0xc184caff01670007, 0x00073985751dff37,
        0x000a018274050190, 0xffbb6ef07fff017d, 0x018b010eba4ebe97, 0x38daff3b9f2084ff, 0x010e01a25a043a35, 0xffb961273fff019d, 0x01ab000a3b756de5, 0x4140ff3b885edbff,
        0x011101f868043c2e, 0x000d01ca010701d8, 0xff398a4996ff01c5, 0x01d302073a4688f5, 0x6003ffb73f3f00ff, 0x580501ea000db9ea, 0xff3bad894eff01e5, 0x01f3000a3ab55b35,
        0x99b4ff3bf46d43ff, 0x7204021c030b3c67, 0x92ff02090111020e, 0xbbfec239ffb85f27, 0xe7b59aff02170207, 0x010ab9ac6765ffb8, 0x09ff0229020d022e, 0x39cca986ffb986c5,
        0x0d735dff0237a204, 0x0013399f7198ffbb, 0x03e8000000050000, 0x023c000000010000, 0x0002000000000000, 0x6f0500948d050120, 0xa004003001110050, 0x39ff001d97040022,
        0x398a00f3ffb82a92, 0x5d2d9bff002b090e, 0x6e053996bdfdffba, 0xfbff003d000a0042, 0x3a15f1c4ffb9d115, 0xd86f01ff004b7604, 0x020dbc89c137ff3a, 0x7e040066010d0074,
        0xff398da845ff0061, 0x006f9204b9e4b6e9, 0xe715ffbb834ad5ff, 0x8604008602073a1e, 0xffba262c8dff0081, 0x008f01123aa12b69, 0x1e50ffba85c754ff, 0x011200dca904bc0d,
        0xa10400aea40400bc, 0xffb89f6a22ff00a9, 0x00b79005b9e617b3, 0x8e1affb95ce872ff, 0x930400ce9a043973, 0xffba7b703aff00c9, 0x00d79c04bc044cfa, 0xf065ff3b25fb8aff,
        0x01110100010dbb11, 0x84ff00edb80400f2, 0xb81e7b04ffb97bdd, 0x5a87b9ff00fb9a05, 0x010bb8a4e6ddff3b, 0x80ff010d01120112, 0x3bf79c6eff3aaca4, 0x6a5b3dff011bb904,
        0x640439a1c5e8ffba, 0x4204016c011101b0, 0x0107013e0011014c, 0xffb930d976ff0139, 0x01472005b9ee4795, 0x49aeff3904f543ff, 0x0107015e030bb8f9, 0xff38686545ff0159,
        0x0167000eb8f5501d, 0x61d9ffb9d0057bff, 0x610501900007393c, 0x93ff017d010a0182, 0x3aa5add0ffbb5436, 0x29e434ff018b010e, 0x5a04baa45aa7ff3b, 0xe8ff019d000d01a2,
        0xb9341f43ff3b4457, 0x5a3163ff01ab000a, 0x020e3c0b6769ff3b, 0xb30401d8011101f8, 0x31ff01c5010a01ca, 0xb9da7c60ffb78953, 0x21797dff01d3b504, 0x79053980e16cff3b,
        0x95ff01e5010d01ea, 0xbaac7890ffbc03b3, 0x13a5dfff01f3010a, 0x030e3baa9a4affba, 0xbc04020e0112021c, 0xff3a27d449ff0209, 0x02179f04baffcfc2, 0xfc97ffbbe40777ff,
        0xa604022e93053bc6, 0xffb9b59b2bff0229, 0x0237aa0439f2ada2, 0xf2c8ff3ad8bcbfff, 0x000500000013b9dc, 0x0001000003e80000, 0x00000000023c0000, 0x8d05012000020000,
        0x680500506e050094, 0x000a002202070030, 0xffb92a1db8ff001d, 0x002b100e38ece08a, 0x919eff385f13d0ff, 0x6e040042070b39cb, 0xffb9c8b90eff003d, 0x004b01113af080e4,
        0xcdf4ffb8bc491eff, 0x020b0074010dbb4d, 0xc8ff006193040066, 0xbb3412d2ff395c68, 0x451873ff006fab04, 0x01073a2ebfd4ffb9, 0x52ff008171050086, 0x39811dcbffba59aa,
        0x2039acff008f7605, 0xa904baa7cbaaff3b, 0xa40400bc011100dc, 0x63ff00a9000a00ae, 0xb9c1460effb830de, 0x30b9f6ff00b79005, 0x010e3942d818ffb9, 0x73ff00c98d0400ce,
        0xbaf79391ffbbf26b, 0x0b5d89ff00d7020d, 0x010d3bcd80e7ffba, 0x030b00f201120100, 0xffb9c96294ff00ed, 0x00fb9a05361a716e, 0xec20ff3b2ed2fbff, 0x01110112010bb883,
        0xff3a8a1d34ff010d, 0x011bae043bc616bf, 0x631bff3ae4f4c5ff, 0xad0401b00112b9d3, 0x9804014c7f05016c, 0x6dff01398d04013e, 0xba43306eff388c34, 0xd54746ff0147000a,
        0x01073a3c1c4effb8, 0x31ff0159010e015e, 0xb9980f9eff36c07a, 0x54adb8ff01678205, 0xbb04b8f80949ffba, 0xb504018200110190, 0xffb9f0c9ceff017d, 0x018b000ab8983513,
        0x1039ff38d8f3a0ff, 0xbd0401a291053a7d, 0xffbb5059d3ff019d, 0x01ab0011ba1cac92, 0xd81bff3a335fc8ff, 0x580501f86f04b9b8, 0x010d01ca5a0401d8, 0xff3a54980cff01c5,
        0x01d3000d3bbb81ee, 0x52e8ff3b77f646ff, 0x640401ea010d3bfe, 0xff39901498ff01e5, 0x01f3010e3baac1cb, 0xa154ffbb87d540ff, 0x8204021c010abc17, 0xf5ff0209010d020e,
        0x3c492252ffbb9e3b, 0xb7e54eff0217020e, 0xa404b8ab24eaffba, 0x41ff02290207022e, 0xbbcfed8affba5048, 0x10f1b6ff0237a804, 0x00133ad13e71ff3c, 0x03e8000000050000,
        0x023c000000010000, 0x0002000000000000, 0x6e0500948d050120, 0x090600300a050050, 0xd7ff001d01110022, 0xba7fdee1ffb8d0e8, 0x014812ff002ba404, 0x6d053af9ef5effba,
        0xdfff003d79040042, 0x38bf4419ff3861be, 0x91330dff004b0111, 0x010d3bc241e8ffb9, 0x93040066020b0074, 0xff393053caff0061, 0x006fa804bb100f11, 0xb0b7ffb94864cdff,
        0x7105008601073a28, 0xffba2e21dbff0081, 0x008f9204394e95f2, 0xc25fff3b8ffce6ff, 0x011200dca904ba47, 0x000700aea40400bc, 0xffb7bd25ccff00a9, 0x00b70107b9aad932,
        0x6eebff382af71eff, 0xa40400cea8043a01, 0xffbaa84d5fff00c9, 0x00d7010d3b953baf, 0x7906ffbaa9af15ff, 0x01110100010dbcd9, 0x4dff00edbe0400f2, 0x39e51f3effb8dd0d,
        0x2df4a9ff00fbb304, 0xb904396e7860ff3b, 0xcfff010d01120112, 0xbb9c0754ffb5d1cb, 0x704ef5ff011b0112, 0x94043c0e362fffb9, 0x020a016c410501b0, 0x7a04013e0111014c,
        0xffb7ba6aecff0139, 0x0147010d3a8698b0, 0x48a6ff3a8e1ee9ff, 0x3405015e01123c0c, 0xff39fc0d2fff0159, 0x01677a04ba728128, 0x5800ffbcbde611ff, 0x02070190010dba05,
        0x20ff017d00070182, 0xb933be08ff3950ed, 0xc77365ff018b0111, 0x020dbbd0ac2fffb9, 0x24ff019d011201a2, 0xbcce5808ffbac2ad, 0x9c6f3bff01ab8804, 0x020abb151faaff3a,
        0x000a01d8050b01f8, 0xa2ff01c5010e01ca, 0xb9cc0372ffba00fe, 0xef7f0dff01d34b05, 0x000d3a3b8e9bffb9, 0x2dff01e5010a01ea, 0xba5737c0ff383173, 0x805735ff01f39205,
        0x9804b9333de5ff3a, 0x7405020e0111021c, 0xffba90effeff0209, 0x0217000738f676cb, 0x6853ffba8f38c5ff, 0x0111022e8005bc31, 0xff3a1b376cff0229, 0x0237b7043bb249e3,
        0x83f4ff3ae76d59ff, 0x000500000013baca, 0x0001000003e80000, 0x00000000023c0000, 0x8d05012000020000, 0x011100506f050094, 0x97040022a0040030, 0xffb83e1c0fff001d,
        0x002ba50439237519, 0x1ad4ffba123a60ff, 0x4b050042550539bf, 0xff3959e299ff003d, 0x004b7204bb0b0fec, 0x6f1bffb9cda4dfff, 0x010d0074020d3b6a, 0x18ff00617d040066,
        0xb9a856c1ff398e6d, 0x5614b4ff006f9204, 0x02073a0fc609ffbb, 0x4dff008186040086, 0x3a70de99ffba0f01, 0x0d70a8ff008f0112, 0xa904bbd949c3ffba, 0x000e00bc011100dc,
        0x4cff00a9650400ae, 0xba0416c9ff38225c, 0x027c2bff00b78f05, 0x9704382062d3ffb9, 0x9bff00c9910400ce, 0xbbb547f6ffb9ddcb, 0x063e7dff00d79c04, 0x0111bab0a3f5ff3b,
        0x010b00f2040d0100, 0xff3a1e0b03ff00ed, 0x00fb8f05b8bf97a9, 0x2095ff3a132ca9ff, 0xb5040112bd043b01, 0xff381b5d04ff010d, 0x011b00073b44ec4c, 0x5481ffbc88c9e5ff,
        0xac0401b00112bc1d, 0x060d014ca404016c, 0x4fff0139040b013e, 0x38b20694ffb85e44, 0x267c4bff0147030e, 0x000abb1cdaa7ff3a, 0x0cff0159a704015e, 0xb936fa8bffba70f5,
        0xf4f589ff0167000d, 0xba043a8786f0ffb9, 0x8b05018202070190, 0xff3a506c0cff017d, 0x018b720538ed734f, 0x00aaff39f48ad7ff, 0xbd0401a28a05b94e, 0xffbb870f3dff019d,
        0x01ab060eba3b2c95, 0xe327ff381b4db2ff, 0x6d0501f89705ba9c, 0x020a01ca820401d8, 0xff3ab5d58fff01c5, 0x01d39804bc89f452, 0x04e4ffbbd1dd8bff, 0x800401ea020db9a3,
        0xffbad4e100ff01e5, 0x01f384053a8e197c, 0xb2b8ffbc218799ff, 0x010d021cb7043b19, 0x35ff0209ab04020e, 0xbae8d4d7ff3b0efd, 0x4bb671ff02179805, 0xb8043ba65767ff3c,
        0xb3ff0229000a022e, 0xbc5bb14dffbb653c, 0x2878bdff0237000a, 0x00133b95105cffbb, 0x03e8000000050000, 0x023c000000010000, 0x020a000000000000, 0x010d009400020120,
        0x6f05003094040050, 0xc4ff001d73040022, 0x3a4c020bffb92c35, 0x9bf34dff002b9304, 0x2205bb967d17ff38, 0xaaff003d30010042, 0x3b3d9c7affbaea60, 0x9e9f11ff004b0111,
        0x9704ba361b46ff38, 0x8204006686040074, 0xff38f5775aff0061, 0x006f0111b9efbf9f, 0xd0f2ffb8794790ff, 0x030b0086140e3c01, 0xff3975d506ff0081, 0x008f2701ba015aa6,
        0xb8bdff3ab0b4e8ff, 0x030d00dc7705ba97, 0x011200ae720400bc, 0xffb726e719ff00a9, 0x00b7820439748aa5, 0x7f1aff39b41adbff, 0x840400ce7405ba24, 0xff3aa2552cff00c9,
        0x00d70112b981d0a9, 0x828bff39491321ff, 0xa7040100ab04bc81, 0xa7ff00ed020d00f2, 0xba11cacdff39637d, 0x097867ff00fb0111, 0xae043bbe9b1fff39, 0x03ff010d01110112,
        0xbb313e0cffb850cb, 0x2de3b4ff011bb704, 0x7005b9aeab53ff39, 0x2101016c2c0101b0, 0x130e013e2205014c, 0xffb90decacff0139, 0x0147180ebb4a1ad4, 0x3013ff39c5d6b7ff,
        0x050b015e0111bb79, 0xff394e22faff0159, 0x01672801ba1642e5, 0x6535ff3abed91aff, 0x4101019042013c20, 0xd0ff017d3e010182, 0xbaf18ebfff3a6dc5, 0x7768b5ff018b4a05,
        0x81043bef70a2ff3c, 0xa0ff019d000201a2, 0xbbad13feff3b32e2, 0x039033ff01ab0002, 0x00073adf40bdffbb, 0x8a0401d8011101f8, 0x70ff01c5001101ca, 0xba4eee33ffb84cbf,
        0xb28196ff01d39905, 0x7d05b9185e99ff39, 0x0cff01e5060e01ea, 0x3b4324e4ff3c2de9, 0xe6d0c0ff01f39805, 0x98043c12ec92ff3a, 0x0111020e0002021c, 0xff3ae34f27ff0209,
        0x021701123d30f801, 0xc7fdffba3d6bc9ff, 0x0111022ea204bbe8, 0xff3ac46d6fff0229, 0x0237a504bbd40d00, 0x61eaffbb2a1520ff, 0x000500000013b7f6, 0x0001000003e80000,
        0x00000000023c0000, 0x8d05012000020000, 0x011100506f050094, 0x0d0e00229f040030, 0xffb79413caff001d, 0x002b040eb985ff55, 0x1b75ffbab1dda4ff, 0x600500426d0538d5,
        0xff38f22605ff003d, 0x004b010e3916d46a, 0x34a9ff3bdeca31ff, 0x710500740007bb8f, 0xcbff0061000a0066, 0xbb1462eaff3a213d, 0x7c1ca7ff006f010d, 0x0107ba058372ff38,
        0xf8ff0081080b0086, 0xba0df303ff3a825d, 0xd6ed3fff008f8b05, 0xa9043a93940cffb9, 0x990500bc011100dc, 0x4bff00a9000700ae, 0xb91aa900ff380e65, 0x94c867ff00b7000a,
        0x000dbb107e32ffb9, 0x38ff00c9000700ce, 0xbab63169ff3a9fdb, 0x97c42dff00d79704, 0x0111ba024e2affbb, 0x980500f200070100, 0xff39901002ff00ed, 0x00fb030b36335afe,
        0x1200ffb9c4d729ff, 0x030b0112050bb816, 0xff3a1ea783ff010d, 0x011b010dbb8827ef, 0x5f32ff3b088005ff, 0x010a01b094043c22, 0x0111014c020b016c, 0xd6ff01399104013e,
        0xbb063beeff37d931, 0xc0024dff01478c04, 0x89043c449dddff3a, 0x66ff01597405015e, 0xb9cca876ff35c238, 0xb094c6ff01670111, 0x9204bbc551a5ffb8, 0x8304018290040190,
        0xff3a9d452bff017d, 0x018b0112ba538ce8, 0x951fffbb09bd27ff, 0x010701a201123cb5, 0xff3ab6b4c8ff019d, 0x01ab5d05bacdad27, 0xbb5fffbcc27db8ff, 0x050b01f8020abc48,
        0x020d01caa50401d8, 0xff38a91972ff01c5, 0x01d3aa04ba271f6b, 0xfca9ff3a9b1509ff, 0x020d01ea090bb891, 0xff3a263318ff01e5, 0x01f301113b04067a, 0x25c2ff38f92a6dff,
        0xb804021c060eba3f, 0xf6ff0209b704020e, 0xbb7a3029ffb8b48f, 0xcc22e7ff0217030b, 0x01113b2de500ff3b, 0x83ff02292005022e, 0x39a7f5faff3b17d7, 0x13a002ff02376d05,
        0x00133b76a60bff3c, 0x03e8000000050000, 0x0233000000010000, 0x020a000000000000, 0x010d009400020120, 0x5e05003094040050, 0x6dff001d68040022, 0x39143598ffb8ec1f,
        0x38bd72ff002b0111, 0x22053a11e17dffb8, 0x42ff003d95040042, 0xb890eadbff3bb6cf, 0xa3ed42ff004b0111, 0x0111ba1730fdff38, 0x890400668b040074, 0xffb6c38badff0061,
        0x006f000a397cd350, 0x1305ffb9514d92ff, 0x020b0086810536ec, 0xffb9933f84ff0081, 0x008f91043afe9a08, 0xc4c0ff3b9f167cff, 0x020d00dc0111babc, 0x410500ae010d00bc,
        0xff396b5f81ff00a9, 0x00b7000ab899be41, 0x9e7fffba393e07ff, 0x8e0500ce00073a5d, 0xffba173cedff00c9, 0x00d77a043920e5d4, 0x7102ffb9a8e452ff, 0x7a0501009b0539c5,
        0x03ff00ed4b0500f2, 0xbab9a3c5ffb8b6f1, 0x9525a0ff00fb030b, 0x0007b92c1c80ff3a, 0x2fff010d010b0112, 0xba9dd3f4ff3b23bb, 0x13f45dff011b9c05, 0x7405bb3b3c55ffbc,
        0x060b016c011101b0, 0xa004013eaa04014c, 0xff385e2293ff0139, 0x01473f01b9e0968b, 0x57b4ff3b58b1dcff, 0x3901015e660539e1, 0xffb9a6b4f3ff0159, 0x0167a904bad30535,
        0x23f2ff3a74f713ff, 0x010b0190030e3988, 0xd2ff017d2f040182, 0xbb95505effbb2d0a, 0xb82f5eff018b0007, 0x1801bc091ac8ffbb, 0x68ff019d060e01a2, 0xbb279e9aff38afb2,
        0x301e8dff01ab7404, 0x0007ba3b12dfff3b, 0x910501d8011201f8, 0x60ff01c5900401ca, 0x38870c64ff3aa858, 0xc82a35ff01d39205, 0xae04398d00f5ff3a, 0x5dff01e5ac0401ea,
        0xbb64bc0eff3ae06c, 0x353a80ff01f3b104, 0xa4043b3928d0ff3c, 0x000d020e01070213, 0xffbb8588e5ff0209, 0xddc100ff3a4156f8, 0x20011202258005b9, 0x9fffb9a136e3ff02,
        0xff022e84053b7772, 0xc9595cffbb0e5e1e, 0x00000500000013b7, 0x000001000003e800, 0x0000000000022a00, 0x94b7040120020a00, 0x3066040050660500, 0x1d01110022540400,
        0xc5ffb704776aff00, 0xff002b000ab9e4be, 0x019a02ffb9601e18, 0x3d000d004201113a, 0xa1ffb93d699eff00, 0xff004b4f0538e079, 0xdf04bdff398769ff, 0x66011100746e053a,
        0xa99aff0061020700, 0x04ba008386ff3801, 0xbad9ccf4ff006f6e, 0x867c043b3369f7ff, 0x63bdff0081790400, 0x05ba8bdf67ff3929, 0xb9334a7bff008f78, 0xdc8f05b78ab977ff,
        0xae060e00bc140e00, 0xa731ff00a9050d00, 0x113b10fefeffb913, 0x38c726b0ff00b701, 0xce030d3b1762b2ff, 0xea2aff00c90a0600, 0x013b0aed48ffb9da, 0x37d62eedff00d730,
        0x000111bb090e46ff, 0xed030b00f2060e01, 0x51ffb8b511f5ff00, 0xff00fb010a3918e4, 0x8d0093ffb9f7f69e, 0x0d020d0112b80439, 0x38ffbbaee1d0ff01, 0xff011b010a3cb197,
        0xeac58fffb9d283d9, 0x6c2c0501b070053b, 0x3e2301014c420101, 0x25abff0139030e01, 0x11b8a5f508ffbaf6, 0x3a01b8d6ff014701, 0x5e010b3b6ed42aff, 0x8f10ff0159011201,
        0x113c4896c6ff3abc, 0xb9998226ff016701, 0x904201bb861d65ff, 0x7d4b050182410101, 0xd3ff39db82f2ff01, 0xff018b0112ba6c6f, 0x6b7c50ffba302e12, 0x9d011101a230053c,
        0xe6ffba0f9c55ff01, 0xff01ab3a05bd0949, 0x291400ff3ad13013, 0xc6890401e69004ba, 0x5a55ff01c1710501, 0x12bac4141effba98, 0xff01d3780501d801, 0xe9c335ff3938f021,
        0x0d66ff01e100023a, 0x073be1f285ff3c30, 0x0401fc0112020a00, 0xb845a171ff01f7ae, 0x059805399523f0ff, 0x58ff3a8a3a3eff02, 0x05021c01073bc46e, 0x3ac86088ff021774,
        0x25060eba4b7b46ff, 0x0cff380e3befff02, 0x05000000133a94de, 0x01000003e8000000, 0x000000023c000000, 0x040120020a000000, 0x01005064050094b7, 0x0700228f04003042,
        0xb774e125ff001d02, 0x2b000739d88c29ff, 0x3bffba12fd43ff00, 0x0b00425f053af88c, 0xb8dc76a7ff003d0a, 0x4b6005b943b652ff, 0x9eff3b4b1341ff00, 0x050074010ab99a81,
        0xff0061020d006684, 0x32a5edffb8bf55e0, 0x6489ff006f860538, 0x0bb754357bffb904, 0xff00810111008603, 0x342fa5ffb922aef6, 0xae70ff008fa5043b, 0x0539fae89fffba9f,
        0x0e00bc140e00dc8f, 0xff00a90c0600ae06, 0x12e9fdff3904ea00, 0x5145ff00b7050dbb, 0x0dba85f4d2ff3ad2, 0xff00c90a0600ce03, 0xde4870ffb9af21c5, 0x58edff00d730013a,
        0x11badb4a09ff37ab, 0x0400f20002010001, 0xba08f08fff00edb8, 0xfb9105b78557b2ff, 0x19ffbabe1ce0ff00, 0x040112060e3946e2, 0xbb8642ffff010db8, 0x1b000a3856abd2ff,
        0x11ff3c02b628ff01, 0x1101b074053ba18f, 0x04014c030b016c01, 0xff01398604013eab, 0xc5b733ff3805c924, 0xff0cff0147680537, 0x0bba56c8aaff3a82, 0xff01592d01015e06,
        0x1b59e2ffb8efcc92, 0xdba3ff01675c053a, 0x0e3981f62dffb9d6, 0x040182010b019003, 0xbaf2b084ff017d2f, 0x8b3004bb84c3baff, 0xe8ffbbb375edff01, 0x0101a2a404bbce2c,
        0x39caabf3ff019d39, 0xab010bbb01769bff, 0xc1ff3c7aed9aff01, 0x0401f8ae043b5603, 0x0701caa80401d8ad, 0x3987fa17ff01c500, 0xd30112babd5572ff, 0x4eff39885148ff01,
        0x0501ea01123b9641, 0x3ae66a40ff01e57e, 0xf37e05ba296462ff, 0x70ff3acf9620ff01, 0x11021cb704bbc496, 0xff0209b504020e01, 0x55aa9aff39cdf38b, 0x6915ff0217010bba,
        0x123b9aa1b2ff3aec, 0xff02297505022e01, 0x3f6c55ff3b8e93a6, 0xc965ff0237ba0439, 0x133b96231bffbbb0, 0xe800000005000000, 0x3300000001000003, 0x0a00000000000002,
        0x050094b704012002, 0x0400304f04005064, 0xff001d010a002237, 0xada76affb94334f9, 0x090fff002b490438, 0x05ba0874ccff3992, 0xff003d420100425c, 0x9cae97ff39f78015,
        0x1507ff004b5d05b8, 0x0a39f0f287ffbad5, 0x0d00668405007401, 0xb89911a1ff006102, 0x6f010b380eeb19ff, 0x23ff39e927f4ff00, 0x110086030bb8436a, 0xb902258fff008101,
        0x8f01113b102623ff, 0x25ff38827c19ff00, 0x0e00dc8f05baf3ad, 0x0e00ae060e00bc0f, 0x3a42dd9cff00a902, 0xb70111b9a0d158ff, 0xe2ffb9806c72ff00, 0x0e00ce040d3b5599,
        0x3ab4dbb8ff00c917, 0xd73001b9ef58bbff, 0x3effb96b6699ff00, 0x0201000111bae04c, 0xff00ed010a00f200, 0x0b68edffb8ae6547, 0x5b17ff00fbbc0439, 0x02b93495acff3991,
        0xff010d9b05011200, 0x84b3d9ff3bc529d6, 0x3d15ff011bb804ba, 0x0536b957b5ffbb83, 0x01016c2c0501b070, 0x04013e3001014c42, 0x384d0cf1ff013934, 0x470111b92dd0f1ff,
        0x09ff3a5e14c3ff01, 0x11015e010b3b9d48, 0x3a961eb8ff015901, 0x6720053c26f1beff, 0x5bffbb87ba59ff01, 0x040190060eb9db3f, 0xff017d0002018281, 0x899ce6ff39b5885c,
        0xf28fff018b0111bb, 0x11bb957916ffb961, 0xff019d4b0501a201, 0xee251cff3999a359, 0xb7c5ff01ab9904b9, 0x043c1b84a0ff3ae7, 0x0501d8011101f898, 0xff01c5970401ca73,
        0x6461e8ffbaf93369, 0xbc8aff01d3000d3a, 0x02ba6cddfcff3987, 0xff01e5740501ea00, 0xb8e5cdff3d0db5f5, 0x14aaff01f38a043b, 0x04bb77ea0dff3c2f, 0x04020e060e02139f,
        0xba0ccb60ff02099b, 0x125cffbbc6d62fff, 0x0112022500073c1e, 0xff391e22e2ff0220, 0x022eb5043ad656c6, 0x254cffba0c928fff, 0x0005000000133961, 0x0001000003e80000,
        0x0000000002330000, 0xb7040120020a0000, 0x5a05005066050094, 0x650400220f0e0030, 0xffb7bef8c2ff001d, 0x002b110e3971c75f, 0x70f9ff3a887875ff, 0x74040042020dba0a,
        0xffb9ab9b82ff003d, 0x004b3e0139b2abda, 0xebc9ff3ae5dc3fff, 0x010a0074020db817, 0x5aff006170050066, 0xb81aaaedffb911cf, 0x7dade7ff006fb604, 0x01113b803ec3ff37,
        0x00ff008100070086, 0x395914cdffb94a25, 0x0cb6b2ff008f050b, 0x010a3c5bf668ffba, 0x120e00bc010b00dc, 0xd8ff00a90c0600ae, 0xba4d2de6ff3a8c2e, 0x9099a3ff00b7030d,
        0x9a05baa31109ff39, 0xb2ff00c9990500ce, 0x3a53cdf3ffb9115f, 0x609190ff00d7030b, 0xb80438c1b208ffba, 0x011200f2060e0100, 0xff3857447aff00ed, 0x00fb0111bba3cdee,
        0x242dffb90fef87ff, 0xb904011200023c08, 0xff3a9f51d9ff010d, 0x011b010d38f401cf, 0xb927ff3b22eb17ff, 0x2c0501b07005bab4, 0x2301014c4201016c, 0x80ff0139130e013e,
        0xbae99d83ffb838ee, 0xae90cfff01470112, 0x010b3b2ae3a9ff39, 0x23ff01590112015e, 0x3c058e32ff3a7031, 0xeb66ebff01670112, 0x060ebb2d72a8ffb8, 0x3f01018281040190,
        0xffb93b0091ff017d, 0x018b01113ad812ef, 0x281affb934c214ff, 0x320501a20112bb6f, 0xff3a46afbaff019d, 0x01ab2801b903c5b8, 0x4d77ffba97bc09ff, 0x011101ef94043bf9,
        0x7d0501ca910401d8, 0xff397c42dbff01c5, 0x01d3000dbab42868, 0x1834ff3b0d6518ff, 0x88ff01e18a043aa5, 0xff01ea00023c0c10, 0x5a2130ff3b93eb0b, 0x05010b0213b004bb,
        0x4e53ff0200aa0402, 0x07bb9fe6deffba1e, 0x39242798ff020e02, 0x25b304bc0ee858ff, 0xf362ff0220011102, 0x0b3bc65259ff3a47, 0x3aea78f0ff022e01, 0x00001336908f3eff,
        0x0003e80000000500, 0x00023c0000000100, 0x20020a0000000000, 0x50010d0094000201, 0x225e050030940400, 0xc18bff001d680400, 0x1138798ddeffb88b, 0xb77bd0d5ff002b01,
        0x42220539b95a64ff, 0x7600ff003d390100, 0x113b850eafffba24, 0x388ba14dff004b01, 0x740111ba2322bdff, 0x612f010066680400, 0x7affb8755997ff00, 0xff006f020b38a081,
        0xbc6e6affb9abc2cc, 0x81020b00868105b7, 0xfbffb93bd9d8ff00, 0xff008fb9043ac5af, 0xd4020effba8803de, 0xbc000a00dc01123b, 0xa99a0400ae9e0400, 0xdbff37f503ceff00,
        0xff00b7a7043a0d73, 0x97168cffb9da4a2b, 0xc9060e00ce9804b8, 0x3dffb8d9a9c0ff00, 0xff00d700113a6ac6, 0x04706affb9b02de7, 0xf268040100010e3a, 0x8d75ff00ed560400,
        0x043b96964affbab4, 0xbb37e134ff00fb8b, 0x12090bb9a89319ff, 0x814bff010d020701, 0x0a3a6ba2cfff390e, 0x39a2ebebff011b01, 0xb00207bb6c8b7cff, 0x4c060e016c010701,
        0x394b04013e5f0401, 0xd4ff3854df37ff01, 0xff01473a013a8e9b, 0x61a9f1ffba6aaf46, 0x590111015e1a0139, 0xbbffb94617a4ff01, 0xff01677104ba8d46, 0x3dda10ff3c19fada,
        0x82011101900e0539, 0x0241ff017d060e01, 0x0eb9a1f434ff38fe, 0xb9d9944dff018b06, 0xa27404bb8e0e12ff, 0xb4f8ff019d6e0401, 0x043b7ab298ff3983, 0xbc5f67f6ff01ab76,
        0xf80203b8941556ff, 0xca420401d8011201, 0xe4ccff01c5060e01, 0x04b8c160c6ff3968, 0xb9405588ff01d357, 0xea2a04ba0cdd26ff, 0x2f70ff01e5000501, 0x053acf4b08ffba84,
        0xbc1ef432ff01f302, 0x1c2405bb723ff1ff, 0x090112020e060302, 0xa4ff39ae06f6ff02, 0xff02170111babe01, 0xf26e07ff39a08710, 0x290112022ea1043a, 0x75ffba1e2714ff02,
        0xff0237a204bba24c, 0x88e45bff3bca4f31, 0x0000050000001339, 0x000001000003e800, 0x0000000000023c00, 0x94b7040120020a00, 0x3001110050680500, 0x1d96040022640500,
        0x55ffb77869e4ff00, 0xff002bb5043932d7, 0x3c075cffb8f1eaed, 0x3d5405004264053b, 0x70ffb70d4a2aff00, 0xff004b5e0439de14, 0x0ba45effbb822f2b, 0x6602070074020b3b,
        0x8a70ff0061690500, 0x05b9037970ffba55, 0xbafa2184ff006f84, 0x8669053b8129d6ff, 0x904bff0081930400, 0x0dbbd28678ffb9ba, 0x38001ceaff008f01, 0xdc9d053907f55bff,
        0xae010b00bcba0400, 0x0738ff00a9940500, 0x0e3a40f938ff3b90, 0xb8ee09bcff00b706, 0xce040d3a9136ddff, 0x890aff00c90c0600, 0x0ebb317cd1ff3806, 0x3aa1399fff00d709,
        0x000111ba811831ff, 0xedbc0400f2030b01, 0x00ff38ea2f09ff00, 0xff00fb0a0bb98f12, 0xc889acff3a45f47e, 0x0db9040112bb04b7, 0x36ffbb6a4c91ff01, 0xff011b010b3b10a7,
        0xb2cad6ff39247149, 0x6c540501b07105bb, 0x3e4f05014c000201, 0x843aff01393f0501, 0x0539da0493ff359a, 0xbbf47facff014750, 0x5e7a043a281c54ff, 0x0ddcff0159011201,
        0x04bc6467b5ff3aeb, 0x3b699679ff01678a, 0x905605b92e6ea2ff, 0x7d030b0182011201, 0xc0ffb9f94711ff01, 0xff018b6f04bb5d15, 0xa82e69ffbaa70ab0, 0x9d5d0501a26205bc,
        0xe9ffba2f294cff01, 0xff01ab00023b1d29, 0xeee81bffba7f0a4e, 0xd8011201f890043a, 0xc5890401ca7c0501, 0x39ffba6f2d64ff01, 0xff01d300023836e1, 0x38adc0ff3b1d9eaa,
        0xe58d0401ea00023a, 0xd8ffbb194c90ff01, 0xff01f38a043c7a55, 0x315310ff3bdeb164, 0x0e7405021ca104bb, 0xc040ff0209000202, 0x11baad5007ff3bd1, 0x387c36b3ff021701,
        0x2e0007bb2d9ac2ff, 0x929dff0229011202, 0x053ab43470ff38a6, 0x39cf122eff023780, 0x000013b9c721afff, 0x0003e80000000500, 0x0002330000000100, 0x20020a0000000000,
        0x5064050094b70401, 0x22000a00304e0400, 0xe825ff001d460400, 0x04382db51cffb8cb, 0x383edd90ff002b48, 0x420002ba715e81ff, 0xbce0ff003d620500, 0x05ba13aa45ff38f5,
        0xb8d1760fff004b52, 0x74010ab9715075ff, 0x61020d0066840500, 0xe4ffb83263e5ff00, 0xff006f8605b70abb, 0x0fcdd9ffb8dd59fb, 0x8101110086030bb5, 0x61ffb8f09febff00,
        0xff008fa5043ae1f4, 0xcca39bffba6c4ca0, 0xbc140e00dc8f0539, 0xa9011100ae8b0500, 0x30ffb904421eff00, 0xff00b701113a9460, 0x470561ff39426bdd, 0xc9060100ce3001bb,
        0xc9ffbb4ab654ff00, 0xff00d7030d3a1882, 0x4c7580ff3890f5db, 0xf2060e01000111ba, 0x8ed9ff00edba0400, 0x02b81a6726ff392b, 0xb93c5beeff00fb00, 0x12060eba2ea9ebff,
        0x62a2ff010d000201, 0x0abab6a076ff3aea, 0x3bd35537ff011b00, 0xb070053b76e63bff, 0x4c4201016c2c0501, 0x392b04013e300101, 0x92ff38834383ff01, 0xff01470112b8e669,
        0x4720e4ff3a051667, 0x597a04015e7c043b, 0xdeffba74c07aff01, 0xff016781043b8236, 0xcf469dff3bbe59f6, 0x82011101903005ba, 0x8b4eff017da90401, 0x073af22e0dff3868,
        0xbb1d75d4ff018b02, 0xa28d04bcc2dc15ff, 0x22a8ff019d880401, 0x013b38a5d8ff389c, 0xbb90e6caff01ab1e, 0xef9004b94acd18ff, 0xca750501d8011201, 0x8a58ff01c5001201,
        0x05b98df333ffb8a7, 0x39e024f0ff01d376, 0xe174053a43064cff, 0x00023bb22784ff01, 0xff3ba99bc4ff01ea, 0x0213b004bb0ddc10, 0x020077050205010b, 0xf1eeffb9944512ff,
        0x6fff020e0207bb05, 0xbbe8f3a0ff388d2a, 0x022001110225b404, 0x519cff3a2d69feff, 0x20ff022eb5043b9b, 0x393bd0f1ffbadbdd, 0x0000000500000013, 0x00000001000003e8,
        0x000000000000023c, 0x0094b7040120020a, 0x00304f0400506405, 0x001d430500223904, 0xadd8ffb8a6f945ff, 0x86ff002b4101b903, 0xb8a25d5bff395390, 0x003d060b00425c05,
        0xc463ff3897aa08ff, 0xf1ff004b010a37df, 0xb875149dff38d14c, 0x006684050074010a, 0x0eb687ff0061020d, 0x0002b6ddf7d1ffb8, 0xffb93fc66dff006f, 0x0086030b396c6531,
        0xc07febff00810111, 0x01123ab4c381ffb8, 0xff389193c1ff008f, 0x00dc8f05bab767a0, 0x00ae030b00bc0f0e, 0xa4f76fff00a90111, 0x80053ab90d6dffb8, 0xff3a5e6310ff00b7,
        0x00ce050db9873c5f, 0x37e725ff00c9170e, 0x0a06b9932745ff3a, 0xffba12d418ff00d7, 0x01000111bb1b0bbc, 0x00edba0400f2060e, 0x0b7eff39093f1eff, 0xd0ff00fb0007b7f7,
        0xb9e8f792ff362917, 0x010d010d0112bc04, 0xeb7bffba4dc453ff, 0xe6ff011b030b3b2a, 0x39decad7ffbbae1d, 0x016c540501b07105, 0x013e4f05014c0002, 0x3ab21dff01393d05,
        0x500539a889bdff35, 0xffbbc3cb59ff0147, 0x015e7a0439fbfcb2, 0xc2e68cff01590112, 0x0112bc35ddedff3a, 0xffb9970421ff0167, 0x019056053b28eb15, 0x017d030b01820111,
        0x10b4ffb9b8c269ff, 0xd0ff018b6f04bb42, 0xbc865fdcffba8795, 0x019d5d0501a26205, 0xd444ffba08ea21ff, 0xebff01ab00023af3, 0x3ac248fdffba4a96, 0x01d8011101f87705,
        0x01c5b80401ca7605, 0xf99affb9c2c84bff, 0xebff01d300023b16, 0x3b47f7d4ffbbac00, 0x01e5020701eab004, 0x6ac6ff3b10a22aff, 0x40ff01f3060ebb32, 0x3c081bb8ff3a7bfe,
        0x020e060e021c7805, 0x3b3ff2ff02090112, 0x030bbaea1ff0ffba, 0xffbb8aef35ff0217, 0x022e8505bbb3076c, 0x87a004ff02298005, 0xb704baa2fc9fff39, 0xff3a2b2ae3ff0237,
        0x00000013b98bdb87, 0x000003e800000005, 0x0000023c00000001, 0x0120010e00000000, 0x00505c0500946105, 0x0022540500307604, 0x7c280bff001d6c04, 0x000ab9a32df9ff37,
        0xffb912c5feff002b, 0x004279043ab8f2b3, 0x88aab0ff003d0112, 0x80043cdb1f74ff39, 0xff3af3ab51ff004b, 0x00748f04ba97e79b, 0x00618b040066000a, 0x7caaffb99e7e45ff,
        0x2eff006f01113b3f, 0x3bee6c3eff38c702, 0x0081980400860112, 0xa7d0ffbb25b7b4ff, 0x33ff008f00023a12, 0xbc0df375ffbd0d3a, 0x00bc690500dc010d, 0x00a9690400ae6e04,
        0xf35affb996bac9ff, 0xefff00b70107bbd6, 0xba4f7cd1ff3c03d7, 0x00c9011100ce7904, 0x7e5aff35ee0d30ff, 0xa0ff00d77d043b2b, 0xb9955200ff3ab2ce, 0x00f2620401008904,
        0xea9f7dff00ed6104, 0x01113b7d7d2bff39, 0xffb82b716eff00fb, 0x0112b104bb6068d6, 0x953070ff010da804, 0xb804bb11e0bcff39, 0xff3b0670c7ff011b, 0x01b0020eb8eb2c5a,
        0x014c0112016c7804, 0x01392205013e2e01, 0x39feffbafffe36ff, 0x6dff01470012bb4c, 0x39a4d94fffb95844, 0x01594605015e3e01, 0xfc98ff3cced2caff, 0x71ff016769043ce8,
        0x3c9a0b42ff3c2d13, 0x018212050190040d, 0x055890ff017d0705, 0x0002b9a7cb20ffbb, 0xffbb6a18b5ff018b, 0x01a2030bbb09b343, 0xe88130ff019d0b05, 0x040b37314854ff3a,
        0xff39a2e324ff01ab, 0x01f83a05bb568d3c, 0x01ca320401d83904, 0xb927e8ff01c50304, 0x0111b7bc7a22ffb9, 0xff36abc541ff01d3, 0x01ea0111baed181b, 0x9a1ff1ff01e5060e,
        0x0b0eb967abc6ff37, 0xff3a4b149aff01f3, 0x021c180eb9c58249, 0x02090207020e4105, 0x7d49ffb901bc99ff, 0xf5ff0217011139e0, 0xb92b38e8ffb62c19, 0x02290112022e9404,
        0xa076ffb919c304ff, 0x9aff023701123b74, 0xbb89f2b3ffb91945, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094b7040120020a, 0x00304f0400506405,
        0x001d290400223704, 0x762dffb87c5105ff, 0xfaff002b4b05b8a7, 0xb9eccd4cff397b13, 0x003d060b00425c05, 0x3b5cff385e0270ff, 0x7dff004b010a3717, 0xb8cd0165ff3872e4,
        0x006684050074010a, 0x2976a9ff0061020d, 0x8605373a8e05ffb8, 0xffb88d98c1ff006f, 0x0086040b37abb053, 0xf63806ff0081b604, 0xa5043b8bc0a6ff38, 0xffba13beacff008f,
        0x00dc8f0539c69b2b, 0x00ae020e00bc0c06, 0xacdce5ff00a90002, 0x040d3b164c04ffb8, 0xff391bdc62ff00b7, 0x00ce000ab9daf845, 0xdd906bff00c9050d, 0x030d39b71438ff3a,
        0xffbb86eb23ff00d7, 0x01000111bacdc9b7, 0x00edb80400f20002, 0xebd1ffba0bec94ff, 0x53ff00fb91053546, 0x391e55aaffbaa121, 0x010d93050112060e, 0xa88dffbb635177ff,
        0x29ff011bb804b918, 0x3b5eb085ff3bbc19, 0x016c2c0501b07005, 0x013e5904014c1401, 0x184ec6ff01392a05, 0x5b043b3b5cc0ffb8, 0xffbbca9d50ff0147, 0x015e030eb9ef78ba,
        0x69d1e1ff01590111, 0x7404bb7ccbc3ff3a, 0xff39eae176ff0167, 0x0190ae04b8fca532, 0x017d011101820107, 0xcd47ffb8f92527ff, 0x6fff018b74043a4d, 0xba619c81ff3b50a6,
        0x019d160e01a20112, 0x8154ffb7176aa1ff, 0x5aff01abb7043ad0, 0x3b2278a0ff3c3cec, 0x01d8b80401f8050b, 0x01c5b60401cab704, 0x294bffb88bb019ff, 0xbbff01d301113b43,
        0xbbb95766ff3a8a2e, 0x01e5060e01ea0112, 0x5333ffb8abca94ff, 0x60ff01f372053a16, 0x3b45b350ff3be864, 0x020e0007021cbd04, 0xfacd51ff02097a05, 0x7605b76a8785ffba,
        0xff39019951ff0217, 0x022e7f05ba682eb3, 0x80dd20ff02290002, 0x060ebb07b302ff39, 0xffb9355565ff0237, 0x000000133a64caa8, 0x000003e800000005, 0x0000023c00000001,
        0x0120020a00000000, 0x005064050094b704, 0x0022370400304f04, 0x49dadbff001d2904, 0x4704b885f80effb8, 0xff3964ea8aff002b, 0x00425c05b989226e, 0x319b81ff003d060b,
        0x010a36f1f5fcff38, 0xff38425018ff004b, 0x0074010ab8a4013b, 0x0061020d00668405, 0x4003ffb8079256ff, 0x1bff006f86053715, 0x3789599bffb8628e, 0x0081030b0086040b,
        0x2b16ff39a56e26ff, 0xa0ff008fb604baa9, 0x3af32149ffb947bb, 0x00bc010b00dc010a, 0x00a9011200ae010e, 0x29fdff3a250748ff, 0x84ff00b70b063ae2, 0x3a1f70b9ffb9d3a3,
        0x00c97a0500ce9a05, 0x809eff3ba4e61dff, 0x39ff00d7030bb82b, 0x38dee53cffba178b, 0x00f2010e01000111, 0x016650ff00ed050b, 0x030ebaf3992bff37, 0xff3a22d8a5ff00fb,
        0x01129805387545e9, 0x5bc6e5ff010d070b, 0x030bbb215769ff3a, 0xff3b7f83f0ff011b, 0x01b071053bd222b0, 0x014c0002016c5405, 0x01393d05013e4f05, 0x7ffbff36a49223ff,
        0x8dff01476b043995, 0x3a4fd8c7ffbb8184, 0x01592005015e7a04, 0x3e6effbac6d264ff, 0xeeff01678a04bb64, 0xb90b1900ff3b190b, 0x0182011101905605, 0x8dd8adff017d030b,
        0x5505bb1a6182ffb9, 0xffba7988e0ff018b, 0x01a26205bc557103, 0xc9c192ff019d5d05, 0x66053aca78c7ffb9, 0xffbac2580aff01ab, 0x01f8000738c7b2fe, 0x01ca0d0e01d80111,
        0x3a2f40ff01c58e05, 0x76053909d616ffb9, 0xff3a2774d2ff01d3, 0x01ea740539fd9e60, 0x81911cff01e5060e, 0xb7043b362940ff3b, 0xff3a8179d6ff01f3, 0x021cb604bb0dfb52,
        0x0209ae04020e010b, 0x989dffbad57b6aff, 0xc4ff02177205bbbe, 0x37c7112dffbb0293, 0x02298405022e010b, 0x224eff3b93d5b0ff, 0x94ff023780053b3c, 0xb9aa69ebff3a960a,
        0x0000000500000013, 0x00000001000003e8, 0x0000000000000233, 0x0094b7040120020a, 0x00305a0500506605, 0x001d650400220f0e, 0x04a6ffb5bb5c83ff, 0x5fff002b110e38e2,
        0xb9cf016fff3a58e1, 0x003d74040042020d, 0x9d5dffb9860814ff, 0x54ff004b8304396c, 0x3a2956e2ffb9a97f, 0x0066010a0074020d, 0x814f4eff00617005, 0xa504b7a863a4ffb8,
        0xffb9794e4dff006f, 0x0086011139f1751c, 0x33a7d0ff00810007, 0x050b392faac1ffb9, 0xffb9abcda6ff008f, 0x00dc8f053c2c2535, 0x00ae030b00bcba04, 0xfde600ff00a90112,
        0x01123bb91999ffb8, 0xff3973855cff00b7, 0x00ce0c06baa4d5f0, 0x9463bfff00c90b06, 0x020539dd9076ffb9, 0xffbb195940ff00d7, 0x010001113a5f020f, 0x00edb90400f2060e,
        0xd022ff392ba679ff, 0x94ff00fb030b370e, 0xb9ed53ebffb6b1d2, 0x010db9040112bc04, 0xa234ffba98bbf9ff, 0xd0ff011b030b3acc, 0x39c70d38ffbb8a5d, 0x016c011101b07405,
        0x013e1701014c0011, 0x453ae5ff01394404, 0x4f053983d7abffb9, 0xffba54551eff0147, 0x015eaa043898dfc8, 0x2f147dff01594101, 0x5205b99b8deaff38, 0xff3a7cf4a8ff0167,
        0x01901c05b83823be, 0x017d250101821b05, 0xdb0bffb9fa2698ff, 0xc3ff018b17013bbc, 0xbca964d4ffbb2e14, 0x019d250501a22605, 0xaa27ff3b063c61ff, 0x08ff01ab060e3c37,
        0x3b0256b5ffb989a9, 0x01d89b0401f8a104, 0x01c5780501ca9004, 0xd9c9ffba015d86ff, 0x17ff01d382053b18, 0x3ab0a948ffb9982b, 0x01e57f0501ea9f04, 0x33efffbb4771a2ff,
        0xf0ff01f30111bb98, 0xbb545e35ff3a6793, 0x020e011202137605, 0x121a0cff0209b504, 0xc5ffba070295ff3a, 0x0402257705bcaf75, 0x3ba78377ff0220a8, 0x2e7805b9376849ff,
        0xfaffbb54b4b7ff02, 0x0500000013389036, 0x01000003e8000000, 0x000000023c000000, 0x040120020a000000, 0x05005066050094b7, 0x0400220111003057, 0x3806f391ff001d64,
        0x2b5505b91f73b5ff, 0xafffb723ace2ff00, 0x04004201113ae6d9, 0x3519dd4aff003daf, 0x4b7c043a7e7ce1ff, 0x81ff3a07ed23ff00, 0x0a0074020dbb31a2, 0xff00617005006601,
        0x86b5fbffb84ee575, 0xc688ff006f020bb7, 0x1138e206afffb9b4, 0xff00810207008601, 0xb7a17eff3805960d, 0x718fff008f050bb9, 0x053c09b75cffb989, 0x0500bcba0400dc8f,
        0xff00a9011100ae8b, 0x952ed3ffb889db26, 0xb42aff00b701123b, 0x0ebb52dd39ff39c7, 0xff00c9050d00ce05, 0xbf1911ffba94031e, 0x9f6bff00d70c0e39, 0x11b93a2a14ff3a85,
        0x0400f20002010001, 0xb9343146ff00edbb, 0xfb910538b00457ff, 0x40ffba80a891ff00, 0x020112060e390cd8, 0x3ace5041ff010d00, 0x1bb804ba626763ff, 0x27ff3b9e225cff01,
        0x1201b074053b2015, 0x04014c000d016c01, 0xff01390011013eaf, 0x801e8effb976dd27, 0xd48dff0147160e37, 0x043aab4717ff36ba, 0xff01599104015e94, 0x2f67c6ffbb457981,
        0xd8a6ff0167a504bb, 0x0ebb1c5521ffb8be, 0x0401824b0401900d, 0xb8e567abff017d48, 0x8b3901bbfa9c58ff, 0x21ff3ae225baff01, 0x0501a21e01b9fcc5, 0xbb4e8f09ff019d35,
        0xab1f01bbe2bed9ff, 0xd3ffbb80bd49ff01, 0x1201f8a1043b4584, 0x0e01ca000701d801, 0x38107b2bff01c506, 0xd30011baf3c924ff, 0x96ff3a2dab0cff01, 0x0201ea9b043b7f4d,
        0x3aadcfdcff01e500, 0xf39f04ba914a20ff, 0xf5ffbb5788e7ff01, 0x04021ca604bb29e4, 0xff02090007020ea4, 0xc2d4c5ff3ad19a4c, 0x5b7eff02170111ba, 0x043c35f060ffba82,
        0xff02290002022ea8, 0x3215ebffbb8e88df, 0x45fdff0237ad043b, 0x13b8867310ff3ac8, 0xe800000005000000, 0x3c00000001000003, 0x0a00000000000002, 0x050094b704012002,
        0x0400304f04005064, 0xff001d010a002237, 0x02cc23ffb8bc5e55, 0xcf4eff002b4b0539, 0x05b9c102b9ff3933, 0xff003d060b00425c, 0x4d7a08ff3835519a, 0x3b5bff004b010a37,
        0x0ab8522607ff3848, 0x0d00668405007401, 0xb777c250ff006102, 0x6f8605b7ddbc40ff, 0x57ffb8530036ff00, 0x040086040b372c63, 0x384bdcb1ff0081b6, 0x8fb6043b58a398ff,
        0xa2ffb94641d3ff00, 0x0400dc9d053ab390, 0x1100ae000d00bcb9, 0x38f209d3ff00a901, 0xb70111bb348953ff, 0x97ff38b119d2ff00, 0x0d00ce0a0b3ade2b, 0x3981d204ff00c904,
        0xd70002b99d2e31ff, 0x6effb9a31102ff00, 0x110100010b3980d3, 0xff00ed010d00f201, 0x0ae269ffb72b9f00, 0xe273ff00fb000a3a, 0x113b8663bbff3adb, 0xff010d000a011201,
        0x029765ff38cdb6df, 0x6d1dff011b030bb9, 0x053a3225a5ffbb27, 0x02016c540501b071, 0x05013e4f05014c00, 0x373490efff01393b, 0x4787043818c716ff, 0x77ff3ab33f45ff01,
        0x07015e7a04bb0e2f, 0xbb307a42ff015902, 0x678a04baab0dacff, 0x26ff3b02b8cdff01, 0x0501905905b905c3, 0xff017d5605018258, 0x29414dffbaed1396, 0x630eff018b01113a,
        0x05bc52e730ffba77, 0xff019d011201a261, 0x6e1565ffb9074f13, 0xf37eff01aba4043b, 0x0539ecafe5ffba61, 0x0701d8011201f877, 0xff01c5010701ca02, 0x86dc25ffb823ca08,
        0x5394ff01d37305ba, 0x0739c6cb43ff3ab3, 0xff01e5a60401ea02, 0x387a8fff3acede92, 0x83cbff01f3060e3b, 0x053ba88990ffbaa3, 0x0b020e060e021c78, 0xbaa045b5ff020903,
        0x17030bb9e50b90ff, 0x20ffbb68ea92ff02, 0x02022eae04bb766d, 0xb788f11cff022900, 0x37b704ba9d7905ff, 0x46ff3a0f578dff02, 0x0500000013b89815, 0x01000003e8000000,
        0x000000023c000000, 0x040120020a000000, 0x04005064050094b7, 0x0b0022340400304f, 0xb94f38ecff001d02, 0x2b3a043806fc49ff, 0xb7ffb978e4ceff00, 0x0b00425c0538808a,
        0x38110e24ff003d06, 0x4b000737246051ff, 0x0dffba8d029cff00, 0x050074010a39e5ee, 0xff0061020d006684, 0xb162b2ffb7463462, 0x89c8ff006f030bb7, 0x04b8929608ff38af,
        0xff0081011100867d, 0x8faa74ff38282b23, 0xe8a1ff008fb6043b, 0x053af60907ffb992, 0x0d00bc000a00dc8f, 0xff00a9030e00ae02, 0x74beb2ffbb237f89, 0x1d81ff00b7140eb9,
        0x063937e7b7ffb9c7, 0xff00c9020e00ce0c, 0xa5dcd1ff3adb5708, 0xdcf6ff00d7030d38, 0x02ba57c042ffbb39, 0x0400f20112010000, 0xb9d6f24bff00edb8, 0xfbbb0437add708ff,
        0x0bff3b7a9faaff00, 0x0d01129205baed1d, 0x3aa60ba9ff010d01, 0x1b9305ba7687eeff, 0x09ffbad50c81ff01, 0x0501b0710536e9d8, 0x05014c2a05016c55, 0xff01391a05013e1c,
        0x8b684bffb88cd41f, 0x6e6eff01470111b9, 0x053aa6daedffb68a, 0xff01595005015e52, 0xd187faffb7bf876b, 0x4424ff01676f043a, 0x05b915952fffbb58, 0x0b01820111019056,
        0x39a04b12ff017d03, 0x8b0107bac36728ff, 0xc7ffbc950d5eff01, 0x0101a25705bbbd0d, 0xb91a1b88ff019d38, 0xab71043bc1cebbff, 0xdaff3b45d37cff01, 0x0401f8b804b89be1,
        0x0b01cab60401d8b7, 0xbab13923ff01c501, 0xd30002387715abff, 0x51ffbb0476cdff01, 0x1201ea01123b3836, 0xb96aa86fff01e500, 0xf3060e3ab5b43aff, 0xe0ffbbdad819ff01,
        0x04021c01123bb4ef, 0xff02097505020eba, 0xbe8f00ff3b219f4b, 0xbc75ff02177f0539, 0x053890c99effbac2, 0xff02297205022e8a, 0x514720ff3b86d470, 0xcf00ff02378b053b,
        0x133b262214ffb9bd, 0xe800000005000000, 0x3300000001000003, 0x0a00000000000002, 0x050094b704012002, 0x0b00300111005068, 0xff001d060e002206, 0x35090fff36d67548,
        0xc818ff002b9604b9, 0x0537f639b6ff3820, 0xff003d5405004264, 0x8ae4bcffb7d4a8a3, 0xf968ff004b5e0439, 0x0b3ae299c7ffbb50, 0x0500660207007402, 0xba3680f3ff006169,
        0x6f8405b90ec083ff, 0x99ffbaca4b2bff00, 0x07008669053b401a, 0x3953b35aff008101, 0x8f010dbb2d0798ff, 0xd6ff38106b00ff00, 0x0d00dc8f0538b64b, 0x0d00ae000a00bc06,
        0xba8b3611ff00a902, 0xb70c06b8e9a54fff, 0xadff395bcd89ff00, 0x0e00ce060ebab88a, 0x3a3d459eff00c902, 0xd709063b32e128ff, 0x66ffb9d0fb90ff00, 0x0701000112bb18ad,
        0xff00ed000700f201, 0x326eafff38c174d9, 0x8395ff00fb020bb9, 0x0a389c3d47ff3a4d, 0xff010d9305011201, 0x41b398ffbb353b2f, 0x88a1ff011bb804b9, 0x053b99f96affbb30,
        0x05016c550501b071, 0x04013e2c01014c28, 0x38d3cca7ff013934, 0x476704b8dd4819ff, 0x9fffbb410e20ff01, 0x05015e52053984cc, 0x36fca0ffff015950, 0x6763043aa79ff9ff,
        0x40ffbb9b4176ff01, 0x0501903d01b8f4b0, 0xff017d0111018258, 0x0a3788ffb8c55094, 0x5eb9ff018b01123c, 0x04bc6b43f3ffba30, 0xff019d011101a279, 0xe9cb85ffb969806a,
        0x411cff01ab56053b, 0x0437c89bc3ffbb1e, 0x0501d88c0501efad, 0xff01c5870501ca8b, 0xe2f648ff37b7f7a0, 0x044cff01d301123a, 0x0bbbb7f264ffba59, 0xff01e5011101ea03,
        0x464b33ff3951e6ba, 0xae0438bf8fc0ff3b, 0x8405020589050213, 0xffba1acda6ff0200, 0x020e01123b58455a, 0x7334ffbabac825ff, 0xb60402257f05bbc8, 0xffba6701b0ff0220,
        0x022e810539ac3759, 0x7688ff3b182ccbff, 0x0000000000003837
};

const std::vector<uint64_t> &get_conv_model_xehpg_dw_data() {
    static std::vector<uint64_t> data(
            _data, _data + sizeof(_data) / sizeof(_data[0]));
    return data;
}
// clang-format on

} // namespace jit
} // namespace intel
} // namespace gpu
} // namespace impl
} // namespace dnnl
