// Copyright (C) 1999-2015
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __frame3dtruecolor_h__
#define __frame3dtruecolor_h__

#include "frame3d.h"
#include "frame3dtrue.h"

class Frame3dTrueColor : public Frame3d, public Frame3dTrue {
 protected:
  long* colormapData;

 private:
  void buildXImage(XImage*, Coord::InternalSystem);

 public:
  Frame3dTrueColor(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~Frame3dTrueColor();

  void colormapCmd(int, float, float, int, 
		   unsigned short*, unsigned char*, int);
  void colormapEndCmd();
  void colormapMotionCmd(int id, float b, float c, int i, 
			 unsigned short* index, unsigned char* cells, int cnt)
  {colormapCmd(id,b,c,i,index,cells,cnt);}
};

#endif
