/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.events.AJComponentAction;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JColorChooser;
import javax.swing.JComponent;

public final class JComponentActionSetCustomBackgroundSingleton
extends AJComponentAction {
    private Color m_lastChosenColor;
    private static Map<String, JComponentActionSetCustomBackgroundSingleton> instances = new HashMap<String, JComponentActionSetCustomBackgroundSingleton>();

    public static JComponentActionSetCustomBackgroundSingleton getInstance(JComponent component, String description) {
        JComponentActionSetCustomBackgroundSingleton result = instances.get(JComponentActionSetCustomBackgroundSingleton.key(component));
        if (result == null) {
            result = new JComponentActionSetCustomBackgroundSingleton(component, description);
            instances.put(JComponentActionSetCustomBackgroundSingleton.key(component), result);
        }
        return result;
    }

    private static String key(JComponent component) {
        return component.getClass().getName() + component.hashCode();
    }

    private JComponentActionSetCustomBackgroundSingleton(JComponent component, String description) {
        super(component, description);
        component.addPropertyChangeListener("background", this);
    }

    public void actionPerformed(ActionEvent e) {
        Color chosen = JColorChooser.showDialog(this.m_component, "choose background color for " + this.m_component.getName(), this.m_component.getBackground());
        if (chosen != null) {
            this.m_lastChosenColor = chosen;
            this.m_component.setBackground(chosen);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property.equals("background")) {
            Color newColor = (Color)evt.getNewValue();
            if (newColor.equals(this.m_lastChosenColor)) {
                this.firePropertyChange("", new Boolean(false), new Boolean(true));
            } else {
                this.firePropertyChange("", new Boolean(true), new Boolean(false));
            }
        }
    }
}

