11.1 APIの基礎

# Minecraft Pi APIの基礎

Sonic Pi は現在、下記のMinecraft Piの基本インタラクションをサポートしています:

* チャットメッセージの表示
* ユーザーの位置設定
* ユーザーの位置情報の取得
* 指定した座標にブロックタイプを設定
* 指定した座標のブロック タイプを取得

これら、それぞれを順番に見てみましょう。

## チャット メッセージの表示

それではSonic Pi からの Minecraft Piの制御が、どれだけ簡単か見てみましょう。まずはじめに Minecraft Pi とSonic Pi が同時に起動しているかを確認し、 Minecraft の世界に入って歩くことができることを確認してください。

新しいSonicPi のワークスペースで、次のコードを入力してください。

```
mc_message "Hello from Sonic Jam Pi"
```

*Run*ボタンを押すと、Minecraft ウィンドウにあなたのメッセージが表示されます。おめでとう、あなたは最初の Minecraft コードを書きました!簡単でしたね。

## ユーザーの位置の設定

これから、小さな魔法を試してみましょう。どこかに瞬間移動してみましょう！以下を試してください。

```
mc_teleport 50, 50, 50
```

Runを押すとボーン！新しい場所へあなたの座標が移動しました。たいていは、乾燥した土地、または水に落ちたか、空中のどこかでしょう。`50, 50, 50`、これらの数字は何でしょう?これらは瞬間移動しようとしている場所の座標です。Minecraftをプログラムするにあたり、座標がどのように動作するのか、本当に重要であるので、短い時間でみていきましょう。

## 座標

いくつかの宝の場所が大きな`X`でマーキングされた海賊の地図を想像してみてください。`X`の正確な位置は、左から右へ向かってどれくらい離れているか、下から上へ向かってどのくらい離れているか、この二つの数字で場所を記述することができます。例えば、横へ`10cm`、上に`8cm`。これら２つの数字`10`と`8`が座標です。他に隠された宝物の在処も別の２つの数字で容易に記述できることが想像できますね。おそらく、`2`つ横切り、`9`つ上には大きな金脈がありそうです...

さて、 Minecraftの中では2つの数字では十分ではありません。また、私たちがどれだけ高い所にいるのかを知る必要があります。したがって、3つの数字が必要になります。

* どのくらい右端から、左へ - `x`
* どのくらい手前から世界の奥へ - `z`
* どのくらい高くあがったか - `y`

通常、 `x`, `y`, `z`でこれらの座標を記述します。

## 現在の座標を知る

座標を使って遊んでみましょう。Minecraftのマップで素敵な場所に移動した後、
SonicPiに切り替え次を入力してください。

```
puts mc_location
```

*Run*ボタンを押すと、ログ画面に、現在位置の座標が表示されます。それらを書き留め、その後で、世界で前方に移動し、再び挑戦してください。これを正確に繰り返すことに時間を使うことをお勧めします。座標がどのように変化するかに注目しましょう！座標移動を繰り返して、世界のビットを移動しましょう。あなたが移動すると座標がどのように変化するか感触を得られるまで、これを行いましょう。これを調整する方法が理解できれば、MinecraftのAPIを使用したプログラミングがほぼ完了します。

## さぁ、構築しましょう!

現在位置をどのように知り、座標を利用して瞬間移動する方法を知っているあなたは、
Mincraft内に、コードで何かを構築し始めるための必要な道具をすべて持っています。
座標`40`, `50`, `60`にガラスのブロックを作りたかったら、それはとっても簡単ですね。

```
mc_set_block :glass, 40, 50, 60
```

ハハ、それは本当に簡単でした。あなたhandyworkを表示するには
ちょっと近くに瞬間移動してみましょう。

```
mc_teleport 35, 50, 60
```

振り向くと、あなたのガラスのブロックが表示されるはずです！それをダイヤモンドに変更してみましょう。

```
mc_set_block :diamond, 40, 50, 60
```

もし正しい方角で見れば、それがあなたの目の前で変更される可能性があります！
これはエキサイティングな何かの始まりです...

## ブロックを調べる

少し複雑なことに移る前に、最後の一つを見てみましょう。座標の集合を与え、
特定のブロックの種類が何であるかをMinecraftに訪ねることができます。
では、先ほど作成したダイヤモンドブロックでそれを試してみましょう。

```
puts mc_get_block 40, 50, 60
```

イェイ! それは`:diamond`(ダイヤモンド）ですね。ガラスに戻して、
もう一度尋ねてみましょう。`:glass`を示しましたか？信じています(^o^)

## 使用可能なブロックタイプ

Minecraft Pi コーディングへ暴れに行く前に、利用可能な
ブロックタイプの便利なリストを示します:

        :air			空気
        :stone			石
        :grass			草
        :dirt			汚れ
        :cobblestone		石畳
        :wood_plank		木の板
        :sapling		苗木
        :bedrock		岩盤
        :water_flowing		水流
        :water			水
        :water_stationary	静止した水
        :lava_flowing		溶岩流
        :lava			溶岩
        :lava_stationary	固まった溶岩
        :sand			砂
        :gravel			砂利
        :gold_ore		金の鉱石
        :iron_ore		鉄鉱石
        :coal_ore		石炭鉱石
        :wood			木材
        :leaves			葉
        :glass			ガラス
        :lapis			ラピス
        :lapis_lazuli_block	ラピスラズリブロック
        :sandstone		砂岩
        :bed			ベッド
        :cobweb			クモの巣
        :grass_tall		背の高い草
        :flower_yellow		黄色い花
        :flower_cyan		シアン色の花
        :mushroom_brown		茶色いキノコ
        :mushroom_red		赤いキノコ
        :gold_block		金のブロック
        :gold			金
        :iron_block		鉄のブロック
        :iron			鉄
        :stone_slab_double	石板(ダブル)
        :stone_slab		石板
        :brick			レンガ
        :brick_block		レンガブロック
        :tnt
        :bookshelf		本棚
        :moss_stone		苔石
        :obsidian		黒曜石
        :torch			トーチ
        :fire			火
        :stairs_wood		木の階段
        :chest			チェスト
        :diamond_ore		ダイアモンドの鉱石
        :diamond_block		ダイアモンドのブロック
        :diamond		ダイアモンド
        :crafting_table		作業テーブル
        :farmland		農地
        :furnace_inactive	廃炉
        :furnace_active		炉
        :door_wood		木のドア
        :ladder			はしご
        :stairs_cobblestone	石畳の階段
        :door_iron		鉄のドア
        :redstone_ore		レッドストーン鉱石
        :snow			雪
        :ice			氷
        :snow_block		雪のブロック
        :cactus			サボテン
        :clay			粘土
        :sugar_cane		サトウキビ
        :fence			フェンズ
        :glowstone_block	光る石のブロック
        :bedrock_invisible	目に見えない岩盤
        :stone_brick		石レンガ
        :glass_pane		ガラス板
        :melon			メロン
        :fence_gate		フェンスゲート
        :glowing_obsidian	輝く黒曜石
        :nether_reactor_core	原子炉コア
