9.1 Podstawy Kodowania na Żywo

# Kodowanie na Żywo (Live Coding)

Teraz nauczyliśmy się już wystarczająco dużo aby zacząć prawdziwą zabaę. 
W tym rozdziale będziemy czerpać ze wszystkich poprzednich i pokażemy Ci 
w jaki sposób możesz zacząć tworzyć swoje własne kompozycje muzyczne na żywo 
i zmienić je w występy na żywo. Będziemy do tego potrzebować 3 podstawowych 
sładników: 

* Umiejętność pisania kodu, który tworzy dźwięki - JEST!
* Umiejętność pisania własnych funkcji - JEST!
* Umiejętność korzystania z (nazwanych) wątków - JEST!

W porząsiu, zaczynamy. Spróbujmy zakodować na żywo nasze pierwsze dźwięki. 
Najpierw potrzebujemy funkcję, która będzie zawierać kod, który chcemy zagrać. 
Zacznijmy od czegoś prostego. Potrzebujemy również aby każda pętla wywołująca 
tę funkcję była uruchamiana w nowym wątku: 

```
define :my_loop do
  play 50
  sleep 1
end

in_thread(name: :looper) do
  loop do
    my_loop
  end
end
```

Jeśli powyższy kawałek kodu wydaje Ci się zbyt skomplikowany, wróć 
z powrotem i ponownie przeczytaj rozdziały dotyczące funkcji i wątków. 
Gdy to zrobisz i uda Ci się dobrze zrozumieć te 2 tematy to powyższy 
kawałek nie powinien sprawić Ci żadnych kłopotów. 

To co mamy powyżej to nic innego jak funkcja, która po prostu gra nutę 
o wartości 50 i następnie czeka 1 uderzenie. W kolejnym kroku mamy 
definicję wątku nazwanego `:looper`, który po prostu kręci się w kółko 
i uruchamia fukcję `my_loop`.

Gdy uruchomisz ten kod, usłyszysz nutę 50 która powtarza się i gra 
w kółko...

## Spróbujmy coś zmienić

Teraz, czas na moment w którym zaczyna się cała zabawa. W momencie 
gdy kod jest *wciąż uruchomiony*, spróbuj zmienić liczbę 50 na inną, 
powiedzmy 55, następnie naciśnij przycisk Run jeszcze raz. Łał! To się 
zmieniło! Ten kod żyje!

Nowa warstwa dźwięku nie została dodana ponieważ korzystamy z nazwanych 
wątków co pozwala tylko na jeden wątek dla jednej nazwy. Ponadto, 
dźwięk się zmienił ponieważ *przedefiniowaliśmy* funkcję. Nadaliśmy 
funkcji `:my_loop` nową definicję - znaczenie. Kiedy wątek `:looper` 
przekręci się po raz kolejny, to w następnej iteracji zostanie zawołana 
funkcja o nowej definicji.

Spróbuj zmienić ją ponownie, zmień nutę, zmień wartość parametru jaki 
przekazujemy do funkcji sleep. Co powiesz na dodanie polecenia `use_synth`? 
Na przykład, zmieńmy kod w taki sposób: 

```
define :my_loop do
  use_synth :tb303
  play 50, release: 0.3
  sleep 0.25
end
```

Brzmi to całkiem ciekawie, ale możemy urozmaicić to jeszcze bardziej. 
Zamiast grać w kółko tę samę nutę, spróbujmy zagrać akord: 

```
define :my_loop do
  use_synth :tb303
  play chord(:e3, :minor), release: 0.3
  sleep 0.5
end
```

A co powiesz na granie losowych nut z akordu: 

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.3
  sleep 0.25
end
```

Albo użycie losowej wartości dla parametru odcięcia (cutoff): 

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

I na sam koniec, dodajmy trochę bębnów: 

```
define :my_loop do
  use_synth :tb303
  sample :drum_bass_hard, rate: rrand(0.5, 2)
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

Teraz zabawa zaczyna być naprawdę ekscytująca!

Jednakże, zanim zamkniesz tutorial i zaczniesz kodować na żywo 
z wykorzystaniem funkcji i wątków, zatrzymaj się na chwile i przeczytaj 
kolejny rozdział dotyczący funkcji `live_loop`, która zmieni twój sposób 
kodowania w Sonic Pi na zawsze...
