#!/usr/bin/perl -w

# A simple wrapper program to launch sorune under windows and get rid of
# the DOS shell. Only tested for ActivePerl on Windows. Use sorune
# directly for other distributions/operating systems.

use strict;
use File::Basename;
use File::Spec;
use Win32;
use Win32::Process;
use Win32::Registry;

sub Error
{
    print shift;
    exit 1;
}

my %values = ();
my $error = "Could not determine perl installation directory.\n";
my $entry = "SOFTWARE\\ActiveState\\ActivePerl";
my $program = File::Spec->rel2abs(dirname($0)) . "/sorune";
my ($perlDir,$processObj);

Error($error) if ($::HKEY_LOCAL_MACHINE->Open($entry,$perlDir) == 0);
$perlDir->GetValues(\%values);
my $version = @{$values{'CurrentVersion'}}[2];

$entry .= "\\$version";
Error($error) if ($::HKEY_LOCAL_MACHINE->Open($entry,$perlDir) == 0);
$perlDir->GetValues(\%values);

my $perl = @{$values{''}}[2];
$perl =~ s/\\$/\\bin\\perl.exe/;
my $ps = Win32::Process::Create($processObj,
    $perl, "\"$perl\" \"$program\"", 0, DETACHED_PROCESS, ".");
Error(Win32::FormatMessage($^E)) if ($ps == 0);
