/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.xhtml.CellStyleConverter;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.FrameStyleConverter;
import writer2latex.xhtml.HeadingStyleConverter;
import writer2latex.xhtml.ListStyleConverter;
import writer2latex.xhtml.PageStyleConverter;
import writer2latex.xhtml.ParStyleConverter;
import writer2latex.xhtml.PresentationStyleConverter;
import writer2latex.xhtml.RowStyleConverter;
import writer2latex.xhtml.SectionStyleConverter;
import writer2latex.xhtml.StyleConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.TableStyleConverter;
import writer2latex.xhtml.TextStyleConverter;
import writer2latex.xhtml.XhtmlConfig;

class StyleConverter
extends ConverterHelper {
    private TextStyleConverter textSc;
    private ParStyleConverter parSc;
    private HeadingStyleConverter headingSc;
    private ListStyleConverter listSc;
    private SectionStyleConverter sectionSc;
    private TableStyleConverter tableSc;
    private RowStyleConverter rowSc;
    private CellStyleConverter cellSc;
    private FrameStyleConverter frameSc;
    private PresentationStyleConverter presentationSc;
    private PageStyleConverter pageSc;

    StyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter);
        this.textSc = new TextStyleConverter(ofr, config, converter, nType);
        this.parSc = new ParStyleConverter(ofr, config, converter, nType);
        this.headingSc = new HeadingStyleConverter(ofr, config, converter, nType);
        this.listSc = new ListStyleConverter(ofr, config, converter, nType);
        this.sectionSc = new SectionStyleConverter(ofr, config, converter, nType);
        this.tableSc = new TableStyleConverter(ofr, config, converter, nType);
        this.rowSc = new RowStyleConverter(ofr, config, converter, nType);
        this.cellSc = new CellStyleConverter(ofr, config, converter, nType);
        this.frameSc = new FrameStyleConverter(ofr, config, converter, nType);
        this.presentationSc = new PresentationStyleConverter(ofr, config, converter, nType);
        this.pageSc = new PageStyleConverter(ofr, config, converter, nType);
    }

    @Override
    TextStyleConverter getTextSc() {
        return this.textSc;
    }

    @Override
    ParStyleConverter getParSc() {
        return this.parSc;
    }

    @Override
    HeadingStyleConverter getHeadingSc() {
        return this.headingSc;
    }

    @Override
    ListStyleConverter getListSc() {
        return this.listSc;
    }

    @Override
    SectionStyleConverter getSectionSc() {
        return this.sectionSc;
    }

    @Override
    TableStyleConverter getTableSc() {
        return this.tableSc;
    }

    @Override
    RowStyleConverter getRowSc() {
        return this.rowSc;
    }

    @Override
    CellStyleConverter getCellSc() {
        return this.cellSc;
    }

    @Override
    FrameStyleConverter getFrameSc() {
        return this.frameSc;
    }

    @Override
    PresentationStyleConverter getPresentationSc() {
        return this.presentationSc;
    }

    @Override
    PageStyleConverter getPageSc() {
        return this.pageSc;
    }

    void applyDefaultLanguage(Element node) {
        StyleWithProperties style = this.getDefaultStyle();
        if (style != null) {
            StyleInfo info = new StyleInfo();
            StyleConverterHelper.applyLang(style, info);
            this.applyStyle(info, node);
        }
    }

    String exportStyles(boolean bIndent) {
        String sIndent = bIndent ? "      " : "";
        StringBuilder buf = new StringBuilder();
        this.exportDefaultStyle(buf, sIndent);
        buf.append(this.getTextSc().getStyleDeclarations(sIndent));
        buf.append(this.getParSc().getStyleDeclarations(sIndent));
        buf.append(this.getHeadingSc().getStyleDeclarations(sIndent));
        buf.append(this.getListSc().getStyleDeclarations(sIndent));
        buf.append(this.getSectionSc().getStyleDeclarations(sIndent));
        buf.append(this.getCellSc().getStyleDeclarations(sIndent));
        buf.append(this.getTableSc().getStyleDeclarations(sIndent));
        buf.append(this.getRowSc().getStyleDeclarations(sIndent));
        buf.append(this.getFrameSc().getStyleDeclarations(sIndent));
        buf.append(this.getPresentationSc().getStyleDeclarations(sIndent));
        buf.append(this.getPageSc().getStyleDeclarations(sIndent));
        return buf.toString();
    }

    Node exportStyles(Document htmlDOM) {
        String sStyles = this.exportStyles(this.config.prettyPrint());
        if (sStyles.length() > 0) {
            Element htmlStyle = htmlDOM.createElement("style");
            htmlStyle.setAttribute("media", "all");
            htmlStyle.setAttribute("type", "text/css");
            htmlStyle.appendChild(htmlDOM.createTextNode(this.config.prettyPrint() ? "\n" : " "));
            htmlStyle.appendChild(htmlDOM.createTextNode(sStyles));
            if (this.config.prettyPrint()) {
                htmlStyle.appendChild(htmlDOM.createTextNode("    "));
            }
            return htmlStyle;
        }
        return null;
    }

    private void exportDefaultStyle(StringBuilder buf, String sIndent) {
        if (this.config.xhtmlCustomStylesheet().length() == 0 && (this.config.xhtmlFormatting() == 3 || this.config.xhtmlFormatting() == 2)) {
            String sMaxWidth;
            CSVList props = new CSVList(";");
            StyleWithProperties defaultStyle = this.getDefaultStyle();
            if (defaultStyle != null) {
                this.getTextSc().cssTextCommon(defaultStyle, props, true);
                if (this.config.useDefaultFont() && this.config.defaultFontName().length() > 0) {
                    props.addValue("font-family", "'" + this.config.defaultFontName() + "'");
                }
            }
            if (this.ofr.isText() && !this.converter.isOPS() && (sMaxWidth = this.config.getMaxWidth().trim()).length() > 0) {
                props.addValue("max-width", sMaxWidth);
                props.addValue("margin-left", "auto");
                props.addValue("margin-right", "auto");
            }
            if (!props.isEmpty()) {
                buf.append(sIndent).append("body {").append(props.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
            }
        }
    }

    private StyleWithProperties getDefaultStyle() {
        if (this.ofr.isSpreadsheet()) {
            return this.ofr.getDefaultCellStyle();
        }
        if (this.ofr.isPresentation()) {
            return this.ofr.getDefaultFrameStyle();
        }
        return this.ofr.getDefaultParStyle();
    }
}

